/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.grits.toolbox.entry.sample.model.Sample;

public class ComponentNameValidator
implements IInputValidator {
    private Set<String> existingNames = null;

    public ComponentNameValidator(Sample sample, String currentName) {
        this.existingNames = sample.getAllComponentLabels();
        this.existingNames.remove(currentName);
    }

    public String isValid(String newName) {
        String errorMessage = null;
        if (newName == null) {
            errorMessage = "Name cannot be empty. Please select a unique name.";
        } else if ((newName = newName.trim()).isEmpty()) {
            errorMessage = "Component name cannot be empty. Please select a unique component name.";
        } else if (newName.length() > 80) {
            errorMessage = "Component name cannot be longer than 80 characters.";
        } else if (this.existingNames.contains(newName)) {
            errorMessage = "This component name already exists. Please choose a unique component name";
        }
        return errorMessage;
    }
}

