/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.scan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class MSProfileToCentroid {
    private Scan m_scan;
    private double m_dMinPeakDistance = 0.02;
    private HashMap<Peak, Peak> m_mapPickedToCentroid = new HashMap();

    public void setMinPeakDistance(double a_dDist) {
        this.m_dMinPeakDistance = a_dDist;
    }

    public HashMap<Peak, Peak> getPickedPeakToCentroidPeak() {
        return this.m_mapPickedToCentroid;
    }

    public Scan convert(Scan a_scan) {
        this.m_scan = a_scan;
        List<Peak> t_lPickedPeaks = this.pickPeaks();
        Map<Peak, List<Peak>> t_mapPickedPeakToGroup = this.groupPeaks(t_lPickedPeaks);
        Scan t_scanCentroid = new Scan();
        t_scanCentroid.setActivationMethode(this.m_scan.getActivationMethode());
        t_scanCentroid.setMsLevel(this.m_scan.getMsLevel());
        t_scanCentroid.setParentScan(this.m_scan.getParentScan());
        t_scanCentroid.setPolarity(this.m_scan.getPolarity());
        t_scanCentroid.setRetentionTime(this.m_scan.getRetentionTime());
        t_scanCentroid.setScanNo(this.m_scan.getScanNo());
        for (Integer t_iSub : this.m_scan.getSubScans()) {
            t_scanCentroid.getSubScans().add(t_iSub);
        }
        double t_dStartMz = Double.MAX_VALUE;
        double t_dEndMz = Double.MIN_VALUE;
        double t_dMostAbandunt = 0.0;
        double t_dTotalIntensity = 0.0;
        int i = 1;
        for (Peak t_peakPicked : t_lPickedPeaks) {
            Peak t_peakCentroid = this.getCentroidPeak(t_mapPickedPeakToGroup.get(t_peakPicked), i++);
            this.m_mapPickedToCentroid.put(t_peakPicked, t_peakCentroid);
            t_scanCentroid.getPeaklist().add(t_peakCentroid);
            t_dTotalIntensity += t_peakCentroid.getIntensity().doubleValue();
            if (t_dStartMz > t_peakCentroid.getMz()) {
                t_dStartMz = t_peakCentroid.getMz();
            }
            if (t_dEndMz < t_peakCentroid.getMz()) {
                t_dEndMz = t_peakCentroid.getMz();
            }
            if (!(t_dMostAbandunt < t_peakCentroid.getIntensity())) continue;
            t_dMostAbandunt = t_peakCentroid.getIntensity();
        }
        t_scanCentroid.setMostAbundantPeak(Double.valueOf(t_dMostAbandunt));
        t_scanCentroid.setScanStart(Double.valueOf(t_dStartMz));
        t_scanCentroid.setScanEnd(Double.valueOf(t_dEndMz));
        t_scanCentroid.setTotalIntensity(Double.valueOf(t_dTotalIntensity));
        t_scanCentroid.setTotalNumPeaks(Integer.valueOf(t_lPickedPeaks.size()));
        for (Peak t_peakCentroid : t_scanCentroid.getPeaklist()) {
            t_peakCentroid.setRelativeIntensity(Double.valueOf(t_peakCentroid.getIntensity() / t_dMostAbandunt));
        }
        return t_scanCentroid;
    }

    private List<Peak> pickPeaks() {
        ArrayList<Peak> t_lPickedPeaks = new ArrayList<Peak>();
        List t_lPeaks = this.m_scan.getPeaklist();
        int t_nPeaks = t_lPeaks.size();
        if (((Peak)t_lPeaks.get(1)).getMz() - ((Peak)t_lPeaks.get(0)).getMz() > this.m_dMinPeakDistance || ((Peak)t_lPeaks.get(1)).getIntensity() < ((Peak)t_lPeaks.get(0)).getIntensity()) {
            t_lPickedPeaks.add((Peak)t_lPeaks.get(0));
        }
        if (((Peak)t_lPeaks.get(t_nPeaks - 1)).getMz() - ((Peak)t_lPeaks.get(t_nPeaks - 2)).getMz() > this.m_dMinPeakDistance || ((Peak)t_lPeaks.get(t_nPeaks - 1)).getIntensity() > ((Peak)t_lPeaks.get(t_nPeaks - 2)).getIntensity()) {
            t_lPickedPeaks.add((Peak)t_lPeaks.get(t_nPeaks - 1));
        }
        int i = 1;
        while (i < t_nPeaks - 1) {
            block7: {
                Peak t_peakCenter;
                block8: {
                    Peak t_peakTail;
                    Peak t_peakHead;
                    block6: {
                        t_peakCenter = (Peak)this.m_scan.getPeaklist().get(i);
                        t_peakHead = (Peak)this.m_scan.getPeaklist().get(i - 1);
                        t_peakTail = (Peak)this.m_scan.getPeaklist().get(i + 1);
                        if (!(t_peakCenter.getMz() - t_peakHead.getMz() > this.m_dMinPeakDistance) || !(t_peakTail.getMz() - t_peakCenter.getMz() > this.m_dMinPeakDistance)) break block6;
                        t_lPickedPeaks.add(t_peakCenter);
                        break block7;
                    }
                    Peak t_peakPrev = (Peak)t_lPickedPeaks.get(t_lPickedPeaks.size() - 1);
                    if (!(t_peakCenter.getIntensity() > t_peakHead.getIntensity()) || !(t_peakCenter.getIntensity() > t_peakTail.getIntensity())) break block7;
                    if (!(t_peakCenter.getMz() - t_peakPrev.getMz() < this.m_dMinPeakDistance)) break block8;
                    if (!(t_peakCenter.getIntensity() > t_peakPrev.getIntensity())) break block7;
                    t_lPickedPeaks.remove(t_peakPrev);
                }
                t_lPickedPeaks.add(t_peakCenter);
            }
            ++i;
        }
        return t_lPickedPeaks;
    }

    private Map<Peak, List<Peak>> groupPeaks(List<Peak> a_lPickedPeaks) {
        HashMap<Peak, List<Peak>> t_mapPickedPeakToGroup = new HashMap<Peak, List<Peak>>();
        ArrayList t_lPrevGroup = new ArrayList();
        Peak t_peakPrevPicked = null;
        int t_iPrevPickedPeakID = 0;
        int t_nPeaks = this.m_scan.getPeaklist().size();
        for (Peak t_peakPicked : a_lPickedPeaks) {
            ArrayList<Peak> t_lGroup = new ArrayList<Peak>();
            int i = t_iPrevPickedPeakID + 1;
            while (i < t_nPeaks) {
                block5: {
                    Peak t_peak;
                    block6: {
                        block4: {
                            t_peak = (Peak)this.m_scan.getPeaklist().get(i);
                            if (!(Math.abs(t_peak.getMz() - t_peakPicked.getMz()) > this.m_dMinPeakDistance)) break block4;
                            if (!t_lGroup.isEmpty()) break;
                            break block5;
                        }
                        if (!t_lPrevGroup.contains(t_peak)) break block6;
                        if (!(t_peakPicked.getIntensity() > t_peakPrevPicked.getIntensity())) break block5;
                        t_lPrevGroup.remove(t_peak);
                    }
                    t_lGroup.add(t_peak);
                }
                ++i;
            }
            t_lPrevGroup = t_lGroup;
            t_peakPrevPicked = t_peakPicked;
            t_iPrevPickedPeakID = this.m_scan.getPeaklist().indexOf(t_peakPicked);
            t_mapPickedPeakToGroup.put(t_peakPicked, t_lGroup);
        }
        return t_mapPickedPeakToGroup;
    }

    private Peak getCentroidPeak(List<Peak> a_lGroup, int a_iID) {
        Peak t_peakCentroid = new Peak();
        t_peakCentroid.setId(Integer.valueOf(a_iID));
        double t_dTotalIntensity = 0.0;
        for (Peak t_peak : a_lGroup) {
            t_dTotalIntensity += t_peak.getIntensity().doubleValue();
        }
        double t_dMeanMz = 0.0;
        for (Peak t_peak : a_lGroup) {
            t_dMeanMz += t_peak.getMz() * t_peak.getIntensity() / t_dTotalIntensity;
        }
        t_peakCentroid.setPrecursorIntensity(Double.valueOf(t_dTotalIntensity));
        t_peakCentroid.setPrecursorMz(Double.valueOf(t_dMeanMz));
        return t_peakCentroid;
    }
}

