/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GlycanRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResidueStyleDictionary;

public class ResidueRendererAWT {
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected GraphicOptions theGraphicOptions;

    public ResidueRendererAWT() {
        this.theResidueStyleDictionary = new ResidueStyleDictionary();
        this.theGraphicOptions = new GraphicOptions();
    }

    public ResidueRendererAWT(GlycanRendererAWT src) {
        this.theResidueStyleDictionary = src.getResidueStyleDictionary();
        this.theGraphicOptions = src.getGraphicOptions();
    }

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
    }

    public ResidueStyleDictionary getResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    public void setResidueStyleDictionary(ResidueStyleDictionary residueStyleDictionary) {
        this.theResidueStyleDictionary = residueStyleDictionary;
    }

    public Icon getIcon(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage((int)(bbox.width + 8), (int)(bbox.height + 8), (boolean)false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(g2d, node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        return new ImageIcon(img);
    }

    public Image getImage(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage((int)(bbox.width + 8), (int)(bbox.height + 8), (boolean)false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(g2d, node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        return Toolkit.getDefaultToolkit().createImage(img.getSource());
    }

    public String getText(Residue node) {
        if (node == null) {
            return "";
        }
        ResidueType type = node.getType();
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String text = style.getText();
        return text != null ? text : type.getResidueName();
    }

    public String getText(Residue node, boolean on_border) {
        if (node == null) {
            return "";
        }
        if (on_border && node.isSpecial() && !node.isLCleavage()) {
            return "*";
        }
        String text = null;
        text = on_border && node.isLCleavage() ? this.getText(node.getCleavedResidue()) : this.getText(node);
        if (on_border && !node.getParentLinkage().hasUncertainParentPositions() && this.theGraphicOptions.SHOW_INFO) {
            text = String.valueOf(node.getParentLinkage().getParentPositionsString()) + text;
        }
        if (on_border && node.isLCleavage()) {
            text = "(" + text + ")";
        }
        return text;
    }

    protected Rectangle computeBoundingBox(Residue node, boolean on_border, int x, int y, ResAngle orientation, int node_size, int max_y_size) {
        Dimension dim;
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (max_y_size < node_size) {
            node_size = max_y_size;
        }
        if (shape == null || on_border) {
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = Geometry.textBounds((String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            dim = x_size > node_size ? new Dimension(x_size, node_size) : new Dimension(node_size, node_size);
            orientation = this.theGraphicOptions.getOrientationAngle();
        } else if (shape.equals("startrep") || shape.equals("endrep")) {
            int size = Math.min(node_size * 2, max_y_size);
            int font_size = this.theGraphicOptions.LINKAGE_INFO_SIZE;
            dim = new Dimension(size / 2, size + 2 * font_size);
        } else {
            dim = shape.equals("point") ? new Dimension(1, 1) : new Dimension(node_size, node_size);
        }
        if (orientation.equals(0) || orientation.equals(180)) {
            return new Rectangle(x, y, dim.width, dim.height);
        }
        return new Rectangle(x, y, dim.height, dim.width);
    }

    private static int sat(int v, int t) {
        if (v > t) {
            return t;
        }
        return v;
    }

    private static int sig(int v) {
        return 128 + v / 2;
    }

    public void paint(Graphics2D g2d, Residue node, boolean selected, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        this.paint(g2d, node, selected, true, on_border, par_bbox, cur_bbox, sup_bbox, orientation);
    }

    public void paint(Graphics2D g2d, Residue node, boolean selected, boolean active, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        if (node == null) {
            return;
        }
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        Shape shape = this.createShape(node, par_bbox, cur_bbox, sup_bbox, orientation);
        Shape text_shape = this.createTextShape(node, par_bbox, cur_bbox, sup_bbox, orientation);
        Shape fill_shape = this.createFillShape(node, cur_bbox);
        Color shape_color = style.getShapeColor();
        Color fill_color = style.getFillColor();
        Color text_color = style.getTextColor();
        if (selected) {
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
        }
        if (!active) {
            shape_color = new Color(ResidueRendererAWT.sig(shape_color.getRed()), ResidueRendererAWT.sig(shape_color.getGreen()), ResidueRendererAWT.sig(shape_color.getBlue()));
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
            text_color = new Color(ResidueRendererAWT.sig(text_color.getRed()), ResidueRendererAWT.sig(text_color.getGreen()), ResidueRendererAWT.sig(text_color.getBlue()));
        }
        if (shape != null && !on_border) {
            if (fill_shape != null) {
                Shape old_clip = g2d.getClip();
                g2d.clip(shape);
                g2d.setColor(style.isFillNegative() ? fill_color : Color.white);
                g2d.fill(shape);
                g2d.setColor(style.isFillNegative() ? Color.white : fill_color);
                g2d.fill(fill_shape);
                g2d.setColor(shape_color);
                g2d.draw(fill_shape);
                g2d.setClip(old_clip);
            }
            g2d.setStroke(selected ? new BasicStroke(2.0f) : new BasicStroke(1.0f));
            g2d.setColor(shape_color);
            g2d.draw(shape);
            g2d.setStroke(new BasicStroke(1.0f));
        } else if (selected) {
            float[] dashes = new float[]{5.0f, 5.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 1, 1.0f, dashes, 0.0f));
            g2d.setColor(shape_color);
            g2d.draw(cur_bbox);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        if (text_shape != null) {
            g2d.setColor(shape_color);
            g2d.fill(text_shape);
        }
        if (shape == null || on_border || style.getText() != null) {
            if (shape == null || on_border) {
                orientation = this.theGraphicOptions.getOrientationAngle();
            } else if (style.getText() != null) {
                orientation = new ResAngle(0);
            }
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = Geometry.textBounds((String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            if (shape != null) {
                font_size = ResidueRendererAWT.sat(8 * font_size * cur_bbox.width / x_size / 10, font_size);
            }
            Font new_font = new Font(this.theGraphicOptions.NODE_FONT_FACE, 0, font_size);
            Font old_font = g2d.getFont();
            g2d.setFont(new_font);
            Rectangle2D.Double text_bound = new Rectangle2D.Double();
            text_bound.setRect(new TextLayout(text, new_font, g2d.getFontRenderContext()).getBounds());
            g2d.setColor(text_color);
            if (orientation.equals(0) || orientation.equals(180)) {
                Rectangle2D.Double text_rect = new Rectangle2D.Double((double)Geometry.midx((Rectangle)cur_bbox) - text_bound.width / 2.0, (double)Geometry.midy((Rectangle)cur_bbox) - text_bound.height / 2.0, text_bound.width, text_bound.height);
                if (shape == null || fill_shape == null) {
                    g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                }
                g2d.drawString(text, (int)text_rect.x, (int)(text_rect.y + text_rect.height));
            } else {
                Rectangle2D.Double text_rect = new Rectangle2D.Double((double)Geometry.midx((Rectangle)cur_bbox) - text_bound.height / 2.0, (double)Geometry.midy((Rectangle)cur_bbox) - text_bound.width / 2.0, text_bound.height, text_bound.width);
                if (shape == null || fill_shape == null) {
                    g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                }
                g2d.rotate(-1.5707963267948966);
                g2d.drawString(text, -((int)(text_rect.y + text_rect.height)), (int)(text_rect.x + text_rect.width));
                g2d.rotate(1.5707963267948966);
            }
            g2d.setFont(old_font);
        }
    }

    private static Polygon createDiamond(double x, double y, double w, double h) {
        if (w % 2.0 == 1.0) {
            w += 1.0;
        }
        if (h % 2.0 == 1.0) {
            h += 1.0;
        }
        Polygon p = new Polygon();
        p.addPoint((int)(x + w / 2.0), (int)y);
        p.addPoint((int)(x + w), (int)(y + h / 2.0));
        p.addPoint((int)(x + w / 2.0), (int)(y + h));
        p.addPoint((int)x, (int)(y + h / 2.0));
        return p;
    }

    private static Shape createHatDiamond(double angle, double x, double y, double w, double h) {
        GeneralPath f = new GeneralPath();
        f.append(ResidueRendererAWT.createDiamond(x, y, w, h), false);
        Polygon p = new Polygon();
        p.addPoint((int)(x - 2.0), (int)(y + h / 2.0 - 2.0));
        p.addPoint((int)(x + w / 2.0 - 2.0), (int)(y - 2.0));
        f.append(p, false);
        return f;
    }

    private static Shape createRHatDiamond(double angle, double x, double y, double w, double h) {
        GeneralPath f = new GeneralPath();
        f.append(ResidueRendererAWT.createDiamond(x, y, w, h), false);
        Polygon p = new Polygon();
        p.addPoint((int)(x + w + 2.0), (int)(y + h / 2.0 - 2.0));
        p.addPoint((int)(x + w / 2.0 + 2.0), (int)(y - 2.0));
        f.append(p, false);
        return f;
    }

    private static Polygon createRhombus(double x, double y, double w, double h) {
        Polygon p = new Polygon();
        p.addPoint((int)(x + 0.5 * w), (int)y);
        p.addPoint((int)(x + 0.85 * w), (int)(y + 0.5 * h));
        p.addPoint((int)(x + 0.5 * w), (int)(y + h));
        p.addPoint((int)(x + 0.15 * w), (int)(y + 0.5 * h));
        return p;
    }

    private static Polygon createTriangle(double angle, double x, double y, double w, double h) {
        Polygon p = new Polygon();
        if (angle >= -0.7853981633974483 && angle <= 0.7853981633974483) {
            p.addPoint((int)(x + w), (int)(y + h / 2.0));
            p.addPoint((int)x, (int)(y + h));
            p.addPoint((int)x, (int)y);
        } else if (angle >= 0.7853981633974483 && angle <= 2.356194490192345) {
            p.addPoint((int)(x + w / 2.0), (int)(y + h));
            p.addPoint((int)x, (int)y);
            p.addPoint((int)(x + w), (int)y);
        } else if (angle >= -2.356194490192345 && angle <= -0.7853981633974483) {
            p.addPoint((int)(x + w / 2.0), (int)y);
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)x, (int)(y + h));
        } else {
            p.addPoint((int)x, (int)(y + h / 2.0));
            p.addPoint((int)(x + w), (int)(y + h));
            p.addPoint((int)(x + w), (int)y);
        }
        return p;
    }

    private static Polygon createStar(double x, double y, double w, double h, int points) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = Math.PI / (double)points;
        double nstep = 1.5707963267948966 - 2.0 * step;
        double mrx = rx / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        double mry = ry / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        Polygon p = new Polygon();
        int i = 0;
        while (i <= 2 * points) {
            if (i % 2 == 0) {
                p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
            } else {
                p.addPoint((int)(cx + mrx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + mry * Math.sin((double)i * step - 1.5707963267948966)));
            }
            ++i;
        }
        return p;
    }

    private static Polygon createPentagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 1.2566370614359172;
        Polygon p = new Polygon();
        int i = 0;
        while (i <= 5) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
            ++i;
        }
        return p;
    }

    private static Polygon createHexagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 1.0471975511965976;
        Polygon p = new Polygon();
        int i = 0;
        while (i <= 6) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step)), (int)(cy + ry * Math.sin((double)i * step)));
            ++i;
        }
        return p;
    }

    private static Polygon createHeptagon(double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = 0.8975979010256552;
        Polygon p = new Polygon();
        int i = 0;
        while (i <= 7) {
            p.addPoint((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966)), (int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966)));
            ++i;
        }
        return p;
    }

    private static Shape createLine(double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p = new Polygon();
        double x1 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle - 1.5707963267948966);
        p.addPoint((int)x1, (int)y1);
        double x2 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle + 1.5707963267948966);
        p.addPoint((int)x2, (int)y2);
        return p;
    }

    private static Shape createCleavage(double angle, double x, double y, double w, double h, boolean has_oxygen) {
        GeneralPath f = new GeneralPath();
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x3 = x2 + rx * Math.cos(angle);
        double y3 = y2 + ry * Math.sin(angle);
        Polygon p = new Polygon();
        p.addPoint((int)x1, (int)y1);
        p.addPoint((int)x2, (int)y2);
        p.addPoint((int)x3, (int)y3);
        p.addPoint((int)x2, (int)y2);
        f.append(p, false);
        if (has_oxygen) {
            double ox = cx + rx * Math.cos(angle);
            double oy = cy + ry * Math.sin(angle);
            Ellipse2D.Double o = new Ellipse2D.Double(ox - rx / 3.0, oy - ry / 3.0, rx / 1.5, ry / 1.5);
            f.append(o, false);
        }
        return f;
    }

    private static Shape createCrossRingCleavage(double angle, double x, double y, double w, double h, int first_pos, int last_pos) {
        GeneralPath c = new GeneralPath();
        c.append(ResidueRendererAWT.createHexagon(x + 1.0, y + 1.0, w - 2.0, h - 2.0), false);
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p1 = new Polygon();
        p1.addPoint((int)cx, (int)cy);
        p1.addPoint((int)(cx + 1.2 * rx * Math.cos(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)), (int)(cy + 1.2 * ry * Math.sin(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.append(p1, false);
        Polygon p2 = new Polygon();
        p2.addPoint((int)cx, (int)cy);
        p2.addPoint((int)(cx + 1.2 * rx * Math.cos(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)), (int)(cy + 1.2 * ry * Math.sin(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.append(p2, false);
        return c;
    }

    private static Shape createEnd(double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double cx1 = cx + 0.5 * rx * Math.cos(angle - 1.5707963267948966);
        double cy1 = cy + 0.5 * ry * Math.sin(angle - 1.5707963267948966);
        double tx1 = cx1 + 0.5 * rx * Math.cos(angle - Math.PI);
        double ty1 = cy1 + 0.5 * ry * Math.sin(angle - Math.PI);
        double cx2 = cx + 0.5 * rx * Math.cos(angle + 1.5707963267948966);
        double cy2 = cy + 0.5 * ry * Math.sin(angle + 1.5707963267948966);
        double tx2 = cx2 + 0.5 * rx * Math.cos(angle);
        double ty2 = cy2 + 0.5 * ry * Math.sin(angle);
        return new CubicCurve2D.Double(x1, y1, tx1, ty1, tx2, ty2, x2, y2);
    }

    private static Shape createBracket(double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x11 = cx + rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double y11 = cy + ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double tx11 = cx + 0.9 * rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle - Math.PI);
        double ty11 = cy + 0.9 * ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle - Math.PI);
        double tx21 = cx + 0.1 * rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double ty21 = cy + 0.1 * ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double x21 = cx + 0.2 * rx * Math.cos(angle - Math.PI);
        double y21 = cy + 0.2 * ry * Math.sin(angle - Math.PI);
        CubicCurve2D.Double s1 = new CubicCurve2D.Double(x11, y11, tx11, ty11, tx21, ty21, x21, y21);
        double x12 = cx + rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double y12 = cy + ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double tx12 = cx + 0.9 * rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle - Math.PI);
        double ty12 = cy + 0.9 * ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle - Math.PI);
        double tx22 = cx + 0.1 * rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double ty22 = cy + 0.1 * ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double x22 = cx + 0.2 * rx * Math.cos(angle - Math.PI);
        double y22 = cy + 0.2 * ry * Math.sin(angle - Math.PI);
        CubicCurve2D.Double s2 = new CubicCurve2D.Double(x12, y12, tx12, ty12, tx22, ty22, x22, y22);
        GeneralPath b = new GeneralPath();
        b.append(s1, false);
        b.append(s2, false);
        return b;
    }

    private Shape createRepetition(double angle, double x, double y, double w, double h) {
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Polygon p = new Polygon();
        double x1 = cx + r * Math.cos(angle - 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y1 = cy + r * Math.sin(angle - 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.addPoint((int)x1, (int)y1);
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        p.addPoint((int)x2, (int)y2);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        p.addPoint((int)x3, (int)y3);
        double x4 = cx + r * Math.cos(angle + 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y4 = cy + r * Math.sin(angle + 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.addPoint((int)x4, (int)y4);
        p.addPoint((int)x3, (int)y3);
        p.addPoint((int)x2, (int)y2);
        return p;
    }

    private Shape createShape(Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        Point ps;
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        double x = cur_bbox.getX();
        double y = cur_bbox.getY();
        double w = cur_bbox.getWidth();
        double h = cur_bbox.getHeight();
        if (shape.equals("point")) {
            return new Rectangle2D.Double(x + w / 2.0, y + h / 2.0, 0.0, 0.0);
        }
        if (shape.equals("square")) {
            return new Rectangle2D.Double(x, y, w, h);
        }
        if (shape.equals("circle")) {
            return new Ellipse2D.Double(x, y, w, h);
        }
        if (shape.equals("diamond")) {
            return ResidueRendererAWT.createDiamond(x, y, w, h);
        }
        if (shape.equals("rhombus")) {
            return ResidueRendererAWT.createRhombus(x, y, w, h);
        }
        if (shape.equals("star")) {
            return ResidueRendererAWT.createStar(x, y, w, h, 5);
        }
        if (shape.equals("sixstar")) {
            return ResidueRendererAWT.createStar(x, y, w, h, 6);
        }
        if (shape.equals("sevenstar")) {
            return ResidueRendererAWT.createStar(x, y, w, h, 7);
        }
        if (shape.equals("pentagon")) {
            return ResidueRendererAWT.createPentagon(x, y, w, h);
        }
        if (shape.equals("hexagon")) {
            return ResidueRendererAWT.createHexagon(x, y, w, h);
        }
        if (shape.equals("heptagon")) {
            return ResidueRendererAWT.createHeptagon(x, y, w, h);
        }
        Point pp = par_bbox != null ? Geometry.center((Rectangle)par_bbox) : Geometry.center((Rectangle)cur_bbox);
        Point pc = Geometry.center((Rectangle)cur_bbox);
        Point point = ps = sup_bbox != null ? Geometry.center((Rectangle)sup_bbox) : Geometry.center((Rectangle)cur_bbox);
        if (shape.equals("triangle")) {
            return ResidueRendererAWT.createTriangle(Geometry.angle((Point)pp, (Point)ps), x, y, w, h);
        }
        if (shape.equals("hatdiamond")) {
            return ResidueRendererAWT.createHatDiamond(Geometry.angle((Point)pp, (Point)ps), x, y, w, h);
        }
        if (shape.equals("rhatdiamond")) {
            return ResidueRendererAWT.createRHatDiamond(Geometry.angle((Point)pp, (Point)ps), x, y, w, h);
        }
        if (shape.equals("bracket")) {
            return ResidueRendererAWT.createBracket(orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.equals("startrep")) {
            return this.createRepetition(orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.equals("endrep")) {
            return this.createRepetition(orientation.getAngle(), x, y, w, h);
        }
        if (shape.startsWith("acleavage")) {
            Vector tokens = TextUtils.tokenize((String)shape, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererAWT.createCrossRingCleavage(Geometry.angle((Point)pc, (Point)ps), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("bcleavage")) {
            return ResidueRendererAWT.createCleavage(Geometry.angle((Point)ps, (Point)pc), x, y, w, h, false);
        }
        if (shape.equals("ccleavage")) {
            return ResidueRendererAWT.createCleavage(Geometry.angle((Point)ps, (Point)pc), x, y, w, h, true);
        }
        if (shape.startsWith("xcleavage")) {
            Vector tokens = TextUtils.tokenize((String)shape, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererAWT.createCrossRingCleavage(Geometry.angle((Point)pp, (Point)pc), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("ycleavage")) {
            return ResidueRendererAWT.createCleavage(Geometry.angle((Point)pp, (Point)pc), x, y, w, h, true);
        }
        if (shape.equals("zcleavage")) {
            return ResidueRendererAWT.createCleavage(Geometry.angle((Point)pp, (Point)pc), x, y, w, h, false);
        }
        if (shape.equals("end")) {
            return ResidueRendererAWT.createEnd(Geometry.angle((Point)pp, (Point)ps), x, y, w, h);
        }
        return cur_bbox;
    }

    private Shape createRepetitionText(double angle, double x, double y, double w, double h, int min, int max) {
        double dist;
        Dimension tb;
        String text;
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        GeneralPath ret = new GeneralPath();
        if (min >= 0 || max >= 0) {
            double ymin;
            double xmin;
            text = min >= 0 ? "" + min : "0";
            tb = Geometry.textBounds((String)text, (String)this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, (int)this.theGraphicOptions.LINKAGE_INFO_SIZE);
            dist = Geometry.isUp((double)angle) || Geometry.isDown((double)angle) ? tb.width / 2 + 4 : tb.height / 2 + 4;
            if (Geometry.isLeft((double)angle) || Geometry.isUp((double)angle)) {
                xmin = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y2 + dist * Math.sin(angle - 1.5707963267948966) + (double)tb.height / 2.0;
            } else {
                xmin = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y3 + dist * Math.sin(angle + 1.5707963267948966) + (double)tb.height / 2.0;
            }
            ret.append(Geometry.getTextShape((double)xmin, (double)ymin, (String)text, (String)this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, (int)this.theGraphicOptions.LINKAGE_INFO_SIZE), false);
        }
        if (min >= 0 || max >= 0) {
            double ymax;
            double xmax;
            text = max >= 0 ? "" + max : "+inf";
            tb = Geometry.textBounds((String)text, (String)this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, (int)this.theGraphicOptions.LINKAGE_INFO_SIZE);
            dist = Geometry.isUp((double)angle) || Geometry.isDown((double)angle) ? tb.width / 2 + 4 : tb.height / 2 + 4;
            if (Geometry.isLeft((double)angle) || Geometry.isUp((double)angle)) {
                xmax = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y3 + dist * Math.sin(angle + 1.5707963267948966) + (double)tb.height / 2.0;
            } else {
                xmax = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y2 + dist * Math.sin(angle - 1.5707963267948966) + (double)tb.height / 2.0;
            }
            ret.append(Geometry.getTextShape((double)xmax, (double)ymax, (String)text, (String)this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, (int)this.theGraphicOptions.LINKAGE_INFO_SIZE), false);
        }
        return ret;
    }

    private Shape createTextShape(Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        double x = cur_bbox.getX();
        double y = cur_bbox.getY();
        double w = cur_bbox.getWidth();
        double h = cur_bbox.getHeight();
        if (shape.equals("endrep")) {
            return this.createRepetitionText(orientation.getAngle(), x, y, w, h, node.getMinRepetitions(), node.getMaxRepetitions());
        }
        return null;
    }

    private static Shape createTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        Polygon p = new Polygon();
        p.addPoint((int)x1, (int)y1);
        p.addPoint((int)x2, (int)y2);
        p.addPoint((int)x3, (int)y3);
        return p;
    }

    private static Shape createCheckered(double x, double y, double w, double h) {
        GeneralPath c = new GeneralPath();
        c.append(new Rectangle2D.Double(x + w / 2.0, y, w / 2.0, h / 2.0), false);
        c.append(new Rectangle2D.Double(x, y + h / 2.0, w / 2.0, h / 2.0), false);
        return c;
    }

    private static Shape createArc(double x, double y, double w, double h, int start_pos, int end_pos) {
        return new Arc2D.Double(x - 0.5 * w, y - 0.5 * h, 2.0 * w, 2.0 * h, (double)(-end_pos) * 60.0 + 30.0, (double)(-((start_pos - end_pos + 6) % 6)) * 60.0, 2);
    }

    private Shape createFillShape(Residue node, Rectangle cur_bbox) {
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String fillstyle = style.getFillStyle();
        double x = cur_bbox.x;
        double y = cur_bbox.y;
        double w = cur_bbox.width;
        double h = cur_bbox.height;
        if (fillstyle.equals("empty")) {
            return null;
        }
        if (fillstyle.equals("full")) {
            return cur_bbox;
        }
        if (fillstyle.equals("left")) {
            return new Rectangle2D.Double(x, y, w / 2.0, h);
        }
        if (fillstyle.equals("top")) {
            return new Rectangle2D.Double(x, y, w, h / 2.0);
        }
        if (fillstyle.equals("right")) {
            return new Rectangle2D.Double(x + w / 2.0, y, w / 2.0, h);
        }
        if (fillstyle.equals("bottom")) {
            return new Rectangle2D.Double(x, y + h / 2.0, w, h / 2.0);
        }
        if (fillstyle.equals("topleft")) {
            return ResidueRendererAWT.createTriangle(x, y, x + w, y, x, y + h);
        }
        if (fillstyle.equals("topright")) {
            return ResidueRendererAWT.createTriangle(x, y, x + w, y, x + w, y + h);
        }
        if (fillstyle.equals("bottomright")) {
            return ResidueRendererAWT.createTriangle(x + w, y, x + w, y + h, x, y + h);
        }
        if (fillstyle.equals("bottomleft")) {
            return ResidueRendererAWT.createTriangle(x, y, x + w, y + h, x, y + h);
        }
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double rx = w / 6.0;
        double ry = h / 6.0;
        if (fillstyle.equals("circle")) {
            return new Ellipse2D.Double(cx - rx, cy - ry, 2.0 * rx, 2.0 * ry);
        }
        if (fillstyle.equals("checkered")) {
            return ResidueRendererAWT.createCheckered(x, y, w, h);
        }
        if (fillstyle.startsWith("arc")) {
            Vector tokens = TextUtils.tokenize((String)fillstyle, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererAWT.createArc(x, y, w, h, first_pos, last_pos);
        }
        return null;
    }
}

