/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.s3.gui;

import com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.gui.AWSCredentialsDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.gui.LoginCredentialsPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.gui.LoginLocalFolderPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.gui.LoginPassphrasePanel;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.ProgressDialog;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.utils.ServiceUtils;

public class StartupDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -2520889480615456474L;
    private static final Log log = LogFactory.getLog(StartupDialog.class);
    public static final String EMPTY_PASSWORD_SURROGATE = "NONE";
    private Frame ownerFrame = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private Jets3tProperties myProperties = null;
    private AWSCredentials awsCredentials = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton storeCredentialsButton = null;
    private JTabbedPane tabbedPane = null;
    private LoginPassphrasePanel loginPassphrasePanel = null;
    private LoginLocalFolderPanel loginLocalFolderPanel = null;
    private LoginCredentialsPanel loginCredentialsPanel = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private static final int LOGIN_MODE_PASSPHRASE = 0;
    private static final int LOGIN_MODE_LOCAL_FOLDER = 1;
    private static final int LOGIN_MODE_DIRECT = 2;
    private int loginMode = 0;

    public StartupDialog(Frame owner, Jets3tProperties properties, HyperlinkActivatedListener hyperlinkListener) {
        super(owner, "Cockpit Login", true);
        this.ownerFrame = owner;
        this.hyperlinkListener = hyperlinkListener;
        this.myProperties = properties;
        this.initGui();
    }

    private void initGui() {
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.cancelButton = new JButton("Don't log in");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.storeCredentialsButton = new JButton("Store Credentials");
        this.storeCredentialsButton.setActionCommand("StoreCredentials");
        this.storeCredentialsButton.addActionListener(this);
        this.okButton = new JButton("Log in");
        this.okButton.setActionCommand("LogIn");
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -1742280851624947873L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartupDialog.this.setVisible(false);
            }
        });
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        buttonsPanel.add((Component)this.storeCredentialsButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        this.loginPassphrasePanel = new LoginPassphrasePanel(this.hyperlinkListener);
        this.loginLocalFolderPanel = new LoginLocalFolderPanel(this.ownerFrame, this.hyperlinkListener);
        this.loginCredentialsPanel = new LoginCredentialsPanel(false, this.hyperlinkListener);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.add((Component)this.loginPassphrasePanel, "S3 Online");
        this.tabbedPane.add((Component)this.loginLocalFolderPanel, "Local Folder");
        this.tabbedPane.add((Component)this.loginCredentialsPanel, "Direct Login");
        int row = 0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        this.getContentPane().add((Component)buttonsPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.pack();
        this.setSize(500, 400);
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton)) {
            if (this.loginMode == 0) {
                this.retrieveCredentialsFromS3(this.loginPassphrasePanel.getPassphrase(), this.loginPassphrasePanel.getPassword());
            } else if (this.loginMode == 1) {
                this.retrieveCredentialsFromDirectory(this.loginLocalFolderPanel.getHomeFolder(), this.loginLocalFolderPanel.getAWSCredentialsFile(), this.loginLocalFolderPanel.getPassword());
            } else if (this.loginMode == 2) {
                String[] inputErrors = this.loginCredentialsPanel.checkForInputErrors();
                if (inputErrors.length > 0) {
                    String errorMessages = "<html>Please correct the following errors:<ul>";
                    for (int i = 0; i < inputErrors.length; ++i) {
                        errorMessages = errorMessages + "<li>" + inputErrors[i] + "</li>";
                    }
                    errorMessages = errorMessages + "</ul></html>";
                    ErrorDialog.showDialog((JDialog)this, null, (String)errorMessages, null);
                } else {
                    this.awsCredentials = this.loginCredentialsPanel.getUsingDevPay() ? new AWSDevPayCredentials(this.loginCredentialsPanel.getAWSAccessKey(), this.loginCredentialsPanel.getAWSSecretKey(), this.loginCredentialsPanel.getAWSUserToken(), this.loginCredentialsPanel.getAWSProductToken(), this.loginCredentialsPanel.getFriendlyName()) : new AWSCredentials(this.loginCredentialsPanel.getAWSAccessKey(), this.loginCredentialsPanel.getAWSSecretKey(), this.loginCredentialsPanel.getFriendlyName());
                    this.setVisible(false);
                }
            }
        } else if (e.getSource().equals(this.storeCredentialsButton)) {
            if (this.loginMode == 0) {
                this.storeCredentialsInS3(this.loginPassphrasePanel.getPassphrase(), this.loginPassphrasePanel.getPassword());
            } else if (this.loginMode == 1) {
                this.storeCredentialsInDirectory(this.loginLocalFolderPanel.getHomeFolder(), this.loginLocalFolderPanel.getPassword());
            } else if (this.loginMode == 2) {
                throw new IllegalStateException("Cannot store AWS credentials from Direct Login panel");
            }
        } else if (e.getSource().equals(this.cancelButton)) {
            this.awsCredentials = null;
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.tabbedPane)) {
            this.loginMode = this.tabbedPane.getSelectedIndex();
            this.changedLoginMode();
        }
    }

    private void changedLoginMode() {
        if (this.loginMode == 0) {
            this.storeCredentialsButton.setEnabled(true);
        } else if (this.loginMode == 1) {
            this.storeCredentialsButton.setEnabled(true);
        } else if (this.loginMode == 2) {
            this.storeCredentialsButton.setEnabled(false);
        } else {
            throw new IllegalStateException("Invalid value for loginMode: " + this.loginMode);
        }
    }

    private String generateBucketNameFromPassphrase(String passphrase) throws Exception {
        return "jets3t-" + ServiceUtils.toHex((byte[])ServiceUtils.computeMD5Hash((byte[])passphrase.getBytes(Constants.DEFAULT_ENCODING)));
    }

    private String generateObjectKeyFromPassphrase(String passphrase, String password) throws Exception {
        String combinedString = passphrase + password;
        return ServiceUtils.toHex((byte[])ServiceUtils.computeMD5Hash((byte[])combinedString.getBytes(Constants.DEFAULT_ENCODING))) + "/jets3t.credentials";
    }

    private boolean validPassphraseInputs(String passphrase, String password) {
        String invalidInputsMessage = "";
        if (passphrase.length() < 6) {
            invalidInputsMessage = invalidInputsMessage + "Passphrase must be at least 6 characters.";
        }
        if (password.length() < 6) {
            invalidInputsMessage = invalidInputsMessage + (invalidInputsMessage.length() > 0 ? " and password" : "Password") + " must be at least 6 characters";
        }
        if (invalidInputsMessage.length() > 0) {
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)invalidInputsMessage, null);
            return false;
        }
        return true;
    }

    private boolean validFolderInputs(boolean isStoreAction, File directory, File credentialsFile, String password, boolean allowLegacyPassword) {
        if (password.length() < 6 && !allowLegacyPassword && !EMPTY_PASSWORD_SURROGATE.equals(password)) {
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)"Password must be at least 6 characters. If you do not wish to set a password, use the password NONE.", null);
            return false;
        }
        if (!directory.exists() || !directory.canWrite()) {
            String invalidInputsMessage = "Directory '" + directory.getAbsolutePath() + "' does not exist or cannot be written to.";
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)invalidInputsMessage, null);
            return false;
        }
        if (credentialsFile == null && !isStoreAction) {
            String invalidInputsMessage = "You must choose which stored login to use";
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)invalidInputsMessage, null);
            return false;
        }
        return true;
    }

    private void retrieveCredentialsFromS3(String passphrase, final String password) {
        if (!this.validPassphraseInputs(passphrase, password)) {
            return;
        }
        final String[] bucketName = new String[1];
        final String[] credentialObjectKey = new String[1];
        try {
            bucketName[0] = this.generateBucketNameFromPassphrase(passphrase);
            credentialObjectKey[0] = this.generateObjectKeyFromPassphrase(passphrase, password);
        }
        catch (Exception e) {
            String message = "Unable to generate bucket name or object key";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
            return;
        }
        final ProgressDialog progressDialog = new ProgressDialog(this.ownerFrame, "Retrieving AWS Credentials", null);
        final StartupDialog myself = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDialog.startDialog("Downloading your AWS Credentials", "", 0, 0, null, null);
                    }
                });
                S3Object encryptedCredentialsObject = null;
                try {
                    RestS3Service s3Service = new RestS3Service(null);
                    encryptedCredentialsObject = s3Service.getObject(new S3Bucket(bucketName[0]), credentialObjectKey[0]);
                }
                catch (S3ServiceException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    String errorMessage = "<html><center>Unable to find your AWS Credentials in S3<br><br>Please check your passphrase and password</center></html>";
                    log.error((Object)"<html><center>Unable to find your AWS Credentials in S3<br><br>Please check your passphrase and password</center></html>", (Throwable)e);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ErrorDialog.showDialog((JDialog)myself, (HyperlinkActivatedListener)StartupDialog.this.hyperlinkListener, (String)"<html><center>Unable to find your AWS Credentials in S3<br><br>Please check your passphrase and password</center></html>", null);
                            }
                        });
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDialog.updateDialog("Decrypting your AWS Credentials", null, 0);
                    }
                });
                try {
                    myself.awsCredentials = AWSCredentials.load((String)password, (BufferedInputStream)new BufferedInputStream(encryptedCredentialsObject.getDataInputStream()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    myself.setVisible(false);
                }
                catch (S3ServiceException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    String errorMessage = "<html><center>Unable to load your AWS Credentials from S3: <br><br>Please check your password</center></html>";
                    log.error((Object)errorMessage, (Throwable)e);
                    ErrorDialog.showDialog((JDialog)myself, (HyperlinkActivatedListener)StartupDialog.this.hyperlinkListener, (String)errorMessage, null);
                }
            }
        }).start();
    }

    private void storeCredentialsInS3(String passphrase, String password) {
        if (!this.validPassphraseInputs(passphrase, password)) {
            return;
        }
        final AWSCredentials awsCredentials = AWSCredentialsDialog.showDialog(this.ownerFrame, this.loginMode == 1, this.hyperlinkListener);
        if (awsCredentials == null) {
            return;
        }
        final String[] bucketName = new String[1];
        final String[] credentialObjectKey = new String[1];
        try {
            bucketName[0] = this.generateBucketNameFromPassphrase(passphrase);
            credentialObjectKey[0] = this.generateObjectKeyFromPassphrase(passphrase, password);
        }
        catch (Exception e) {
            String message = "Unable to generate bucket name or object key";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
            return;
        }
        final ByteArrayInputStream[] bais = new ByteArrayInputStream[1];
        try {
            String algorithm = this.myProperties.getStringProperty("crypto.algorithm", "PBEWithMD5AndDES");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            awsCredentials.save(password, (OutputStream)baos, algorithm);
            bais[0] = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Unable to encrypt your AWS Credentials";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
            return;
        }
        final ProgressDialog progressDialog = new ProgressDialog(this.ownerFrame, "Storing AWS Credentials", null);
        final StartupDialog myself = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDialog.startDialog("Uploading your AWS Credentials", null, 0, 0, null, null);
                    }
                });
                try {
                    S3Bucket bucket = new S3Bucket(bucketName[0]);
                    S3Object encryptedCredentialsObject = new S3Object(credentialObjectKey[0]);
                    encryptedCredentialsObject.setDataInputStream((InputStream)bais[0]);
                    encryptedCredentialsObject.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                    RestS3Service s3Service = new RestS3Service(awsCredentials);
                    s3Service.createBucket(bucketName[0]);
                    s3Service.putObject(bucket, encryptedCredentialsObject);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    JOptionPane.showMessageDialog(StartupDialog.this.ownerFrame, "Your AWS Credentials have been stored in your S3 account\n\nBucket name: " + bucketName[0] + "\nObject key: " + credentialObjectKey[0]);
                }
                catch (S3ServiceException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    String message = "Unable to store your AWS Credentials in S3";
                    log.error((Object)message, (Throwable)e);
                    ErrorDialog.showDialog((JDialog)myself, (HyperlinkActivatedListener)StartupDialog.this.hyperlinkListener, (String)message, (Throwable)e);
                }
            }
        }).start();
    }

    private void retrieveCredentialsFromDirectory(File directory, File credentialsFile, String password) {
        if (!this.validFolderInputs(false, directory, credentialsFile, password, true)) {
            return;
        }
        try {
            this.awsCredentials = AWSCredentials.load((String)password, (File)credentialsFile);
            this.setVisible(false);
        }
        catch (Exception e) {
            String message = "<html><center>Unable to load your AWS Credentials from the file: " + credentialsFile + "<br><br>Please check your password</center></html>";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, null);
        }
    }

    private void storeCredentialsInDirectory(File directory, String password) {
        AWSCredentials awsCredentials;
        if (!this.validFolderInputs(true, directory, null, password, false)) {
            return;
        }
        if (EMPTY_PASSWORD_SURROGATE.equals(password.trim())) {
            password = "";
        }
        if ((awsCredentials = AWSCredentialsDialog.showDialog(this.ownerFrame, true, this.hyperlinkListener)) == null) {
            return;
        }
        if (awsCredentials.getFriendlyName() == null || awsCredentials.getFriendlyName().length() == 0) {
            String message = "You must enter a nickname when storing your credentials";
            log.error((Object)message);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, null);
            return;
        }
        File credentialsFile = new File(directory, awsCredentials.getFriendlyName() + ".enc");
        try {
            String algorithm = this.myProperties.getStringProperty("crypto.algorithm", "PBEWithMD5AndDES");
            awsCredentials.save(password, credentialsFile, algorithm);
            this.loginLocalFolderPanel.clearPassword();
            this.loginLocalFolderPanel.refreshStoredCredentialsTable();
            JOptionPane.showMessageDialog(this.ownerFrame, "Your AWS Credentials have been stored in the file:\n" + credentialsFile.getAbsolutePath());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Unable to encrypt your AWS Credentials to a folder";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((JDialog)this, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
        }
    }

    public AWSCredentials getAWSCredentials() {
        return this.awsCredentials;
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        HyperlinkActivatedListener listener = new HyperlinkActivatedListener(){
            private static final long serialVersionUID = -225585129296632961L;

            public void followHyperlink(URL url, String target) {
                BareBonesBrowserLaunch.openURL((String)url.toString());
            }
        };
        StartupDialog startupDialog = new StartupDialog((Frame)f, Jets3tProperties.getInstance((String)Constants.JETS3T_PROPERTIES_FILENAME), listener);
        startupDialog.setVisible(true);
        AWSCredentials awsCredentials = startupDialog.getAWSCredentials();
        startupDialog.dispose();
        if (awsCredentials != null) {
            System.out.println("AWS Credentials: " + awsCredentials.getLogString());
        } else {
            System.out.println("AWS Credentials: null");
        }
        f.dispose();
    }
}

