/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Anomer {
    ALPHA("alpha", "a", "a", 'a', StereoConfiguration.Dexter.getStereosymbol()),
    BETA("beta", "b", "b", 'b', StereoConfiguration.Laevus.getStereosymbol()),
    OPEN_CHAIN("open-chain", "o", "", 'x', StereoConfiguration.Nonchiral.getStereosymbol()),
    UNKNOWN("unknown", "x", "?", '?', StereoConfiguration.Unknown.getStereosymbol()),
    NONE("none", "n", "", 'x', StereoConfiguration.Nonchiral.getStereosymbol());

    private String fullname;
    private String symbol;
    private String carbbankSymbol;
    private char bcsdbSymbol;
    private String stereosymbolD;

    private Anomer(String fullname, String symbol, String carbbankSym, char bcsdbSym, char stereosymbolD) {
        this.fullname = fullname;
        this.symbol = symbol;
        this.carbbankSymbol = carbbankSym;
        this.bcsdbSymbol = bcsdbSym;
        this.stereosymbolD = "" + stereosymbolD;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getCarbbankSymbol() {
        return this.carbbankSymbol;
    }

    public String formatCarbbankSymbol() {
        if (this.carbbankSymbol.length() > 0) {
            return this.carbbankSymbol + "-";
        }
        return "";
    }

    public char getBcsdbSymbol() {
        return this.bcsdbSymbol;
    }

    public String getStereosymbolD() {
        return this.stereosymbolD;
    }

    public static Anomer forNameOrSymbol(String anomerStr) throws MonosaccharideException {
        for (Anomer anom : Anomer.values()) {
            if (anomerStr.equalsIgnoreCase(anom.symbol)) {
                return anom;
            }
            if (!anomerStr.equalsIgnoreCase(anom.fullname)) continue;
            return anom;
        }
        throw new MonosaccharideException("Invalid value for anomer: " + anomerStr);
    }

    public static Anomer forBcsdbSymbol(char sym) {
        for (Anomer anom : Anomer.values()) {
            if (anom.bcsdbSymbol != sym) continue;
            return anom;
        }
        return null;
    }
}

