/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.NameParsingException;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardImporter
extends ResourcesDbObject {
    private String inputName;
    private boolean foundMs;
    private int parsingPosition = 0;
    private GlycanNamescheme namescheme;
    private String tmpStereocode;
    private TrivialnameTemplate detectedTrivialname;

    public StandardImporter(GlycanNamescheme scheme, Config confObj) {
        this(null, null, null);
    }

    public StandardImporter(GlycanNamescheme scheme, Config confObj, TemplateContainer container) {
        this.namescheme = scheme;
        this.setConfig(confObj);
        this.setTemplateContainer(container);
        this.inputName = null;
        this.foundMs = false;
    }

    public StandardImporter() {
        this((GlycanNamescheme)null, (Config)null);
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public void setNamescheme(GlycanNamescheme scheme) {
        this.namescheme = scheme;
    }

    public boolean isFoundMs() {
        return this.foundMs;
    }

    protected void setFoundMs(boolean foundMs) {
        this.foundMs = foundMs;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    protected String getTmpStereocode() {
        return this.tmpStereocode;
    }

    protected void setTmpStereocode(String tmpStereocode) {
        this.tmpStereocode = tmpStereocode;
    }

    protected int getParsingPosition() {
        return this.parsingPosition;
    }

    protected void setParsingPosition(int ppos) {
        this.parsingPosition = ppos;
    }

    protected void increaseParsingPosition() {
        ++this.parsingPosition;
    }

    protected void increaseParsingPosition(int steps) {
        this.parsingPosition += steps;
    }

    public TrivialnameTemplate getDetectedTrivialname() {
        return this.detectedTrivialname;
    }

    public void setDetectedTrivialname(TrivialnameTemplate detectedTrivialname) {
        this.detectedTrivialname = detectedTrivialname;
    }

    protected char getCurrentToken() throws NameParsingException {
        if (this.getInputName().length() <= this.getParsingPosition()) {
            throw new NameParsingException("unexpected end of string", this.getInputName(), this.getParsingPosition());
        }
        return this.getInputName().charAt(this.getParsingPosition());
    }

    protected String getCurrentSubstring(int length) throws NameParsingException {
        if (this.getInputName().length() < this.getParsingPosition() + length) {
            throw new NameParsingException("unexpected end of string", this.getInputName(), this.getParsingPosition());
        }
        return this.getInputName().substring(this.getParsingPosition(), this.getParsingPosition() + length);
    }

    protected boolean hasCurrentSubstring(String cmpString) {
        try {
            return this.getCurrentSubstring(cmpString.length()).equals(cmpString);
        }
        catch (NameParsingException npe) {
            return false;
        }
    }

    protected char getNextToken() throws NameParsingException {
        this.increaseParsingPosition();
        if (this.getInputName().length() <= this.getParsingPosition()) {
            throw new NameParsingException("unexpected end of string", this.getInputName(), this.getParsingPosition());
        }
        return this.getInputName().charAt(this.getParsingPosition());
    }

    protected boolean hasNextToken() {
        return this.getInputName() != null && this.getParsingPosition() + 1 < this.getInputName().length();
    }

    protected int countRemainingTokens() {
        if (this.getInputName() == null) {
            return -1;
        }
        return this.getInputName().length() - this.getParsingPosition();
    }

    protected boolean hasCurrentToken() {
        return this.getInputName() != null && this.getParsingPosition() < this.getInputName().length() && this.getParsingPosition() >= 0;
    }

    protected int parseIntNumber() throws NameParsingException {
        return this.parseIntNumber(false);
    }

    protected int parseIntNumber(boolean allowWildcard) throws NameParsingException {
        if (allowWildcard && this.getCurrentToken() == '?') {
            this.increaseParsingPosition();
            return 0;
        }
        String numberString = "";
        while (this.hasCurrentToken() && Character.isDigit(this.getCurrentToken())) {
            numberString = numberString + this.getCurrentToken();
            this.increaseParsingPosition();
        }
        if (numberString.length() == 0) {
            throw new NameParsingException("number expected ", this.getInputName(), this.getParsingPosition());
        }
        return Integer.parseInt(numberString);
    }

    protected ArrayList<Integer> parseIntNumberList() throws NameParsingException {
        return this.parseIntNumberList(false);
    }

    protected ArrayList<Integer> parseIntNumberList(boolean allowWildcard) throws NameParsingException {
        ArrayList<Integer> outList = new ArrayList<Integer>();
        int num = this.parseIntNumber(allowWildcard);
        outList.add(new Integer(num));
        while (this.hasCurrentToken() && this.getCurrentToken() == ',') {
            this.increaseParsingPosition();
            num = this.parseIntNumber(allowWildcard);
            outList.add(new Integer(num));
        }
        return outList;
    }

    protected String checkForTrivialname() throws ResourcesDbException {
        String detectedTrivName = null;
        for (String trivName : this.getTemplateContainer().getTrivialnameTemplateContainer().getTrivialnameBasetypeList(this.getNamescheme())) {
            if (detectedTrivName != null && detectedTrivName.length() >= trivName.length() || this.getInputName().length() - this.getParsingPosition() < trivName.length() || !this.getInputName().substring(this.getParsingPosition(), this.getParsingPosition() + trivName.length()).equals(trivName)) continue;
            detectedTrivName = trivName;
        }
        return detectedTrivName;
    }

    protected void addParsedSubstitution(Monosaccharide ms, String parsedName, ArrayList<Integer> posList) throws ResourcesDbException {
        SubstituentTemplate substTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forResidueIncludedName(this.getNamescheme(), parsedName);
        if (substTmpl == null) {
            throw new ResourcesDbException("internal error: cannot get template for substituent " + parsedName);
        }
        LinkageType linktype1 = substTmpl.getLinkageTypeBySubstituentName(this.getNamescheme(), parsedName);
        if (substTmpl.getMaxValence() == 1 || posList.size() == 1 && substTmpl.getMinValence() == 1) {
            for (Integer pos : posList) {
                Substitution subst = new Substitution();
                subst.setSubstitution(substTmpl, pos, linktype1);
                subst.setSourceName(parsedName);
                ms.addSubstitution(subst);
            }
        } else if (substTmpl.getMaxValence() == 2) {
            if (posList.size() != 2) {
                throw new NameParsingException("Only one position given for divalent substituent " + parsedName, this.getInputName(), this.getParsingPosition());
            }
            LinkageType linktype2 = substTmpl.getLinkageType2BySubstituentName(this.getNamescheme(), parsedName);
            Substitution subst = new Substitution();
            subst.setDivalentSubstitution(substTmpl, posList.get(0), linktype1, substTmpl.getDefaultLinkingPosition1(), posList.get(1), linktype2, substTmpl.getDefaultLinkingPosition2());
            subst.setSourceName(parsedName);
            ms.addSubstitution(subst);
        }
    }

    public void init() {
        this.setInputName(null);
        this.setParsingPosition(0);
        this.setFoundMs(false);
        this.setTmpStereocode(null);
        this.setDetectedTrivialname(null);
    }
}

