/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.entry.handler;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ICancelableEditor;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.tools.gsl.annotation.entry.views.tabbed.MSGlycolipidAnnotationMultiPageViewer;

public class ViewMSGlycolipidAnnotationResults {
    private static final Logger logger = Logger.getLogger(ViewMSGlycolipidAnnotationResults.class);
    public static final String PARAMETER_ID = "viewAnnotationResults_Entry";
    public static final String COMMAND_ID = "org.grits.toolbox.entry.ms.handler.viewMSGlycolipidAnnotationResults";
    @Inject
    static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    EPartService partService;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") Object object, @Named(value="activeShell") Shell shell, @Optional @Named(value="viewAnnotationResults_Entry") Entry entry) {
        if (entry == null) {
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            entry = selectedEntry;
        }
        this.showPlugInView(shell, entry);
    }

    private void showPlugInView(Shell shell, Entry entry) {
        block4: {
            if (entry != null) {
                MPart part = null;
                try {
                    part = gritsUIService.openEntryInPart(entry);
                    if (part != null && part.getObject() != null && part.getObject() instanceof ICancelableEditor && ((ICancelableEditor)part.getObject()).isCanceled()) {
                        this.partService.hidePart(part, true);
                    }
                }
                catch (Exception e) {
                    Exception pie = new Exception("There was an error converting the XML to a table.", e);
                    logger.error((Object)pie.getMessage(), (Throwable)pie);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Unable to open the results viewer", (Exception)pie);
                    if (part == null) break block4;
                    this.partService.hidePart(part, true);
                }
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") Object object, @Named(value="e4ActivePart") MPart part) {
        Entry entry = null;
        if (object instanceof Entry) {
            entry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            entry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (entry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            entry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (entry != null && (entry.getProperty().getType().equals("org.grits.toolbox.property.ms_annotation.glycolipid") || entry.getProperty() instanceof MSAnnotationEntityProperty)) {
            return true;
        }
        if (part != null && part.getObject() instanceof MSGlycolipidAnnotationMultiPageViewer) {
            return true;
        }
        for (MPart mPart : this.partService.getParts()) {
            if (!(mPart.getObject() instanceof MSGlycolipidAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement())) continue;
            return true;
        }
        return false;
    }
}

