/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptorInterface;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor_TBD;

public class BackboneCarbon {
    private Backbone m_objBackbone;
    private CarbonDescriptorInterface m_objCarbonDescriptor;
    private boolean m_bIsAnomericLike = false;
    private boolean m_bHasUnknownLength = false;

    public BackboneCarbon(Backbone a_oBackbone, CarbonDescriptor a_enumCarbonDescriptor, boolean a_bIsAnomeric, boolean a_bIsUnknown) {
        this.m_objBackbone = a_oBackbone;
        this.m_objCarbonDescriptor = a_enumCarbonDescriptor;
        this.m_bIsAnomericLike = a_bIsAnomeric;
        this.m_bHasUnknownLength = a_bIsUnknown;
    }

    public BackboneCarbon(Backbone a_oBackbone, CarbonDescriptor a_enumCarbonDescriptor, boolean a_bIsAnomeric) {
        this(a_oBackbone, a_enumCarbonDescriptor, a_bIsAnomeric, false);
    }

    public BackboneCarbon(Backbone a_oBackbone, CarbonDescriptor_TBD a_enumCarbonDescriptor) {
        this.m_objBackbone = a_oBackbone;
        this.m_objCarbonDescriptor = a_enumCarbonDescriptor;
    }

    public Backbone getBackbone() {
        return this.m_objBackbone;
    }

    public CarbonDescriptorInterface getDesctriptor() {
        return this.m_objCarbonDescriptor;
    }

    public boolean isAnomeric() {
        return this.m_bIsAnomericLike;
    }

    public boolean hasUnknownLength() {
        return this.m_bHasUnknownLength;
    }

    public boolean isChiral() {
        if (this.m_objCarbonDescriptor.getHybridOrbital() == null) {
            return false;
        }
        return this.m_objCarbonDescriptor.getHybridOrbital().equals("sp3") && this.m_objCarbonDescriptor.getStereo() != null;
    }

    public BackboneCarbon copy(Backbone backbone) {
        if (this.m_objCarbonDescriptor instanceof CarbonDescriptor_TBD) {
            return new BackboneCarbon(backbone, (CarbonDescriptor_TBD)this.m_objCarbonDescriptor);
        }
        return new BackboneCarbon(backbone, (CarbonDescriptor)this.m_objCarbonDescriptor, this.m_bIsAnomericLike, this.m_bHasUnknownLength);
    }

    public BackboneCarbon invert(Backbone backbone) {
        int symbolInv = this.m_objCarbonDescriptor.getChar();
        int n = symbolInv == 49 ? 50 : (symbolInv == 50 ? 49 : (symbolInv == 51 ? 52 : (symbolInv == 52 ? 51 : (symbolInv == 53 ? 54 : (symbolInv == 54 ? 53 : (symbolInv == 55 ? 56 : (symbolInv == 56 ? 55 : (symbolInv == 115 ? 114 : (symbolInv == 114 ? 115 : (symbolInv == 83 ? 82 : (symbolInv = symbolInv == 82 ? 83 : symbolInv)))))))))));
        if (this.m_objCarbonDescriptor instanceof CarbonDescriptor_TBD) {
            CarbonDescriptor_TBD cdInv = CarbonDescriptor_TBD.forCharacter((char)symbolInv, this.m_objCarbonDescriptor.isTerminal());
            return new BackboneCarbon(backbone, cdInv);
        }
        CarbonDescriptor cdInv = CarbonDescriptor.forCharacter((char)symbolInv, this.m_objCarbonDescriptor.isTerminal());
        return new BackboneCarbon(backbone, cdInv, this.m_bIsAnomericLike, this.m_bHasUnknownLength);
    }
}

