/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.filter.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;
import org.grits.toolbox.util.structure.glycan.filter.visitor.GlycoTraverserTreeProstOrder;
import org.grits.toolbox.util.structure.glycan.filter.visitor.MonosaccharidePattern;
import org.grits.toolbox.util.structure.glycan.filter.visitor.MonosaccharidePatternMatcher;

public class GlycoVisitorCountAntenna
implements GlycoVisitor {
    private Integer m_count = 0;
    private List<MonosaccharidePattern> m_excludeMS = new ArrayList<MonosaccharidePattern>();
    private MonosaccharidePatternMatcher m_matcher = new MonosaccharidePatternMatcher();
    private HashMap<GlycoNode, Boolean> m_hashExcluded = new HashMap();
    private GlycoVisitorNodeType m_visitorNodeType = new GlycoVisitorNodeType();
    private boolean m_filterBisection = true;
    private MonosaccharidePattern m_bisectionGlcNAc = MonosaccharidePattern.fromString("RES\n1b:x-dglc-HEX-1:5\n2s:n-acetyl\nLIN\n1:1d(2+1)2n");
    private MonosaccharidePattern m_bisectionCoreMan = MonosaccharidePattern.fromString("RES\n1b:x-dman-HEX-1:5");
    private MonosaccharidePattern m_bisectionCoreGlcNAc = MonosaccharidePattern.fromString("RES\n1b:x-dglc-HEX-1:5\n2s:n-acetyl\nLIN\n1:1d(2+1)2n");

    public void clear() {
        this.m_hashExcluded.clear();
        this.m_count = 0;
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_visitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeProstOrder(a_visitor);
    }

    public void start(Sugar a_sugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_sugar);
        for (UnderdeterminedSubTree t_tree : a_sugar.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(NonMonosaccharide a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("NonMonosaccharide is not supported.");
    }

    public void visit(SugarUnitRepeat a_repeat) throws GlycoVisitorException {
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_repeat);
        for (UnderdeterminedSubTree t_tree : a_repeat.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(Substituent a_arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitCyclic a_arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative is not supported.");
    }

    public void visit(UnvalidatedGlycoNode a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode is not supported.");
    }

    public void visit(GlycoEdge a_arg0) throws GlycoVisitorException {
    }

    public void visit(Monosaccharide a_monosaccharide) throws GlycoVisitorException {
        if (this.terminalMonosaccharide(a_monosaccharide)) {
            Integer n = this.m_count;
            Integer n2 = this.m_count = Integer.valueOf(this.m_count + 1);
        }
    }

    private boolean terminalMonosaccharide(Monosaccharide a_monosaccharide) throws GlycoVisitorException {
        GlycoVisitorNodeType t_visitorNodeType = new GlycoVisitorNodeType();
        for (GlycoEdge t_glycoEdge : a_monosaccharide.getChildEdges()) {
            if (this.m_hashExcluded.get(t_glycoEdge.getChild()) != null || t_visitorNodeType.getSubstituent(t_glycoEdge.getChild()) != null) continue;
            return false;
        }
        if (this.m_filterBisection && this.isBisection(a_monosaccharide)) {
            return false;
        }
        for (MonosaccharidePattern t_monosaccharidePattern : this.m_excludeMS) {
            if (!this.m_matcher.matchMonosaccharide(t_monosaccharidePattern, a_monosaccharide)) continue;
            if (this.hasTwoChildMS(a_monosaccharide.getParentNode())) {
                this.m_hashExcluded.put((GlycoNode)a_monosaccharide, Boolean.TRUE);
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean isBisection(Monosaccharide a_monosaccharide) throws GlycoVisitorException {
        Monosaccharide t_parentMS;
        GlycoNode t_parent;
        return this.m_matcher.matchMonosaccharide(this.m_bisectionGlcNAc, a_monosaccharide) && (t_parent = a_monosaccharide.getParentNode()) != null && (t_parentMS = this.m_visitorNodeType.getMonosaccharide(t_parent)) != null && this.m_matcher.matchMonosaccharide(this.m_bisectionCoreMan, t_parentMS) && (t_parent = t_parent.getParentNode()) != null && (t_parentMS = this.m_visitorNodeType.getMonosaccharide(t_parent)) != null && this.m_matcher.matchMonosaccharide(this.m_bisectionCoreGlcNAc, t_parentMS);
    }

    private boolean hasTwoChildMS(GlycoNode a_parentNode) throws GlycoVisitorException {
        if (a_parentNode == null) {
            return false;
        }
        int t_childMS = 0;
        for (GlycoEdge t_edge : a_parentNode.getChildEdges()) {
            if (this.m_hashExcluded.get(t_edge.getChild()) != null || this.m_visitorNodeType.getMonosaccharide(t_edge.getChild()) == null) continue;
            ++t_childMS;
        }
        return t_childMS >= 2;
    }

    public Integer getCount() {
        return this.m_count;
    }

    public List<MonosaccharidePattern> getExcludeMS() {
        return this.m_excludeMS;
    }

    public void setExcludeMS(List<MonosaccharidePattern> a_excludeMS) {
        this.m_excludeMS = a_excludeMS;
    }

    public boolean isFilterBisection() {
        return this.m_filterBisection;
    }

    public void setFilterBisection(boolean a_filterBisection) {
        this.m_filterBisection = a_filterBisection;
    }
}

