/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.utilShare.validator.IntegerValidator;
import org.grits.toolbox.util.structure.glycan.filter.om.ComboFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterAnd;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterNot;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterOr;
import org.grits.toolbox.util.structure.glycan.filter.om.IntegerFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.table.FilterRow;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class FilterTableSetup {
    protected static final Image CHECKED = ImageShare.CHECKBOX_ICON_YES.createImage();
    protected static final Image UNCHECKED = ImageShare.CHECKBOX_ICON_NO.createImage();
    protected List<FilterChangedListener> listeners = new ArrayList<FilterChangedListener>();
    protected TableViewer tableViewer = null;
    protected String op = "AND";
    protected List<Filter> filterList;
    protected String filterFile = null;
    protected ComboViewer comboOp;
    protected Button addButton;
    protected Button removeButton;
    protected ComboViewer combo;

    public void setFilterFile(String localFilterFile) {
        this.filterFile = localFilterFile;
    }

    public void addFilterChangedListener(FilterChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterChangedListener(FilterChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void loadFilters() throws Exception {
        this.filterList = new ArrayList<Filter>();
        if (this.filterFile != null) {
            this.filterList.addAll(FilterUtils.readFilters((String)this.filterFile).getFilters());
        }
        Collections.sort(this.filterList);
    }

    public void createFilterTableSection(Composite filterComposite) throws Exception {
        GridLayout gl_comp = new GridLayout();
        gl_comp.numColumns = 3;
        filterComposite.setLayout((Layout)gl_comp);
        this.comboOp = new ComboViewer(filterComposite, 8);
        this.comboOp.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboOp.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboOp.setInput((Object)new String[]{"AND", "OR"});
        this.comboOp.getCombo().select(0);
        this.comboOp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selected = FilterTableSetup.this.comboOp.getStructuredSelection();
                FilterTableSetup.this.op = (String)selected.getFirstElement();
                FilterTableSetup.this.filterUpdated();
            }
        });
        new Label(filterComposite, 0);
        new Label(filterComposite, 0);
        this.combo = new ComboViewer(filterComposite, 8);
        this.combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Filter) {
                    return ((Filter)element).getLabel();
                }
                return super.getText(element);
            }
        });
        if (this.filterList == null) {
            this.loadFilters();
        }
        this.combo.setInput(this.filterList);
        if (this.filterList.size() > 0) {
            this.combo.getCombo().select(0);
        }
        this.addButton = new Button(filterComposite, 8);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selected;
                if (FilterTableSetup.this.tableViewer != null && (selected = (IStructuredSelection)FilterTableSetup.this.combo.getSelection()) != null && selected.getFirstElement() instanceof Filter) {
                    Filter filter = (Filter)selected.getFirstElement();
                    FilterRow filterRow = new FilterRow();
                    filterRow.setFilter(filter.copy());
                    List currentInput = (List)FilterTableSetup.this.tableViewer.getInput();
                    currentInput.add(filterRow);
                    FilterTableSetup.this.filterUpdated();
                    FilterTableSetup.this.tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(filterComposite, 8);
        this.removeButton.setText("Remove");
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selected;
                if (FilterTableSetup.this.tableViewer != null && (selected = (IStructuredSelection)FilterTableSetup.this.tableViewer.getSelection()) != null && selected.getFirstElement() instanceof FilterRow) {
                    FilterRow filterRow = (FilterRow)selected.getFirstElement();
                    ((List)FilterTableSetup.this.tableViewer.getInput()).remove(filterRow);
                    FilterTableSetup.this.filterUpdated();
                    FilterTableSetup.this.tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createTable(filterComposite);
    }

    protected void filterUpdated() {
        for (FilterChangedListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    public List<Filter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<Filter> filterList) {
        this.filterList = filterList;
        Collections.sort(filterList);
    }

    protected void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68352);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 120;
        data.horizontalSpan = 3;
        this.tableViewer.getTable().setLayoutData((Object)data);
        TableViewerColumn filterColumn = new TableViewerColumn(this.tableViewer, 0);
        filterColumn.getColumn().setText("Filter");
        filterColumn.getColumn().setWidth(80);
        filterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilterRow) {
                    return ((FilterRow)element).getFilter().getLabel();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn filterDescriptionColumn = new TableViewerColumn(this.tableViewer, 0);
        filterDescriptionColumn.getColumn().setText("Description");
        filterDescriptionColumn.getColumn().setWidth(120);
        filterDescriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilterRow) {
                    return ((FilterRow)element).getFilter().getDescription();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn includeExcludeColumn = new TableViewerColumn(this.tableViewer, 0);
        includeExcludeColumn.getColumn().setText("Include");
        includeExcludeColumn.getColumn().setWidth(50);
        includeExcludeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof FilterRow) {
                    if (((FilterRow)element).getInclude().booleanValue()) {
                        return CHECKED;
                    }
                    return UNCHECKED;
                }
                return null;
            }
        });
        includeExcludeColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof FilterRow && value != null) {
                    Boolean current = ((FilterRow)element).getInclude();
                    ((FilterRow)element).setInclude((Boolean)value);
                    if (current == null || !current.equals(value)) {
                        FilterTableSetup.this.filterUpdated();
                        FilterTableSetup.this.tableViewer.update(element, null);
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof FilterRow) {
                    return ((FilterRow)element).getInclude();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)FilterTableSetup.this.tableViewer.getTable(), 32);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.getColumn().setText("Selection");
        valueColumn.getColumn().setWidth(100);
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            ComboBoxViewerCellEditor comboBoxViewerCellEditor;
            {
                this.comboBoxViewerCellEditor = null;
            }

            protected void setValue(Object element, Object value) {
                Filter filter;
                if (element instanceof FilterRow && (filter = ((FilterRow)element).getFilter()) instanceof ComboFilter && value != null) {
                    Filter current = ((ComboFilter)filter).getSelected();
                    ((ComboFilter)filter).setSelected((Filter)value);
                    if (current == null || !current.equals(value)) {
                        FilterTableSetup.this.filterUpdated();
                        FilterTableSetup.this.tableViewer.update(element, null);
                    }
                    FilterTableSetup.this.tableViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                Filter filter;
                if (element instanceof FilterRow && (filter = ((FilterRow)element).getFilter()) instanceof ComboFilter) {
                    return ((ComboFilter)filter).getSelected();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.comboBoxViewerCellEditor == null) {
                    this.comboBoxViewerCellEditor = new ComboBoxViewerCellEditor((Composite)FilterTableSetup.this.tableViewer.getTable(), 8);
                    this.comboBoxViewerCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                }
                if (element instanceof FilterRow && ((FilterRow)element).getFilter() instanceof ComboFilter) {
                    this.comboBoxViewerCellEditor.setInput((Object)((ComboFilter)((FilterRow)element).getFilter()).getFilters());
                }
                return this.comboBoxViewerCellEditor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof FilterRow && ((FilterRow)element).getFilter() instanceof ComboFilter;
            }
        });
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Filter selected;
                if (element instanceof FilterRow && ((FilterRow)element).getFilter() instanceof ComboFilter && (selected = ((ComboFilter)((FilterRow)element).getFilter()).getSelected()) != null) {
                    return selected.getLabel();
                }
                return "";
            }
        });
        TableViewerColumn minValueColumn = new TableViewerColumn(this.tableViewer, 0);
        minValueColumn.getColumn().setText("Min Value");
        minValueColumn.getColumn().setWidth(50);
        minValueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            TextCellEditor integerEditor;
            {
                this.integerEditor = null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.integerEditor == null) {
                    this.integerEditor = new TextCellEditor((Composite)FilterTableSetup.this.tableViewer.getTable());
                    ((Text)this.integerEditor.getControl()).setTextLimit(80);
                    ControlDecoration intControlDecoration = new ControlDecoration(this.integerEditor.getControl(), 0x1000000);
                    this.integerEditor.setValidator((ICellEditorValidator)new IntegerValidator(intControlDecoration));
                }
                return this.integerEditor;
            }

            protected Object getValue(Object element) {
                Filter filter;
                if (element instanceof FilterRow && (filter = ((FilterRow)element).getFilter()) instanceof IntegerFilter) {
                    Integer min = ((IntegerFilter)filter).getMin();
                    if (min == null) {
                        return "";
                    }
                    return "" + min;
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof FilterRow) {
                    Filter filter = ((FilterRow)element).getFilter();
                    if (value != null && ((String)value).length() > 0) {
                        Integer current = null;
                        if (filter instanceof IntegerFilter) {
                            current = ((IntegerFilter)filter).getMin();
                            ((IntegerFilter)filter).setMin(Integer.valueOf(Integer.parseInt((String)value)));
                        }
                        if (current == null || !current.equals(Integer.parseInt((String)value))) {
                            FilterTableSetup.this.filterUpdated();
                            FilterTableSetup.this.tableViewer.update(element, null);
                        }
                    } else {
                        Integer current = null;
                        if (filter instanceof IntegerFilter) {
                            current = ((IntegerFilter)filter).getMin();
                            ((IntegerFilter)filter).setMin(null);
                            if (current != null) {
                                FilterTableSetup.this.filterUpdated();
                                FilterTableSetup.this.tableViewer.update(element, null);
                            }
                        }
                    }
                }
            }

            protected boolean canEdit(Object element) {
                return element instanceof FilterRow && ((FilterRow)element).getFilter() instanceof IntegerFilter;
            }
        });
        minValueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilterRow) {
                    Filter filter = ((FilterRow)element).getFilter();
                    if (filter instanceof IntegerFilter) {
                        Integer value = ((IntegerFilter)filter).getMin();
                        if (value == null) {
                            return "";
                        }
                        return "" + value;
                    }
                    return null;
                }
                return super.getText(element);
            }
        });
        TableViewerColumn maxValueColumn = new TableViewerColumn(this.tableViewer, 0);
        maxValueColumn.getColumn().setText("Max Value");
        maxValueColumn.getColumn().setWidth(50);
        maxValueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FilterRow) {
                    Filter filter = ((FilterRow)element).getFilter();
                    if (filter instanceof IntegerFilter) {
                        Integer value = ((IntegerFilter)filter).getMax();
                        if (value == null) {
                            return "";
                        }
                        return "" + value;
                    }
                    return null;
                }
                return super.getText(element);
            }
        });
        maxValueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            TextCellEditor integerEditor;
            {
                this.integerEditor = null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.integerEditor == null) {
                    this.integerEditor = new TextCellEditor((Composite)FilterTableSetup.this.tableViewer.getTable());
                    ((Text)this.integerEditor.getControl()).setTextLimit(80);
                    ControlDecoration intControlDecoration = new ControlDecoration(this.integerEditor.getControl(), 0x1000000);
                    this.integerEditor.setValidator((ICellEditorValidator)new IntegerValidator(intControlDecoration));
                }
                return this.integerEditor;
            }

            protected Object getValue(Object element) {
                Filter filter;
                if (element instanceof FilterRow && (filter = ((FilterRow)element).getFilter()) instanceof IntegerFilter) {
                    Integer max = ((IntegerFilter)filter).getMax();
                    if (max == null) {
                        return "";
                    }
                    return "" + max;
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof FilterRow) {
                    Filter filter = ((FilterRow)element).getFilter();
                    if (value != null && ((String)value).length() > 0) {
                        Integer current = null;
                        if (filter instanceof IntegerFilter) {
                            current = ((IntegerFilter)filter).getMax();
                            Integer maxValue = Integer.parseInt((String)value);
                            ((IntegerFilter)filter).setMax(maxValue);
                            if (current == null || !current.equals(maxValue)) {
                                FilterTableSetup.this.filterUpdated();
                                FilterTableSetup.this.tableViewer.update(element, null);
                            }
                        }
                    } else {
                        Integer current = null;
                        if (filter instanceof IntegerFilter) {
                            current = ((IntegerFilter)filter).getMax();
                            ((IntegerFilter)filter).setMax(null);
                            if (current != null) {
                                FilterTableSetup.this.filterUpdated();
                                FilterTableSetup.this.tableViewer.update(element, null);
                            }
                        }
                    }
                }
            }

            protected boolean canEdit(Object element) {
                return element instanceof FilterRow && ((FilterRow)element).getFilter() instanceof IntegerFilter;
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.tableViewer.setInput(new ArrayList());
    }

    public FilterSetting getFilterSetting() {
        GlycanFilterAnd filter;
        if (this.tableViewer == null) {
            return null;
        }
        FilterSetting setting = new FilterSetting();
        ArrayList<Object> elements = new ArrayList<Object>();
        List rows = (List)this.tableViewer.getInput();
        for (FilterRow filterRow : rows) {
            Filter filterToSet = null;
            filterToSet = filterRow.getFilter() instanceof ComboFilter ? ((ComboFilter)filterRow.getFilter()).getSelected() : filterRow.getFilter();
            if (filterToSet == null) continue;
            if (filterToSet instanceof IntegerFilter) {
                Integer max = ((IntegerFilter)filterToSet).getMax();
                Integer min = ((IntegerFilter)filterToSet).getMin();
                if (min != null && min < 0) {
                    ((IntegerFilter)filterToSet).setMin(Integer.valueOf(0));
                }
                if (max != null && min != null && max < min) {
                    ((IntegerFilter)filterToSet).setMax(null);
                }
            }
            if (!filterRow.getInclude().booleanValue()) {
                GlycanFilterNot notFilter = new GlycanFilterNot();
                notFilter.setFilter(filterToSet);
                elements.add(notFilter);
                continue;
            }
            elements.add(filterToSet);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (this.op.equals("AND")) {
            filter = new GlycanFilterAnd();
            filter.setElements(elements);
            setting.setFilter((Filter)filter);
        } else {
            filter = new GlycanFilterOr();
            filter.setElements(elements);
            setting.setFilter((Filter)filter);
        }
        return setting;
    }

    public void resetFilters() {
        if (this.tableViewer != null) {
            this.tableViewer.setInput(new ArrayList());
        }
    }

    public void stopEditing() {
        this.tableViewer.applyEditorValue();
    }

    public void setExistingFilters(FilterSetting filterSetting) {
        if (this.tableViewer != null && filterSetting != null) {
            Filter filter = filterSetting.getFilter();
            List filters = null;
            if (filter instanceof GlycanFilterAnd) {
                this.op = "AND";
                this.comboOp.getCombo().select(0);
                filters = ((GlycanFilterAnd)filter).getElements();
            } else if (filter instanceof GlycanFilterOr) {
                this.op = "OR";
                this.comboOp.getCombo().select(1);
                filters = ((GlycanFilterOr)filter).getElements();
            }
            if (filters != null) {
                ArrayList<FilterRow> filterRows = new ArrayList<FilterRow>();
                for (Filter filter2 : filters) {
                    boolean include = true;
                    if (filter2 instanceof GlycanFilterNot) {
                        include = false;
                        filter2 = ((GlycanFilterNot)filter2).getFilter();
                    }
                    FilterRow filterRow = new FilterRow();
                    filterRow.setFilter(filter2);
                    filterRow.setInclude(Boolean.valueOf(include));
                    filterRows.add(filterRow);
                }
                this.tableViewer.setInput(filterRows);
            }
        }
    }

    public void setEnabled(boolean b) {
        this.combo.getCombo().setEnabled(b);
        this.comboOp.getCombo().setEnabled(b);
        this.tableViewer.getTable().setEnabled(b);
        this.addButton.setEnabled(b);
        this.removeButton.setEnabled(b);
    }
}

