/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.count;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.EdgeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.MatrixDataObject;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.NodeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchVisitor;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardEdgeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardNodeComparator;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorCountNodeType;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class CompositionSearchEngine {
    private Vector<MatrixDataObject> v_query = new Vector();
    private Vector<MatrixDataObject> v_queried = new Vector();
    private NodeComparator NodeComparator = new StandardNodeComparator();
    private EdgeComparator EdgeComparator = new StandardEdgeComparator();
    private Sugar queried = null;
    private Sugar query = null;
    private int[][] m_aMatrix;
    private int score = 0;
    private MatrixDataObject queriedMax = new MatrixDataObject();
    private MatrixDataObject queryMax = new MatrixDataObject();

    public void setQueriedStructure(Sugar queriedStructure) throws GlycoVisitorException {
        this.queried = queriedStructure;
        SearchVisitor sv = new SearchVisitor();
        sv.start(this.queried);
        this.v_queried = sv.getVector();
    }

    public void setQueryStructure(Sugar queryStructure) throws GlycoVisitorException {
        GlycoVisitorCountNodeType gvnt = new GlycoVisitorCountNodeType();
        gvnt.start(queryStructure);
        if (gvnt.getRepeatCount() > 0) {
            throw new GlycoVisitorException("No Repeats as queries. Expand Repeat query!");
        }
        this.query = queryStructure;
        SearchVisitor sv1 = new SearchVisitor();
        sv1.start(this.query);
        this.v_query = sv1.getVector();
    }

    public void setNodeComparator(NodeComparator NodeComparator2) {
        this.NodeComparator = NodeComparator2;
    }

    public void setEdgeComparator(EdgeComparator EdgeComparator2) {
        this.EdgeComparator = EdgeComparator2;
    }

    public Boolean isMatch() throws SearchEngineException {
        try {
            this.match();
        }
        catch (GlycoVisitorException e2) {
            throw new SearchEngineException(e2.getMessage());
        }
        catch (GlycoconjugateException e2) {
            throw new SearchEngineException(e2.getMessage());
        }
        catch (SearchEngineException e2) {
            throw e2;
        }
        GlycoVisitorCountNodeType g_count = new GlycoVisitorCountNodeType();
        try {
            g_count.start(this.query);
        }
        catch (GlycoVisitorException e) {
            throw new SearchEngineException(e.getMessage());
        }
        Integer count = g_count.getMonosaccharideCount() + g_count.getNonMonosaccharideCount() + g_count.getSubstituentCount() + g_count.getUnvalidatedNodeCount();
        if (this.getMax() >= count) {
            return true;
        }
        return false;
    }

    public void removeMatchedFromQueried() {
        ArrayList<MatrixDataObject> itemsToRemove = new ArrayList<MatrixDataObject>();
        this.removeMatchedChildren(this.queriedMax, this.queryMax, itemsToRemove);
        this.v_queried.remove(this.queriedMax);
        for (MatrixDataObject matrixDataObject : itemsToRemove) {
            this.v_queried.remove(matrixDataObject);
        }
    }

    public void removeMatchedChildren(MatrixDataObject queriedM, MatrixDataObject queryM, List<MatrixDataObject> itemsToRemove) {
        for (GlycoEdge t_childEdge_queried : queriedM.getChildren()) {
            for (GlycoEdge t_childEdge_query : queryM.getChildren()) {
                if (this.EdgeComparator.compare((Object)t_childEdge_queried, (Object)t_childEdge_query) != 0 || this.NodeComparator.compare((Object)t_childEdge_queried.getChild(), (Object)t_childEdge_query.getChild()) != 0) continue;
                for (MatrixDataObject a : this.v_queried) {
                    for (MatrixDataObject b : this.v_query) {
                        if (t_childEdge_queried.getChild() != a.getNode() || t_childEdge_query.getChild() != b.getNode()) continue;
                        itemsToRemove.add(a);
                        this.removeMatchedChildren(a, b, itemsToRemove);
                    }
                }
            }
        }
    }

    public int getNotMatchedCount() {
        return this.v_queried.size();
    }

    public void match() throws GlycoVisitorException, GlycoconjugateException, SearchEngineException {
        if (this.queried == null || this.query == null) {
            throw new SearchEngineException("You forgot to add sugars");
        }
        this.m_aMatrix = new int[this.v_queried.size()][this.v_query.size()];
        for (int i = 0; i < this.v_queried.size(); ++i) {
            for (int q = 0; q < this.v_query.size(); ++q) {
                this.score = 0;
                for (MatrixDataObject mdo : this.v_queried) {
                    mdo.setVisited(Boolean.valueOf(false));
                }
                for (MatrixDataObject mdo : this.v_query) {
                    mdo.setVisited(Boolean.valueOf(false));
                }
                this.m_aMatrix[i][q] = this.recursive(this.v_queried.get(i), this.v_query.get(q));
            }
        }
    }

    private int recursive(MatrixDataObject MDO_queried, MatrixDataObject MDO_query) throws GlycoconjugateException {
        GlycoNode queryNode;
        GlycoNode queriedNode = MDO_queried.getNode();
        if (this.NodeComparator.compare((Object)queriedNode, (Object)(queryNode = MDO_query.getNode())) == 0) {
            ++this.score;
            for (GlycoEdge t_childEdge_queried : MDO_queried.getChildren()) {
                for (GlycoEdge t_childEdge_query : MDO_query.getChildren()) {
                    if (this.EdgeComparator.compare((Object)t_childEdge_queried, (Object)t_childEdge_query) != 0 || this.NodeComparator.compare((Object)t_childEdge_queried.getChild(), (Object)t_childEdge_query.getChild()) != 0) continue;
                    for (MatrixDataObject a : this.v_queried) {
                        for (MatrixDataObject b : this.v_query) {
                            if (t_childEdge_queried.getChild() != a.getNode() || t_childEdge_query.getChild() != b.getNode() || b.getVisited().booleanValue() || this.score >= this.v_query.size()) continue;
                            this.block(b);
                            this.recursive(a, b);
                        }
                    }
                }
            }
        }
        return this.score;
    }

    private void block(MatrixDataObject mdo_queried) {
        for (MatrixDataObject mdo : this.v_queried) {
            if (mdo_queried != mdo) continue;
            mdo.setVisited(Boolean.valueOf(true));
        }
        for (MatrixDataObject mdo : this.v_query) {
            if (mdo_queried != mdo) continue;
            mdo.setVisited(Boolean.valueOf(true));
        }
    }

    private Integer getMax() {
        this.score = 0;
        Integer temp = 0;
        for (int t_counterG1 = 0; t_counterG1 < this.v_queried.size(); ++t_counterG1) {
            for (int t_counterG2 = 0; t_counterG2 < this.v_query.size(); ++t_counterG2) {
                if (this.m_aMatrix[t_counterG1][t_counterG2] <= temp) continue;
                temp = this.m_aMatrix[t_counterG1][t_counterG2];
                this.score = temp;
                this.queriedMax = this.v_queried.get(t_counterG1);
                this.queryMax = this.v_query.get(t_counterG2);
            }
        }
        return this.score;
    }
}

