/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.EurocarbResizableIcon;
import org.eurocarbdb.application.glycanbuilder.ICON_PATH;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ImageResizableIconReducedMem;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class ThemeManager {
    static final Logger log = Logger.getLogger(ThemeManager.class);
    public static ThemeManager defaultManager;
    protected List<ICON_PATH> iconPaths;
    protected Class clazz;
    public static boolean lookupNoneCached;

    public ThemeManager(String _iconPath, Class _defaultClazz) throws MalformedURLException {
        log.setLevel(Level.ALL);
        this.iconPaths = new ArrayList<ICON_PATH>();
        this.clazz = _defaultClazz;
        if (_iconPath != null) {
            try {
                this.addIconPath(_iconPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addIconPath(String _iconPath) throws IOException {
        this.addIconPath(_iconPath, this.clazz);
    }

    public void addIconPath(String _iconPath, Class _defaultClazz) throws IOException {
        ICON_PATH iconPath = new ICON_PATH(_iconPath, _defaultClazz, this);
        this.iconPaths.add(iconPath);
    }

    public EurocarbResizableIcon getResizableIcon(STOCK_ICON icon, ICON_SIZE iconSize) {
        ICON_PATH iconPath;
        EurocarbResizableIcon resizableIcon = null;
        Iterator<ICON_PATH> i$ = this.iconPaths.iterator();
        while (i$.hasNext() && (resizableIcon = (iconPath = i$.next()).getResizableIcon(icon, iconSize)) == null) {
        }
        if (resizableIcon != null) {
            return resizableIcon;
        }
        return ThemeManager.getResizableEmptyIcon(iconSize);
    }

    public EurocarbResizableIcon getResizableIcon(String id, ICON_SIZE iconSize) {
        ICON_PATH iconPath;
        EurocarbResizableIcon resizableIcon = null;
        Iterator<ICON_PATH> i$ = this.iconPaths.iterator();
        while (i$.hasNext() && (resizableIcon = (iconPath = i$.next()).getResizableIcon(id, iconSize)) == null) {
        }
        if (resizableIcon != null) {
            return resizableIcon;
        }
        return ThemeManager.getResizableEmptyIcon(iconSize);
    }

    public static EurocarbResizableIcon getResizableEmptyIcon(ICON_SIZE iconSize) {
        EurocarbResizableIcon eurocarbIcon = new EurocarbResizableIcon();
        eurocarbIcon.setResizableIcon(new ImageResizableIconReducedMem(ThemeManager.getEmptyIcon(iconSize).getImage(), iconSize.getSize(), iconSize.getSize()));
        eurocarbIcon.setIconProperties(null);
        return eurocarbIcon;
    }

    public ImageIcon getImageIcon(String id, ICON_SIZE iconSize) throws IOException {
        EurocarbResizableIcon iconR = this.getResizableIcon(id, iconSize);
        BufferedImage image = ImageIO.read(iconR.getIconProperties().imgURL);
        return new ImageIcon(ICON_PATH.scaleImage(image, iconSize.getSize(), iconSize.getSize()));
    }

    public ImageIcon getImageIcon(String id, int size) {
        EurocarbResizableIcon iconR = this.getResizableIcon(id, ICON_SIZE.L3);
        try {
            BufferedImage image = ImageIO.read(iconR.getIconProperties().imgURL);
            return new ImageIcon(ICON_PATH.scaleImage(image, size, size));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImageIcon getImageIcon(String id) {
        EurocarbResizableIcon iconR = this.getResizableIcon(id, ICON_SIZE.L3);
        return iconR.imageIcon;
    }

    public static ImageIcon getEmptyIcon(ICON_SIZE iconSize) {
        if (iconSize == null) {
            iconSize = ICON_SIZE.L2;
        }
        return new ImageIcon(new BufferedImage(iconSize.getSize(), iconSize.getSize(), 2));
    }

    public static void setDefaultResizePolicy(JRibbonBand band) {
        ArrayList<Object> resizePolicies = new ArrayList<Object>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)band.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)band.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy(band.getControlPanel()));
        band.setResizePolicies(resizePolicies);
    }

    static {
        log.setLevel(Level.ALL);
        lookupNoneCached = true;
    }
}

