/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class TerminalDictionary {
    private static TreeMap<String, TerminalType> dictionary = new TreeMap();
    private static Vector<String> superclasses = new Vector();
    private static Vector<TerminalType> all_terminals = new Vector();
    private static HashMap<String, Vector<TerminalType>> all_terminals_map = new HashMap();

    public static TerminalType getTerminalType(String type_name) throws Exception {
        if (dictionary.containsKey(type_name)) {
            return dictionary.get(type_name);
        }
        throw new Exception("Invalid type: <" + type_name + ">");
    }

    public static Iterator<TerminalType> iterator() {
        return all_terminals.iterator();
    }

    public static Collection<String> getSuperclasses() {
        return superclasses;
    }

    public static Collection<TerminalType> getTerminals() {
        return all_terminals;
    }

    public static Collection<TerminalType> getTerminals(String superclass) {
        return all_terminals_map.get(superclass);
    }

    public static Residue newTerminal(String type_name) throws Exception {
        if (type_name.length() > 2 && type_name.charAt(1) == '-') {
            return TerminalDictionary.getTerminalType(type_name.substring(2)).newTerminal(type_name.charAt(0));
        }
        return TerminalDictionary.getTerminalType(type_name).newTerminal();
    }

    private TerminalDictionary() {
    }

    public static void loadDictionary(String filename) {
        dictionary.clear();
        superclasses.clear();
        all_terminals.clear();
        all_terminals_map.clear();
        try {
            String line;
            URL file_url = TerminalDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                TerminalType type = new TerminalType(line);
                dictionary.put(type.getName(), type);
                TerminalDictionary.addSuperclass(type.getSuperclass());
                all_terminals.add(type);
                all_terminals_map.get(type.getSuperclass()).add(type);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            dictionary.clear();
        }
    }

    private static void addSuperclass(String superclass) {
        for (String sc : superclasses) {
            if (!sc.equals(superclass)) continue;
            return;
        }
        superclasses.add(superclass);
        all_terminals_map.put(superclass, new Vector());
    }
}

