/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.tools;

import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.widgets.progress.IProgressListener;

public class NotifyingProcessUtil {
    private static final Logger logger = Logger.getLogger(NotifyingProcessUtil.class);

    public static void setProgressType(List<IProgressListener> lProgressListeners, IProgressListener.ProgressType progressType) {
        try {
            if (lProgressListeners == null || lProgressListeners.isEmpty()) {
                return;
            }
            for (IProgressListener listener : lProgressListeners) {
                listener.setProgressType(progressType);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setMaxValue(List<IProgressListener> lProgressListeners, int _iVal) {
        try {
            if (lProgressListeners == null || lProgressListeners.isEmpty()) {
                return;
            }
            for (IProgressListener listener : lProgressListeners) {
                if (_iVal < 0) continue;
                listener.setMaxValue(_iVal);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void updateListeners(List<IProgressListener> lProgressListeners, String _sMsg, int _iVal) {
        try {
            if (lProgressListeners == null || lProgressListeners.isEmpty()) {
                return;
            }
            for (IProgressListener listener : lProgressListeners) {
                listener.setProgressMessage(_sMsg);
                if (_iVal < 0) continue;
                listener.setProgressValue(_iVal);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void updateErrorListener(List<IProgressListener> lProgressListeners, String _sMsg) {
        try {
            if (lProgressListeners == null || lProgressListeners.isEmpty()) {
                return;
            }
            for (IProgressListener listener : lProgressListeners) {
                listener.setError(_sMsg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void updateErrorListener(List<IProgressListener> lProgressListeners, String _sMsg, Throwable t) {
        try {
            if (lProgressListeners == null || lProgressListeners.isEmpty()) {
                return;
            }
            for (IProgressListener listener : lProgressListeners) {
                listener.setError(_sMsg, t);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

