/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;

public class AnnotationRowExtraction {
    private static final Logger logger = Logger.getLogger(AnnotationRowExtraction.class);

    public static final ArrayList<Scan> getPrecursorScan(Data data, Integer iParentScan, Integer iParentPeakNo, HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> htParentScanToParentPeaksToSubScan) {
        Scan precursorScan = null;
        ArrayList<Scan> alScans = new ArrayList<Scan>();
        if (iParentScan != null && htParentScanToParentPeaksToSubScan.containsKey(iParentScan)) {
            HashMap<Integer, ArrayList<Integer>> htParentPeaksToSubScans = htParentScanToParentPeaksToSubScan.get(iParentScan);
            if (iParentPeakNo != null && htParentPeaksToSubScans.containsKey(iParentPeakNo)) {
                ArrayList<Integer> alSubScans = htParentPeaksToSubScans.get(iParentPeakNo);
                for (Integer iScan : alSubScans) {
                    precursorScan = (Scan)data.getScans().get(iScan);
                    alScans.add(precursorScan);
                }
            }
        }
        if (alScans.isEmpty()) {
            alScans.add(null);
        }
        return alScans;
    }

    public static HashMap<String, List<Feature>> createRowIdToFeatureHash(ScanFeatures _features) {
        try {
            HashMap<String, List<Feature>> htRetData = new HashMap<String, List<Feature>>();
            for (Feature feature : _features.getFeatures()) {
                if (feature == null || feature.getFeatureSelections() == null || feature.getFeatureSelections().isEmpty()) continue;
                for (FeatureSelection selection : feature.getFeatureSelections()) {
                    List<Object> alFeatureList = null;
                    if (htRetData.containsKey(selection.getRowId())) {
                        alFeatureList = htRetData.get(selection.getRowId());
                    } else {
                        alFeatureList = new ArrayList();
                        htRetData.put(selection.getRowId(), alFeatureList);
                    }
                    if (alFeatureList.contains(feature)) continue;
                    alFeatureList.add(feature);
                }
            }
            return htRetData;
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Exception in createPeakIdToFeatureHash", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static HashMap<String, List<Feature>> createPeakIdToFeatureHash(ScanFeatures _features) {
        try {
            HashMap<String, List<Feature>> htRetData = new HashMap<String, List<Feature>>();
            for (Feature feature : _features.getFeatures()) {
                if (feature == null || feature.getPeaks() == null || feature.getPeaks().isEmpty()) continue;
                for (Integer rowId : feature.getPeaks()) {
                    List<Object> alFeatureList = null;
                    if (htRetData.containsKey(rowId.toString())) {
                        alFeatureList = htRetData.get(rowId.toString());
                    } else {
                        alFeatureList = new ArrayList();
                        htRetData.put(rowId.toString(), alFeatureList);
                    }
                    if (alFeatureList.contains(feature)) continue;
                    alFeatureList.add(feature);
                }
            }
            return htRetData;
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Exception in createPeakIdToFeatureHash", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> createParentScanToParentPeaksToSubScanHash(Data _data) {
        try {
            HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> htRetData = new HashMap<Integer, HashMap<Integer, ArrayList<Integer>>>();
            Set setParentScanNos = _data.getScans().keySet();
            Object[] arParentScanNos = setParentScanNos.toArray();
            for (int i = 0; i < arParentScanNos.length; ++i) {
                Integer iParentScan = (Integer)arParentScanNos[i];
                Scan curParentScan = (Scan)_data.getScans().get(iParentScan);
                if (curParentScan == null || curParentScan.getSubScans() == null || curParentScan.getSubScans().isEmpty()) continue;
                HashMap<Object, Object> htParentPeaks = null;
                if (htRetData.containsKey(iParentScan)) {
                    htParentPeaks = htRetData.get(iParentScan);
                } else {
                    htParentPeaks = new HashMap();
                    htRetData.put(iParentScan, htParentPeaks);
                }
                List iSubScanNos = curParentScan.getSubScans();
                for (int iSubScan = 0; iSubScan < iSubScanNos.size(); ++iSubScan) {
                    Scan curSubScan = (Scan)_data.getScans().get(iSubScanNos.get(iSubScan));
                    if (curSubScan == null || curSubScan.getPrecursor() == null) continue;
                    Integer iParentPeak = curSubScan.getPrecursor().getId();
                    ArrayList alSubScans = null;
                    if (htParentPeaks.containsKey(iParentPeak)) {
                        alSubScans = (ArrayList)htParentPeaks.get(iParentPeak);
                    } else {
                        alSubScans = new ArrayList();
                        htParentPeaks.put(iParentPeak, alSubScans);
                    }
                    alSubScans.add(curSubScan.getScanNo());
                }
            }
            return htRetData;
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Exception in createParentScanToParentPeaksToSubScanHash", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static void updateParentScanToParentPeaksToSubScanHashForDirectInfusion(HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> htParentScanToParentPeaksToSubScanHash, Data _data) {
        try {
            Set setParentScanNos = _data.getScans().keySet();
            Object[] arParentScanNos = setParentScanNos.toArray();
            for (int i = 0; i < arParentScanNos.length; ++i) {
                Integer iThatParentScan = (Integer)arParentScanNos[i];
                Scan sThatParentScan = (Scan)_data.getScans().get(iThatParentScan);
                if (sThatParentScan.getMsLevel() != 1) continue;
                HashMap<Object, Object> htThatParentPeaksToSubScanHash = null;
                if (htParentScanToParentPeaksToSubScanHash.containsKey(iThatParentScan)) {
                    htThatParentPeaksToSubScanHash = htParentScanToParentPeaksToSubScanHash.get(iThatParentScan);
                } else {
                    htThatParentPeaksToSubScanHash = new HashMap();
                    htParentScanToParentPeaksToSubScanHash.put(iThatParentScan, htThatParentPeaksToSubScanHash);
                }
                for (int j = 0; j < arParentScanNos.length; ++j) {
                    if (i == j) continue;
                    Integer iThisParentScan = (Integer)arParentScanNos[j];
                    Scan sThisParentScan = (Scan)_data.getScans().get(iThisParentScan);
                    if (sThisParentScan.getMsLevel() != 1) continue;
                    HashMap<Integer, ArrayList<Integer>> htThisParentPeaksToSubScansHash = null;
                    if (!htParentScanToParentPeaksToSubScanHash.containsKey(iThisParentScan)) continue;
                    htThisParentPeaksToSubScansHash = htParentScanToParentPeaksToSubScanHash.get(iThisParentScan);
                    for (Integer iThisParentPeak : htThisParentPeaksToSubScansHash.keySet()) {
                        ArrayList alThoseSubScans = null;
                        if (htThatParentPeaksToSubScanHash.containsKey(iThisParentPeak)) {
                            alThoseSubScans = (ArrayList)htThatParentPeaksToSubScanHash.get(iThisParentPeak);
                        } else {
                            alThoseSubScans = new ArrayList();
                            htThatParentPeaksToSubScanHash.put(iThisParentPeak, alThoseSubScans);
                        }
                        ArrayList<Integer> alTheseSubScans = htThisParentPeaksToSubScansHash.get(iThisParentPeak);
                        for (Integer iThisSubScan : alTheseSubScans) {
                            if (alThoseSubScans.contains(iThisSubScan)) continue;
                            alThoseSubScans.add(iThisSubScan);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Exception in updateParentScanToParentPeaksToSubScanHashForDirectInfusion", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static boolean convertPeakIdsToRowIds(Data data, ScanFeatures scanFeatures, int iParentScan, Integer iPeakId, ArrayList<Scan> precursorScans, HashMap<String, List<Feature>> htPeakToFeatures) {
        boolean bConverted = false;
        boolean bNullPrecursor = false;
        for (Scan precursorScan : precursorScans) {
            String sRowId2;
            String sRowId1 = iPeakId.toString();
            if (precursorScan == null) {
                bNullPrecursor = true;
            }
            String string = sRowId2 = bNullPrecursor ? sRowId1 : Feature.getRowId((Integer)iPeakId, (Integer)precursorScan.getScanNo(), (boolean)true);
            if (!htPeakToFeatures.containsKey(sRowId1)) continue;
            List<Feature> alFeatures = htPeakToFeatures.get(sRowId1);
            ArrayList<Feature> alNewFeatures = new ArrayList<Feature>();
            for (Feature feature : alFeatures) {
                if (!feature.getPeaks().contains(iPeakId)) continue;
                FeatureSelection fSelection = new FeatureSelection();
                fSelection.setRowId(sRowId2);
                fSelection.setManuallySelected(feature.getManuallySelected());
                fSelection.setSelected(feature.getSelected());
                feature.getFeatureSelections().add(fSelection);
                alNewFeatures.add(feature);
                bConverted = true;
            }
            if (alNewFeatures.isEmpty()) continue;
            htPeakToFeatures.put(sRowId2, alNewFeatures);
        }
        if (bConverted) {
            if (htPeakToFeatures.containsKey(iPeakId.toString())) {
                List<Feature> alFeatures = htPeakToFeatures.get(iPeakId.toString());
                for (Feature feature : alFeatures) {
                    if (!feature.getPeaks().contains(iPeakId)) continue;
                    feature.getPeaks().remove(iPeakId);
                }
                if (!bNullPrecursor) {
                    htPeakToFeatures.remove(iPeakId.toString());
                }
            }
            scanFeatures.setUsesComplexRowId(Boolean.valueOf(true));
        }
        return bConverted;
    }

    public static ArrayList<Integer> getUniqueAnnotationList(ScanFeatures _features) {
        ArrayList<Integer> alList = new ArrayList<Integer>();
        for (Feature feature : _features.getFeatures()) {
            if (feature == null || alList.contains(feature.getAnnotationId())) continue;
            alList.add(feature.getAnnotationId());
        }
        return alList;
    }

    public static Annotation getAnnotation(Data _data, Integer annId) {
        for (Annotation ann : _data.getAnnotation()) {
            if (!ann.getId().equals(annId)) continue;
            return ann;
        }
        return null;
    }
}

