/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerNatTable;

public class ManagerTableBase {
    GeneList geneList;
    private GeneListManagerEditor editor;

    public ManagerTableBase(GeneListManagerEditor editor) {
        this.editor = editor;
    }

    public void setGeneList(GeneList geneList) {
        this.geneList = geneList;
    }

    public Control createControl(Composite parent) {
        ArrayList<List<GRITSColumnHeader>> columnList = new ArrayList<List<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> firstLevelColumns = new ArrayList<GRITSColumnHeader>();
        this.addColumns(firstLevelColumns);
        columnList.add(firstLevelColumns);
        ArrayList<TableData> allData = new ArrayList<TableData>();
        for (Gene gene : this.geneList.getGenes()) {
            allData.add(gene);
        }
        ManagerNatTable natTable = new ManagerNatTable(parent, this.editor, columnList);
        natTable.setTableData(allData);
        natTable.setGeneList(this.geneList);
        natTable.initializeComponents();
        return natTable;
    }

    private void addColumns(List<GRITSColumnHeader> columnList) {
        GRITSColumnHeader header = new GRITSColumnHeader("Select", "Select");
        columnList.add(header);
        header = new GRITSColumnHeader("Gene Identifier", "Gene Identifier");
        columnList.add(header);
        header = new GRITSColumnHeader("Gene Symbol", "Gene Symbol");
        columnList.add(header);
        header = new GRITSColumnHeader("ID", "ID");
        columnList.add(header);
        header = new GRITSColumnHeader("Name", "Name");
        columnList.add(header);
        header = new GRITSColumnHeader("Description", "Description");
        columnList.add(header);
        header = new GRITSColumnHeader("Notes", "Notes");
        columnList.add(header);
        header = new GRITSColumnHeader("Forward Primer", "Forward Primer");
        columnList.add(header);
        header = new GRITSColumnHeader("Reverse Primer", "Reverse Primer");
        columnList.add(header);
        header = new GRITSColumnHeader("Group", "Group");
        columnList.add(header);
        header = new GRITSColumnHeader("Aliases", "Aliases");
        columnList.add(header);
        header = new GRITSColumnHeader("Genomic Location", "Genomic Location");
        columnList.add(header);
        header = new GRITSColumnHeader("RefSeq", "RefSeq");
        columnList.add(header);
        header = new GRITSColumnHeader("Protein RefSeq", "Protein RefSeq");
        columnList.add(header);
        header = new GRITSColumnHeader("Control?", "Control?");
        columnList.add(header);
    }
}

