/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference.cartoon;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferencesLoader;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationFigureCanvas;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.grits.toolbox.utils.image.ImageCreationException;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.progress.ProgressThread;
import org.grits.toolbox.widgets.tools.IGRITSEventListener;

public class MSGlycanAnnotationCartoonPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationCartoonPreferencePage.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.datamodel.ms.annotation.glycan.cartoon";
    private MSGlycanAnnotationCartoonPreferences cartoonPreferences = null;
    private Label imageLayout = null;
    private Combo imageLayoutCombo = null;
    private Label imageStyle = null;
    private Combo imageStyleCombo = null;
    private Label lblImageOrientation = null;
    private Combo cImageOrientation = null;
    private Label lblShowInfo = null;
    private Button btnShowInfoYes = null;
    private Button btnShowInfoNo = null;
    private Label lblShowMasses = null;
    private Button btnShowMassesYes = null;
    private Button btnShowMassesNo = null;
    private Label lblShowRedEnd = null;
    private Button btnShowRedEndYes = null;
    private Button btnShowRedEndNo = null;
    private MSGlycanAnnotationFigureCanvas canvas = null;
    private Text scaleValue = null;
    private Label scaleLabel = null;
    private Scale scale = null;
    private Composite container;
    private static String SEQUENCE = "freeEnd--??1D-GlcNAc,p(--4b1D-GlcNAc,p--4b1D-Man,p((--3a1D-Man,p--2b1D-GlcNAc,p--4b1D-Gal,p)--6a1D-Man,p--2b1D-GlcNAc,p--4b1D-Gal,p)--4b1D-GlcNAc,p)--6a1D-Fuc,p$MONO,perMe,Na,0,freeEnd";
    private static final double SCALE_FACTOR = 32.0;
    private final DecimalFormat dcF = new DecimalFormat("0.00");
    private List<IGRITSEventListener> eventListeners = new ArrayList<IGRITSEventListener>();
    public static final int GLYCAN_BLOCK_RELEASED = 12345;

    public MSGlycanAnnotationCartoonPreferencePage() {
        this.loadWorkspacePreferences();
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.numColumns = 6;
        this.container.setLayout((Layout)layout);
        this.createImageLayoutCombo();
        this.createImageStyleCombo();
        this.addImageOrientationParts();
        this.addShowMassesParts();
        this.addShowRedEndParts();
        this.createScalePart();
        this.createShowImagePart();
        this.setPageComplete(true);
        return this.container;
    }

    private void createImageStyleCombo() {
        this.imageStyle = new Label(this.container, 0);
        this.imageStyle.setText("Image Style");
        GridData comboData = new GridData(768);
        this.imageStyleCombo = new Combo(this.container, 2568);
        comboData.horizontalSpan = 5;
        this.imageStyleCombo.setLayoutData((Object)comboData);
        Object[] elements = this.cartoonPreferences.getAllStyles().toArray();
        int i = 0;
        while (i < elements.length) {
            this.imageStyleCombo.add((String)elements[i]);
            if (this.cartoonPreferences.getImageStyle().equals((String)elements[i])) {
                this.imageStyleCombo.select(i);
            }
            ++i;
        }
        this.imageStyleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setImageStyle(MSGlycanAnnotationCartoonPreferencePage.this.imageStyleCombo.getText());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createImageLayoutCombo() {
        this.imageLayout = new Label(this.container, 0);
        this.imageLayout.setText("Image Layout");
        GridData comboData = new GridData(768);
        this.imageLayoutCombo = new Combo(this.container, 2568);
        comboData.horizontalSpan = 5;
        this.imageLayoutCombo.setLayoutData((Object)comboData);
        Object[] elements = this.cartoonPreferences.getAllLayouts().toArray();
        int i = 0;
        while (i < elements.length) {
            this.imageLayoutCombo.add((String)elements[i]);
            if (this.cartoonPreferences.getImageLayout().equals((String)elements[i])) {
                this.imageLayoutCombo.select(i);
            }
            ++i;
        }
        this.imageLayoutCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setImageLayout(MSGlycanAnnotationCartoonPreferencePage.this.imageLayoutCombo.getText());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addImageOrientationParts() {
        this.lblImageOrientation = new Label(this.container, 0);
        this.lblImageOrientation.setText("Image Orientation");
        GridData comboData = new GridData(768);
        this.cImageOrientation = new Combo(this.container, 2568);
        comboData.horizontalSpan = 5;
        this.cImageOrientation.setLayoutData((Object)comboData);
        Object[] elements = this.cartoonPreferences.getAllOrientations().toArray();
        int i = 0;
        while (i < elements.length) {
            this.cImageOrientation.add((String)elements[i]);
            if (this.cartoonPreferences.getOrientation().equals((String)elements[i])) {
                this.cImageOrientation.select(i);
            }
            ++i;
        }
        if (this.cImageOrientation.getSelectionIndex() < 0) {
            this.cImageOrientation.select(0);
        }
        this.cImageOrientation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setOrientation(MSGlycanAnnotationCartoonPreferencePage.this.cImageOrientation.getText());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addShowMassesParts() {
        this.lblShowMasses = new Label(this.container, 0);
        this.lblShowMasses.setText("Show Masses");
        Composite cmp = new Composite(this.container, 0);
        GridData cmpGD = new GridData(768);
        cmpGD.horizontalSpan = 2;
        cmp.setLayoutData((Object)cmpGD);
        cmp.setLayout((Layout)new RowLayout());
        this.btnShowMassesYes = new Button(cmp, 16);
        this.btnShowMassesYes.setText("Yes");
        if (this.cartoonPreferences.isShowMasses()) {
            this.btnShowMassesYes.setSelection(true);
        }
        this.btnShowMassesNo = new Button(cmp, 16);
        this.btnShowMassesNo.setText("No");
        if (!this.cartoonPreferences.isShowMasses()) {
            this.btnShowMassesNo.setSelection(true);
        }
        this.btnShowMassesYes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setShowMasses(MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesNo.setSelection(!MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnShowMassesNo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setShowMasses(MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesYes.setSelection(MSGlycanAnnotationCartoonPreferencePage.this.btnShowMassesYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData filler = new GridData(768);
        filler.horizontalSpan = 3;
        Label lblFill = new Label(this.container, 0);
        lblFill.setLayoutData((Object)filler);
    }

    private void addShowRedEndParts() {
        this.lblShowRedEnd = new Label(this.container, 0);
        this.lblShowRedEnd.setText("Show Reducing End");
        Composite cmp = new Composite(this.container, 0);
        GridData cmpGD = new GridData(768);
        cmpGD.horizontalSpan = 2;
        cmp.setLayoutData((Object)cmpGD);
        cmp.setLayout((Layout)new RowLayout());
        this.btnShowRedEndYes = new Button(cmp, 16);
        this.btnShowRedEndYes.setText("Yes");
        if (this.cartoonPreferences.isShowRedEnd()) {
            this.btnShowRedEndYes.setSelection(true);
        }
        new GridData(768);
        this.btnShowRedEndNo = new Button(cmp, 16);
        this.btnShowRedEndNo.setText("No");
        if (!this.cartoonPreferences.isShowRedEnd()) {
            this.btnShowRedEndNo.setSelection(true);
        }
        this.btnShowRedEndYes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setShowRedEnd(MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndNo.setSelection(!MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnShowRedEndNo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setShowRedEnd(MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndYes.setSelection(MSGlycanAnnotationCartoonPreferencePage.this.btnShowRedEndYes.getSelection());
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData filler = new GridData(768);
        filler.horizontalSpan = 3;
        Label lblFill = new Label(this.container, 0);
        lblFill.setLayoutData((Object)filler);
    }

    private void createScalePart() {
        this.scaleLabel = new Label(this.container, 0);
        this.scaleLabel.setText("Image Scaling Factor");
        this.scale = new Scale(this.container, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.scale.setMinimum(1);
        int iMax = 128;
        this.scale.setMaximum(iMax);
        this.scale.setIncrement(1);
        int iPrefVal = (int)(Double.parseDouble(this.cartoonPreferences.getImageScaleFactor()) * 32.0);
        this.scale.setSelection(iPrefVal);
        this.scale.setLayoutData((Object)data);
        this.scaleValue = new Text(this.container, 2048);
        this.scaleValue.setEditable(true);
        double dVal = (double)iPrefVal / 32.0;
        this.scaleValue.setText(this.dcF.format(dVal));
        this.scale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                double dVal = (double)MSGlycanAnnotationCartoonPreferencePage.this.scale.getSelection() / 32.0;
                MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setImageScaleFactor(String.valueOf(dVal));
                MSGlycanAnnotationCartoonPreferencePage.this.scaleValue.setText(MSGlycanAnnotationCartoonPreferencePage.this.dcF.format(dVal));
                MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.scaleValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                double dVal = (double)MSGlycanAnnotationCartoonPreferencePage.this.scale.getSelection() / 32.0;
                try {
                    dVal = Double.parseDouble(MSGlycanAnnotationCartoonPreferencePage.this.scaleValue.getText());
                    MSGlycanAnnotationCartoonPreferencePage.this.cartoonPreferences.setImageScaleFactor(String.valueOf(dVal));
                    int iScaleVal = (int)Math.round(dVal * 32.0);
                    MSGlycanAnnotationCartoonPreferencePage.this.scale.setSelection(iScaleVal);
                    MSGlycanAnnotationCartoonPreferencePage.this.drawImage();
                }
                catch (NumberFormatException numberFormatException) {}
                MSGlycanAnnotationCartoonPreferencePage.this.isValid();
            }
        });
    }

    private void drawImage() {
        CartoonOptions options = this.getCartoonOptions();
        if (options != null) {
            this.canvas.updateCartoonOptions(options);
            this.canvas.updateImage();
            this.canvas.drawImage();
        }
    }

    private void createShowImagePart() {
        try {
            GridData gridData1 = new GridData(1808);
            Group imageGroup = new Group(this.container, 0);
            imageGroup.setLayout((Layout)new FillLayout());
            imageGroup.setText("Image");
            imageGroup.setLayoutData((Object)gridData1);
            gridData1.horizontalSpan = 6;
            CartoonOptions options = this.getCartoonOptions();
            if (options != null) {
                this.canvas = new MSGlycanAnnotationFigureCanvas((Composite)imageGroup, 768, options);
                this.canvas.updateGlycan(SEQUENCE);
                MSGlycanAnnotationTableDataObject.glycanImageProvider.addImageToProvider(SEQUENCE, SEQUENCE);
            }
            this.drawImage();
        }
        catch (ImageCreationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized CartoonOptions getCartoonOptions() {
        try {
            CartoonOptions options = new CartoonOptions(MSGlycanAnnotationCartoonPreferences.getGWBlayoutString((String)this.imageLayoutCombo.getText()), MSGlycanAnnotationCartoonPreferences.getGWBStyleString((String)this.imageStyleCombo.getText()), Double.valueOf((double)this.scale.getSelection() / 32.0), Integer.valueOf(MSGlycanAnnotationCartoonPreferences.getGWBOrientationCode((String)this.cImageOrientation.getText())), true, this.btnShowMassesYes.getSelection(), this.btnShowRedEndYes.getSelection());
            return options;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in MSGlycanAnnotationFigureCanvas.updateCartoonOptions", (Throwable)e);
            return null;
        }
    }

    public boolean isValid() {
        try {
            double dVal = Double.parseDouble(this.scaleValue.getText());
            if (dVal > 0.0 && dVal <= 4.0) {
                this.setPageComplete(true);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setErrorMessage("Please enter a Scale Factor value greater than 0 and less than or equal to 4.");
        this.setPageComplete(false);
        return false;
    }

    protected void setPageComplete(boolean b) {
        if (b) {
            this.setErrorMessage(null);
        }
        this.setValid(b);
    }

    protected void performApply() {
        this.cartoonPreferences.saveValues();
    }

    public boolean performOk() {
        try {
            ImageConverterThread converter = new ImageConverterThread(this.getCartoonOptions());
            ProgressDialog t_dialog = new ProgressDialog(this.getShell());
            t_dialog.setWorker((ProgressThread)converter);
            t_dialog.open();
            MSGlycanAnnotationTableDataObject.glycanImageProvider.notifyListeners(12345);
        }
        catch (Exception ex) {
            logger.info((Object)"Exception in MSGlycanAnnotationFigureCanvas.performOk", (Throwable)ex);
        }
        this.cartoonPreferences.saveValues();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected void performDefaults() {
    }

    private boolean loadWorkspacePreferences() {
        try {
            this.cartoonPreferences = MSGlycanAnnotationCartoonPreferencesLoader.getCartoonPreferences();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the Preference variable for Position", (Throwable)ex);
        }
        return this.cartoonPreferences != null;
    }

    private class ImageConverterThread
    extends ProgressThread {
        CartoonOptions cartoonOptions = null;

        public ImageConverterThread(CartoonOptions cartoonOptions) {
            this.cartoonOptions = cartoonOptions;
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
            try {
                MSGlycanAnnotationTableDataObject.glycanImageProvider.blockAccess();
                MSGlycanAnnotationTableDataObject.glycanImageProvider.setCartoonOptions(this.cartoonOptions);
                for (GlycanImageProvider.GlycanImageObject gio : MSGlycanAnnotationTableDataObject.glycanImageProvider.getImageStack()) {
                    if (gio.getImageId().equals(SEQUENCE)) continue;
                    gio.dispose();
                }
                MSGlycanAnnotationTableDataObject.glycanImageProvider.releaseBlock();
            }
            catch (Exception ex) {
                logger.error((Object)"Error updating images from new preferences.", (Throwable)ex);
                MSGlycanAnnotationTableDataObject.glycanImageProvider.releaseBlock();
                return false;
            }
            return true;
        }

        public void cancelWork() {
        }
    }
}

