/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.services.RegistryPersistence;

public final class ContextPersistence
extends RegistryPersistence {
    private static final int INDEX_CONTEXT_DEFINITIONS = 0;
    private final ContextManager contextManager;

    private static void readContextsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, ContextManager contextManager) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String name;
            IConfigurationElement configurationElement = configurationElements[i];
            String contextId = ContextPersistence.readRequired(configurationElement, "id", warningsToLog, "Contexts need an id");
            if (contextId != null && (name = ContextPersistence.readRequired(configurationElement, "name", warningsToLog, "Contexts need a name", contextId)) != null) {
                Context context;
                String description = ContextPersistence.readOptional(configurationElement, "description");
                String parentId = configurationElement.getAttribute("parentId");
                if (!(parentId != null && parentId.length() != 0 || (parentId = configurationElement.getAttribute("parent")) != null && parentId.length() != 0)) {
                    parentId = configurationElement.getAttribute("parentScope");
                }
                if (parentId != null && parentId.length() == 0) {
                    parentId = null;
                }
                if (!(context = contextManager.getContext(contextId)).isDefined()) {
                    context.define(name, description, parentId);
                }
            }
            ++i;
        }
        ContextPersistence.logWarnings(warningsToLog, "Warnings while parsing the contexts from the 'org.eclipse.ui.contexts', 'org.eclipse.ui.commands' and 'org.eclipse.ui.acceleratorScopes' extension points.");
    }

    public ContextPersistence(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("The context manager must not be null");
        }
        this.contextManager = contextManager;
    }

    @Override
    protected boolean isChangeImportant(IRegistryChangeEvent event) {
        IExtensionDelta[] commandDeltas;
        IExtensionDelta[] contextDeltas;
        IExtensionDelta[] acceleratorScopeDeltas = event.getExtensionDeltas("org.eclipse.ui", "acceleratorScopes");
        return acceleratorScopeDeltas.length != 0 || (contextDeltas = event.getExtensionDeltas("org.eclipse.ui", "contexts")).length != 0 || (commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands")).length != 0;
    }

    @Override
    protected void read() {
        super.read();
        this.reRead();
    }

    public void reRead() {
        IConfigurationElement[] contextsExtensionPoint;
        IConfigurationElement[] commandsExtensionPoint;
        IConfigurationElement[] acceleratorScopesExtensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int contextDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[1][];
        IConfigurationElement[] iConfigurationElementArray = acceleratorScopesExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.acceleratorScopes");
        int n = acceleratorScopesExtensionPoint.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String name = configurationElement.getName();
            if ("acceleratorScope".equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = commandsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n3 = commandsExtensionPoint.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement configurationElement = iConfigurationElementArray2[n];
            String name = configurationElement.getName();
            if ("scope".equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            } else if ("context".equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++n;
        }
        IConfigurationElement[] iConfigurationElementArray3 = contextsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.contexts");
        int n4 = contextsExtensionPoint.length;
        n3 = 0;
        while (n3 < n4) {
            IConfigurationElement configurationElement = iConfigurationElementArray3[n3];
            String name = configurationElement.getName();
            if ("context".equals(name)) {
                ContextPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, contextDefinitionCount++);
            }
            ++n3;
        }
        ContextPersistence.readContextsFromRegistry(indexedConfigurationElements[0], contextDefinitionCount, this.contextManager);
    }
}

