/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.wizards.createnew;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.tools.databasebot.utils.TextUtil;

public class DatabaseInformationPage
extends WizardPage {
    private static Integer TEXT_LENGTH_NAME_VERSION = 64;
    private static Integer TEXT_LENGTH_DESCRITION = 1024;
    private static final Logger logger = Logger.getLogger(DatabaseInformationPage.class);
    private Text m_textDatabaseFile = null;
    private Text m_textDatabaseName = null;
    private Text m_textDatabaseVersion = null;
    private Text m_textDescription = null;
    private Text m_textIdPrefix = null;
    private Text m_textIdPostfix = null;
    private Button m_checkOverwriteIds = null;

    public DatabaseInformationPage(ImageDescriptor a_titleImage) {
        super("Database information", "Database information", a_titleImage);
        this.setDescription("Choose file location and database information.");
    }

    public void createControl(Composite a_parent) {
        Composite t_container = new Composite(a_parent, 0);
        t_container.setLayout((Layout)new GridLayout(3, false));
        this.createFilesControl(t_container);
        this.createDatabaseInformationSection(t_container);
        this.createIDsection(t_container);
        this.m_textDatabaseName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseInformationPage.this.validate();
            }
        });
        this.m_textDatabaseVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseInformationPage.this.validate();
            }
        });
        this.m_textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseInformationPage.this.validate();
            }
        });
        this.setControl((Control)t_container);
        this.setPageComplete(false);
    }

    private void createIDsection(Composite a_container) {
        Group t_groupID = new Group(a_container, 0);
        GridData t_gridID = new GridData(4, 128, true, false, 3, 1);
        t_groupID.setLayoutData((Object)t_gridID);
        t_groupID.setText("Database IDs");
        t_groupID.setLayout((Layout)new GridLayout(2, false));
        Label t_labelPrefix = new Label((Composite)t_groupID, 0);
        t_labelPrefix.setText("Prefix");
        t_labelPrefix.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_textIdPrefix = new Text((Composite)t_groupID, 2048);
        this.m_textIdPrefix.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label t_labelPostfix = new Label((Composite)t_groupID, 0);
        t_labelPostfix.setText("Postfix");
        t_labelPostfix.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_textIdPostfix = new Text((Composite)t_groupID, 2048);
        this.m_textIdPostfix.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label t_labelPlaceholder = new Label((Composite)t_groupID, 0);
        t_labelPlaceholder.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Label t_labelHelp = new Label((Composite)t_groupID, 0);
        t_labelHelp.setText("Database IDs will be generated following the format <prefix>Number<postfix>.\nIf prefix and postfix are empty the ID will consist of a number alone.");
        t_labelHelp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_checkOverwriteIds = new Button((Composite)t_groupID, 32);
        this.m_checkOverwriteIds.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_checkOverwriteIds.setText("Overwrite: For glycans with existing IDs generate new IDs as well.");
    }

    private void createDatabaseInformationSection(Composite a_container) {
        Group t_groupInformation = new Group(a_container, 0);
        GridData t_gridInformation = new GridData(4, 128, true, false, 3, 1);
        t_groupInformation.setLayoutData((Object)t_gridInformation);
        t_groupInformation.setText("Database Information");
        t_groupInformation.setLayout((Layout)new GridLayout(2, false));
        Label t_labelDatabaseName = new Label((Composite)t_groupInformation, 0);
        t_labelDatabaseName.setText("Name");
        t_labelDatabaseName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_textDatabaseName = new Text((Composite)t_groupInformation, 2048);
        this.m_textDatabaseName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label t_labelDatabaseVersion = new Label((Composite)t_groupInformation, 0);
        t_labelDatabaseVersion.setText("Version");
        t_labelDatabaseVersion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_textDatabaseVersion = new Text((Composite)t_groupInformation, 2048);
        this.m_textDatabaseVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label t_labelDescription = new Label((Composite)t_groupInformation, 0);
        t_labelDescription.setText("Description");
        t_labelDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.m_textDescription = new Text((Composite)t_groupInformation, 2626);
        GridData t_gridDataDescrition = new GridData(4, 4, true, true, 1, 1);
        t_gridDataDescrition.heightHint = 100;
        this.m_textDescription.setLayoutData((Object)t_gridDataDescrition);
    }

    private void createFilesControl(final Composite a_container) {
        Label t_labelFilename = new Label(a_container, 0);
        t_labelFilename.setText("Database file");
        t_labelFilename.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_textDatabaseFile = new Text(a_container, 2048);
        this.m_textDatabaseFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_textDatabaseFile.setEditable(false);
        Button t_buttonBrowseDatabaseFile = new Button(a_container, 0);
        GridData t_gridDataButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        t_gridDataButton.widthHint = 100;
        t_buttonBrowseDatabaseFile.setLayoutData((Object)t_gridDataButton);
        t_buttonBrowseDatabaseFile.setText("Save As");
        t_buttonBrowseDatabaseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                try {
                    FileDialog t_dialogSave = new FileDialog(a_container.getShell(), 8192);
                    t_dialogSave.setFilterNames(new String[]{"Glycan structure database (.xml)", "All files"});
                    t_dialogSave.setFilterExtensions(new String[]{"*.xml", "*.*"});
                    String t_file = t_dialogSave.open();
                    if (t_file != null) {
                        File t_fileHandle = new File(t_file);
                        if (t_fileHandle.exists()) {
                            int t_response = ErrorUtils.createSingleConfirmationMessageBoxReturn((Shell)a_container.getShell(), (String)"Database file exists", (String)"The selected database file already exists. Do you want to overwrite it?");
                            if (t_response == 64) {
                                DatabaseInformationPage.this.m_textDatabaseFile.setText(t_file);
                            }
                        } else {
                            DatabaseInformationPage.this.m_textDatabaseFile.setText(t_file);
                        }
                    }
                    DatabaseInformationPage.this.validate();
                }
                catch (Exception e) {
                    logger.fatal((Object)"Unable to select a database file.", (Throwable)e);
                }
            }
        });
    }

    public void fillCreateDatabaseSettings(DatabaseBotSettings a_settings) {
        a_settings.setFilename(this.m_textDatabaseFile.getText());
        a_settings.setName(this.m_textDatabaseName.getText());
        a_settings.setDescription(this.m_textDescription.getText());
        a_settings.setVersion(this.m_textDatabaseVersion.getText());
        a_settings.setIdPrefix(this.m_textIdPrefix.getText());
        a_settings.setIdPostfix(this.m_textIdPostfix.getText());
        if (this.m_checkOverwriteIds.getSelection()) {
            a_settings.setOverwriteIds(true);
        } else {
            a_settings.setOverwriteIds(false);
        }
    }

    private void validate() {
        if (this.isValidInput()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean isValidInput() {
        if (TextUtil.isEmpty(this.m_textDatabaseFile)) {
            this.setErrorMessage("Please select a file to save the database.");
            return false;
        }
        if (TextUtil.isEmpty(this.m_textDatabaseName)) {
            this.setErrorMessage("Please provide a name for the database.");
            return false;
        }
        if (this.m_textDatabaseName.getText().length() > TEXT_LENGTH_NAME_VERSION) {
            this.setErrorMessage("The database name can not be longer than " + TEXT_LENGTH_NAME_VERSION.toString() + " characters.");
            return false;
        }
        if (TextUtil.isEmpty(this.m_textDatabaseVersion)) {
            this.setErrorMessage("Please provide a version for the database.");
            return false;
        }
        if (this.m_textDatabaseVersion.getText().length() > TEXT_LENGTH_NAME_VERSION) {
            this.setErrorMessage("The database version can not be longer than " + TEXT_LENGTH_NAME_VERSION.toString() + " characters.");
            return false;
        }
        if (!TextUtil.isEmpty(this.m_textDescription) && this.m_textDescription.getText().length() > TEXT_LENGTH_DESCRITION) {
            this.setErrorMessage("The description can not be longer than " + TEXT_LENGTH_DESCRITION.toString() + " characters.");
            return false;
        }
        return true;
    }
}

