/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;

public class GeneUtils {
    public static List<GeneData> findBestValuesAndReplace(List<GeneData> dataList, int numOfReplicates, Double lowerThreshold, Double stDevCutOff) {
        int index = -1;
        if (dataList.size() < numOfReplicates) {
            return null;
        }
        HashMap<ArrayList<GeneData>, Double> stDevMap = new HashMap<ArrayList<GeneData>, Double>();
        int i = 0;
        while (i < numOfReplicates) {
            ArrayList<GeneData> newDataList = new ArrayList<GeneData>();
            int j = 0;
            while (j < numOfReplicates - 1) {
                int k = (i + j) % numOfReplicates;
                newDataList.add(dataList.get(k));
                ++j;
            }
            double average = GeneUtils.findAverage(newDataList, lowerThreshold);
            GeneData averageData = new GeneData();
            averageData.setCt(average);
            ArrayList<GeneData> listForStDev = new ArrayList<GeneData>();
            listForStDev.addAll(newDataList);
            listForStDev.add(averageData);
            double stDev = Gene.getStandardDeviation(listForStDev, lowerThreshold);
            if (stDev < stDevCutOff) {
                stDevMap.put(newDataList, stDev);
            }
            ++i;
        }
        if (stDevMap.isEmpty()) {
            return null;
        }
        double lowest = stDevCutOff;
        List lowestCombination = null;
        for (List geneDataList : stDevMap.keySet()) {
            Double ct;
            Double stDev = (Double)stDevMap.get(geneDataList);
            if (stDev < lowest) {
                lowest = stDev;
                lowestCombination = geneDataList;
                continue;
            }
            if (stDev != lowest) continue;
            double valueTotal1 = 0.0;
            double valueTotal2 = 0.0;
            int i2 = 0;
            while (i2 < geneDataList.size()) {
                ct = ((GeneData)geneDataList.get(i2)).getCt();
                if (ct == null || ct >= lowerThreshold) {
                    ct = (double)lowerThreshold;
                }
                valueTotal1 += ct.doubleValue();
                ++i2;
            }
            if (lowestCombination != null) {
                i2 = 0;
                while (i2 < lowestCombination.size()) {
                    ct = ((GeneData)lowestCombination.get(i2)).getCt();
                    if (ct == null || ct >= lowerThreshold) {
                        ct = (double)lowerThreshold;
                    }
                    valueTotal2 += ct.doubleValue();
                    ++i2;
                }
            }
            if (!(valueTotal2 > 0.0) || !(valueTotal1 < valueTotal2)) continue;
            lowestCombination = geneDataList;
        }
        if (lowestCombination == null) {
            return null;
        }
        int i3 = 0;
        double average = 0.0;
        int total = 0;
        for (GeneData geneData : dataList) {
            boolean keep = false;
            for (GeneData geneData2 : lowestCombination) {
                if (!geneData.equals(geneData2)) continue;
                ++total;
                Double ct = geneData2.getCt();
                if (ct == null || ct >= lowerThreshold) {
                    ct = (double)lowerThreshold;
                }
                average += ct.doubleValue();
                keep = true;
                break;
            }
            if (!keep) {
                index = i3;
            }
            ++i3;
        }
        ArrayList<GeneData> modifiedList = new ArrayList<GeneData>();
        i3 = 0;
        for (GeneData geneData : dataList) {
            if (i3 == index) {
                GeneData newGeneData = new GeneData();
                newGeneData.setCt(average / (double)total);
                newGeneData.setPlateId(geneData.getPlateId());
                newGeneData.setPosition(geneData.getPosition());
                modifiedList.add(i3, newGeneData);
            } else {
                modifiedList.add(i3, geneData);
            }
            ++i3;
        }
        return modifiedList;
    }

    private static double findAverage(List<GeneData> newDataList, Double lowerThreshold) {
        int total = 0;
        double average = 0.0;
        for (GeneData geneData : newDataList) {
            Double ct = geneData.getCt();
            if (ct == null || ct >= lowerThreshold) {
                ct = (double)lowerThreshold;
            }
            average += ct.doubleValue();
            ++total;
        }
        if (total > 0) {
            return average / (double)total;
        }
        return 0.0;
    }

    public static void cleanUpGenesForMasterGeneList(GeneList geneList) {
        List<Gene> genes;
        if (geneList != null && (genes = geneList.getGenes()) != null) {
            for (Gene gene : genes) {
                gene.setRunId(null);
                gene.setReRun(null);
                gene.setShouldRerun(null);
            }
        }
    }

    public static Gene makeACopy(Gene gene) {
        Gene newGene = new Gene();
        newGene.setAliases(gene.getAliases());
        newGene.setDataMap(gene.getDataMap());
        newGene.setDescription(gene.getDescription());
        newGene.setForwardPrimer(gene.getForwardPrimer());
        newGene.setFullName(gene.getFullName());
        newGene.setGeneIdentifier(gene.getGeneIdentifier());
        newGene.setGeneIds(gene.getGeneIds());
        newGene.setGeneSymbol(gene.getGeneSymbol());
        newGene.setGroup(gene.getGroup());
        newGene.setIsCommon(gene.getIsCommon());
        newGene.setIsControl(gene.getIsControl());
        newGene.setLocations(gene.getLocations());
        newGene.setNotes(gene.getNotes());
        newGene.setNumOfReplicates(gene.getNumOfReplicates());
        newGene.setRefSeq(gene.getRefSeq());
        newGene.setSecondaryRefSeq(gene.getSecondaryRefSeq());
        newGene.setReRun(gene.getReRun());
        newGene.setReversePrimer(gene.getReversePrimer());
        newGene.setRunId(gene.getRunId());
        newGene.setShouldRerun(gene.getShouldRerun());
        newGene.setNormValueMap(gene.getNormValueMap());
        return newGene;
    }
}

