/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;

@XmlRootElement(name="qrtPCR-Data")
public class QrtPCRData {
    String name;
    Date dateCreated;
    Integer numberOfReplicates = 3;
    List<String> dyes;
    List<Gene> genes;
    Double normValue = null;

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @XmlAttribute
    public Integer getNumberOfReplicates() {
        return this.numberOfReplicates;
    }

    public void setNumberOfReplicates(Integer numberOfReplicates) {
        this.numberOfReplicates = numberOfReplicates;
    }

    @XmlElement
    public List<String> getDyes() {
        return this.dyes;
    }

    public void setDyes(List<String> dyes) {
        this.dyes = dyes;
    }

    @XmlElementWrapper(name="gene")
    public List<Gene> getGenes() {
        return this.genes;
    }

    public void setGenes(List<Gene> genes) {
        this.genes = genes;
    }

    public void addDye(String dye) {
        if (this.dyes == null) {
            this.dyes = new ArrayList<String>();
        }
        this.dyes.add(dye);
    }

    public void calculateNormValue(int runId) {
        this.normValue = this.findNormValue(runId, false);
    }

    public void calculateNormValue() {
        this.normValue = this.findNormValue(null, false);
        for (Gene gene : this.genes) {
            gene.setNormValue(gene.getRunId(), this.normValue);
        }
    }

    public double findNormValue(Integer runId, boolean original) {
        double average = 0.0;
        int i = 0;
        for (Gene gene : this.genes) {
            if (!gene.getIsControl().booleanValue()) continue;
            if (runId == null) {
                runId = gene.getRunId();
            }
            for (GeneData data : gene.getDataMap().get(runId)) {
                if (data.isEliminated().booleanValue()) continue;
                if (original) {
                    if (data.getOriginalCt() == null) continue;
                    average += data.getOriginalCt().doubleValue();
                    ++i;
                    continue;
                }
                if (data.getCt() == null) continue;
                average += data.getCt().doubleValue();
                ++i;
            }
        }
        double norm = Math.pow(2.0, -1.0 * (average /= (double)i));
        return norm;
    }

    public double getNormValue() {
        return this.normValue;
    }

    public double getScaler(Double lowerThreshold, boolean original) {
        if (original) {
            return Math.pow(2.0, -1.0 * lowerThreshold) / this.findNormValue(0, original) - 1.0E-6;
        }
        return Math.pow(2.0, -1.0 * lowerThreshold) / this.normValue - 1.0E-6;
    }
}

