/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCREntrySelectionAdapter;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRMergeProperty;

public class QrtPCRMergeReportDialog
extends ModalDialog {
    private Label nameLabel;
    private Text nameText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label listLabel;
    private Table table;
    private QrtPCREntrySelectionAdapter qrtPCREntrySelectionAdapter;
    private List<Entry> qrtPCREntryList;
    private Button okButton;
    private Button cancelButton;
    private String name;
    private String description;
    private Map<String, String> listEntries = new HashMap<String, String>();
    private TableEditor editor;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Entry> getQrtPCREntryList() {
        return this.qrtPCREntryList;
    }

    public Map<String, String> getListEntries() {
        return this.listEntries;
    }

    public QrtPCRMergeReportDialog(Shell parentShell) {
        super(parentShell);
    }

    public QrtPCRMergeReportDialog(Shell parentShell, List<Entry> entries) {
        super(parentShell);
        this.qrtPCREntryList = entries == null ? new ArrayList<Entry>() : entries;
    }

    public void create() {
        super.create();
        this.setTitle("Merge qRT-PCR data");
        this.setMessage("");
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        this.initGrid(parent);
        this.createDisplayName(parent);
        this.createDescription(parent);
        this.createEmptyLine(parent);
        this.createListHeader(parent);
        this.createList(parent);
        this.createAddAndDelButtons(parent);
        this.createEmptyLine(parent);
        this.createLineSeparator(parent);
        this.createMergeOKAndCancelButtons(parent);
        return parent;
    }

    private void createMergeOKAndCancelButtons(Composite parent) {
        Label dummy2 = new Label(parent, 0);
        GridData gdDummy2 = new GridData();
        gdDummy2.horizontalSpan = 4;
        gdDummy2.grabExcessHorizontalSpace = true;
        dummy2.setLayoutData((Object)gdDummy2);
        GridData cancelData = new GridData();
        cancelData.grabExcessHorizontalSpace = false;
        cancelData.horizontalAlignment = 3;
        cancelData.horizontalSpan = 1;
        this.cancelButton = new Button(parent, 8);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QrtPCRMergeReportDialog.this.cancelPressed();
            }
        });
        this.cancelButton.setLayoutData((Object)cancelData);
        GridData okData = new GridData();
        okData.grabExcessHorizontalSpace = false;
        okData.horizontalAlignment = 3;
        okData.horizontalSpan = 1;
        this.okButton = new Button(parent, 8);
        this.okButton.setText("   OK   ");
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QrtPCRMergeReportDialog.this.okPressed();
                QrtPCRMergeReportDialog.this.close();
            }
        });
        this.okButton.setLayoutData((Object)okData);
        if (this.isReadyToFinish()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        new Label(parent, 0);
    }

    private void createAddAndDelButtons(Composite parent) {
        Label dummy = new Label(parent, 0);
        GridData gdDummy = new GridData();
        dummy.setLayoutData((Object)gdDummy);
        Label dummy2 = new Label(parent, 0);
        GridData gdDummy2 = new GridData();
        gdDummy2.horizontalSpan = 2;
        gdDummy2.grabExcessHorizontalSpace = true;
        dummy2.setLayoutData((Object)gdDummy2);
        Label dummy3 = new Label(parent, 0);
        GridData gdDummy3 = new GridData();
        dummy3.setLayoutData((Object)gdDummy3);
        GridData gdAddBtn = new GridData();
        gdAddBtn.grabExcessHorizontalSpace = false;
        gdAddBtn.horizontalAlignment = 3;
        gdAddBtn.horizontalSpan = 1;
        Button btnAddButton = new Button(parent, 8);
        btnAddButton.setText("  Add  ");
        this.qrtPCREntrySelectionAdapter = new QrtPCREntrySelectionAdapter("org.grits.toolbox.property.qrtpcr", "Select Entry", "Select a qRT-PCR Entry");
        this.qrtPCREntrySelectionAdapter.setParent(parent);
        this.qrtPCREntrySelectionAdapter.setList(this.table);
        this.qrtPCREntrySelectionAdapter.setListEntries(this.listEntries);
        this.qrtPCREntrySelectionAdapter.setEntries(this.qrtPCREntryList);
        btnAddButton.addSelectionListener((SelectionListener)this.qrtPCREntrySelectionAdapter);
        btnAddButton.setLayoutData((Object)gdAddBtn);
        Button deleteButton = new Button(parent, 8);
        GridData gdDelBtn = new GridData();
        gdDelBtn.grabExcessHorizontalSpace = false;
        gdDelBtn.horizontalAlignment = 3;
        gdDelBtn.horizontalSpan = 1;
        deleteButton.setText("Delete");
        deleteButton.setLayoutData((Object)gdDelBtn);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iRemoveInx = QrtPCRMergeReportDialog.this.table.getSelectionIndex();
                QrtPCRMergeReportDialog.this.qrtPCREntryList.remove(iRemoveInx);
                QrtPCRMergeReportDialog.this.table.remove(iRemoveInx);
                Control oldEditor = QrtPCRMergeReportDialog.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                QrtPCRMergeReportDialog.this.listEntries.clear();
                int i = 0;
                while (i < QrtPCRMergeReportDialog.this.table.getItemCount()) {
                    String displayName = QrtPCRMergeReportDialog.this.table.getItem(i).getText(0).trim();
                    String alias = QrtPCRMergeReportDialog.this.table.getItem(i).getText(1).trim();
                    QrtPCRMergeReportDialog.this.listEntries.put(displayName, alias);
                    ++i;
                }
                if (QrtPCRMergeReportDialog.this.listEntries.isEmpty()) {
                    QrtPCRMergeReportDialog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
    }

    private void createList(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 67584);
        this.table = viewer.getTable();
        GridData data = new GridData(4, 4, true, true, 7, 1);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnEntry = new TableColumn(this.table, 0);
        tblclmnEntry.setText("QrtPCR Entry");
        tblclmnEntry.setWidth(150);
        TableColumn tblclmnAlias = new TableColumn(this.table, 0);
        tblclmnAlias.setText("Alias (User defined)");
        tblclmnAlias.setWidth(200);
        this.setListData();
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.horizontalAlignment = 16384;
        this.editor.minimumWidth = 200;
        this.table.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (QrtPCRMergeReportDialog.this.isReadyToFinish()) {
                    QrtPCRMergeReportDialog.this.setPageComplete(true);
                } else {
                    QrtPCRMergeReportDialog.this.setPageComplete(false);
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = QrtPCRMergeReportDialog.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)QrtPCRMergeReportDialog.this.table, 0);
                newEditor.setText(item.getText(1));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent me) {
                        Text text = (Text)QrtPCRMergeReportDialog.this.editor.getEditor();
                        QrtPCRMergeReportDialog.this.editor.getItem().setText(1, text.getText());
                        QrtPCRMergeReportDialog.this.listEntries.put(item.getText(0), text.getText());
                        if (QrtPCRMergeReportDialog.this.isReadyToFinish()) {
                            QrtPCRMergeReportDialog.this.setPageComplete(true);
                        } else {
                            QrtPCRMergeReportDialog.this.setPageComplete(false);
                        }
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                QrtPCRMergeReportDialog.this.editor.setEditor((Control)newEditor, item, 1);
            }
        });
    }

    private void createListHeader(Composite parent) {
        GridData listLabelData = new GridData();
        this.listLabel = new Label(parent, 0);
        listLabelData.grabExcessHorizontalSpace = true;
        listLabelData.horizontalSpan = 7;
        this.listLabel.setText("QrtPCR Experiments");
        this.listLabel.setLayoutData((Object)listLabelData);
        this.listLabel = this.setMandatoryLabel(this.listLabel);
    }

    private void createEmptyLine(Composite parent) {
        GridData dummy = new GridData();
        Label dummyLbl = new Label(parent, 0);
        dummy.grabExcessHorizontalSpace = true;
        dummy.horizontalSpan = 7;
        dummyLbl.setLayoutData((Object)dummy);
    }

    private void createLineSeparator(Composite parent) {
        GridData dummy = new GridData(768);
        Label separator = new Label(parent, 258);
        dummy.grabExcessHorizontalSpace = true;
        dummy.horizontalSpan = 7;
        separator.setLayoutData((Object)dummy);
    }

    private void createDescription(Composite parent) {
        GridData descriptionData = new GridData();
        descriptionData.grabExcessHorizontalSpace = false;
        this.descriptionLabel = new Label(parent, 0);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData(1808);
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.horizontalSpan = 6;
        this.descriptionText = new Text(parent, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (QrtPCRMergeReportDialog.this.isReadyToFinish()) {
                    QrtPCRMergeReportDialog.this.setPageComplete(true);
                } else {
                    QrtPCRMergeReportDialog.this.setPageComplete(false);
                }
            }
        });
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    private void createDisplayName(Composite parent) {
        GridData nameData = new GridData();
        nameData.grabExcessHorizontalSpace = false;
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText("Display Name");
        this.nameLabel = this.setMandatoryLabel(this.nameLabel);
        this.nameLabel.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData(768);
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalSpan = 6;
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (QrtPCRMergeReportDialog.this.isReadyToFinish()) {
                    QrtPCRMergeReportDialog.this.setPageComplete(true);
                } else {
                    QrtPCRMergeReportDialog.this.setPageComplete(false);
                }
            }
        });
    }

    private void setListData() {
        int i = 0;
        while (i < this.qrtPCREntryList.size()) {
            Entry entry = this.qrtPCREntryList.get(i);
            String displayName = entry.getDisplayName();
            this.listEntries.put(displayName, displayName);
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, displayName);
            item.setBackground(0, Display.getCurrent().getSystemColor(22));
            item.setText(1, displayName);
            ++i;
        }
    }

    private boolean isReadyToFinish() {
        if (!this.nameText.getText().isEmpty() && this.table.getItemCount() != 0) {
            if (!this.checkBasicLengthCheck(this.nameLabel, this.nameText, 0, 32)) {
                return false;
            }
            if (this.qrtPCREntryList != null && this.qrtPCREntryList.size() != 0) {
                for (Entry child : DataModelSearch.findParentByType((Entry)this.qrtPCREntryList.get(0), (String)"org.grits.toolbox.property.project").getChildren()) {
                    if (!child.getProperty().getType().equals("org.grits.toolbox.property.qrtpcr.merge")) continue;
                    for (Entry child2 : child.getChildren()) {
                        if (!child2.getDisplayName().equals(this.nameText.getText())) continue;
                        this.setError(this.nameLabel, "The name is in use. Please choose another name.");
                        return false;
                    }
                }
            }
            if (!this.descriptionLabel.getText().isEmpty() && !this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")))) {
                return false;
            }
            ArrayList<String> alContains = new ArrayList<String>();
            int i = 0;
            while (i < this.table.getItemCount()) {
                String displayName = this.table.getItem(i).getText(0);
                String alias = this.table.getItem(i).getText(1);
                if (alias.equals("")) {
                    this.setErrorMessage("Alias for " + displayName + " cannot be blank.");
                    return false;
                }
                if (alContains.contains(alias)) {
                    this.setErrorMessage("Duplicate aliases are not allowed.");
                    return false;
                }
                alContains.add(alias);
                ++i;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    protected void setPageComplete(boolean flag) {
        if (flag) {
            this.name = this.nameText.getText();
            this.description = this.descriptionText.getText();
        }
        this.okButton.setEnabled(flag);
    }

    private void initGrid(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
    }

    protected boolean isValidInput() {
        return true;
    }

    public Entry createEntry() {
        Entry qrtPCRMergeReportEntry = new Entry();
        qrtPCRMergeReportEntry.setDisplayName(this.name);
        QrtPCRMergeProperty property = new QrtPCRMergeProperty();
        qrtPCRMergeReportEntry.setProperty((Property)property);
        return qrtPCRMergeReportEntry;
    }
}

