/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycanFilterPreference {
    private static final Logger logger = Logger.getLogger(MSGlycanFilterPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.entry.ms.annotation.glycan.filter";
    private static final String CURRENT_VERSION = "1.0";
    FilterSettingLibrary filterSettings;

    public void setFilterSettings(FilterSettingLibrary filterSettings) {
        this.filterSettings = filterSettings;
    }

    public FilterSettingLibrary getFilterSettings() {
        return this.filterSettings;
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    public static MSGlycanFilterPreference getMSGlycanFilterPreferences(PreferenceEntity preferenceEntity) throws UnsupportedVersionException {
        MSGlycanFilterPreference preferenceSettings = new MSGlycanFilterPreference();
        if (preferenceEntity != null) {
            FilterSettingLibrary filters = MSGlycanFilterPreference.unmarshalFiltersList(preferenceEntity.getValue());
            preferenceSettings.setFilterSettings(filters);
        } else {
            preferenceSettings.setFilterSettings(new FilterSettingLibrary());
        }
        return preferenceSettings;
    }

    private static FilterSettingLibrary unmarshalFiltersList(String value) {
        StringReader reader = new StringReader(value);
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FilterSettingLibrary.class);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Unmarshaller unmarshaller = context.createUnmarshaller();
            FilterSettingLibrary filters = (FilterSettingLibrary)unmarshaller.unmarshal((Reader)reader);
            return filters;
        }
        catch (JAXBException e) {
            logger.error((Object)"Cannot read filter preferences: ", (Throwable)e);
            return null;
        }
    }

    private static String marshalFiltersList(MSGlycanFilterPreference preference) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FilterSettingLibrary.class);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)preference.getFilterSettings(), (OutputStream)os);
        }
        catch (JAXBException e) {
            logger.error((Object)"Cannot write filter preferences: ", (Throwable)e);
            return null;
        }
        return os.toString();
    }

    public static FilterSetting unmarshalFilter(String value) throws JAXBException {
        StringReader reader = new StringReader(value);
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FilterSetting.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FilterSetting filter = (FilterSetting)unmarshaller.unmarshal((Reader)reader);
        return filter;
    }

    public static String marshalFilter(FilterSetting filter) throws JAXBException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(FilterSetting.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)filter, (OutputStream)os);
        return os.toString();
    }

    public boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        preferenceEntity.setValue(MSGlycanFilterPreference.marshalFiltersList(this));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }
}

