/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.filter;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.ms.om.data.IntensityFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.BooleanFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.ComboFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterAnd;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterNot;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterOr;
import org.grits.toolbox.util.structure.glycan.filter.om.IntegerFilter;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;
import org.osgi.framework.Bundle;

public class MSGlycanAnnotationFilterSetup
extends FilterTableSetup {
    public static Image helpIcon = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation.glycan"), (IPath)new Path("icons" + File.separator + "helpIcon.png"), null)).createImage();
    public static final String FILTERMESSAGE = "Please note that some of the descriptions below may not apply to this filter view!";
    private static final int COLUMNS = 10;
    public static final String CATEGORY_ALL = "All";
    List<Category> categories = null;
    List<Filter> includedFilters = new ArrayList<Filter>();
    Composite filterComposite;
    Composite parent;
    Map<Control, ControlDecoration> errors = new HashMap<Control, ControlDecoration>();
    Category selectedCategory;
    private ComboViewer categoryCombo;
    private String filterMessage = "Please note that some of the descriptions below may not apply to this filter view!";

    public MSGlycanAnnotationFilterSetup() {
    }

    public MSGlycanAnnotationFilterSetup(List<Category> categoryList) {
        this();
        this.categories = categoryList;
    }

    public void createFilterTableSection(Composite parent) {
        if (this.filterComposite == null || this.filterComposite.isDisposed()) {
            this.parent = parent;
            parent.setLayout((Layout)new GridLayout(4, false));
            this.filterComposite = new Composite(parent, 0);
            this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 4));
        }
        GridLayout gridLayout = new GridLayout(10, false);
        this.filterComposite.setLayout((Layout)gridLayout);
        gridLayout.horizontalSpacing = 10;
        if (this.categories != null) {
            this.addCategorySelection(this.filterComposite);
        }
        if (this.filterList != null && !this.filterList.isEmpty()) {
            this.addHeaderSection(this.filterComposite);
            int columns = 0;
            for (Filter filter : this.filterList) {
                if (this.selectedCategory != null && !this.includeFilter(filter) || filter instanceof IntensityFilter) continue;
                if (filter instanceof IntegerFilter) {
                    this.addIntegerFilterSelection(this.filterComposite, (IntegerFilter)filter.copy());
                    columns += 5;
                    continue;
                }
                if (filter instanceof BooleanFilter) {
                    this.addBooleanFilterSelection(this.filterComposite, (BooleanFilter)filter.copy());
                    columns += 5;
                    continue;
                }
                if (!(filter instanceof ComboFilter)) continue;
                this.addComboFilterSelection(this.filterComposite, (ComboFilter)filter.copy());
                columns += 5;
            }
            int remaning = columns % 10;
            int i = 0;
            while (i < remaning) {
                new Label(this.filterComposite, 0);
                ++i;
            }
            Label separator = new Label(this.filterComposite, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 10, 1));
            columns = 0;
            for (Filter filter : this.filterList) {
                if (!(filter instanceof IntensityFilter)) continue;
                this.addIntegerFilterSelection(this.filterComposite, (IntegerFilter)filter.copy());
                columns += 5;
            }
            remaning = columns % 10;
            int i2 = 0;
            while (i2 < remaning + 10) {
                new Label(this.filterComposite, 0);
                ++i2;
            }
        }
    }

    private boolean includeFilter(Filter filter) {
        if (this.selectedCategory == null) {
            return true;
        }
        return this.selectedCategory.containsFilter(filter.getName());
    }

    private void addCategorySelection(Composite parent) {
        int i;
        Label categorySelLabel = new Label(parent, 0);
        categorySelLabel.setText("Select Filter Category");
        categorySelLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 2, 1));
        this.categoryCombo = new ComboViewer(parent, 8);
        this.categoryCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.categoryCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return MSGlycanAnnotationFilterSetup.CATEGORY_ALL;
                }
                if (element instanceof Category) {
                    return ((Category)element).getLabel();
                }
                return null;
            }
        });
        this.categoryCombo.setInput(this.categories);
        this.categoryCombo.insert(null, 0);
        this.categoryCombo.getCombo().setEnabled(parent.isEnabled());
        if (this.selectedCategory != null) {
            i = 1;
            for (Category c : this.categories) {
                if (c.getLabel().equals(this.selectedCategory.getLabel())) {
                    this.categoryCombo.getCombo().select(i);
                }
                ++i;
            }
        } else {
            this.categoryCombo.getCombo().select(0);
        }
        this.categoryCombo.getCombo().setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 4, 1));
        this.categoryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index = MSGlycanAnnotationFilterSetup.this.categoryCombo.getCombo().getSelectionIndex();
                if (index > 0) {
                    IStructuredSelection selected = MSGlycanAnnotationFilterSetup.this.categoryCombo.getStructuredSelection();
                    MSGlycanAnnotationFilterSetup.this.selectedCategory = (Category)selected.getFirstElement();
                    MSGlycanAnnotationFilterSetup.this.resetFilters();
                } else {
                    MSGlycanAnnotationFilterSetup.this.selectedCategory = null;
                    MSGlycanAnnotationFilterSetup.this.resetFilters();
                }
            }
        });
        i = 6;
        while (i < 10) {
            new Label(parent, 0);
            ++i;
        }
    }

    private void addHeaderSection(Composite parent) {
        this.comboOp = new ComboViewer(parent, 8);
        this.comboOp.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboOp.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboOp.setInput((Object)new String[]{"AND", "OR"});
        if (this.op.equals("AND")) {
            this.comboOp.getCombo().select(0);
        } else {
            this.comboOp.getCombo().select(1);
        }
        this.comboOp.getCombo().setEnabled(parent.isEnabled());
        this.comboOp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selected = MSGlycanAnnotationFilterSetup.this.comboOp.getStructuredSelection();
                MSGlycanAnnotationFilterSetup.this.op = (String)selected.getFirstElement();
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }
        });
        MSGlycanAnnotationFilterSetup.addHelpButton(parent, this.filterMessage);
        Label titleLabel = new Label(parent, 0);
        titleLabel.setText("Range (if known)");
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 3, 1));
        titleLabel.setEnabled(parent.isEnabled());
        new Label(parent, 0);
        new Label(parent, 0);
        titleLabel = new Label(parent, 0);
        titleLabel.setText("Range (if known)");
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 3, 1));
        titleLabel.setEnabled(parent.isEnabled());
    }

    public static void addHelpButton(Composite parent, final String filterMessage) {
        final Button helpButton = new Button(parent, 0);
        helpButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.setBackground(helpButton.getParent().getBackground());
                event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                event.gc.drawImage(helpIcon, 5, 2);
            }
        });
        helpButton.setToolTipText("Help with Filters (examples)");
        helpButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        helpButton.setEnabled(parent.isEnabled());
        helpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaDialog helpDialog = new TitleAreaDialog(Display.getCurrent().getActiveShell()){

                    protected Control createDialogArea(Composite parent) {
                        Composite composite = (Composite)super.createDialogArea(parent);
                        this.setTitle("Filter Help");
                        if (filterMessage != null) {
                            this.setMessage(filterMessage);
                        }
                        GridLayout layout = new GridLayout(1, false);
                        composite.setLayout((Layout)layout);
                        GridData data = new GridData(4, 4, true, true);
                        data.widthHint = 500;
                        data.heightHint = 450;
                        composite.setLayoutData((Object)data);
                        Browser browser = new Browser(composite, 0);
                        browser.setUrl(FileUtils.getFilterHelpPath());
                        browser.setLayoutData((Object)new GridData(4, 4, true, true));
                        return composite;
                    }

                    protected boolean isResizable() {
                        return true;
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    }
                };
                helpDialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addComboFilterSelection(Composite parent, final ComboFilter filter) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setText(filter.getLabel());
        filterLabel.setToolTipText(filter.getDescription());
        filterLabel.setEnabled(parent.isEnabled());
        Combo combo = new Combo(parent, 8);
        combo.setEnabled(parent.isEnabled());
        final ComboViewer selection = new ComboViewer(combo);
        selection.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "Any";
                }
                if (element instanceof Filter) {
                    return ((Filter)element).getLabel();
                }
                return null;
            }
        });
        selection.setContentProvider((IContentProvider)new ArrayContentProvider());
        selection.setInput((Object)filter.getFiltersInFilterOrder());
        selection.insert(null, 0);
        Filter existing = this.findFilter((Filter)filter);
        if (existing != null && existing instanceof ComboFilter && ((ComboFilter)existing).getSelected() != null) {
            selection.getCombo().select(((ComboFilter)existing).getFiltersInFilterOrder().indexOf(((ComboFilter)existing).getSelected()) + 1);
        } else {
            selection.getCombo().select(0);
        }
        selection.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (selection.getCombo().getSelectionIndex() == -1) {
                    selection.getCombo().select(0);
                }
            }
        });
        selection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index = selection.getCombo().getSelectionIndex();
                if (index > 0) {
                    IStructuredSelection selected = (IStructuredSelection)selection.getSelection();
                    if (selected.getFirstElement() instanceof Filter) {
                        filter.setSelected((Filter)selected.getFirstElement());
                        if (!MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.add((Filter)filter);
                        }
                    }
                } else if (MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                    MSGlycanAnnotationFilterSetup.this.includedFilters.remove(filter);
                }
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }
        });
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
    }

    private void addBooleanFilterSelection(Composite parent, final BooleanFilter filter) {
        Label filter1 = new Label(parent, 0);
        filter1.setText(filter.getLabel());
        filter1.setToolTipText(filter.getDescription());
        filter1.setEnabled(parent.isEnabled());
        final Combo selection = new Combo(parent, 0);
        selection.setEnabled(parent.isEnabled());
        selection.setItems(new String[]{"possible", "yes", "no"});
        Filter existing = this.findFilter((Filter)filter);
        if (existing != null) {
            selection.select(1);
        } else if (this.findNotFilter((Filter)filter) != null) {
            selection.select(2);
        } else {
            selection.select(0);
        }
        selection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = selection.getSelectionIndex();
                switch (index) {
                    case 0: {
                        if (MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.remove(filter);
                        }
                        MSGlycanAnnotationFilterSetup.this.removeNotFilter((Filter)filter);
                        break;
                    }
                    case 1: {
                        if (!MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.add((Filter)filter);
                        }
                        MSGlycanAnnotationFilterSetup.this.removeNotFilter((Filter)filter);
                        break;
                    }
                    case 2: {
                        GlycanFilterNot notFilter = new GlycanFilterNot();
                        notFilter.setFilter((Filter)filter);
                        MSGlycanAnnotationFilterSetup.this.includedFilters.add((Filter)notFilter);
                    }
                }
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
    }

    private void addIntegerFilterSelection(Composite parent, final IntegerFilter filter) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setText(filter.getLabel());
        filterLabel.setToolTipText(filter.getDescription());
        filterLabel.setEnabled(parent.isEnabled());
        final Combo selection = new Combo(parent, 0);
        selection.setEnabled(parent.isEnabled());
        selection.setItems(new String[]{"possible", "yes", "no"});
        final Filter existing = this.findFilter((Filter)filter);
        if (existing != null) {
            selection.select(1);
        } else if (this.findNotFilter((Filter)filter) != null) {
            selection.select(2);
        } else {
            selection.select(0);
        }
        final Text rangeBegin = new Text(parent, 2048);
        rangeBegin.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        ControlDecoration dec = new ControlDecoration((Control)rangeBegin, 0x1000000);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        dec.setImage(image);
        dec.setDescriptionText("Should enter a positive integer");
        dec.hide();
        this.errors.put((Control)rangeBegin, dec);
        rangeBegin.setEnabled(parent.isEnabled());
        if (existing != null && existing instanceof IntegerFilter && ((IntegerFilter)existing).getMin() != null && ((IntegerFilter)existing).getMin() != 0) {
            rangeBegin.setText("" + ((IntegerFilter)existing).getMin());
        }
        rangeBegin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (rangeBegin.getText() != null && !rangeBegin.getText().isEmpty()) {
                    if (MSGlycanAnnotationFilterSetup.this.validRange(rangeBegin.getText())) {
                        filter.setMin(Integer.valueOf(Integer.parseInt(rangeBegin.getText())));
                        if (existing != null) {
                            ((IntegerFilter)existing).setMin(filter.getMin());
                        }
                        MSGlycanAnnotationFilterSetup.this.showError((Control)rangeBegin, false);
                    } else {
                        MSGlycanAnnotationFilterSetup.this.showError((Control)rangeBegin, true);
                    }
                } else {
                    filter.setMin(Integer.valueOf(0));
                    if (existing != null) {
                        ((IntegerFilter)existing).setMin(Integer.valueOf(0));
                    }
                }
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }
        });
        Label dash = new Label(parent, 0);
        dash.setText("-");
        dash.setEnabled(parent.isEnabled());
        final Text rangeEnd = new Text(parent, 2048);
        rangeEnd.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        dec = new ControlDecoration((Control)rangeEnd, 0x1000000);
        dec.setImage(image);
        dec.setDescriptionText("Should enter a positive integer");
        dec.hide();
        this.errors.put((Control)rangeEnd, dec);
        rangeEnd.setEnabled(parent.isEnabled());
        if (existing != null && existing instanceof IntegerFilter && ((IntegerFilter)existing).getMax() != null) {
            rangeEnd.setText("" + ((IntegerFilter)existing).getMax());
        }
        rangeEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (rangeEnd.getText() != null && !rangeEnd.getText().isEmpty()) {
                    if (MSGlycanAnnotationFilterSetup.this.validRange(rangeEnd.getText())) {
                        filter.setMax(Integer.valueOf(Integer.parseInt(rangeEnd.getText())));
                        if (existing != null) {
                            ((IntegerFilter)existing).setMax(filter.getMax());
                        }
                        MSGlycanAnnotationFilterSetup.this.showError((Control)rangeEnd, false);
                    } else {
                        MSGlycanAnnotationFilterSetup.this.showError((Control)rangeEnd, true);
                    }
                } else {
                    filter.setMax(null);
                    if (existing != null) {
                        ((IntegerFilter)existing).setMax(null);
                    }
                }
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }
        });
        selection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = selection.getSelectionIndex();
                switch (index) {
                    case 0: {
                        if (MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.remove(filter);
                        }
                        MSGlycanAnnotationFilterSetup.this.removeNotFilter((Filter)filter);
                        rangeBegin.setText("");
                        rangeEnd.setText("");
                        break;
                    }
                    case 1: {
                        if (!MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.add((Filter)filter);
                        }
                        if (filter.getMin() == 0) {
                            filter.setMin(Integer.valueOf(1));
                            rangeBegin.setText("1");
                        }
                        MSGlycanAnnotationFilterSetup.this.removeNotFilter((Filter)filter);
                        break;
                    }
                    case 2: {
                        if (MSGlycanAnnotationFilterSetup.this.includedFilters.contains(filter)) {
                            MSGlycanAnnotationFilterSetup.this.includedFilters.remove(filter);
                        }
                        GlycanFilterNot notFilter = new GlycanFilterNot();
                        notFilter.setFilter((Filter)filter);
                        if (filter.getMin() == 0) {
                            filter.setMin(Integer.valueOf(1));
                            rangeBegin.setText("1");
                        }
                        MSGlycanAnnotationFilterSetup.this.includedFilters.add((Filter)notFilter);
                    }
                }
                MSGlycanAnnotationFilterSetup.this.filterUpdated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void showError(Control control, boolean show) {
        for (Control c : this.errors.keySet()) {
            if (!c.equals(control)) continue;
            ControlDecoration d = this.errors.get(c);
            if (show) {
                d.show();
                continue;
            }
            d.hide();
        }
    }

    private boolean validRange(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void removeNotFilter(Filter filter) {
        Filter toBeRemoved = this.findNotFilter(filter);
        if (toBeRemoved != null) {
            this.includedFilters.remove(toBeRemoved);
        }
    }

    private Filter findNotFilter(Filter filter) {
        for (Filter f : this.includedFilters) {
            if (!(f instanceof GlycanFilterNot) || !((GlycanFilterNot)f).getFilter().equals((Object)filter)) continue;
            return f;
        }
        return null;
    }

    private Filter findFilter(Filter filter) {
        for (Filter f : this.includedFilters) {
            if (f instanceof GlycanFilterNot || f instanceof GlycanFilterAnd || f instanceof GlycanFilterOr || !f.equals((Object)filter)) continue;
            return f;
        }
        return null;
    }

    public FilterSetting getFilterSetting() {
        if (this.includedFilters.isEmpty()) {
            return null;
        }
        FilterSetting setting = new FilterSetting();
        if (this.op.equals("AND")) {
            GlycanFilterAnd filter = new GlycanFilterAnd();
            filter.setElements(this.includedFilters);
            setting.setFilter((Filter)filter);
        } else {
            GlycanFilterOr filter = new GlycanFilterOr();
            filter.setElements(this.includedFilters);
            setting.setFilter((Filter)filter);
        }
        return setting;
    }

    public void setExistingFilters(FilterSetting filterSetting) {
        if (filterSetting != null) {
            Filter filter = filterSetting.getFilter();
            List filters = null;
            if (filter instanceof GlycanFilterAnd) {
                this.op = "AND";
                filters = ((GlycanFilterAnd)filter).getElements();
            } else if (filter instanceof GlycanFilterOr) {
                this.op = "OR";
                filters = ((GlycanFilterOr)filter).getElements();
            }
            if (filters != null) {
                this.includedFilters.clear();
                this.includedFilters.addAll(filters);
                Control[] controlArray = this.filterComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                this.createFilterTableSection(this.parent);
                this.filterComposite.layout();
                this.parent.layout();
            }
        }
    }

    public void setFilterList(List<Filter> filterList) {
        this.filterList = filterList;
    }

    public void setEnabled(boolean b) {
        if (this.comboOp.getCombo().isDisposed()) {
            this.comboOp.getCombo().setEnabled(b);
        }
        if (this.filterComposite != null && !this.filterComposite.isDisposed()) {
            this.filterComposite.setEnabled(b);
            Control[] controlArray = this.filterComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!child.isDisposed()) {
                    child.setEnabled(b);
                }
                ++n2;
            }
        }
    }

    public void resetFilters() {
        this.includedFilters.clear();
        Control[] controlArray = this.filterComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.createFilterTableSection(this.parent);
        this.filterComposite.layout();
        this.parent.layout();
        Composite sc = this.findCompositeWithScrolledParent(this.parent);
        if (sc != null & sc.getParent() != null && sc.getParent() instanceof ScrolledComposite) {
            sc.getParent().layout(true, true);
            ((ScrolledComposite)sc.getParent()).setMinSize(sc.computeSize(-1, -1));
        }
    }

    Composite findCompositeWithScrolledParent(Composite c) {
        if (c.getParent() != null && c.getParent() instanceof ScrolledComposite) {
            return c;
        }
        if (c.getParent() != null) {
            return this.findCompositeWithScrolledParent(c.getParent());
        }
        return null;
    }

    public Control getFilterComposite() {
        return this.filterComposite;
    }

    public void setSelectedCategory(Category preferredCategory) {
        this.selectedCategory = preferredCategory;
    }

    public String getFilterMessage() {
        return this.filterMessage;
    }

    public void setFilterMessage(String filterMessage) {
        this.filterMessage = filterMessage;
    }
}

