/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandler;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;

public class OpenGelatoWizard {
    private static final Logger logger = Logger.getLogger(OpenGelatoWizard.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    MApplication application;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell, EPartService partService) {
        MSGlycanAnnotationWizard wizard;
        List<Entry> msEntries;
        block11: {
            msEntries = this.getMSEntries(object);
            wizard = this.createNewMSAnnotDialog(shell, msEntries);
            if (wizard != null && wizard.getInitial().getMsEntryList() != null) break block11;
            return null;
        }
        try {
            Entry[] curEntries;
            int i;
            Shell shell2 = new Shell(shell);
            NewGelatoHandler handler = new NewGelatoHandler();
            handler.setWizard(wizard);
            handler.setMsEntries(msEntries);
            List<Entry[]> resultEntries = handler.process(shell2);
            if (resultEntries != null) {
                i = 0;
                while (i < resultEntries.size()) {
                    curEntries = resultEntries.get(i);
                    gritsDataModelService.addEntry(curEntries[0], curEntries[1]);
                    ++i;
                }
            }
            if (resultEntries != null && !resultEntries.isEmpty() && resultEntries.get(resultEntries.size() - 1)[1] != null) {
                try {
                    ProjectFileHandler.saveProject((Entry)resultEntries.get(resultEntries.size() - 1)[0].getParent().getParent());
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + resultEntries.get(resultEntries.size() - 1)[0].getParent().getParent().getDisplayName() + "\""));
                    gritsDataModelService.closeProject(resultEntries.get(resultEntries.size() - 1)[0].getParent().getParent());
                    throw e;
                }
                i = 0;
                while (i < resultEntries.size()) {
                    curEntries = resultEntries.get(i);
                    this.lockFiles(wizard, curEntries[0], curEntries[1]);
                    ++i;
                }
                Entry lastMSEntry = resultEntries.get(resultEntries.size() - 1)[1];
                eventBroker.send("grits_entry_selected", (Object)lastMSEntry);
                try {
                    gritsUIService.setPartService(partService);
                    gritsUIService.openEntryInPart(lastMSEntry);
                }
                catch (Exception e) {
                    logger.debug((Object)"Could not open the part", (Throwable)e);
                }
            }
            return resultEntries;
        }
        catch (Exception ex) {
            logger.error((Object)"General Exception executing OpenGelatoWizard.", (Throwable)ex);
            return null;
        }
    }

    private void lockFiles(MSGlycanAnnotationWizard wizard, Entry msEntry, Entry msAnnotationEntry) {
        MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
        try {
            String lockFileLocation = prop.getLockFilePath(msEntry);
            FileLockManager mng = FileLockingUtils.readLockFile((String)lockFileLocation);
            MSPropertyDataFile file = wizard.getInitial().getFileMap().get(msEntry.getDisplayName());
            if (file != null) {
                mng.lockFile(file.getName(), msAnnotationEntry);
                FileLockingUtils.writeLockFile((FileLockManager)mng, (String)lockFileLocation);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
    }

    private MSGlycanAnnotationWizard createNewMSAnnotDialog(Shell shell, List<Entry> msEntries) {
        MSGlycanAnnotationWizard wizard = new MSGlycanAnnotationWizard();
        wizard.setMSEntries(msEntries);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        try {
            if (dialog.open() == 0) {
                return wizard;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Exception", (Exception)e);
        }
        return null;
    }

    private List<Entry> getMSEntries(Object object) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        StructuredSelection to = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            to = (StructuredSelection)object;
        }
        if (selectedEntry != null && selectedEntry.getProperty() instanceof MassSpecProperty) {
            entries.add(selectedEntry);
        }
        if (gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            to = gritsDataModelService.getLastSelection();
        }
        if (to != null) {
            List selList = to.toList();
            int i = 0;
            while (i < selList.size()) {
                Entry msEntry = (Entry)selList.get(i);
                if (msEntry.getProperty() instanceof MassSpecProperty && !entries.contains(msEntry)) {
                    entries.add(msEntry);
                }
                ++i;
            }
        }
        return entries;
    }
}

