/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.MissingReaderException;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.projectexplorer.dialog.importentry.ImportEntryDialog;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utils.FileCopyProgressDialog;
import org.grits.toolbox.core.utils.WorkspaceXMLHandler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ImportProjectHandler {
    private static final Logger logger = Logger.getLogger(ImportProjectHandler.class);
    private String workspaceFolder = null;
    private HashMap<String, Element> selectedElementMap = null;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") Object object, @Optional @Named(value="activeShell") Shell shell, final IGritsDataModelService gritsDataModelService) {
        logger.info((Object)"Importing Projects from workspace");
        HashSet<Entry> selectedEntrySet = new HashSet<Entry>();
        if (object instanceof StructuredSelection) {
            Iterator iterator = ((StructuredSelection)object).iterator();
            Object nextSelection = null;
            while (iterator.hasNext()) {
                nextSelection = iterator.next();
                if (!(nextSelection instanceof Entry)) continue;
                selectedEntrySet.add(gritsDataModelService.findParentByType((Entry)object, "org.grits.toolbox.property.project"));
            }
        } else if (object instanceof Entry) {
            selectedEntrySet.add(gritsDataModelService.findParentByType((Entry)object, "org.grits.toolbox.property.project"));
        }
        logger.info((Object)"opening import entry dialog");
        ImportEntryDialog dialog = new ImportEntryDialog(PropertyHandler.getModalDialog(shell));
        if (dialog.open() == 0) {
            this.workspaceFolder = PropertyHandler.getVariable("workspace_location");
            final FileCopyProgressDialog progressDialog = new FileCopyProgressDialog(new File(this.workspaceFolder));
            try {
                List<Element> selectedEntryElements = dialog.getSelectedEntryElements();
                this.selectedElementMap = new HashMap();
                for (Element selectedEntryElement : selectedEntryElements) {
                    this.selectedElementMap.put(selectedEntryElement.getAttributeValue("previousName"), selectedEntryElement);
                }
                final ZipFile exportedZippedFile = dialog.getExportedZipFile();
                final Enumeration<? extends ZipEntry> entries = exportedZippedFile.entries();
                progressDialog.setTotalSize(exportedZippedFile.size() + selectedEntryElements.size());
                progressDialog.openProgressBar();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (entries.hasMoreElements()) {
                                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                                if (zipEntry.getName().contains("/") && ImportProjectHandler.this.selectedElementMap.containsKey(zipEntry.getName().substring(0, zipEntry.getName().indexOf("/")))) {
                                    logger.debug((Object)zipEntry.getName());
                                    try {
                                        ImportProjectHandler.this.deCompressFiles(exportedZippedFile, zipEntry);
                                    }
                                    catch (IOException ex) {
                                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                                    }
                                }
                                progressDialog.updateProgressBar(1L);
                            }
                            for (String selectedElement : ImportProjectHandler.this.selectedElementMap.keySet()) {
                                logger.info((Object)("adding entry " + selectedElement));
                                ImportProjectHandler.this.addProjectEntry(gritsDataModelService, ((Element)ImportProjectHandler.this.selectedElementMap.get(selectedElement)).getAttributeValue("name"));
                                progressDialog.updateProgressBar(1L);
                            }
                        }
                        finally {
                            progressDialog.closeProgressBar();
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)"Importing Projects from workspace");
    }

    private void addProjectEntry(IGritsDataModelService gritsDataModelService, String projectNewName) {
        block23: {
            try {
                File projectXmlFile = new File(this.workspaceFolder, String.valueOf(projectNewName) + File.separator + ".project.xml");
                HashMap<String, Element> propertyIdElementMap = new HashMap<String, Element>();
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(projectXmlFile);
                Element project = doc.getRootElement();
                if (!"project".equals(project.getName())) {
                    throw new IOException("Project file does not start with project tag " + projectXmlFile.getAbsolutePath());
                }
                List children = project.getChildren();
                Element entryElement = null;
                for (Element childElement : children) {
                    switch (childElement.getName()) {
                        case "entry": {
                            entryElement = childElement;
                            break;
                        }
                        case "property": {
                            propertyIdElementMap.put(childElement.getAttributeValue("id"), childElement);
                            break;
                        }
                        default: {
                            throw new IOException("In .project.xml file project's child element has tag other than entry or property");
                        }
                    }
                }
                if (entryElement == null) {
                    throw new IOException("Unable to find entry tag " + projectXmlFile.getAbsolutePath());
                }
                Element propertyElement = (Element)propertyIdElementMap.get(entryElement.getAttributeValue("id"));
                if (propertyElement == null || !"org.grits.toolbox.property.project".equals(propertyElement.getAttributeValue("type"))) break block23;
                entryElement.setAttribute("name", projectNewName);
                FileWriter fileWriter = null;
                try {
                    XMLOutputter xmlOutput = new XMLOutputter();
                    xmlOutput.setFormat(Format.getPrettyFormat());
                    if (projectXmlFile.exists() && projectXmlFile.isHidden() && System.getProperty("os.name").startsWith("Windows")) {
                        Files.setAttribute(projectXmlFile.toPath(), "dos:hidden", false, new LinkOption[0]);
                    }
                    fileWriter = new FileWriter(projectXmlFile);
                    xmlOutput.output(doc, (Writer)fileWriter);
                    fileWriter.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileWriter);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)fileWriter);
            }
            catch (IOException | JDOMException e) {
                logger.fatal((Object)e.getMessage(), e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error loading project to workspace.");
                return;
            }
        }
        Entry projectEntry = null;
        try {
            projectEntry = ProjectFileHandler.loadProject(projectNewName);
            gritsDataModelService.addProjectEntry(projectEntry);
            WorkspaceXMLHandler.updateWorkspaceXMLFile(projectEntry);
        }
        catch (IOException | UnsupportedVersionException | MissingReaderException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                projectEntry = ProjectFileHandler.loadPartialProject(projectNewName);
                gritsDataModelService.addProjectEntry(projectEntry);
                WorkspaceXMLHandler.closeProject(projectNewName);
            }
            catch (Exception e1) {
                logger.fatal((Object)e1.getMessage(), (Throwable)e1);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error loading partial project to workspace.");
            }
        }
        catch (Exception e) {
            logger.error((Object)("ErrorMessage.\n" + e.getMessage()), (Throwable)e);
            WorkspaceXMLHandler.closeProject(projectNewName);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error loading project for workspace.");
        }
    }

    private void deCompressFiles(ZipFile exportedZippedFile, ZipEntry zipEntry) throws IOException {
        logger.info((Object)("decompressing file " + exportedZippedFile.getName()));
        String name = zipEntry.getName();
        String projectName = name.substring(0, name.indexOf("/"));
        String newProjectName = this.selectedElementMap.get(projectName).getAttributeValue("name");
        String newFullName = String.valueOf(newProjectName) + name.substring(name.indexOf(projectName) + projectName.length());
        FileOutputStream fileOutputstream = null;
        if (zipEntry.isDirectory()) {
            newFullName = newFullName.replaceAll("\\\\/", File.separator);
            new File(this.workspaceFolder, newFullName).mkdir();
        } else {
            File entryFile = new File(String.valueOf(this.workspaceFolder) + File.separator + newFullName);
            fileOutputstream = new FileOutputStream(entryFile);
            try {
                IOUtils.copy((InputStream)exportedZippedFile.getInputStream(zipEntry), (OutputStream)fileOutputstream);
            }
            finally {
                IOUtils.closeQuietly((Closeable)fileOutputstream);
            }
        }
    }
}

