/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog.importentry;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.projectexplorer.dialog.importentry.ElementNameEditingSupport;
import org.grits.toolbox.core.projectexplorer.dialog.importentry.ImportEntryLabelProvider;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ImportEntryDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(ImportEntryDialog.class);
    private ZipFile exportedZipFile = null;
    private List<Element> selectedEntryElements = null;
    private Text locationText = null;
    private CheckboxTableViewer projectTableViewer = null;
    private Button autoRenameButton = null;
    private HashSet<String> existingNames = null;
    private ImportEntryLabelProvider labelProvider = null;

    public ImportEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Import Projects");
        this.setMessage("Import Projects From a File");
        this.getShell().setText("Import");
        this.getButton(0).setText("Import");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 20;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        String workspaceLocationFolder = PropertyHandler.getVariable("workspace_location");
        File workspaceFolder = new File(workspaceLocationFolder);
        this.existingNames = new HashSet();
        String[] stringArray = workspaceFolder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.existingNames.add(name);
            ++n2;
        }
        this.labelProvider = new ImportEntryLabelProvider(this.existingNames);
        this.locationText = new Text(container, 2048);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)textData);
        this.locationText.setEnabled(false);
        Button browseButton = this.addAButton(container, "Browse File", 128);
        final FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Select File");
        fileDialog.setFilterExtensions(new String[]{"*.GR"});
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportEntryDialog.this.setErrorMessage(null);
                fileDialog.setFileName(null);
                String selected = fileDialog.open();
                if (selected != null) {
                    try {
                        ImportEntryDialog.this.exportedZipFile = new ZipFile(selected);
                        ZipEntry exportEntry = ImportEntryDialog.this.exportedZipFile.getEntry("export_info.xml");
                        if (exportEntry != null) {
                            try {
                                Object[] entryElements = ImportEntryDialog.this.exportEntryElements(exportEntry);
                                ImportEntryDialog.this.projectTableViewer.setInput(entryElements);
                                ImportEntryDialog.this.projectTableViewer.setCheckedElements(entryElements);
                                ImportEntryDialog.this.labelProvider.resetAllNames();
                                ImportEntryDialog.this.projectTableViewer.refresh();
                                ImportEntryDialog.this.locationText.setText(selected);
                            }
                            catch (IOException iOException) {
                                ImportEntryDialog.this.setErrorMessage("Error loading Entry elements. Please upload another file.");
                                ImportEntryDialog.this.exportedZipFile = null;
                            }
                        } else {
                            ImportEntryDialog.this.setErrorMessage("Grits Export File is corrupt. Please upload another file.");
                            ImportEntryDialog.this.exportedZipFile = null;
                        }
                    }
                    catch (IOException e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Table projectsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.heightHint = 200;
        projectsTable.setLayoutData((Object)tableLayouData);
        this.projectTableViewer = new CheckboxTableViewer(projectsTable, "Select");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.projectTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Projects");
        tableColumn2.getColumn().setWidth(550);
        tableColumn2.setEditingSupport((EditingSupport)new ElementNameEditingSupport(this.projectTableViewer));
        this.projectTableViewer.getTable().setHeaderVisible(true);
        this.projectTableViewer.getTable().setLinesVisible(true);
        this.projectTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Button selectAllButton = this.addAButton(container, "Select All", 1);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportEntryDialog.this.projectTableViewer.getInput() != null) {
                    Element[] elementArray = (Element[])ImportEntryDialog.this.projectTableViewer.getInput();
                    int n = elementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element selectedEntry = elementArray[n2];
                        ImportEntryDialog.this.projectTableViewer.setChecked(selectedEntry, true);
                        ++n2;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllButton = this.addAButton(container, "Deselect All", 1);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportEntryDialog.this.projectTableViewer.getInput() != null) {
                    Element[] elementArray = (Element[])ImportEntryDialog.this.projectTableViewer.getInput();
                    int n = elementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element selectedEntry = elementArray[n2];
                        ImportEntryDialog.this.projectTableViewer.setChecked(selectedEntry, false);
                        ++n2;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.autoRenameButton = new Button(container, 32);
        this.autoRenameButton.setText("Auto-Rename");
        GridData buttonGridData = new GridData(3);
        buttonGridData.horizontalSpan = 1;
        buttonGridData.widthHint = 150;
        this.autoRenameButton.setLayoutData((Object)buttonGridData);
        this.autoRenameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportEntryDialog.this.projectTableViewer.getInput() != null && ((Button)e.getSource()).getSelection()) {
                    HashSet<String> allNames = new HashSet<String>(ImportEntryDialog.this.existingNames);
                    Element[] elementArray = (Element[])ImportEntryDialog.this.projectTableViewer.getInput();
                    int n = elementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element entryElement = elementArray[n2];
                        if (allNames.contains(entryElement.getAttributeValue("name"))) {
                            ImportEntryDialog.this.renameElement(allNames, entryElement);
                        }
                        allNames.add(entryElement.getAttributeValue("name"));
                        ++n2;
                    }
                    ImportEntryDialog.this.labelProvider.resetAllNames();
                    ImportEntryDialog.this.projectTableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label legendLabel = new Label(container, 0);
        legendLabel.setText(" * duplicate name");
        GridData labelGridData = new GridData(4);
        labelGridData.horizontalSpan = 3;
        labelGridData.verticalSpan = 1;
        legendLabel.setForeground(Display.getCurrent().getSystemColor(3));
        legendLabel.setLayoutData((Object)labelGridData);
        this.autoRenameButton.setSelection(true);
        browseButton.setFocus();
        container.setLayoutData((Object)new GridData(1808));
        comp.setLayoutData((Object)new GridData(1808));
        return comp;
    }

    private Element[] exportEntryElements(ZipEntry exportEntry) throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(this.exportedZipFile.getInputStream(exportEntry));
            Element rootNode = document.getRootElement();
            if (rootNode.getName().equals("export") && rootNode.getAttributeValue("version").equals("1.0")) {
                Element[] entryElements = new Element[rootNode.getChildren().size()];
                int i = 0;
                boolean autoRename = this.autoRenameButton.getSelection();
                HashSet<String> allNames = new HashSet<String>(this.existingNames);
                for (Object node : rootNode.getChildren("entry")) {
                    Element entryElement = (Element)node;
                    if (!Objects.equals(entryElement.getAttributeValue("type"), "org.grits.toolbox.property.project")) continue;
                    entryElements[i++] = entryElement;
                    if (autoRename && allNames.contains(entryElement.getAttributeValue("name"))) {
                        this.renameElement(allNames, entryElement);
                    }
                    allNames.add(entryElement.getAttributeValue("name"));
                }
                return entryElements;
            }
            throw new IOException("Root node is not \"export\" or its version is not\"1.0\"");
        }
        catch (JDOMException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new IOException(e1.getMessage(), e1);
        }
    }

    private void renameElement(Set<String> allNames, Element entryElement) {
        String currentName = entryElement.getAttributeValue("name");
        int suffixCounter = 2;
        while (allNames.contains(currentName)) {
            currentName = String.valueOf(entryElement.getAttributeValue("name")) + "_GR_" + suffixCounter++;
        }
        entryElement.setAttribute("name", currentName);
    }

    private Button addAButton(Composite container, String label, int horizontalAlignment) {
        Button button = new Button(container, 8);
        button.setText(label);
        GridData buttonGridData = new GridData(horizontalAlignment);
        buttonGridData.horizontalSpan = 1;
        buttonGridData.widthHint = 150;
        button.setLayoutData((Object)buttonGridData);
        return button;
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        if (this.projectTableViewer.getCheckedElements().length > 0) {
            boolean renameRequired = false;
            this.selectedEntryElements = new ArrayList<Element>();
            Object[] objectArray = this.projectTableViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object pj = objectArray[n2];
                if (pj instanceof Element) {
                    if (this.labelProvider.getDuplicateElements().contains(pj)) {
                        renameRequired = true;
                        break;
                    }
                    this.selectedEntryElements.add((Element)pj);
                }
                ++n2;
            }
            if (renameRequired) {
                this.setErrorMessage("Rename selected duplicate entries before exporting.");
            } else {
                super.okPressed();
            }
        } else {
            this.setErrorMessage("No Entry selected for export.");
        }
    }

    public ZipFile getExportedZipFile() {
        return this.exportedZipFile;
    }

    public List<Element> getSelectedEntryElements() {
        return this.selectedEntryElements;
    }
}

