/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.s3.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.TableSorter;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.BaseS3Object;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;

public class AccessControlDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6621927508514378546L;
    private GuiUtils guiUtils = new GuiUtils();
    private static AccessControlDialog accessControlDialog = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private AccessControlList originalAccessControlList = null;
    private AccessControlList updatedAccessControlList = null;
    private JHtmlLabel itemsDescription = null;
    private JTable canonicalGranteeTable = null;
    private GranteeTableModel canonicalGranteeTableModel = null;
    private JTable emailGranteeTable = null;
    private GranteeTableModel emailGranteeTableModel = null;
    private JTable groupGranteeTable = null;
    private GranteeTableModel groupGranteeTableModel = null;
    private static final String[] canonicalUserTableColumnNames = new String[]{"Canonical ID", "Display Name", "Permission"};
    private static final String[] groupTableColumnNames = new String[]{"Group URI", "Permission"};
    private static final String[] emailTableColumnNames = new String[]{"Email Address", "Permission"};
    private final JComboBox permissionComboBox = new JComboBox<Permission>(new Permission[]{Permission.PERMISSION_READ, Permission.PERMISSION_WRITE, Permission.PERMISSION_FULL_CONTROL, Permission.PERMISSION_READ_ACP, Permission.PERMISSION_WRITE_ACP});
    private final JComboBox groupGranteeComboBox = new JComboBox<GroupGrantee>(new GroupGrantee[]{GroupGrantee.ALL_USERS, GroupGrantee.AUTHENTICATED_USERS, GroupGrantee.LOG_DELIVERY});
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final Insets insetsZeroAtBottom = new Insets(5, 7, 0, 7);
    private final Insets insetsZeroAtTop = new Insets(0, 7, 5, 7);

    protected AccessControlDialog(Frame owner, HyperlinkActivatedListener hyperlinkListener) {
        super(owner, "Update Access Control List Permissions", true);
        this.hyperlinkListener = hyperlinkListener;
        this.initGui();
    }

    protected void initData(BaseS3Object[] s3Items, AccessControlList accessControlList) {
        this.originalAccessControlList = accessControlList;
        if (s3Items.length > 1) {
            this.itemsDescription.setText("<html><b>Object count</b>: " + s3Items.length + " objects");
        } else if (s3Items[0] instanceof S3Bucket) {
            this.itemsDescription.setText("<html><b>Bucket</b><br>" + ((S3Bucket)s3Items[0]).getName());
        } else {
            this.itemsDescription.setText("<html><b>Object</b><br>" + ((S3Object)s3Items[0]).getKey());
        }
        this.canonicalGranteeTableModel.removeAllGrantAndPermissions();
        this.emailGranteeTableModel.removeAllGrantAndPermissions();
        this.groupGranteeTableModel.removeAllGrantAndPermissions();
        for (GrantAndPermission gap : this.originalAccessControlList.getGrants()) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            if (grantee instanceof CanonicalGrantee) {
                this.canonicalGranteeTableModel.addGrantee(grantee, permission);
                continue;
            }
            if (grantee instanceof EmailAddressGrantee) {
                this.emailGranteeTableModel.addGrantee(grantee, permission);
                continue;
            }
            if (!(grantee instanceof GroupGrantee)) continue;
            this.groupGranteeTableModel.addGrantee(grantee, permission);
        }
    }

    protected void initGui() {
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.canonicalGranteeTableModel = new GranteeTableModel(CanonicalGrantee.class);
        this.canonicalGranteeTable = new GranteeTable(this.canonicalGranteeTableModel);
        JButton removeCanonical = new JButton();
        removeCanonical.setToolTipText("Remove the selected Canonical User grantee");
        this.guiUtils.applyIcon((Object)removeCanonical, "/images/nuvola/16x16/actions/viewmag-.png");
        removeCanonical.addActionListener(this);
        removeCanonical.setActionCommand("removeCanonicalGrantee");
        JButton addCanonical = new JButton();
        addCanonical.setToolTipText("Add a new Canonical User grantee");
        this.guiUtils.applyIcon((Object)addCanonical, "/images/nuvola/16x16/actions/viewmag+.png");
        addCanonical.setActionCommand("addCanonicalGrantee");
        addCanonical.addActionListener(this);
        this.emailGranteeTableModel = new GranteeTableModel(EmailAddressGrantee.class);
        this.emailGranteeTable = new GranteeTable(this.emailGranteeTableModel);
        JButton removeEmail = new JButton();
        removeEmail.setToolTipText("Remove the selected Email Address grantee");
        this.guiUtils.applyIcon((Object)removeEmail, "/images/nuvola/16x16/actions/viewmag-.png");
        removeEmail.setActionCommand("removeEmailGrantee");
        removeEmail.addActionListener(this);
        JButton addEmail = new JButton();
        addEmail.setToolTipText("Add a new Email Address grantee");
        this.guiUtils.applyIcon((Object)addEmail, "/images/nuvola/16x16/actions/viewmag+.png");
        addEmail.setActionCommand("addEmailGrantee");
        addEmail.addActionListener(this);
        this.groupGranteeTableModel = new GranteeTableModel(GroupGrantee.class);
        this.groupGranteeTable = new GranteeTable(this.groupGranteeTableModel);
        JButton removeGroup = new JButton();
        removeGroup.setToolTipText("Remove the selected Group grantee");
        this.guiUtils.applyIcon((Object)removeGroup, "/images/nuvola/16x16/actions/viewmag-.png");
        removeGroup.setActionCommand("removeGroupGrantee");
        removeGroup.addActionListener(this);
        JButton addGroup = new JButton();
        addGroup.setToolTipText("Add a new Group grantee");
        this.guiUtils.applyIcon((Object)addGroup, "/images/nuvola/16x16/actions/viewmag+.png");
        addGroup.setActionCommand("addGroupGrantee");
        addGroup.addActionListener(this);
        JPanel buttonsContainer = new JPanel(new GridBagLayout());
        final JButton cancelButton = new JButton("Cancel Permission Changes");
        cancelButton.setDefaultCapable(true);
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand("Cancel");
        JButton okButton = new JButton("Save Permission Changes");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 4173433313456104263L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cancelButton.doClick();
            }
        });
        JPanel container = new JPanel(new GridBagLayout());
        int row = 0;
        this.itemsDescription = new JHtmlLabel("", this.hyperlinkListener);
        container.add((Component)this.itemsDescription, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        JPanel canonicalAddRemovePanel = new JPanel();
        canonicalAddRemovePanel.add(removeCanonical);
        canonicalAddRemovePanel.add(addCanonical);
        container.add((Component)new JHtmlLabel("<html><b>Canonical User Grantees</b></html>", this.hyperlinkListener), new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 16, 2, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)new JScrollPane(this.canonicalGranteeTable), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)new JHtmlLabel("<html><b>Group Grantees</b></html>", this.hyperlinkListener), new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 16, 2, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)canonicalAddRemovePanel, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsZeroAtTop, 0, 0));
        JPanel groupAddRemovePanel = new JPanel();
        groupAddRemovePanel.add(removeGroup);
        groupAddRemovePanel.add(addGroup);
        container.add((Component)new JScrollPane(this.groupGranteeTable), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)new JHtmlLabel("<html><b>Email Address Grantees</b></html>", this.hyperlinkListener), new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 16, 2, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)groupAddRemovePanel, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsZeroAtTop, 0, 0));
        JPanel emailAddRemovePanel = new JPanel();
        emailAddRemovePanel.add(removeEmail);
        emailAddRemovePanel.add(addEmail);
        container.add((Component)new JScrollPane(this.emailGranteeTable), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, this.insetsZeroAtBottom, 0, 0));
        container.add((Component)emailAddRemovePanel, new GridBagConstraints(1, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsZeroAtTop, 0, 0));
        buttonsContainer.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, this.insetsZero, 0, 0));
        buttonsContainer.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, this.insetsZero, 0, 0));
        container.add((Component)buttonsContainer, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getContentPane().add(container);
        this.pack();
        this.setSize(new Dimension(700, 450));
        this.setLocationRelativeTo(this.getOwner());
        this.canonicalGranteeTable.getColumnModel().getColumn(0).setPreferredWidth((int)(this.canonicalGranteeTable.getParent().getBounds().getWidth() * 0.9));
        this.emailGranteeTable.getColumnModel().getColumn(0).setPreferredWidth((int)(this.emailGranteeTable.getParent().getBounds().getWidth() * 0.9));
        this.groupGranteeTable.getColumnModel().getColumn(0).setPreferredWidth((int)(this.groupGranteeTable.getParent().getBounds().getWidth() * 0.9));
    }

    public AccessControlList getUpdatedAccessControlList() {
        return this.updatedAccessControlList;
    }

    private void updateAccessControlList() {
        Permission permission;
        GranteeInterface grantee;
        int i;
        this.updatedAccessControlList = new AccessControlList();
        this.updatedAccessControlList.setOwner(this.originalAccessControlList.getOwner());
        for (i = 0; i < this.canonicalGranteeTable.getRowCount(); ++i) {
            grantee = this.canonicalGranteeTableModel.getGrantee(i);
            permission = this.canonicalGranteeTableModel.getPermission(i);
            this.updatedAccessControlList.grantPermission(grantee, permission);
        }
        for (i = 0; i < this.emailGranteeTable.getRowCount(); ++i) {
            grantee = this.emailGranteeTableModel.getGrantee(i);
            permission = this.emailGranteeTableModel.getPermission(i);
            this.updatedAccessControlList.grantPermission(grantee, permission);
        }
        for (i = 0; i < this.groupGranteeTable.getRowCount(); ++i) {
            grantee = this.groupGranteeTableModel.getGrantee(i);
            permission = this.groupGranteeTableModel.getPermission(i);
            this.updatedAccessControlList.grantPermission(grantee, permission);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.updateAccessControlList();
            this.setVisible(false);
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.updatedAccessControlList = null;
            this.setVisible(false);
        } else if ("addCanonicalGrantee".equals(e.getActionCommand())) {
            int rowIndex = this.canonicalGranteeTableModel.addGrantee((GranteeInterface)new CanonicalGrantee("NewCanonicalId"), Permission.PERMISSION_READ);
            this.canonicalGranteeTable.setRowSelectionInterval(rowIndex, rowIndex);
        } else if ("removeCanonicalGrantee".equals(e.getActionCommand())) {
            if (this.canonicalGranteeTable.getSelectedRow() >= 0) {
                this.canonicalGranteeTableModel.removeGrantAndPermission(this.canonicalGranteeTable.getSelectedRow());
            }
        } else if ("addEmailGrantee".equals(e.getActionCommand())) {
            int rowIndex = this.emailGranteeTableModel.addGrantee((GranteeInterface)new EmailAddressGrantee("new.email@address.here"), Permission.PERMISSION_READ);
            this.emailGranteeTable.setRowSelectionInterval(rowIndex, rowIndex);
        } else if ("removeEmailGrantee".equals(e.getActionCommand())) {
            if (this.emailGranteeTable.getSelectedRow() >= 0) {
                this.emailGranteeTableModel.removeGrantAndPermission(this.emailGranteeTable.getSelectedRow());
            }
        } else if ("addGroupGrantee".equals(e.getActionCommand())) {
            int rowIndex = this.groupGranteeTableModel.addGrantee((GranteeInterface)GroupGrantee.AUTHENTICATED_USERS, Permission.PERMISSION_READ);
            this.groupGranteeTable.setRowSelectionInterval(rowIndex, rowIndex);
        } else if ("removeGroupGrantee".equals(e.getActionCommand())) {
            if (this.groupGranteeTable.getSelectedRow() >= 0) {
                this.groupGranteeTableModel.removeGrantAndPermission(this.groupGranteeTable.getSelectedRow());
            }
        } else {
            System.err.println("UNRECOGNISED ACTION COMMAND: " + e.getActionCommand());
        }
    }

    public static AccessControlList showDialog(Frame owner, BaseS3Object[] s3Items, AccessControlList accessControlList, HyperlinkActivatedListener hyperlinkListener) {
        if (accessControlDialog == null) {
            accessControlDialog = new AccessControlDialog(owner, hyperlinkListener);
        }
        accessControlDialog.initData(s3Items, accessControlList);
        accessControlDialog.setVisible(true);
        return accessControlDialog.getUpdatedAccessControlList();
    }

    public static void main(String[] args) throws Exception {
        AccessControlList acl = new AccessControlList();
        S3Owner owner = new S3Owner("1234567890", "Some Name");
        acl.setOwner(owner);
        CanonicalGrantee grantee = new CanonicalGrantee();
        grantee.setIdentifier("zzz");
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_WRITE);
        grantee = new CanonicalGrantee();
        grantee.setIdentifier("abc");
        grantee.setDisplayName("jamesmurty");
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_FULL_CONTROL);
        grantee = new CanonicalGrantee();
        grantee.setIdentifier("aaa");
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_READ);
        grantee = GroupGrantee.ALL_USERS;
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_READ);
        grantee = GroupGrantee.AUTHENTICATED_USERS;
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_WRITE);
        grantee = new EmailAddressGrantee();
        grantee.setIdentifier("james@test.com");
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_READ);
        grantee = new EmailAddressGrantee();
        grantee.setIdentifier("james@test2.com");
        acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_FULL_CONTROL);
        JFrame f = new JFrame("Cockpit");
        S3Bucket bucket = new S3Bucket();
        bucket.setName("SomeReallyLongAndWackyBucketNamePath.HereItIs");
        AccessControlList updatedACL = acl;
        while ((updatedACL = AccessControlDialog.showDialog(f, (BaseS3Object[])new S3Bucket[]{bucket}, updatedACL, null)) != null) {
            System.out.println(updatedACL.toXml());
        }
        f.dispose();
    }

    private class GranteeTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -5533290183089426571L;
        private Class granteeClass;
        ArrayList currentGrantees;
        int permissionColumn;

        public GranteeTableModel(Class granteeClass) {
            super(CanonicalGrantee.class.equals((Object)granteeClass) ? canonicalUserTableColumnNames : (EmailAddressGrantee.class.equals((Object)granteeClass) ? emailTableColumnNames : (GroupGrantee.class.equals((Object)granteeClass) ? groupTableColumnNames : new String[]{})), 0);
            this.granteeClass = null;
            this.currentGrantees = new ArrayList();
            this.permissionColumn = 0;
            this.granteeClass = granteeClass;
            this.permissionColumn = CanonicalGrantee.class.equals((Object)granteeClass) ? 2 : 1;
        }

        public int addGrantee(GranteeInterface grantee, Permission permission) {
            GrantAndPermission gap = new GrantAndPermission(grantee, permission);
            int insertRow = Collections.binarySearch(this.currentGrantees, gap, new Comparator(){

                public int compare(Object o1, Object o2) {
                    GrantAndPermission g1 = (GrantAndPermission)o1;
                    GrantAndPermission g2 = (GrantAndPermission)o2;
                    return g1.getGrantee().getIdentifier().compareToIgnoreCase(g2.getGrantee().getIdentifier());
                }
            });
            if (insertRow < 0) {
                insertRow = -insertRow - 1;
            }
            this.currentGrantees.add(insertRow, gap);
            if (grantee instanceof GroupGrantee) {
                this.insertRow(insertRow, new Object[]{grantee, permission});
            } else if (grantee instanceof CanonicalGrantee) {
                CanonicalGrantee canonicalGrantee = (CanonicalGrantee)grantee;
                this.insertRow(insertRow, new Object[]{canonicalGrantee.getIdentifier(), canonicalGrantee.getDisplayName(), permission});
            } else {
                this.insertRow(insertRow, new Object[]{grantee.getIdentifier(), permission});
            }
            return insertRow;
        }

        public void removeGrantAndPermission(int index) {
            GranteeInterface grantee = this.getGrantee(index);
            this.removeRow(index);
            this.currentGrantees.remove(grantee);
        }

        public void removeAllGrantAndPermissions() {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.removeRow(0);
            }
            this.currentGrantees.clear();
        }

        public Permission getPermission(int index) {
            return (Permission)this.getValueAt(index, this.permissionColumn);
        }

        public GranteeInterface getGrantee(int index) {
            GrantAndPermission originalGAP = (GrantAndPermission)this.currentGrantees.get(index);
            Object updatedGrantee = super.getValueAt(index, 0);
            if (updatedGrantee instanceof GroupGrantee) {
                return (GroupGrantee)updatedGrantee;
            }
            originalGAP.getGrantee().setIdentifier((String)updatedGrantee);
            return originalGAP.getGrantee();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 || column == this.permissionColumn;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                if (GroupGrantee.class.equals((Object)this.granteeClass)) {
                    return GroupGrantee.class;
                }
                return String.class;
            }
            if (columnIndex == this.permissionColumn) {
                return Permission.class;
            }
            return String.class;
        }
    }

    private class GranteeTable
    extends JTable {
        private static final long serialVersionUID = -5339684196750695854L;
        private TableSorter sorter = null;

        public GranteeTable(GranteeTableModel granteeTableModel) {
            this.sorter = new TableSorter((TableModel)granteeTableModel);
            this.setModel((TableModel)this.sorter);
            this.sorter.setTableHeader(this.getTableHeader());
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(this);
            DefaultCellEditor groupCellEditor = new DefaultCellEditor(AccessControlDialog.this.groupGranteeComboBox);
            groupCellEditor.setClickCountToStart(2);
            this.setDefaultEditor(GroupGrantee.class, groupCellEditor);
            this.setDefaultRenderer(GroupGrantee.class, new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 4938391147702620699L;

                @Override
                public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                    GroupGrantee groupGrantee = (GroupGrantee)value;
                    return super.getTableCellRendererComponent(arg0, groupGrantee.getIdentifier(), arg2, arg3, arg4, arg5);
                }
            });
            DefaultCellEditor permissionCellEditor = new DefaultCellEditor(AccessControlDialog.this.permissionComboBox);
            permissionCellEditor.setClickCountToStart(2);
            this.setDefaultEditor(Permission.class, permissionCellEditor);
        }

        @Override
        public int getSelectedRow() {
            int tableIndex = super.getSelectedRow();
            return this.sorter.modelIndex(tableIndex);
        }
    }
}

