/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationThread;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class GAGPlugin
implements Plugin,
ActionListener {
    protected GAGDictionary theDictionary = null;
    protected GAGOptions theOptions = null;
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected boolean first_time_run = true;
    protected boolean annotate = false;
    protected boolean showTopResults = true;
    protected AnnotationThread theThread = null;
    protected ProgressMonitor progressDialog = null;
    protected Timer activityMonitor = null;

    public GAGPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        this.theDictionary = new GAGDictionary("/conf/gag_backbones");
        this.theOptions = new GAGOptions();
    }

    @Override
    public void init() {
        if (this.theWorkspace != null) {
            this.theOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public void exit() {
        if (this.theWorkspace != null) {
            this.theOptions.store(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public String getName() {
        return "GAGs";
    }

    @Override
    public int getMnemonic() {
        return 71;
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return -1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return null;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("options", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Set plugin options", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("computeStructures", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Compute all the possible structures for a given family", 77, "", (ActionListener)this));
        actions.add(new GlycanAction("findStructures", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find all the structures of a given family with a certain m/z value", 70, "", (ActionListener)this));
        actions.add(new GlycanAction("matchStructures", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with structures from a given family", 78, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("findSulfationsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find the sulfation patterns of the current structures with a given m/z value", 67, "", (ActionListener)this));
        actions.add(new GlycanAction("findSulfationsSelected", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find the sulfation patterns of the selected structures with a given m/z value", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("findSulfationsAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find the sulfation patterns of all structures with a given m/z value", 65, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("matchSulfationsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with sulfation patterns of the current structures", 85, "", (ActionListener)this));
        actions.add(new GlycanAction("matchSulfationsSelected", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with sulfation patterns of the selected structures", 69, "", (ActionListener)this));
        actions.add(new GlycanAction("matchSulfationsAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with sulfation patterns of all structures", 76, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
        if (this.theManager != null) {
            this.theManager.addMsPeakAction(new GlycanAction("findStructures", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find all GAG structures matching the peaks", 70, "", (ActionListener)this));
        }
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        if (this.theWorkspace != null) {
            this.theOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    @Override
    public void show(String view) throws Exception {
        throw new Exception("Invalid view: " + view);
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.startsWith("find")) {
            String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), (Object)"Insert m/z value");
            if (m_z != null) {
                return this.runAction(true, action, new PeakList(Double.valueOf(m_z)));
            }
            return false;
        }
        return this.runAction(true, action, this.theWorkspace.getPeakList());
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        if (!(params instanceof PeakList)) {
            throw new Exception("Invalid param object: PeakList needed");
        }
        if (this.runAction(this.first_time_run, action, (PeakList)((Object)params))) {
            this.first_time_run = false;
            return true;
        }
        return false;
    }

    public boolean runAction(boolean ask, String action, PeakList peaks) throws Exception {
        if (action.equals("options")) {
            return this.setOptions();
        }
        if (action.equals("computeStructures")) {
            if (this.computeAllStructures(ask)) {
                this.theManager.show("Fragments", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findStructures")) {
            this.annotate = false;
            if (this.matchStructures(ask, peaks)) {
                this.theManager.show("Search", this.theWorkspace.getSearchResults().getNoStructures() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchStructures")) {
            this.annotate = true;
            if (this.matchStructures(ask, peaks)) {
                this.theManager.show("Annotation", this.theWorkspace.getAnnotatedPeakList().getNoStructures() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findSulfationsCurrent")) {
            this.annotate = false;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllSulfations(ask, this.theApplication.getCanvas().getCurrentStructure(), peaks)) {
                this.theManager.show("Search", this.theWorkspace.getSearchResults().getNoStructures() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findSulfationsSelected")) {
            this.annotate = false;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllSulfations(ask, this.theApplication.getCanvas().getSelectedStructures(), peaks)) {
                this.theManager.show("Search", this.theWorkspace.getSearchResults().getNoStructures() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findSulfationsAll")) {
            this.annotate = false;
            if (this.matchAllSulfations(ask, this.theWorkspace.getStructures().getStructures(), peaks)) {
                this.theManager.show("Search", this.theWorkspace.getSearchResults().getNoStructures() > 1 ? "Summary" : "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchSulfationsCurrent")) {
            this.annotate = true;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllSulfations(ask, this.theApplication.getCanvas().getCurrentStructure(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("matchSulfationsSelected")) {
            this.annotate = true;
            this.theApplication.getCanvas().enforceSelection();
            if (this.matchAllSulfations(ask, this.theApplication.getCanvas().getSelectedStructures(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        if (action.equals("matchSulfationsAll")) {
            this.annotate = true;
            if (this.matchAllSulfations(ask, this.theWorkspace.getStructures().getStructures(), peaks)) {
                this.theManager.show("Annotation", "Stats");
                return true;
            }
            return false;
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
    }

    @Override
    public void updateMasses() {
    }

    public boolean setOptions() {
        GAGOptionsDialog dlg = new GAGOptionsDialog((Frame)((Object)this.theApplication), this.theDictionary, this.theOptions);
        dlg.setVisible(true);
        return dlg.getReturnStatus().equals("OK");
    }

    public boolean computeAllStructures(boolean ask_options) {
        if (ask_options) {
            GAGOptionsDialog dlg = new GAGOptionsDialog((Frame)((Object)this.theApplication), this.theDictionary, this.theOptions);
            dlg.setVisible(true);
            if (!dlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        this.theApplication.haltInteractions();
        FragmentDocument results = this.theDictionary.generateStructures(this.theOptions);
        this.theWorkspace.getFragments().copy(results);
        this.theApplication.restoreInteractions();
        return true;
    }

    public boolean matchStructures(boolean ask_options, PeakList peaks) {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask_options) {
            GAGOptionsDialog gdlg = new GAGOptionsDialog((Frame)((Object)this.theApplication), this.theDictionary, this.theOptions);
            gdlg.setVisible(true);
            if (!gdlg.getReturnStatus().equals("OK")) {
                return false;
            }
            AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
            adlg.setVisible(true);
            if (!adlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        this.theApplication.haltInteractions();
        this.theDictionary.setOptions(this.theOptions);
        this.theThread = new AnnotationThread(peaks, this.theDictionary, ann_opt);
        return this.runAnnotation();
    }

    public boolean matchAllSulfations(boolean ask_options, Glycan structure, PeakList peaks) {
        if (structure != null) {
            return this.matchAllSulfations(ask_options, Collections.singleton(structure), peaks);
        }
        return false;
    }

    public boolean matchAllSulfations(boolean ask_options, Collection<Glycan> structures, PeakList peaks) {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask_options) {
            AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
            adlg.setVisible(true);
            if (!adlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        this.theApplication.haltInteractions();
        FragmentDocument fd = Fragmenter.generateLabilesConfigurations(structures);
        this.theThread = new AnnotationThread(peaks, fd, ann_opt);
        return this.runAnnotation();
    }

    private boolean runAnnotation() {
        this.theThread.start();
        this.progressDialog = new ProgressMonitor((Component)((Object)this.theApplication), "Matching peaks with fragments", null, 0, this.theThread.getTarget());
        this.activityMonitor = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int progress = GAGPlugin.this.theThread.getProgress();
                GAGPlugin.this.progressDialog.setProgress(progress);
                if (progress == GAGPlugin.this.theThread.getTarget() || GAGPlugin.this.theThread.isInterrupted() || GAGPlugin.this.progressDialog.isCanceled()) {
                    GAGPlugin.this.activityMonitor.stop();
                    GAGPlugin.this.progressDialog.close();
                    if (progress != GAGPlugin.this.theThread.getTarget()) {
                        GAGPlugin.this.theThread.interrupt();
                        GAGPlugin.this.onAnnotationAborted(GAGPlugin.this.theThread);
                    } else {
                        GAGPlugin.this.onAnnotationCompleted(GAGPlugin.this.theThread);
                    }
                }
            }
        });
        this.activityMonitor.start();
        return true;
    }

    public void onAnnotationCompleted(AnnotationThread t) {
        AnnotatedPeakList dest = null;
        dest = this.annotate ? this.theWorkspace.getAnnotatedPeakList() : this.theWorkspace.getSearchResults();
        if (this.showTopResults) {
            dest.copy(t.getAnnotatedPeaks().getFirst(20));
        } else {
            dest.copy(t.getAnnotatedPeaks());
        }
        this.theApplication.restoreInteractions();
        if (t.getNonEmptyStructures() > 0 && t.hasFuzzyStructures()) {
            if (t.getNonEmptyStructures() == 1) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for structures with uncertain terminals", "Error", 0);
            } else if (t.hasNonFuzzyStructures()) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for some structures with uncertain terminals", "Error", 0);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments, all structures have uncertain terminals", "Error", 0);
            }
        }
    }

    public void onAnnotationAborted(AnnotationThread t) {
        this.theApplication.restoreInteractions();
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

