/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.taskexport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectContribution;
import org.grits.toolbox.core.datamodel.property.project.ProjectContributor;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.wizard.taskexport.pages.SelectColumnPage;
import org.grits.toolbox.core.wizard.taskexport.pages.TaskFilterPage;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class TaskExportWizard
extends Wizard {
    private static Logger logger = Logger.getLogger(TaskExportWizard.class);
    private TaskFilterPage pageOne = new TaskFilterPage();
    private SelectColumnPage pageTwo = new SelectColumnPage();
    private ArrayList<ProjectContributor> contributors = null;
    private String savingLocation = null;
    private ArrayList<String> selectedColumns;

    public void addPages() {
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return page == this.pageOne ? this.pageTwo : null;
    }

    public boolean performFinish() {
        try {
            this.prepareExport();
        }
        catch (Exception e1) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(e1.getMessage());
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return false;
        }
        final GRITSProgressDialog progressDialog = new GRITSProgressDialog(this.getShell(), 1, true);
        progressDialog.open();
        progressDialog.getMajorProgressBarListener().setMaxValue(2);
        progressDialog.setGritsWorker(new GRITSWorker(){

            public int doWork() {
                try {
                    this.updateListeners("Exporting...", 1);
                    CancelableThread t = new CancelableThread(){

                        public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                            try {
                                if (TaskExportWizard.this.selectedColumns != null) {
                                    return TaskExportWizard.this.exportToExcel(TaskExportWizard.this.selectedColumns, progressDialog);
                                }
                                return false;
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                return false;
                            }
                        }
                    };
                    t.setProgressThreadHandler((IProgressThreadHandler)progressDialog);
                    progressDialog.setThread(t);
                    progressDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
                    t.start();
                    while (!t.isCanceled() && !t.isFinished() && t.isAlive()) {
                        Display.getDefault().readAndDispatch();
                    }
                    if (t.isCanceled()) {
                        t.interrupt();
                        return GRITSProcessStatus.CANCEL;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.updateListeners("Done", 2);
                return GRITSProcessStatus.OK;
            }
        });
        progressDialog.startWorker();
        return true;
    }

    private void prepareExport() throws Exception {
        boolean locationError = false;
        try {
            this.savingLocation = this.pageOne.locationText.getText();
            File inputFile = new File(this.savingLocation);
            FileOutputStream fos = new FileOutputStream(inputFile);
            fos.close();
            locationError = !inputFile.getParentFile().exists() || !inputFile.getParentFile().isDirectory();
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
            throw new Exception("The location is not correct. Please select a correct location", ex);
        }
        if (locationError) {
            String message = "The location is not correct. Please select a correct location";
            logger.error((Object)message);
            throw new Exception(message);
        }
        if (this.pageOne.projectTableViewer.getCheckedElements().length > 0 && this.pageOne.statusTableViewer.getCheckedElements().length > 0) {
            this.exportContributors();
            if (this.getContainer().getCurrentPage() == this.pageTwo && this.pageTwo.isPageComplete()) {
                this.saveExportColumnNames();
            }
        }
        this.selectedColumns = new ArrayList();
        int j = 0;
        int i = 0;
        while (i < this.pageTwo.columnsToExport.length) {
            if (this.pageTwo.columnsToExport[i].getSelection()) {
                this.selectedColumns.add(j, this.pageTwo.columnsToExport[i].getText());
                ++j;
            }
            ++i;
        }
    }

    private void saveExportColumnNames() {
    }

    private void exportContributors() throws Exception {
        this.contributors = new ArrayList();
        CheckboxTableViewer projectTableViewer = this.pageOne.projectTableViewer;
        CheckboxTableViewer statusTableViewer = this.pageOne.statusTableViewer;
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        String workspaceLocationFolder = PropertyHandler.getVariable("workspace_location");
        workspaceLocationFolder = workspaceLocationFolder.substring(0, workspaceLocationFolder.length());
        ProjectContributor contributor = null;
        ProjectContribution projectContribution = null;
        String collaborator = null;
        ArrayList<String> checkedStatus = new ArrayList<String>();
        Object[] objectArray = statusTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object status = objectArray[n2];
            checkedStatus.add((String)status);
            ++n2;
        }
        objectArray = projectTableViewer.getCheckedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object pj = objectArray[n2];
            if (pj instanceof Entry) {
                Entry projectEntry = (Entry)pj;
                ProjectDetails projectDetails = null;
                try {
                    projectDetails = ProjectDetailsHandler.getProjectDetails(projectEntry);
                    if (projectDetails != null) {
                        collaborator = "";
                        for (ProjectCollaborator coll : projectDetails.getCollaborators()) {
                            collaborator = String.valueOf(collaborator) + coll.getName();
                            if (coll.getAddress() != null) {
                                collaborator = String.valueOf(collaborator) + "\n" + coll.getAddress();
                            }
                            collaborator = String.valueOf(collaborator) + "\n----x----\n";
                        }
                        if (!collaborator.isEmpty()) {
                            collaborator = collaborator.substring(0, collaborator.length() - 2);
                        }
                        for (ProjectTasklist taskList : projectDetails.getTasklists()) {
                            if (!checkedStatus.contains(taskList.getStatus())) continue;
                            if (alreadyAdded.contains(taskList.getPerson())) {
                                for (ProjectContributor contbtr : this.contributors) {
                                    if (!contbtr.getName().equals(taskList.getPerson())) continue;
                                    contributor = contbtr;
                                }
                            } else {
                                contributor = new ProjectContributor();
                                contributor.setName(taskList.getPerson());
                                this.contributors.add(contributor);
                                alreadyAdded.add(taskList.getPerson());
                            }
                            projectContribution = new ProjectContribution();
                            projectContribution.setProjectName(projectEntry.getDisplayName());
                            projectContribution.setGroupPI(taskList.getGroupOrPIName());
                            projectContribution.setRole(taskList.getRole());
                            projectContribution.setTask(taskList.getTask());
                            projectContribution.setStatus(taskList.getStatus());
                            projectContribution.setProjectCollaborator(collaborator);
                            projectContribution.setDueDate(taskList.getDueDate());
                            projectContribution.setNumberOfTasks(taskList.getNumberOfTasks());
                            contributor.addContribution(projectContribution);
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            ++n2;
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.pageOne) {
            return this.pageOne.projectTableViewer.getCheckedElements().length > 0;
        }
        if (this.getContainer().getCurrentPage() == this.pageTwo) {
            return this.pageTwo != null && this.pageTwo.isPageComplete();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportToExcel(List<String> selectedColumns, GRITSProgressDialog progressDialog) {
        boolean exported = false;
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.savingLocation));
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFCellStyle wrapStyle = workbook.createCellStyle();
            wrapStyle.setWrapText(true);
            XSSFCellStyle boldStyle = workbook.createCellStyle();
            XSSFFont boldFont = workbook.createFont();
            boldFont.setBold(true);
            boldStyle.setFont((Font)boldFont);
            boldStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
            boldStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFCellStyle boldHeaderStyle = workbook.createCellStyle();
            boldHeaderStyle.setFont((Font)boldFont);
            boldHeaderStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            boldHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFSheet sheet = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            int num = 0;
            int totalNum = this.contributors.size();
            progressDialog.getMinorProgressBarListener(0).setMaxValue(totalNum);
            progressDialog.getMinorProgressBarListener(0).setProgressValue(0);
            for (ProjectContributor contributor : this.contributors) {
                if (progressDialog.isCanceled()) {
                    fos.close();
                    fos.getChannel().close();
                    workbook.close();
                    return false;
                }
                progressDialog.getMinorProgressBarListener(0).setProgressValue(num + 1);
                progressDialog.getMinorProgressBarListener(0).setProgressMessage("Filtering row: " + (num + 1) + " of " + totalNum);
                sheet = workbook.createSheet(contributor.getName());
                sheet.createRow(0).createCell(0).setCellValue(contributor.getName());
                sheet.getRow(0).getCell(0).setCellStyle((CellStyle)boldStyle);
                int indexRow = 1;
                Row thisRow = null;
                thisRow = sheet.createRow(indexRow);
                int i = 0;
                while (i < selectedColumns.size()) {
                    thisRow.createCell(i).setCellValue(selectedColumns.get(i));
                    ++i;
                }
                i = 0;
                while (i < selectedColumns.size()) {
                    thisRow.getCell(i).setCellStyle((CellStyle)boldHeaderStyle);
                    ++i;
                }
                ++indexRow;
                for (ProjectContribution contribution : contributor.getContributions()) {
                    thisRow = sheet.createRow(indexRow);
                    thisRow.setRowStyle((CellStyle)wrapStyle);
                    int i2 = 0;
                    while (i2 < selectedColumns.size()) {
                        Object value = null;
                        switch (selectedColumns.get(i2)) {
                            case "Project": {
                                value = contribution.getProjectName();
                                break;
                            }
                            case "Name/Address": {
                                value = contribution.getProjectCollaborator();
                                break;
                            }
                            case "Group/P.I.": {
                                value = contribution.getGroupPI();
                                break;
                            }
                            case "Role": {
                                value = contribution.getRole();
                                break;
                            }
                            case "Task": {
                                value = contribution.getTask();
                                break;
                            }
                            case "Status": {
                                value = contribution.getStatus();
                                break;
                            }
                            case "#Samples": {
                                value = contribution.getNumberOfTasks();
                                break;
                            }
                            case "Completion Date": {
                                value = contribution.getDueDate() != null ? dateFormat.format(contribution.getDueDate()) : null;
                                break;
                            }
                        }
                        if (value != null) {
                            if (value instanceof String) {
                                thisRow.createCell(i2).setCellValue((String)value);
                            } else if (value instanceof Integer) {
                                thisRow.createCell(i2).setCellValue((double)((Integer)value).intValue());
                            }
                            thisRow.getCell(i2).setCellStyle((CellStyle)wrapStyle);
                        }
                        ++i2;
                    }
                    indexRow += 2;
                }
                i = 0;
                while (i < selectedColumns.size()) {
                    sheet.autoSizeColumn(i);
                    ++i;
                }
                ++num;
            }
            progressDialog.getMinorProgressBarListener(0).setProgressValue(totalNum);
            progressDialog.getMinorProgressBarListener(0).setProgressMessage("Done!");
            workbook.write((OutputStream)fos);
            fos.close();
            fos.getChannel().close();
            workbook.close();
            return true;
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            if (!ex.getMessage().contains("The process cannot access the file because it is being used by another process")) return exported;
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"The file is already in use. Please close it first and then try again");
            return exported;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return exported;
    }
}

