/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.util.analytical.misc.ComparatorModification;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monosaccharide
extends GlycoNode {
    private Anomer m_enumAnomer;
    private ArrayList<BaseType> m_aBaseType = new ArrayList();
    private Superclass m_enumSuperclass;
    public static final int UNKNOWN_RING = -1;
    public static final int OPEN_CHAIN = 0;
    private int m_iRingStart;
    private int m_iRingEnd;
    private ArrayList<Modification> m_aModifications = new ArrayList();

    private Monosaccharide() {
    }

    public Monosaccharide(Anomer a_enumAnomer, Superclass a_enumSuperclass) throws GlycoconjugateException {
        if (a_enumAnomer == null) {
            throw new GlycoconjugateException("Anomer can't be null");
        }
        this.m_enumAnomer = a_enumAnomer;
        if (a_enumSuperclass == null) {
            throw new GlycoconjugateException("Superclass can't be null");
        }
        this.m_enumSuperclass = a_enumSuperclass;
        this.m_iRingEnd = -1;
        this.m_iRingStart = -1;
        this.m_aModifications.clear();
        this.m_aBaseType.clear();
    }

    public void setAnomer(Anomer a_enumAnomer) throws GlycoconjugateException {
        if (a_enumAnomer == null) {
            throw new GlycoconjugateException("Anomer can't be null");
        }
        this.m_enumAnomer = a_enumAnomer;
    }

    public void setSuperclass(Superclass a_enumSuperclass) throws GlycoconjugateException {
        if (a_enumSuperclass == null) {
            throw new GlycoconjugateException("Superclass can't be null");
        }
        this.m_enumSuperclass = a_enumSuperclass;
    }

    public Superclass getSuperclass() {
        return this.m_enumSuperclass;
    }

    public Anomer getAnomer() {
        return this.m_enumAnomer;
    }

    public void setRing(int a_iStart, int a_iEnd) throws GlycoconjugateException {
        if ((a_iEnd == 0 || a_iStart == 0) && a_iEnd + a_iStart > 0) {
            throw new GlycoconjugateException("For open chain both ring positions must be 0.");
        }
        if (a_iStart > a_iEnd) {
            throw new GlycoconjugateException("Endpoint must be larger than startpoint");
        }
        if (a_iStart < -1) {
            throw new GlycoconjugateException("Startpoint must be equal or larger than -1");
        }
        this.m_iRingStart = a_iStart;
        if (a_iEnd < -1) {
            throw new GlycoconjugateException("Endpoint must be equal or larger than -1");
        }
        this.m_iRingEnd = a_iEnd;
    }

    public int getRingStart() {
        return this.m_iRingStart;
    }

    public int getRingEnd() {
        return this.m_iRingEnd;
    }

    @Override
    public void accept(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        a_objVisitor.visit(this);
    }

    public void setModification(ArrayList<Modification> a_aModi) throws GlycoconjugateException {
        if (a_aModi == null) {
            throw new GlycoconjugateException("null is not a valide set of modifications.");
        }
        this.m_aModifications.clear();
        Iterator<Modification> t_iterModi = a_aModi.iterator();
        while (t_iterModi.hasNext()) {
            this.addModification(t_iterModi.next());
        }
    }

    public ArrayList<Modification> getModification() {
        return this.m_aModifications;
    }

    public boolean addModification(Modification a_objModification) {
        if (a_objModification == null) {
            return false;
        }
        if (!this.m_aModifications.contains(a_objModification)) {
            return this.m_aModifications.add(a_objModification);
        }
        return false;
    }

    public boolean removeModification(Modification a_objModification) {
        return this.m_aModifications.remove(a_objModification);
    }

    public void setBaseType(ArrayList<BaseType> a_aBastType) throws GlycoconjugateException {
        if (a_aBastType == null) {
            throw new GlycoconjugateException("null is not a valide set of basetypes.");
        }
        this.m_aBaseType.clear();
        Iterator<BaseType> t_iterBase = a_aBastType.iterator();
        while (t_iterBase.hasNext()) {
            this.addBaseType(t_iterBase.next());
        }
        this.m_aBaseType = a_aBastType;
    }

    public ArrayList<BaseType> getBaseType() {
        return this.m_aBaseType;
    }

    public boolean addBaseType(BaseType a_objBaseType) throws GlycoconjugateException {
        if (a_objBaseType == null) {
            throw new GlycoconjugateException("Basetype can't be null");
        }
        return this.m_aBaseType.add(a_objBaseType);
    }

    public boolean removeBaseType(BaseType a_objBaseType) {
        return this.m_aBaseType.remove((Object)a_objBaseType);
    }

    public String getGlycoCTName() {
        String anomer = null;
        String name = null;
        String basetypes = "";
        String t_Modifications = "";
        String ringstart = null;
        String ringend = null;
        anomer = this.getAnomer().getSymbol();
        for (BaseType element : this.getBaseType()) {
            basetypes = basetypes + "-" + element.getName();
        }
        ringstart = this.getRingStart() == -1 ? "x" : String.valueOf(this.getRingStart());
        ringend = this.getRingEnd() == -1 ? "x" : String.valueOf(this.getRingEnd());
        ComparatorModification cf = new ComparatorModification();
        Collections.sort(this.m_aModifications, cf);
        for (Modification element : this.getModification()) {
            if (element.hasPositionTwo()) {
                t_Modifications = t_Modifications + "|" + element.getPositionOne() + "," + element.getPositionTwo() + ":" + element.getName();
                continue;
            }
            t_Modifications = t_Modifications + "|" + element.getPositionOne() + ":" + element.getName();
        }
        if (t_Modifications != "") {
            t_Modifications = t_Modifications.substring(1, t_Modifications.length());
        }
        name = anomer + basetypes + "-" + (Object)((Object)this.getSuperclass()) + "-" + ringstart + ":" + ringend;
        if (t_Modifications != "") {
            name = name + "|" + t_Modifications;
        }
        return name;
    }

    public boolean hasModification(Modification a_objModification) {
        return this.m_aModifications.contains(a_objModification);
    }

    public boolean hasModification(ModificationType a_objModiType, Integer positionOne) {
        for (Modification m : this.m_aModifications) {
            if (m.getName() != a_objModiType.getName() || m.getPositionOne() != positionOne.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasModification(ModificationType a_objModiType, Integer positionOne, Integer positionTwo) {
        for (Modification m : this.m_aModifications) {
            if (!m.getName().equals(a_objModiType.getName()) || m.getPositionOne() != positionOne.intValue() || m.getPositionTwo() != positionTwo) continue;
            return true;
        }
        return false;
    }

    @Override
    public Monosaccharide copy() throws GlycoconjugateException {
        Monosaccharide t_objMS = null;
        t_objMS = new Monosaccharide(this.m_enumAnomer, this.m_enumSuperclass);
        t_objMS.setRing(this.m_iRingStart, this.m_iRingEnd);
        Iterator<BaseType> t_iterBase = this.m_aBaseType.iterator();
        while (t_iterBase.hasNext()) {
            t_objMS.addBaseType(t_iterBase.next());
        }
        Iterator<Modification> t_iterModi = this.m_aModifications.iterator();
        while (t_iterModi.hasNext()) {
            t_objMS.addModification(t_iterModi.next().copy());
        }
        return t_objMS;
    }

    public void setRingStart(int a_iStart) throws GlycoconjugateException {
        if (a_iStart > this.m_iRingEnd) {
            throw new GlycoconjugateException("Endpoint must be larger than startpoint");
        }
        if (a_iStart < -1) {
            throw new GlycoconjugateException("Startpoint must be equal or larger than -1");
        }
        this.m_iRingStart = a_iStart;
    }

    public void setRingEnd(int a_iEnd) throws GlycoconjugateException {
        if (this.m_iRingStart > a_iEnd) {
            throw new GlycoconjugateException("Endpoint must be larger than startpoint");
        }
        if (a_iEnd < -1) {
            throw new GlycoconjugateException("Endpoint must be equal or larger than -1");
        }
        this.m_iRingEnd = a_iEnd;
    }

    public static Monosaccharide forGlycoCTName(String nameGlycoCT) throws GlycoconjugateException {
        Monosaccharide t_monosaccharide = new Monosaccharide();
        String[] t_aPartsModi = nameGlycoCT.split("\\|");
        String t_strMonosaccharide = t_aPartsModi[0];
        String[] t_aPartsMS = t_strMonosaccharide.split("\\-");
        if (t_aPartsMS.length < 3) {
            throw new GlycoconjugateException("Unknown monosaccharide format: " + t_strMonosaccharide);
        }
        try {
            t_monosaccharide.setAnomer(Anomer.forSymbol(t_aPartsMS[0].charAt(0)));
            int t_iPosition = 1;
            ArrayList<BaseType> t_aBasetypes = new ArrayList<BaseType>();
            while (t_aPartsMS[t_iPosition].length() == 4) {
                t_aBasetypes.add(BaseType.forName(t_aPartsMS[t_iPosition++]));
            }
            t_monosaccharide.setBaseType(t_aBasetypes);
            Superclass t_superclass = Superclass.forName(t_aPartsMS[t_iPosition++]);
            if (t_superclass == null) {
                throw new GlycoconjugateException("Unknown superclass name: " + t_strMonosaccharide);
            }
            t_monosaccharide.setSuperclass(t_superclass);
            String[] t_aPartsRing = t_aPartsMS[t_iPosition].split(":");
            if (t_aPartsRing.length != 2) {
                throw new GlycoconjugateException("Unknown ring size format: " + t_strMonosaccharide);
            }
            Integer t_iStart = null;
            Integer t_iEnd = null;
            t_iEnd = t_aPartsRing[1].equals("x") ? Integer.valueOf(-1) : Integer.valueOf(Integer.parseInt(t_aPartsRing[1]));
            t_iStart = t_aPartsRing[0].equals("x") ? Integer.valueOf(-1) : Integer.valueOf(Integer.parseInt(t_aPartsRing[0]));
            t_monosaccharide.setRing(t_iStart, t_iEnd);
            ArrayList<Modification> t_aModifications = new ArrayList<Modification>();
            for (int i = 1; i < t_aPartsModi.length; ++i) {
                t_aModifications.add(Monosaccharide.parseModification(t_aPartsModi[i]));
            }
            t_monosaccharide.setModification(t_aModifications);
        }
        catch (NumberFormatException e) {
            throw new GlycoconjugateException(t_strMonosaccharide + ":" + e.getMessage(), e);
        }
        return t_monosaccharide;
    }

    private static Modification parseModification(String a_strModi) throws GlycoconjugateException {
        String[] t_aParts = a_strModi.split(":");
        if (t_aParts.length != 2) {
            throw new GlycoconjugateException("Unknown modification format: " + a_strModi);
        }
        ModificationType t_objModi = ModificationType.forName(t_aParts[1]);
        String[] t_aPositions = t_aParts[0].split(",");
        int t_iPosition1 = 0;
        t_iPosition1 = t_aPositions[0].equals("x") ? 0 : Integer.parseInt(t_aPositions[0]);
        if (t_aPositions.length > 2) {
            throw new GlycoconjugateException("Unknown modification format: " + a_strModi);
        }
        if (t_aPositions.length == 2) {
            int t_iPosition2 = 0;
            t_iPosition2 = t_aPositions[1].equals("x") ? 0 : Integer.parseInt(t_aPositions[1]);
            return new Modification(t_objModi, t_iPosition1, (Integer)t_iPosition2);
        }
        return new Modification(t_objModi, t_iPosition1);
    }
}

