/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.analyzer;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;

public class SubstituentIUPACNotationAnalyzer
extends SubstituentUtility {
    private ArrayList<Substituent> substituents;

    public ArrayList<Substituent> getSubstituents() {
        return this.substituents;
    }

    public void start(Monosaccharide _mono, ArrayList<String> _substituents) throws GlycanException {
        this.init();
        this.makeSubstituent(_mono, _substituents);
    }

    public void start(String _substituent) throws GlycanException, GlyCoImporterException {
        this.init();
        ArrayList<String> temp = this.resolveSubstituents(_substituent, true);
        this.makeSubstituent(null, temp);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<String> resolveSubstituents(String _notations, boolean _isSubstituent) {
        notation = "";
        subs = new ArrayList<String>();
        mods = new ArrayList<String>();
        isLink = false;
        isNotation = false;
        i = 0;
        while (i < _notations.length()) {
            block10: {
                block9: {
                    unit = _notations.charAt(i);
                    if (this.isInteger(unit)) {
                        isLink = true;
                    }
                    if (this.isAlphabet(unit)) {
                        isNotation = true;
                    }
                    if (!(notation = String.valueOf(notation) + unit).contains("en") && !notation.equals("??")) break block9;
                    mods.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                    break block10;
                }
                if (i == _notations.length() - 1) {
                    subs.add(notation);
                    break;
                }
                if (!isLink || !isNotation || !this.isInteger(_notations.charAt(i + 1))) ** GOTO lbl-1000
                if (notation.split(",").length == 1) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                } else if (notation.split(",").length == this.toInteger(unit)) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                } else if (!isLink && isNotation && this.isInteger(_notations.charAt(i + 1))) {
                    subs.add(notation);
                    notation = "";
                    isNotation = false;
                    isLink = false;
                }
            }
            ++i;
        }
        return _isSubstituent != false ? subs : mods;
    }

    private void makeSubstituent(Monosaccharide _mono, ArrayList<String> _substituents) throws GlycanException {
        String regex = "([\\d?:/,(%)-]+(?![RSX]\\)))?([(a-zA-Z?\\-)]+)+(\\d)?([\\d?])?";
        for (String unit : _substituents) {
            Enum subT;
            int number;
            Matcher matSub = Pattern.compile(regex).matcher(unit);
            if (!matSub.find()) continue;
            String positions = matSub.group(1);
            String notation = matSub.group(2);
            int n = number = matSub.group(3) != null ? Integer.parseInt(matSub.group(3)) : 1;
            if (positions == null) {
                subT = BaseSubstituentTemplate.forIUPACNotation(this.makePlaneNotation(notation));
                BaseStereoIndex bsi = null;
                if (!_mono.getStereos().isEmpty()) {
                    bsi = BaseStereoIndex.forCode(_mono.getStereos().getFirst());
                    if (bsi != null && bsi.getSize() == 6) {
                        positions = "2";
                    }
                    if (bsi != null && bsi.getSize() != 6 && _mono.getSuperClass().equals((Object)SuperClass.HEX)) {
                        bsi = null;
                    }
                }
                if (bsi == null && _mono.getSuperClass().equals((Object)SuperClass.HEX)) {
                    positions = "2";
                }
                Linkage firstLink = this.makeLinkage(positions, "1", 1.0, 1.0);
                Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink);
                sub.setHeadAtom(this.makeHeadAtom(notation, this.makePlaneNotation(notation)));
                this.substituents.add(sub);
                continue;
            }
            String[] stringArray = positions.split(":");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] probs;
                String plane;
                String position = stringArray[n3];
                if (positions.indexOf(":") != -1 && position.contains(",") || position.contains(",") && number == 1) {
                    plane = this.makePlaneNotation(notation);
                    subT = BaseCrossLinkedTemplate.forIUPACNotation(plane);
                    String[] pos = position.split(",");
                    String[] firstPos = this.extractPos(pos[0]);
                    String[] secondPos = this.extractPos(pos[1]);
                    String[] firstProb = this.trimProbability(pos[0]);
                    String[] secondProb = this.trimProbability(pos[1]);
                    Linkage firstLink = this.makeLinkage(firstPos[0], firstPos[1], this.extractProbability(firstProb[0]), this.extractProbability(firstProb[1]));
                    Linkage secondLink = this.makeLinkage(secondPos[0], secondPos[1], this.extractProbability(secondProb[0]), this.extractProbability(secondProb[1]));
                    Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink, secondLink);
                    sub.setHeadAtom(this.makeHeadAtom(notation, plane));
                    this.substituents.add(sub);
                } else if (position.contains("/")) {
                    plane = this.makePlaneNotation(notation);
                    subT = BaseSubstituentTemplate.forIUPACNotation(plane);
                    probs = this.trimProbability(position);
                    Linkage firstLink = this.makeLinkage(this.extractPos(position)[0], "1", this.extractProbability(probs[0]), this.extractProbability(probs[1]));
                    Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink);
                    sub.setHeadAtom(this.makeHeadAtom(notation, plane));
                    this.substituents.add(sub);
                } else {
                    String[] stringArray2 = position.split(",");
                    int n4 = stringArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String multi = stringArray2[n5];
                        String plane2 = this.makePlaneNotation(notation);
                        subT = BaseSubstituentTemplate.forIUPACNotation(plane2);
                        probs = this.trimProbability(multi);
                        Linkage firstLink = this.makeLinkage(matSub.group(1).equals("?") ? "-1" : this.extractPos(multi)[0], "1", this.extractProbability(probs[0]), this.extractProbability(probs[1]));
                        Substituent sub = new Substituent((SubstituentInterface)((Object)subT), firstLink);
                        sub.setHeadAtom(this.makeHeadAtom(notation, plane2));
                        this.substituents.add(sub);
                        ++n5;
                    }
                }
                ++n3;
            }
        }
    }

    private String makePlaneNotation(String _notation) {
        if (_notation.equals("N")) {
            return _notation;
        }
        if (_notation.equals("Cl")) {
            return _notation;
        }
        if (_notation.startsWith("O") || _notation.startsWith("C")) {
            return _notation.substring(1, _notation.length());
        }
        if (_notation.startsWith("(")) {
            String bracket = _notation.substring(0, _notation.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            if ((_notation = _notation.replaceFirst(regex, "")).startsWith("C") && _notation.length() == 3 || !_notation.startsWith("C") && _notation.length() > 2) {
                _notation = _notation.substring(1, _notation.length());
            }
            return String.valueOf(bracket) + _notation;
        }
        return _notation;
    }

    private Linkage makeLinkage(String _parentPos, String _childPos, double _probabilityLow, double _probabilityHigh) throws GlycanException {
        Linkage ret = new Linkage();
        ret.setProbabilityLower(_probabilityLow == 1.0 ? 1.0 : (_probabilityLow == -1.0 ? -1.0 : _probabilityLow * 0.01));
        ret.setProbabilityUpper(_probabilityHigh == 1.0 ? 1.0 : (_probabilityHigh == -1.0 ? -1.0 : _probabilityHigh * 0.01));
        ret.addChildLinkage(Integer.parseInt(_childPos));
        String[] stringArray = _parentPos.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parentPos = stringArray[n2];
            ret.addParentLinkage(Integer.parseInt(parentPos.equals("?") ? "-1" : parentPos));
            ++n2;
        }
        return ret;
    }

    private double extractProbability(String _pribability) {
        double ret = 1.0;
        if (_pribability == null) {
            return ret;
        }
        ret = (_pribability = _pribability.replace("%", "")).equals("?") ? -1.0 : Double.parseDouble(_pribability.replace("%", ""));
        return ret;
    }

    private String[] trimProbability(String _linkagepos) {
        String[] ret = new String[]{"1.0D", "1.0D"};
        if (_linkagepos.indexOf("(") == -1) {
            return ret;
        }
        String probability = _linkagepos.substring(_linkagepos.indexOf("(") + 1, _linkagepos.indexOf(")"));
        String[] stringArray = probability.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (ret[0] != null) {
                ret[1] = unit.replace("%", "");
            }
            ret[0] = unit.replace("%", "");
            ++n2;
        }
        if (ret[1] == null) {
            ret[1] = ret[0];
        }
        return ret;
    }

    private String[] extractPos(String _position) {
        String[] ret = new String[2];
        if (_position == null) {
            return null;
        }
        if (_position.indexOf("(") != -1) {
            _position = _position.substring(0, _position.indexOf("("));
        }
        if (_position.indexOf("-") != -1) {
            ret = _position.split("-");
        } else {
            ret[0] = _position;
            ret[1] = "1";
        }
        return ret;
    }

    private String makeHeadAtom(String _notation, String _planeNotaiton) {
        String ret;
        if (_notation.equals("N") && _planeNotaiton.equals("N")) {
            return _planeNotaiton;
        }
        if (_notation.startsWith("(")) {
            String bracket = _notation.substring(0, _notation.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            _notation = _notation.replaceFirst(regex, "");
            _planeNotaiton = _planeNotaiton.replaceFirst(regex, "");
            ret = _notation.replaceFirst(_planeNotaiton, "");
        } else {
            ret = _notation.replaceFirst(_planeNotaiton, "");
        }
        return ret;
    }

    private boolean isInteger(char _int) {
        return String.valueOf(_int).matches("\\d|\\?");
    }

    private boolean isAlphabet(char _alphabet) {
        return String.valueOf(_alphabet).matches("[A-Za-z]");
    }

    private Integer toInteger(char _unit) {
        if (!String.valueOf(_unit).matches("\\d")) {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_unit));
    }

    private void init() {
        this.substituents = new ArrayList();
    }
}

