/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcherMSProfile;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.AnalyteStructure;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class GlycanStructureAnnotationMSProfile
extends GlycanStructureAnnotation {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotationMSProfile.class);
    protected HashMap<Integer, Scan> hmPeakIdToScan;
    protected int iPhonySubScanCounter;

    public GlycanStructureAnnotationMSProfile(Data data, String path, String archiveName, MSFile msFile) {
        super(data, path, archiveName, msFile);
    }

    public void init(int iFirstMS1Scan) {
        this.iPhonySubScanCounter = iFirstMS1Scan + 1;
        this.hmPeakIdToScan = new HashMap();
    }

    public void setPhonySubScanCounter(int iPhonySubScanCounter) {
        this.iPhonySubScanCounter = iPhonySubScanCounter;
    }

    public int getPhonySubScanCounter() {
        return this.iPhonySubScanCounter;
    }

    protected Scan getPhonySubScan(Peak parentPeak, Scan parentScan) {
        Scan subScan = null;
        try {
            if (!this.hmPeakIdToScan.containsKey(parentPeak.getId())) {
                int iSubScanNum = this.getPhonySubScanCounter();
                if (parentScan.getSubScans() != null && !parentScan.getSubScans().isEmpty()) {
                    iSubScanNum = (Integer)parentScan.getSubScans().get(parentScan.getSubScans().size() - 1) + 1;
                } else {
                    this.setPhonySubScanCounter(iSubScanNum + 1);
                }
                subScan = new Scan();
                subScan.setScanNo(Integer.valueOf(iSubScanNum));
                subScan.setPrecursor(parentPeak);
                subScan.setRetentionTime(parentScan.getRetentionTime());
                parentPeak.setIsPrecursor(true);
                subScan.setParentScan(parentScan.getScanNo());
                subScan.setMsLevel(Integer.valueOf(parentScan.getMsLevel() + 1));
                if (this.data.getScans().containsKey(iSubScanNum)) {
                    throw new Exception("Subscan already added (" + iSubScanNum + ")");
                }
                parentScan.getSubScans().add(iSubScanNum);
                this.data.getScans().put(iSubScanNum, subScan);
                this.hmPeakIdToScan.put(parentPeak.getId(), subScan);
            } else {
                subScan = this.hmPeakIdToScan.get(parentPeak.getId());
            }
            return subScan;
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting Phony SubScan.", (Throwable)ex);
            return null;
        }
    }

    @Override
    protected HashMap<Integer, Scan> getScans(MSFile msFile, int _iScanNumber, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        if (msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)msFile.getReader()).readMSFile(msFile, _iScanNumber);
            return GelatoUtils.listToHashMap(scans, dFragCutoff, sFragCutoffType, dPreCutoff, sPreCutoffType);
        }
        return null;
    }

    @Override
    protected boolean processScan(Method _method, int iInx) {
        int iCurScanNum = (Integer)this.scansToProcess.get(iInx);
        this.init(iCurScanNum);
        return super.processScan(_method, iInx);
    }

    @Override
    public List<Integer> determineScanBounds() {
        if (this.msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)this.msFile.getReader()).getScanList(this.msFile, -1);
            if (scans == null || scans.isEmpty()) {
                return null;
            }
            ArrayList<Integer> firstScan = new ArrayList<Integer>();
            firstScan.add((Integer)scans.get(0));
            return firstScan;
        }
        return null;
    }

    protected void setMatchedPeakList() {
        Scan curScan = (Scan)this.data.getScans().get(this.iCurScanNum);
        ArrayList<Peak> newPeakList = new ArrayList<Peak>();
        for (int i = 0; i < curScan.getPeaklist().size(); ++i) {
            if (this.isCanceled()) {
                return;
            }
            Peak peak = (Peak)curScan.getPeaklist().get(i);
            if (!peak.getIsPrecursor()) continue;
            newPeakList.add(peak);
        }
        curScan.setPeaklist(newPeakList);
    }

    @Override
    protected boolean writeScanFeaturesToArchive() {
        this.setMatchedPeakList();
        return super.writeScanFeaturesToArchive();
    }

    @Override
    protected boolean processAnalyteSetting(AnalyteSettings _analyteSettings, List<AnalyteStructure> _structures) {
        try {
            boolean bRes = this.processStructures(_analyteSettings, _structures);
            if (this.isCanceled()) {
                return false;
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getFinalArchiveName() {
        return this.m_finalArchive;
    }

    @Override
    public boolean needsOverview() {
        return false;
    }

    @Override
    public String getOverviewFileName() {
        return null;
    }

    @Override
    protected AnalyteMatcher getNewAnalyteMatcher(int iCurScan) {
        return new GlycanMatcherMSProfile(iCurScan, this);
    }

    @Override
    protected void cleanAfterCancel() {
        try {
            File file = new File(this.getFinalArchiveName());
            file.delete();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setArchiveFilePaths() {
        this.m_finalArchive = AnnotationWriter.getArchiveFilePath((String)this.m_preArchive);
    }
}

