/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.structure.AnalyteStructure;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyteCache;
import org.grits.toolbox.ms.annotation.sugar.GlycanExtraInfo;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public abstract class AnalyteStructureAnnotation
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(AnalyteStructureAnnotation.class);
    protected List<INotifyingProcess> notifyingProcesses = new ArrayList<INotifyingProcess>();
    protected DataHeader dataHeader = null;
    protected List<List<AnalyteStructure>> structures = null;
    protected Data data;
    public static final CustomExtraData countingScoreData = new CustomExtraData("counting_score", "Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.00");
    public static final CustomExtraData intensityScoreData = new CustomExtraData("intensity_score", "Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.00");
    public static final CustomExtraData rawCountingScoreData = new CustomExtraData("raw_counting_score", "Raw Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.0000");
    public static final CustomExtraData rawIntensityScoreData = new CustomExtraData("raw_intensity_score", "Raw Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.0000");
    protected String m_tempFilePath = null;
    protected String m_preArchive = null;
    protected String m_finalArchive = null;
    protected List<Integer> scansToProcess;
    protected int iTotalSize;
    protected MSFile msFile;
    public static int iAnnotationIDCount;
    protected int iCurProgressValue;
    protected String sCurProgressMsg = null;
    protected int iCurScanNum;
    protected List<List<IonSettings>> lPosModeSettingsToAnalyze = null;
    protected List<List<Integer>> lPosModeSettingsToAnalyzeCounts = null;
    protected List<List<IonSettings>> lNegModeSettingsToAnalyze = null;
    protected List<List<Integer>> lNegModeSettingsToAnalyzeCounts = null;
    protected List<List<IonSettings>> lExchangesoAnalyze = null;
    protected List<List<Integer>> lExchangesToAnalyzeCounts = null;
    protected List<List<MoleculeSettings>> lNeutralLossesToAnalyze = null;
    protected List<List<Integer>> lNeutralLossesToAnalyzeCounts = null;
    protected List<IProgressListener> myProgressListeners = null;
    protected List<IProgressListener> matcherProgressListeners = null;
    protected boolean bCancel = false;

    protected abstract HashMap<Integer, Scan> getScans(MSFile var1, int var2, double var3, String var5, double var6, String var8);

    public abstract List<Integer> determineScanBounds();

    public abstract String getFinalArchiveName();

    public abstract boolean needsOverview();

    public abstract String getOverviewFileName();

    protected abstract AnalyteMatcher getNewAnalyteMatcher(int var1);

    protected abstract void cleanAfterCancel();

    protected abstract void setArchiveFilePaths();

    public AnalyteStructureAnnotation() {
    }

    public AnalyteStructureAnnotation(Data data, String path, String archiveName, MSFile msFile) {
        this.data = data;
        this.dataHeader = data.getDataHeader();
        this.m_tempFilePath = path;
        this.m_preArchive = archiveName;
        this.addFeatureCustomExtraData();
        this.addAnnotationCustomExtraData();
        this.iTotalSize = -1;
        iAnnotationIDCount = 1;
        this.msFile = msFile;
    }

    protected abstract List<AnalyteStructure> loadAnalyteSettingsFromDB(AnalyteSettings var1);

    protected abstract Annotation getNewAnnotationObject();

    protected abstract boolean passesFilters(AnalyteStructure var1, AnalyteSettings var2);

    protected abstract boolean processStructure(AnalyteSettings var1, GelatoAnalyte var2);

    protected abstract ScansAnnotation readScansAnnotation(AnnotationReader var1, String var2, String var3);

    protected abstract GelatoAnalyte getNewGelatoAnalyteObject(AnalyteStructure var1);

    protected Data getData() {
        return this.data;
    }

    public static int getNumListenersNeeded() {
        return 1;
    }

    public void setMatcherProgressListener(List<IProgressListener> matcherProgressListeners) {
        this.matcherProgressListeners = matcherProgressListeners;
    }

    public List<IProgressListener> getMatcherProgressListener() {
        return this.matcherProgressListeners;
    }

    public int getTotal() {
        return this.iTotalSize;
    }

    protected void addAnnotation(GlycanAnnotation annotation) {
        this.data.getAnnotation().add(annotation);
    }

    public List<INotifyingProcess> getNotifyingProcesses() {
        return this.notifyingProcesses;
    }

    public void initialize() {
        this.setProgressType(IProgressListener.ProgressType.Indeterminant);
        this.scansToProcess = this.determineScanBounds();
        this.setArchiveFilePaths();
        this.iTotalSize = 0;
        int iNumScans = this.scansToProcess.size();
        this.initializeStructures();
        for (int i = 0; i < this.structures.size(); ++i) {
            List<AnalyteStructure> settingStructures = this.structures.get(i);
            this.iTotalSize += iNumScans * settingStructures.size();
        }
        this.setProgressType(IProgressListener.ProgressType.Determinant);
    }

    public int processScans() {
        try {
            boolean bRes = true;
            this.setMaxValue(this.getTotal());
            this.iCurProgressValue = 0;
            this.updateListeners("Processing", 0);
            Method method = this.getData().getDataHeader().getMethod();
            for (int iInx = 0; iInx < this.scansToProcess.size(); ++iInx) {
                this.sCurProgressMsg = "Scan # " + this.scansToProcess.get(iInx);
                if (this.isCanceled()) {
                    return GRITSProcessStatus.CANCEL;
                }
                bRes = this.processScan(method, iInx);
            }
            this.updateListeners("Done!", this.getTotal());
            if (!bRes) {
                if (this.isCanceled()) {
                    return GRITSProcessStatus.CANCEL;
                }
                return GRITSProcessStatus.ERROR;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processScans", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected boolean processScan(Method method, int iInx) {
        if (this.isCanceled()) {
            return false;
        }
        Double dCutoffVal = method.getIntensityCutoff();
        String sCutoffType = method.getIntensityCutoffType();
        Double dPrecursorCutoffVal = method.getPrecursorIntensityCutoff();
        String sPrecursoCutoffType = method.getPrecursorIntensityCutoffType();
        this.iCurScanNum = this.scansToProcess.get(iInx);
        this.data.getScanFeatures().clear();
        this.data.getScans().clear();
        this.data.getAnnotation().clear();
        this.data.getAnnotatedScan().clear();
        logger.debug((Object)("Processing scan #: " + this.iCurScanNum));
        this.data.setScans(this.getScans(this.msFile, this.iCurScanNum, dCutoffVal, sCutoffType, dPrecursorCutoffVal, sPrecursoCutoffType));
        return this.processAnalyteSettings();
    }

    protected boolean processAnalyteSettings() {
        try {
            String prevProgMsg = this.sCurProgressMsg;
            Method method = this.getData().getDataHeader().getMethod();
            boolean bRes = false;
            for (int analyteSettingsInx = 0; analyteSettingsInx < method.getAnalyteSettings().size(); ++analyteSettingsInx) {
                if (this.isCanceled()) {
                    return false;
                }
                AnalyteSettings analyteSettings = (AnalyteSettings)method.getAnalyteSettings().get(analyteSettingsInx);
                List<AnalyteStructure> analyteStructures = this.structures.get(analyteSettingsInx);
                this.initializeAdductsAndExchanges(analyteSettings);
                this.sCurProgressMsg = prevProgMsg + ", analyte settings " + (analyteSettingsInx + 1) + " of " + method.getAnalyteSettings().size();
                bRes |= this.processAnalyteSetting(analyteSettings, analyteStructures);
            }
            if (bRes) {
                return this.writeScanFeaturesToArchive();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
        }
        return false;
    }

    protected boolean writeScanFeaturesToArchive() {
        try {
            ++iAnnotationIDCount;
            this.populateScanFeatureData(this.m_tempFilePath);
            AnnotationWriter writer = new AnnotationWriter();
            writer.generateScansAnnotationFiles(this.m_tempFilePath, this.data, this.getFinalArchiveName(), !this.needsOverview(), !this.needsOverview(), true, true);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    protected void initializeAdductsAndExchanges(AnalyteSettings _analayteSettings) {
        Method method = this.getData().getDataHeader().getMethod();
        this.lPosModeSettingsToAnalyze = new ArrayList<List<IonSettings>>();
        this.lPosModeSettingsToAnalyzeCounts = new ArrayList<List<Integer>>();
        GelatoUtils.determineIonSettingSets(true, method.getIons(), method.getMaxIonCount(), this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts);
        this.lNegModeSettingsToAnalyze = new ArrayList<List<IonSettings>>();
        this.lNegModeSettingsToAnalyzeCounts = new ArrayList<List<Integer>>();
        GelatoUtils.determineIonSettingSets(false, method.getIons(), method.getMaxIonCount(), this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts);
        this.lExchangesoAnalyze = new ArrayList<List<IonSettings>>();
        this.lExchangesToAnalyzeCounts = new ArrayList<List<Integer>>();
        GelatoUtils.determineIonSettingSets(null, method.getIonExchanges(), method.getMaxIonCount(), this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts);
        this.lNeutralLossesToAnalyze = new ArrayList<List<MoleculeSettings>>();
        this.lNeutralLossesToAnalyzeCounts = new ArrayList<List<Integer>>();
        GelatoUtils.determineIonSettingSets(null, method.getNeutralLoss(), -1, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts);
    }

    protected boolean processAnalyteSetting(AnalyteSettings _analyteSettings, List<AnalyteStructure> _structures) {
        try {
            boolean bRes = this.processStructures(_analyteSettings, _structures);
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    protected boolean processStructures(AnalyteSettings _analyteSettings, List<AnalyteStructure> structures) {
        try {
            String prevProgMsg = this.sCurProgressMsg;
            boolean bRes = false;
            for (AnalyteStructure structure : structures) {
                if (this.isCanceled()) {
                    return false;
                }
                this.sCurProgressMsg = prevProgMsg + ", structure: " + structure.getId();
                GelatoAnalyte gelatoAnalyte = GelatoAnalyteCache.hmGelatoAnalytesByStructureId.get(structure.getId());
                if (gelatoAnalyte == null || gelatoAnalyte.getAnalyteStructure() == null) {
                    throw new Exception("Unable to location analyte structure with id: " + structure.getId());
                }
                bRes |= this.processStructure(_analyteSettings, gelatoAnalyte);
                this.updateListeners(this.sCurProgressMsg, ++this.iCurProgressValue);
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processStructure", (Throwable)e);
            return false;
        }
    }

    protected Annotation getNewAnnotation(String sAnnotId, String sSequence, String sSeqFormat) {
        Annotation annotation = this.getNewAnnotationObject();
        annotation.setStringId(sAnnotId);
        annotation.setSequence(sSequence);
        annotation.setSequenceFormat(sSeqFormat);
        return annotation;
    }

    protected boolean processAllStructureOptions(List<List<IonSettings>> lPosModeSettingsToAnalyze, List<List<Integer>> lPosModeSettingsToAnalyzeCounts, List<List<IonSettings>> lNegModeSettingsToAnalyze, List<List<Integer>> lNegModeSettingsToAnalyzeCounts, List<List<IonSettings>> lExchangesToAnalyze, List<List<Integer>> lExchangesToAnalyzeCounts, List<List<MoleculeSettings>> lNeutralLossesToAnalyze, List<List<Integer>> lNeutralLossesToAnalyzeCounts, ScansAnnotation scansAnnotation, AnalyteSettings analyteSettings, GelatoAnalyte gelatoAnalyte, Annotation annotation) {
        try {
            AnalyteMatcher analyteMatcher = this.getNewAnalyteMatcher(this.iCurScanNum);
            this.getNotifyingProcesses().add(analyteMatcher);
            int iCnt = 0;
            boolean bRes = false;
            for (int polCnt = 0; polCnt < 2; ++polCnt) {
                List<List<Integer>> lSettingsToAnalyzeCounts;
                if (this.isCanceled()) {
                    return false;
                }
                boolean bPolarity = polCnt == 0;
                List<List<IonSettings>> lSettingsToAnalyze = bPolarity ? lPosModeSettingsToAnalyze : lNegModeSettingsToAnalyze;
                List<List<Integer>> list = lSettingsToAnalyzeCounts = bPolarity ? lPosModeSettingsToAnalyzeCounts : lNegModeSettingsToAnalyzeCounts;
                if (lSettingsToAnalyze == null || lSettingsToAnalyze.isEmpty()) continue;
                int iNumAdducts = lSettingsToAnalyze.size();
                int iNumExchanges = lExchangesToAnalyze != null ? lExchangesToAnalyze.size() : 0;
                int iNumLosses = lNeutralLossesToAnalyze != null ? lNeutralLossesToAnalyze.size() : 0;
                for (int i = 0; i < iNumAdducts; ++i) {
                    for (int j = -1; j < iNumExchanges; ++j) {
                        for (int k = -1; k < iNumLosses; ++k) {
                            List<IonSettings> lAdducts = null;
                            List<Integer> lAdductCounts = null;
                            if (lSettingsToAnalyze == null || lSettingsToAnalyze.isEmpty() || lSettingsToAnalyzeCounts == null || lSettingsToAnalyzeCounts.isEmpty()) continue;
                            lAdducts = lSettingsToAnalyze.get(i);
                            lAdductCounts = lSettingsToAnalyzeCounts.get(i);
                            if (lAdducts == null || lAdducts.isEmpty() || lAdductCounts == null || lAdductCounts.isEmpty()) continue;
                            List<IonSettings> lExchanges = null;
                            List<Integer> lExchangeCounts = null;
                            if (j > -1) {
                                lExchanges = lExchangesToAnalyze.get(j);
                                lExchangeCounts = lExchangesToAnalyzeCounts.get(j);
                            }
                            List<MoleculeSettings> lNeutralLosses = null;
                            List<Integer> lNeutralLossCounts = null;
                            if (k > -1) {
                                lNeutralLosses = lNeutralLossesToAnalyze.get(k);
                                lNeutralLossCounts = lNeutralLossesToAnalyzeCounts.get(k);
                            }
                            bRes |= analyteMatcher.matchAnalyteStructure(bPolarity, this.data, this.iCurScanNum, scansAnnotation, gelatoAnalyte, null, annotation, null, lAdducts, lAdductCounts, lExchanges, lExchangeCounts, lNeutralLosses, lNeutralLossCounts, analyteSettings, this.m_tempFilePath);
                            ++iCnt;
                        }
                    }
                }
            }
            logger.debug((Object)("Number of options for structure: " + iCnt));
            this.getNotifyingProcesses().remove(analyteMatcher);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAdducts", (Throwable)e);
            return false;
        }
    }

    protected void populateScanFeatureData(String tempFilePath) {
        AnnotationReader reader = new AnnotationReader();
        ScansAnnotation scansAnnotation = new ScansAnnotation();
        ScanFeatures scanFeatures = null;
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (Integer scanId : this.data.getAnnotatedScan().keySet()) {
            if (this.isCanceled()) {
                return;
            }
            for (String analyteId : (List)this.data.getAnnotatedScan().get(scanId)) {
                if (seen.containsKey(analyteId)) continue;
                scansAnnotation = this.readScansAnnotation(reader, tempFilePath, analyteId);
                if (scansAnnotation != null) {
                    for (Integer scanId2 : scansAnnotation.getScanAnnotations().keySet()) {
                        if (this.isCanceled()) {
                            return;
                        }
                        if (this.data.getScanFeatures().containsKey(scanId2)) {
                            scanFeatures = (ScanFeatures)this.data.getScanFeatures().get(scanId2);
                        } else {
                            scanFeatures = new ScanFeatures();
                            scanFeatures.setScanId(scanId2.intValue());
                            scanFeatures.setUsesComplexRowId(Boolean.valueOf(true));
                            scanFeatures.setScanPeaks(new HashSet(((Scan)this.data.getScans().get(scanId2)).getPeaklist()));
                            this.data.getScanFeatures().put(scanId2, scanFeatures);
                        }
                        if (scansAnnotation.getScanAnnotations().get(scanId2) == null) continue;
                        List lF = (List)scansAnnotation.getScanAnnotations().get(scanId2);
                        for (Feature f : (List)scansAnnotation.getScanAnnotations().get(scanId2)) {
                            if (scanFeatures.getFeatures().contains(f)) continue;
                            scanFeatures.getFeatures().add(f);
                        }
                    }
                }
                seen.put(analyteId, 1);
            }
        }
    }

    protected void addFeatureCustomExtraData() {
        this.dataHeader.getFeatureCustomExtraData().add(countingScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(intensityScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(rawCountingScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(rawIntensityScoreData);
    }

    protected void addAnnotationCustomExtraData() {
        List<CustomExtraData> lCED = GlycanExtraInfo.getColumns();
        for (CustomExtraData ced : lCED) {
            this.dataHeader.getAnnotationCustomExtraData().add(ced);
        }
    }

    protected String correctSequence(String _sStructureSequence) {
        return _sStructureSequence;
    }

    protected void initializeStructures() {
        List<AnalyteStructure> settingStructures1;
        int i;
        Method method = this.getData().getDataHeader().getMethod();
        this.structures = new ArrayList<List<AnalyteStructure>>();
        for (AnalyteSettings settings : method.getAnalyteSettings()) {
            List<AnalyteStructure> settingStructures = this.loadAnalyteSettingsFromDB(settings);
            if (this.structures == null) continue;
            this.structures.add(settingStructures);
        }
        for (i = 0; i < method.getAnalyteSettings().size(); ++i) {
            settingStructures1 = this.structures.get(i);
            HashMap<String, Boolean> mMatched = new HashMap<String, Boolean>();
            for (int iStruc1 = 0; iStruc1 < settingStructures1.size(); ++iStruc1) {
                AnalyteStructure struc1 = settingStructures1.get(iStruc1);
                if (mMatched.containsKey(struc1.getId())) continue;
                int iMatchCnt = 0;
                for (int iStruc2 = iStruc1 + 1; iStruc2 < settingStructures1.size(); ++iStruc2) {
                    AnalyteStructure struc2 = settingStructures1.get(iStruc2);
                    if (!struc1.getId().equals(struc2.getId())) continue;
                    String sNewId = struc2.getId() + "." + (++iMatchCnt + 1);
                    struc2.setId(sNewId);
                    mMatched.put(sNewId, Boolean.TRUE);
                }
                if (iMatchCnt <= 0) continue;
                logger.warn((Object)("Duplicate id in database: " + struc1.getId()));
                String sNewId = struc1.getId() + ".1";
                struc1.setId(sNewId);
                mMatched.put(sNewId, Boolean.TRUE);
            }
        }
        for (i = 0; i < method.getAnalyteSettings().size(); ++i) {
            settingStructures1 = this.structures.get(i);
            for (AnalyteStructure struc1 : settingStructures1) {
                block6: for (int j = i + 1; j < method.getAnalyteSettings().size(); ++j) {
                    List<AnalyteStructure> settingStructures2 = this.structures.get(j);
                    for (AnalyteStructure struc2 : settingStructures2) {
                        if (!struc1.getId().equals(struc2.getId())) continue;
                        if (!struc1.getId().startsWith("(DB")) {
                            struc1.setId("(DB" + (i + 1) + ") " + struc1.getId());
                        }
                        if (struc2.getId().startsWith("(DB")) continue block6;
                        struc2.setId("(DB" + (j + 1) + ") " + struc2.getId());
                        continue block6;
                    }
                }
            }
        }
    }

    public void populateGelatoAnalyteObjects() {
        int iProgress = 0;
        int iTotalStructures = 0;
        for (List<AnalyteStructure> lStructures : this.structures) {
            iTotalStructures += lStructures.size();
        }
        this.setMaxValue(iTotalStructures);
        for (List<AnalyteStructure> lStructures : this.structures) {
            for (AnalyteStructure structure : lStructures) {
                try {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.updateListeners("Structure: " + structure.getId(), iProgress++);
                    GelatoAnalyte gelatoGlycan = this.getNewGelatoAnalyteObject(structure);
                    if (gelatoGlycan == null) continue;
                    GelatoAnalyteCache.hmGelatoAnalytesByStructureId.put(structure.getId(), gelatoGlycan);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        this.updateListeners("Done!", this.structures.size());
    }

    public void applyFilters() {
        ArrayList<List<AnalyteStructure>> filteredStructures = new ArrayList<List<AnalyteStructure>>();
        int iProgress = 0;
        int iTotalStructures = 0;
        for (List<AnalyteStructure> lStructures : this.structures) {
            iTotalStructures += lStructures.size();
        }
        this.setMaxValue(iTotalStructures);
        Method method = this.getData().getDataHeader().getMethod();
        int i = 0;
        for (AnalyteSettings settings : method.getAnalyteSettings()) {
            if (settings.getGlycanSettings().getFilterSetting() != null) {
                ArrayList<AnalyteStructure> filtered = new ArrayList<AnalyteStructure>();
                for (AnalyteStructure structure : this.structures.get(i)) {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.updateListeners("Structure: " + structure.getId(), iProgress++);
                    if (!this.passesFilters(structure, settings)) continue;
                    filtered.add(structure);
                }
                filteredStructures.add(filtered);
            } else {
                filteredStructures.add(this.structures.get(i));
            }
            ++i;
        }
        this.updateListeners("Done!", this.structures.size());
        this.structures = filteredStructures;
    }

    public MSFile getMsFile() {
        return this.msFile;
    }

    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
        if (bCancel) {
            for (INotifyingProcess process : this.getNotifyingProcesses()) {
                process.setCanceled(true);
            }
        }
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.myProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.myProgressListeners;
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.myProgressListeners = lProgressListeners;
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }
}

