/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.process.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Ion;
import org.grits.toolbox.ms.om.data.IonAdduct;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Scan;

public class MSAnnotationTableDataProcessorUtil {
    private static final Logger logger = Logger.getLogger(MSAnnotationTableDataProcessorUtil.class);

    public static int fillMassSpecColumnSettingsScan(TableViewerColumnSettings _columnSettings, int _iMSLevel) {
        _columnSettings.addColumn(DMScan.scan_numannotatedpeaks.getLabel(), DMScan.scan_numannotatedpeaks.name());
        return 1;
    }

    public static void fillMassSpecScanData(Scan a_scan, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMScan.scan_numannotatedpeaks.name()), (Object)(a_scan.getNumAnnotatedPeaks() != null ? a_scan.getNumAnnotatedPeaks() : -1), _tableRow);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static int fillColumnSettingsCustomExtraData(TableViewerColumnSettings _columnSettings, List<CustomExtraData> _lCustomExtraData) {
        int iNumColumns = 0;
        try {
            if (_lCustomExtraData != null && !_lCustomExtraData.isEmpty()) {
                for (CustomExtraData ced : _lCustomExtraData) {
                    if (ced.getKey().equals("gg.gch")) continue;
                    _columnSettings.addColumn(ced.getLabel(), ced.getKey());
                    ++iNumColumns;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return iNumColumns;
    }

    public static int fillColumnSettingsCustomExtraData(TableViewerColumnSettings _columnSettings, List<CustomExtraData> _lCustomExtraData, HashMap<String, Integer> htKeyToPos) {
        int iNumColumns = 0;
        try {
            if (_lCustomExtraData != null && !_lCustomExtraData.isEmpty()) {
                for (CustomExtraData ced : _lCustomExtraData) {
                    if (ced.getKey().equals("gg.gch")) continue;
                    if (htKeyToPos != null && htKeyToPos.containsKey(ced.getKey())) {
                        _columnSettings.putColumn(ced.getLabel(), ced.getKey(), htKeyToPos.get(ced.getKey()).intValue());
                        htKeyToPos.remove(ced.getKey());
                        ++iNumColumns;
                        continue;
                    }
                    _columnSettings.addColumn(ced.getLabel(), ced.getKey());
                    ++iNumColumns;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return iNumColumns;
    }

    public static void fillMSAnnotationCustomExtraData(Annotation a_annotation, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, List<CustomExtraData> _lCustomExtraData) {
        try {
            if (a_annotation != null && _lCustomExtraData != null && !_lCustomExtraData.isEmpty()) {
                for (CustomExtraData ced : _lCustomExtraData) {
                    if (ced.getKey().equals("gg.gch")) continue;
                    MSAnnotationTableDataProcessorUtil.fillAnnotationCustomExtraData(a_annotation, ced, _tableRow, _columnSettings);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void fillAnnotationCustomExtraData(Annotation a_annotation, CustomExtraData _cnd, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            switch (_cnd.getType()) {
                case Double: {
                    if (a_annotation.getDoubleProp() != null && a_annotation.getDoubleProp().containsKey(_cnd.getKey()) && a_annotation.getDoubleProp().get(_cnd.getKey()) != null) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)new Double(_cnd.getDoubleFormat().format(a_annotation.getDoubleProp().get(_cnd.getKey()))), _tableRow);
                    }
                    break;
                }
                case Integer: {
                    if (a_annotation.getIntegerProp() != null && a_annotation.getIntegerProp().containsKey(_cnd.getKey()) && a_annotation.getIntegerProp().get(_cnd.getKey()) != null) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), a_annotation.getIntegerProp().get(_cnd.getKey()), _tableRow);
                    }
                    break;
                }
                case Boolean: {
                    if (a_annotation.getBooleanProp() != null && a_annotation.getBooleanProp().containsKey(_cnd.getKey()) && a_annotation.getBooleanProp().get(_cnd.getKey()) != null) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)((Boolean)a_annotation.getBooleanProp().get(_cnd.getKey()) != false ? "Yes" : "No"), _tableRow);
                        break;
                    }
                    MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)"No", _tableRow);
                    break;
                }
                case String: {
                    if (a_annotation.getStringProp() == null || !a_annotation.getStringProp().containsKey(_cnd.getKey()) || a_annotation.getStringProp().get(_cnd.getKey()) == null) break;
                    MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), a_annotation.getStringProp().get(_cnd.getKey()), _tableRow);
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void fillMSFeatureCustomExtraData(Feature a_feature, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings, List<CustomExtraData> _lCustomExtraData) {
        try {
            if (a_feature != null && _lCustomExtraData != null && !_lCustomExtraData.isEmpty()) {
                for (CustomExtraData ced : _lCustomExtraData) {
                    if (ced.getKey().equals("gg.gch")) continue;
                    MSAnnotationTableDataProcessorUtil.fillFeatureCustomExtraData(a_feature, ced, _tableRow, _columnSettings);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void fillFeatureCustomExtraData(Feature a_feature, CustomExtraData _cnd, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            switch (_cnd.getType()) {
                case Double: {
                    if (a_feature.getDoubleProp() != null && a_feature.getDoubleProp().containsKey(_cnd.getKey())) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)new Double(_cnd.getDoubleFormat().format(a_feature.getDoubleProp().get(_cnd.getKey()))), _tableRow);
                    }
                    break;
                }
                case Integer: {
                    if (a_feature.getIntegerProp() != null && a_feature.getIntegerProp().containsKey(_cnd.getKey())) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), a_feature.getIntegerProp().get(_cnd.getKey()), _tableRow);
                    }
                    break;
                }
                case Boolean: {
                    if (a_feature.getBooleanProp() != null && a_feature.getBooleanProp().containsKey(_cnd.getKey())) {
                        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)((Boolean)a_feature.getBooleanProp().get(_cnd.getKey()) != false ? "Yes" : "No"), _tableRow);
                        break;
                    }
                    MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), (Object)"No", _tableRow);
                    break;
                }
                case String: {
                    if (a_feature.getStringProp() == null || !a_feature.getStringProp().containsKey(_cnd.getKey())) break;
                    MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(_cnd.getKey()), a_feature.getStringProp().get(_cnd.getKey()), _tableRow);
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static int fillMSAnnotationColumnSettingsFeature(TableViewerColumnSettings _columnSettings) {
        try {
            _columnSettings.addColumn(DMFeature.feature_id.getLabel(), DMFeature.feature_id.name());
            _columnSettings.addColumn(DMFeature.feature_sequence.getLabel(), DMFeature.feature_sequence.name());
            _columnSettings.addColumn(DMFeature.feature_mz.getLabel(), DMFeature.feature_mz.name());
            _columnSettings.addColumn(DMFeature.feature_deviation.getLabel(), DMFeature.feature_deviation.name());
            _columnSettings.addColumn(DMFeature.feature_charge.getLabel(), DMFeature.feature_charge.name());
            _columnSettings.addColumn(DMFeature.feature_precursor_id.getLabel(), DMFeature.feature_precursor_id.name());
            _columnSettings.addColumn(DMFeature.feature_ions.getLabel(), DMFeature.feature_ions.name());
            _columnSettings.addColumn(DMFeature.feature_fragmentType.getLabel(), DMFeature.feature_fragmentType.name());
            _columnSettings.addColumn(DMFeature.feature_neutralLosses.getLabel(), DMFeature.feature_neutralLosses.name());
            _columnSettings.addColumn(DMFeature.feature_exchanges.getLabel(), DMFeature.feature_exchanges.name());
            return 11;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    private static String getListFillString(List<?> _lObjects) {
        block11: {
            if (_lObjects != null && !_lObjects.isEmpty()) break block11;
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (Object obj : _lObjects) {
                int iCnt;
                if (obj instanceof Ion) {
                    Ion ion = (Ion)obj;
                    iCnt = 1;
                    if (obj instanceof IonAdduct) {
                        IonAdduct ionAdduct = (IonAdduct)obj;
                        iCnt = ionAdduct.getCount();
                    }
                    if (ion.getMass() < 0.0) {
                        sb.append("-");
                    }
                    if (iCnt > 0) {
                        sb.append(Integer.toString(iCnt));
                    }
                    sb.append(ion.getLabel());
                    continue;
                }
                if (!(obj instanceof MoleculeSettings)) continue;
                if (!sb.toString().equals("")) {
                    sb.append(", ");
                }
                MoleculeSettings molSettings = (MoleculeSettings)obj;
                iCnt = molSettings.getCount();
                if (obj instanceof IonSettings) {
                    IonSettings cfr_ignored_0 = (IonSettings)obj;
                }
                if (iCnt > 0) {
                    sb.append(Integer.toString(iCnt));
                    sb.append("x");
                }
                sb.append(molSettings.getLabel());
            }
            return sb.toString();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static void fillFeatureData(Feature a_feature, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            if (a_feature != null) {
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_id.name()), (Object)a_feature.getId(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_sequence.name()), (Object)a_feature.getSequence(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_mz.name()), (Object)new Double(MassSpecTableDataProcessorUtil.formatDec4.format(a_feature.getMz())), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_deviation.name()), (Object)new Double(MassSpecTableDataProcessorUtil.formatDec4.format(a_feature.getDeviation())), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_charge.name()), (Object)a_feature.getCharge(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_precursor_id.name()), (Object)a_feature.getPrecursor(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_ions.name()), (Object)MSAnnotationTableDataProcessorUtil.getListFillString(a_feature.getIons()), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_fragmentType.name()), (Object)a_feature.getFragmentType(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_neutralLosses.name()), (Object)MSAnnotationTableDataProcessorUtil.getListFillString(a_feature.getNeutralLoss()), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMFeature.feature_exchanges.name()), (Object)MSAnnotationTableDataProcessorUtil.getListFillString(a_feature.getNeutralexchange()), _tableRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void updateFeatureData(Feature a_feature, ArrayList _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            if (a_feature != null) {
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_id.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_id.name())).equals(a_feature.getId())) {
                    a_feature.setId((String)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_id.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_sequence.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_sequence.name())).equals(a_feature.getSequence())) {
                    a_feature.setSequence((String)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_sequence.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_mz.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_mz.name())).equals(a_feature.getMz())) {
                    a_feature.setMz((Double)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_mz.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_deviation.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_deviation.name())).equals(a_feature.getDeviation())) {
                    a_feature.setDeviation((Double)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_deviation.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_charge.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_charge.name())).equals(a_feature.getCharge())) {
                    a_feature.setCharge((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_charge.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_precursor_id.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_precursor_id.name())).equals(a_feature.getPrecursor())) {
                    a_feature.setPrecursor((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_precursor_id.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_fragmentType.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_fragmentType.name())).equals(a_feature.getFragmentType())) {
                    a_feature.setFragmentType((String)_tableRow.get(_columnSettings.getColumnPosition(DMFeature.feature_fragmentType.name())));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static int fillMSAnnotationColumnSettingsAnnotation(TableViewerColumnSettings _columnSettings) {
        try {
            _columnSettings.addColumn(DMAnnotation.annotation_num_candidates.getLabel(), DMAnnotation.annotation_num_candidates.name());
            _columnSettings.addColumn(TableDataProcessor.filterColHeader.getLabel(), TableDataProcessor.filterColHeader.getKeyValue());
            _columnSettings.addColumn(TableDataProcessor.commentColHeader.getLabel(), TableDataProcessor.commentColHeader.getKeyValue());
            _columnSettings.addColumn(DMAnnotation.annotation_id.getLabel(), DMAnnotation.annotation_id.name());
            _columnSettings.addColumn(DMAnnotation.annotation_sequence.getLabel(), DMAnnotation.annotation_sequence.name());
            _columnSettings.addColumn(DMAnnotation.annotation_ratio.getLabel(), DMAnnotation.annotation_ratio.name());
            return 5;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    public static void fillAnnotationData(Annotation a_annotation, int _iNumCandidates, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMAnnotation.annotation_num_candidates.name()), (Object)_iNumCandidates, _tableRow);
            MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(TableDataProcessor.filterColHeader.getKeyValue()), (Object)-1, _tableRow);
            if (a_annotation != null) {
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMAnnotation.annotation_id.name()), (Object)a_annotation.getId(), _tableRow);
                MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMAnnotation.annotation_sequence.name()), (Object)a_annotation.getSequence(), _tableRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void updateAnnotationData(Annotation a_annotation, ArrayList _tableRow, TableViewerColumnSettings _columnSettings) {
        try {
            if (a_annotation != null) {
                if (_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_id.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_id.name())).equals(a_annotation.getId())) {
                    a_annotation.setId((Integer)_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_id.name())));
                }
                if (_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_sequence.name())) != null && !_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_sequence.name())).equals(a_annotation.getSequence())) {
                    a_annotation.setSequence((String)_tableRow.get(_columnSettings.getColumnPosition(DMAnnotation.annotation_sequence.name())));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

