/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.providers;

import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.editsupport.EditingSupportForUnit;
import org.grits.toolbox.entry.sample.part.editsupport.EditingSupportForValue;
import org.grits.toolbox.entry.sample.part.providers.DescriptorColumnLabelProvider;
import org.grits.toolbox.entry.sample.part.providers.DescriptorUnitLabelProvider;
import org.grits.toolbox.entry.sample.part.providers.DescriptorValueLabelProvider;

public class TreeViewerSetup {
    private TreeViewer treeViewer;
    private TreeViewerColumn column1 = null;
    private TreeViewerColumn column2 = null;
    private TreeViewerColumn column3 = null;
    private TreeViewerColumn column4 = null;
    private MDirtyable dirtyable = null;

    public TreeViewerSetup(TreeViewer treeViewer, MDirtyable dirtyable) {
        this.treeViewer = treeViewer;
        this.dirtyable = dirtyable;
    }

    public void setupColumns() {
        this.column1 = new TreeViewerColumn(this.treeViewer, 16384);
        this.column1.getColumn().setText("Descriptor Group / Descriptor");
        this.column2 = new TreeViewerColumn(this.treeViewer, 16384);
        this.column2.getColumn().setText("Value");
        this.column2.setEditingSupport((EditingSupport)new EditingSupportForValue(this.treeViewer, this.dirtyable));
        this.column3 = new TreeViewerColumn(this.treeViewer, 16384);
        this.column3.getColumn().setText("Unit");
        this.column3.setEditingSupport((EditingSupport)new EditingSupportForUnit(this.treeViewer, this.dirtyable));
        this.column4 = new TreeViewerColumn(this.treeViewer, 16384);
        this.column4.getColumn().setText("Guidelines");
    }

    public void setLabelProviders() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.column1.getViewer());
        this.column1.setLabelProvider((CellLabelProvider)new DescriptorColumnLabelProvider());
        this.column2.setLabelProvider((CellLabelProvider)new DescriptorValueLabelProvider(this.treeViewer));
        this.column3.setLabelProvider((CellLabelProvider)new DescriptorUnitLabelProvider());
        this.column4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List<String> guidelines = null;
                if (element instanceof Descriptor) {
                    guidelines = ((Descriptor)element).getGuidelineURIs();
                } else if (element instanceof DescriptorGroup) {
                    guidelines = ((DescriptorGroup)element).getGuidelineURIs();
                }
                if (guidelines != null) {
                    String stringValue = "";
                    for (String guideline : guidelines) {
                        if (!stringValue.isEmpty()) {
                            stringValue = String.valueOf(stringValue) + ", ";
                        }
                        stringValue = String.valueOf(stringValue) + guideline;
                    }
                    return stringValue;
                }
                return null;
            }
        });
    }
}

