/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.action;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.AddDescriptorGroupDialog;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.action.AbstractTreeTableAction;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorGroupAction
extends AbstractTreeTableAction {
    @Inject
    private IEclipseContext eclipseContext;
    private List<DescriptorGroup> availableDescriptorGroups = null;

    private void loadAvailableGroupsForCategory() {
        this.availableDescriptorGroups = new ArrayList<DescriptorGroup>();
        String categoryUri = ((Category)this.treeViewer.getInput()).getUri();
        this.availableDescriptorGroups = this.sampleOntologyApi.getCategoryDescriptorGroups(categoryUri);
    }

    @Override
    protected void setUp() {
        this.setText("Add Descriptor Group");
        this.setToolTipText("Add a new Descriptor Group");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.ADD_DESCRIPTOR_GROUP_ICON));
    }

    public void run() {
        this.loadAvailableGroupsForCategory();
        AddDescriptorGroupDialog descriptorGroupDialog = (AddDescriptorGroupDialog)((Object)ContextInjectionFactory.make(AddDescriptorGroupDialog.class, (IEclipseContext)this.eclipseContext));
        descriptorGroupDialog.init(this.availableDescriptorGroups);
        if (descriptorGroupDialog.open() == 0) {
            Category category = (Category)this.treeViewer.getInput();
            List<DescriptorGroup> prevDescriptorGroups = category.getDescriptorGroups();
            DescriptorGroup newDescriptorGroup = descriptorGroupDialog.getDescriptorGroup().getACopy();
            int action = this.occurenceLessThanMax(prevDescriptorGroups, newDescriptorGroup);
            switch (action) {
                case 1: {
                    prevDescriptorGroups.add(newDescriptorGroup);
                    this.treeViewer.refresh();
                    this.dirtyable.setDirty(true);
                    this.treeViewer.setExpandedState((Object)newDescriptorGroup, true);
                    break;
                }
                case 0: {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Add Descriptor Group Denied", (String)("You cannot add this descriptor group \"" + newDescriptorGroup.getLabel() + "\" more than its max occurence \"" + newDescriptorGroup.getMaxOccurrence() + "\""));
                    break;
                }
                case -1: {
                    prevDescriptorGroups.add(newDescriptorGroup);
                    this.treeViewer.refresh();
                    this.dirtyable.setDirty(true);
                    this.treeViewer.setExpandedState((Object)newDescriptorGroup, true);
                    this.component.setTemplateUri(null);
                    this.eventBroker.post("component_modified_in_a_tab", (Object)this.component);
                }
            }
        }
    }

    private int occurenceLessThanMax(List<DescriptorGroup> prevDescriptorGroups, DescriptorGroup newDescriptorGroup) {
        CategoryTemplate categoryTamplate = ((CategoryTreeContentProvider)this.treeViewer.getContentProvider()).getCategoryTemplate();
        boolean isInTemplate = true;
        if (categoryTamplate != null) {
            isInTemplate = false;
            List<DescriptorGroup> dgGroups = UtilityDescriptorDescriptorGroup.getAllDescriptorGroups(categoryTamplate);
            for (DescriptorGroup dg : dgGroups) {
                if (!dg.getUri().equals(newDescriptorGroup.getUri())) continue;
                newDescriptorGroup.setMaxOccurrence(dg.getMaxOccurrence());
                isInTemplate = true;
                break;
            }
        }
        int templateValue = 0;
        if (!isInTemplate) {
            int n = templateValue = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Remove Template", (String)("This Descriptor Group \"" + newDescriptorGroup.getLabel() + "\" is not allowed in the template \"" + categoryTamplate.getTemplateURI() + "\". Do you want to remove the template?")) ? -1 : -2;
        }
        if (templateValue >= -1) {
            int maxOccurrenceIsRight = 1;
            if (newDescriptorGroup.getMaxOccurrence() != null) {
                int prevOccurence = 0;
                for (DescriptorGroup prevDescriptorGroup : prevDescriptorGroups) {
                    if (!prevDescriptorGroup.getUri().equals(newDescriptorGroup.getUri())) continue;
                    ++prevOccurence;
                }
                maxOccurrenceIsRight = templateValue == 0 ? (prevOccurence < newDescriptorGroup.getMaxOccurrence() ? 1 : 0) : (prevOccurence < newDescriptorGroup.getMaxOccurrence() ? -1 : 0);
                return maxOccurrenceIsRight;
            }
            return templateValue == 0 ? 1 : -1;
        }
        return -2;
    }
}

