/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator;

import java.util.ArrayList;
import java.util.List;

public class LipidGeneratorUtils {
    public static List<Integer> parseValueRanges(String a_strValues) {
        String[] t_listParsedParams;
        ArrayList<Integer> t_listParams = new ArrayList<Integer>();
        try {
            if (!LipidGeneratorUtils.validateValueRangesFormat(a_strValues)) {
                return t_listParams;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return t_listParams;
        }
        String[] stringArray = t_listParsedParams = a_strValues.split(",");
        int n = t_listParsedParams.length;
        int n2 = 0;
        while (n2 < n) {
            String t_strParam = stringArray[n2];
            if (!t_strParam.contains("-")) {
                int t_iParam = Integer.parseInt(t_strParam);
                t_listParams.add(t_iParam);
            } else {
                String[] t_listParamRange = t_strParam.split("-");
                int t_iMin = Integer.parseInt(t_listParamRange[0]);
                int t_iMax = Integer.parseInt(t_listParamRange[1]);
                int i = t_iMin;
                while (i <= t_iMax) {
                    t_listParams.add(i);
                    ++i;
                }
            }
            ++n2;
        }
        return t_listParams;
    }

    public static boolean validateValueRangesFormat(String a_strValues) throws NumberFormatException {
        String[] t_listParsedParams;
        if (a_strValues == null || a_strValues.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < a_strValues.length()) {
            char t_char = a_strValues.charAt(i);
            if (!Character.isDigit(t_char) && t_char != '-' && t_char != ',') {
                throw new NumberFormatException("Non digit character(s) are not allowed except for comma \",\" and hyphen \"-\".");
            }
            ++i;
        }
        String[] stringArray = t_listParsedParams = a_strValues.split(",", -1);
        int n = t_listParsedParams.length;
        int n2 = 0;
        while (n2 < n) {
            String t_str = stringArray[n2];
            if (t_str.contains("-")) {
                int t_iMax;
                if (t_str.startsWith("-")) {
                    throw new NumberFormatException("Negative number is not allowed.");
                }
                String[] t_strRange = t_str.split("-", -1);
                if (t_strRange.length > 2) {
                    String[] stringArray2 = t_strRange;
                    int n3 = t_strRange.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String t_strParsed = stringArray2[n4];
                        if (t_strParsed.isEmpty()) {
                            throw new NumberFormatException("Negative number is not allowed");
                        }
                        ++n4;
                    }
                    throw new NumberFormatException("Two or more hyphens between two commas are not allowed.");
                }
                if (t_strRange[1].isEmpty()) {
                    throw new NumberFormatException("Number(s) are necessary after hyphen.");
                }
                int t_iMin = Integer.parseInt(t_strRange[0]);
                if (t_iMin >= (t_iMax = Integer.parseInt(t_strRange[1]))) {
                    throw new NumberFormatException("First number must be smaller than last number in the value ranges.");
                }
            } else if (t_str.isEmpty()) {
                throw new NumberFormatException("A number between two commas are needed.");
            }
            ++n2;
        }
        return true;
    }
}

