/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.handler.NewGelatoHandler;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.LipidDatabase;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.tools.gsl.annotation.entry.property.MSGlycolipidAnnotationProperty;
import org.grits.toolbox.tools.gsl.annotation.entry.property.datamodel.MSGlycolipidAnnotationMetaData;
import org.grits.toolbox.tools.gsl.annotation.process.DANGOWorker;
import org.grits.toolbox.tools.gsl.dango.DANGOAnnotation;
import org.grits.toolbox.tools.gsl.util.DatabaseUtilsForGSL;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressHandler;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class DANGOHandler
extends NewGelatoHandler {
    private static final Logger logger = Logger.getLogger(DANGOHandler.class);
    private String m_strArchiveFilePath;

    private String getWorkspaceLocation() {
        return PropertyHandler.getVariable((String)"workspace_location");
    }

    protected File getTempFolder() {
        String workspaceLocation = this.getWorkspaceLocation();
        String t_tempFolder = String.valueOf(workspaceLocation) + ".temp" + File.separator + "DANGO_" + Long.toString(System.currentTimeMillis()) + File.separator;
        File t_tempFolderFile = new File(t_tempFolder);
        t_tempFolderFile.mkdirs();
        return t_tempFolderFile;
    }

    protected File getAnnotationFolder(Entry msEntry) {
        String workspaceLocation = this.getWorkspaceLocation();
        MSGlycolipidAnnotationProperty t_property = new MSGlycolipidAnnotationProperty();
        Entry projectEntry = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project");
        String projectName = projectEntry.getDisplayName();
        String msAnnotationFolder = String.valueOf(workspaceLocation) + projectName + File.separator + t_property.getArchiveFolder();
        File msAnnotationFolderFile = new File(msAnnotationFolder);
        msAnnotationFolderFile.mkdirs();
        return msAnnotationFolderFile;
    }

    protected MSAnnotationProperty getMSAnnotationProperty(Shell shell, MSGlycanAnnotationWizard wizard, String msAnnotationFolder) {
        MSGlycolipidAnnotationProperty t_property = new MSGlycolipidAnnotationProperty();
        MSGlycolipidAnnotationMetaData metaData = new MSGlycolipidAnnotationMetaData();
        t_property.setMSAnnotationMetaData((MSAnnotationMetaData)metaData);
        try {
            metaData.setAnnotationId(this.createRandomId(msAnnotationFolder));
            metaData.setDescription(wizard.getInitial().getMSDescription());
            metaData.setVersion("1.0");
            metaData.setName(t_property.getMetaDataFileName());
        }
        catch (IOException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Exception", (Exception)e2);
            return null;
        }
        return t_property;
    }

    private void updateDatabaseReferences(Method method) {
        for (AnalyteSettings aSettings : method.getAnalyteSettings()) {
            LipidDatabase lipidDb;
            GlycanFilter filter = aSettings.getGlycanSettings().getFilter();
            if (filter.getDatabase().indexOf(File.separator) == -1) {
                try {
                    filter.setDatabase(String.valueOf(DatabaseUtilsForGSL.getDatabasePath()) + File.separator + filter.getDatabase());
                }
                catch (IOException e) {
                    logger.error((Object)"Database path cannot be determined", (Throwable)e);
                }
            }
            if (aSettings.getLipidSettings() == null || aSettings.getLipidSettings().getDatabase() == null || (lipidDb = aSettings.getLipidSettings().getDatabase()).getURI().indexOf(File.separator) != -1) continue;
            try {
                lipidDb.setURI(String.valueOf(DatabaseUtilsForGSL.getDatabasePath()) + File.separator + lipidDb.getURI());
            }
            catch (IOException e) {
                logger.error((Object)"Lipid database path cannot be determined", (Throwable)e);
            }
        }
    }

    private int performAnnotation(GRITSProgressDialog gpd, Data data, String workspaceFolder, String msAnnotationFolder, MSAnnotationProperty property, MSFile msFile) {
        try {
            this.updateDatabaseReferences(data.getDataHeader().getMethod());
            String sMSType = msFile.getExperimentType();
            data.getDataHeader().getMethod().setMsType(sMSType);
            MSGlycolipidAnnotationProperty t_prop = (MSGlycolipidAnnotationProperty)property;
            String t_strMSArchivePath = String.valueOf(msAnnotationFolder) + File.separator + t_prop.getMSAnnotationMetaData().getAnnotationId();
            this.m_strArchiveFilePath = String.valueOf(t_strMSArchivePath) + ".zip";
            ArrayList<IProgressListener> workerListeners = new ArrayList<IProgressListener>();
            workerListeners.add((IProgressListener)gpd.getMinorProgressBarListeners()[0]);
            ArrayList<IProgressListener> annotationListeners = new ArrayList<IProgressListener>();
            annotationListeners.add((IProgressListener)gpd.getMinorProgressBarListeners()[1]);
            DANGOAnnotation t_DANGO = new DANGOAnnotation(data, msFile, this.m_strArchiveFilePath);
            t_DANGO.setIntactGlycanAnnotation(true);
            t_DANGO.setFilterByKeyFragment(true);
            this.wizard.getMethod().setMsType(sMSType);
            DANGOWorker dw = new DANGOWorker(t_DANGO, (IProgressHandler)gpd, (IProgressThreadHandler)gpd, workerListeners, annotationListeners);
            int iRes = dw.doWork();
            return iRes;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int doWork() {
        File fWorkspaceFolderFile = this.getTempFolder();
        int iStatus = GRITSProcessStatus.OK;
        try {
            this.setMaxValue(this.wizard.getInitial().getMsEntryList().size());
            int i = 0;
            while (i < this.wizard.getInitial().getMsEntryList().size() && iStatus == GRITSProcessStatus.OK) {
                Entry msEntry = (Entry)this.wizard.getInitial().getMsEntryList().get(i);
                this.updateListeners("Processing entry: " + msEntry.getDisplayName(), i);
                MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
                Entry msAnnotationEntry = new Entry();
                String sWorkspaceFolder = fWorkspaceFolderFile.getAbsolutePath();
                File msAnnFile = this.getAnnotationFolder(msEntry);
                String msAnnotationFolder = msAnnFile.getAbsolutePath();
                MSAnnotationProperty msAnnotProperty = this.getMSAnnotationProperty(this.shell, this.wizard, msAnnotationFolder);
                msAnnotationEntry.setProperty((Property)msAnnotProperty);
                String msEntryDisplayName = msEntry.getDisplayName();
                String msAnnotName = (String)this.wizard.getInitial().getListEntries().get(msEntryDisplayName);
                msAnnotationEntry.setDisplayName(msAnnotName);
                Data data = this.getNewDataObject(this.wizard);
                DataHeader dHeader = data.getDataHeader();
                MSPropertyDataFile dataFile = (MSPropertyDataFile)this.wizard.getInitial().getFileMap().get(msEntryDisplayName);
                String workspaceLocation = this.getWorkspaceLocation();
                String projectName = DataModelSearch.findParentByType((Entry)msEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
                String pathToFile = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
                iStatus = this.performAnnotation(this.gpd, data, sWorkspaceFolder, msAnnotationFolder, msAnnotProperty, dataFile.getMSFileWithReader(pathToFile, prop.getMassSpecMetaData().getMsExperimentType()));
                if (iStatus == GRITSProcessStatus.OK) {
                    msAnnotProperty.getMSAnnotationMetaData().addAnnotationFile(dataFile);
                    PropertyDataFile msMetaData = MSAnnotationProperty.getNewSettingsFile((String)msAnnotProperty.getMetaDataFileName(), (MSAnnotationMetaData)msAnnotProperty.getMSAnnotationMetaData());
                    msAnnotProperty.getDataFiles().add(msMetaData);
                    this.addResultFileToMetaData(dHeader.getMethod().getMsType(), msAnnotProperty);
                    MSAnnotationProperty.marshallSettingsFile((String)(String.valueOf(msAnnotProperty.getAnnotationFolder(msEntry)) + File.separator + msAnnotProperty.getMetaDataFileName()), (MSAnnotationMetaData)msAnnotProperty.getMSAnnotationMetaData());
                    Entry[] entries = new Entry[]{msEntry, msAnnotationEntry};
                    this.returnList.add(entries);
                } else if (iStatus == GRITSProcessStatus.CANCEL) {
                    this.deleteResultFiles(dHeader.getMethod().getMsType());
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            iStatus = GRITSProcessStatus.ERROR;
        }
        File[] fileArray = fWorkspaceFolderFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        fWorkspaceFolderFile.delete();
        this.updateListeners("Done!", this.getMsEntries().size());
        return iStatus;
    }

    protected void addResultFileToMetaData(String sMSType, MSAnnotationProperty msAnnotProperty) {
        File annotationFile = new File(this.m_strArchiveFilePath);
        if (sMSType.equals("LC-MS/MS")) {
            this.addResultFileToMetaData(annotationFile, msAnnotProperty);
        } else {
            this.addResultFileToMetaData(annotationFile, msAnnotProperty);
        }
    }

    private void addResultFileToMetaData(File annotationFile, MSAnnotationProperty msAnnotProperty) {
        MSPropertyDataFile pdfFolder = new MSPropertyDataFile(annotationFile.getName(), "1.0", "file", FileCategory.ANNOTATION_CATEGORY, "DANGO", annotationFile.getPath(), new ArrayList());
        msAnnotProperty.getMSAnnotationMetaData().addFile(pdfFolder);
    }

    protected void deleteResultFiles(String msType) {
        try {
            File annotationFile = new File(this.m_strArchiveFilePath);
            if (annotationFile.exists()) {
                annotationFile.delete();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not delete generated files", (Throwable)e);
        }
    }
}

