/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.similarity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoExporterException;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeNodeConverter;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeSUDictionary;
import org.glycoinfo.GlycanFormatconverter.util.comparater.LCNodeComparater;
import org.glycoinfo.GlycanFormatconverter.util.comparater.NodeDescendingComparator;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;

public class LinearCodeNodeSimilarity
extends NodeSimilarity {
    @Override
    public ArrayList<Node> sortAllNode(Node _root) {
        ArrayList<Node> ret = new ArrayList<Node>();
        ret.add(_root);
        try {
            ret = this.sortSUNotations(ret, _root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ArrayList<Node> sortCurrentChildren(Node _node) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        return this.sortSUBranch(_node);
    }

    @Override
    public ArrayList<Edge> sortParentSideEdges(ArrayList<Edge> _edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        Edge cyclic = null;
        ArrayList<Edge> repeating = new ArrayList<Edge>();
        ArrayList<Edge> simple = new ArrayList<Edge>();
        for (Edge edge : _edges) {
            if (edge.isRepeat()) {
                repeating.add(edge);
                continue;
            }
            if (edge.isCyclic()) {
                cyclic = edge;
                continue;
            }
            simple.add(edge);
        }
        ret.addAll(simple);
        ret.addAll(repeating);
        if (cyclic != null) {
            ret.add(cyclic);
        }
        if (ret.isEmpty()) {
            return _edges;
        }
        return ret;
    }

    private ArrayList<Node> sortSUNotations(ArrayList<Node> _notations, Node _node) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        if (_node.getChildNodes().isEmpty() || this.countChildren(_node) == 0) {
            return _notations;
        }
        if (this.countChildren(_node) > 1) {
            for (Node child : this.sortSUBranch(_node)) {
                _notations.add(child);
                _notations = this.sortSUNotations(_notations, child);
            }
        } else {
            _notations.add(_node.getChildNodes().get(0));
            _notations = this.sortSUNotations(_notations, _node.getChildNodes().get(0));
        }
        return _notations;
    }

    private ArrayList<Node> sortSUBranch(Node _node) throws GlyCoExporterException, ConverterExchangeException, GlycanException {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Edge childEdge : _node.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub != null && sub instanceof GlycanRepeatModification || childEdge.getChild() == null) continue;
            children.add(childEdge.getChild());
        }
        Collections.sort(children, new LCNodeComparater());
        return this.sortSUBranchByPosition(children);
    }

    private ArrayList<Node> sortSUBranchByPosition(ArrayList<Node> _notations) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        ArrayList<Node> subNotations = new ArrayList<Node>();
        TreeMap<Integer, Node> mapNodes = new TreeMap<Integer, Node>();
        int i = 0;
        while (i < _notations.size()) {
            LinearCodeSUDictionary lcDict2;
            mapNodes.put(i, _notations.get(i));
            if (i + 1 > _notations.size() - 1) {
                if (subNotations.isEmpty()) break;
                mapNodes = this.sortMap(mapNodes, i, subNotations);
                break;
            }
            LinearCodeNodeConverter lcConv = new LinearCodeNodeConverter();
            LinearCodeSUDictionary lcDict1 = lcConv.start(_notations.get(i));
            if (lcDict1.equals((Object)(lcDict2 = lcConv.start(_notations.get(i + 1))))) {
                if (!subNotations.contains(_notations.get(i))) {
                    subNotations.add(_notations.get(i));
                }
                if (!subNotations.contains(_notations.get(i + 1))) {
                    subNotations.add(_notations.get(i + 1));
                }
            }
            if (!lcDict1.equals((Object)lcDict2) && !subNotations.isEmpty()) {
                mapNodes = this.sortMap(mapNodes, i, subNotations);
                subNotations.clear();
            }
            ++i;
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator iterNode = mapNodes.values().iterator();
        while (iterNode.hasNext()) {
            ret.add((Node)iterNode.next());
        }
        return ret;
    }

    private TreeMap<Integer, Node> sortMap(TreeMap<Integer, Node> _map, int _index, ArrayList<Node> _subGraph) {
        Collections.sort(_subGraph, new NodeDescendingComparator());
        for (Node node : _subGraph) {
            _map.put(_index - _subGraph.size() + 1 + _subGraph.indexOf(node), node);
        }
        return _map;
    }

    public boolean isSubBranch(Node _node) throws GlyCoExporterException, ConverterExchangeException, GlycanException {
        if (_node.getParentEdges().isEmpty()) {
            return false;
        }
        for (Edge parentEdge : _node.getParentEdges()) {
            if (parentEdge.isRepeat() || parentEdge.isCyclic()) continue;
            if (parentEdge.getParent() == null) break;
            ArrayList<Node> children = this.sortCurrentChildren(parentEdge.getParent());
            if (children.size() < 2 || children.indexOf(_node) == children.size() - 1) continue;
            return true;
        }
        return false;
    }
}

