/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFNodeConverter;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFUtility;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;
import org.glycoinfo.GlycanFormatconverter.util.MonosaccharideUtility;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;

public class KCFImporter {
    private KCFUtility kcfUtil = new KCFUtility();
    private HashMap<String, Node> nodeIndex = new HashMap();
    private GlyContainer glyco = new GlyContainer();

    public GlyContainer start(String _kcf) throws GlyCoImporterException, GlycanException, ConverterExchangeException, TrivialNameException {
        String countKey = "";
        boolean isRepeat = false;
        ArrayList<String> repeatNode = new ArrayList<String>();
        this.kcfUtil.start(_kcf);
        KCFNodeConverter kcfNodeConv = new KCFNodeConverter(this.kcfUtil);
        for (String unit : this.kcfUtil.getNodes()) {
            Node node = kcfNodeConv.start(unit);
            if (node == null) continue;
            this.nodeIndex.put(this.kcfUtil.splitNotation(unit).get(0), node);
        }
        for (String unit : this.kcfUtil.getEdges()) {
            this.extractLinkage(unit);
        }
        for (String unit : this.kcfUtil.getNotationList()) {
            if ((unit = unit.trim()).equals("///")) break;
            if (unit.startsWith("BRACKET")) {
                isRepeat = true;
            }
            if (!isRepeat) continue;
            if (unit.matches("^BRACKET(\\t|\\s).*$")) {
                unit = unit.replaceFirst("BRACKET", "");
                unit = unit.trim();
                countKey = unit.substring(0, 1);
            }
            repeatNode.add(unit);
            if (!unit.matches("^" + countKey + "(\\s|\\t)+" + "(N|n|\\d)+")) continue;
            isRepeat = false;
            countKey = "";
            this.extractRepeatation(repeatNode);
            repeatNode.clear();
        }
        MonosaccharideUtility monoUtil = new MonosaccharideUtility();
        this.modifyRootStatus(this.glyco.getRootNodes().get(0));
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        gcOpt.start(this.glyco);
        return this.glyco;
    }

    private void extractLinkage(String _node) throws GlycanException {
        String anomericState;
        String parentLin;
        Node parentNode;
        String childLin;
        Node childNode;
        ArrayList<String> units = this.kcfUtil.splitNotation(_node);
        String pID = this.kcfUtil.extractID(units.get(2));
        String cID = this.kcfUtil.extractID(units.get(1));
        if (this.nodeIndex.get(pID) instanceof Substituent && !(((Substituent)this.nodeIndex.get(pID)).getSubstituent() instanceof BaseCrossLinkedTemplate)) {
            childNode = this.nodeIndex.get(pID);
            childLin = this.kcfUtil.extractLinkagePosition(units.get(2));
            parentNode = this.nodeIndex.get(cID);
            parentLin = this.kcfUtil.extractLinkagePosition(units.get(1));
            anomericState = this.kcfUtil.extractAnomerixState(units.get(2));
        } else {
            childNode = this.nodeIndex.get(cID);
            childLin = this.kcfUtil.extractLinkagePosition(units.get(1));
            parentNode = this.nodeIndex.get(pID);
            parentLin = this.kcfUtil.extractLinkagePosition(units.get(2));
            anomericState = this.kcfUtil.extractAnomerixState(units.get(1));
        }
        if (childNode == null && parentNode == null || parentNode == null && childNode instanceof Substituent) {
            return;
        }
        if (childNode instanceof Substituent && parentNode instanceof Substituent) {
            return;
        }
        Edge edge = new Edge();
        if (parentNode == null) {
            this.defineAnomericStatus(anomericState, parentLin, childNode);
            this.glyco.addNode(childNode);
            return;
        }
        if (childNode instanceof Monosaccharide) {
            String childPos;
            String string = childPos = childLin.length() == 1 ? String.valueOf(childLin.charAt(0)) : String.valueOf(childLin.charAt(1));
            if (parentNode instanceof Substituent) {
                this.defineAnomericStatus(anomericState.length() == 1 ? "?" : anomericState, parentLin, childNode);
            } else {
                this.defineAnomericStatus(anomericState, parentLin, childNode);
            }
            if (parentNode instanceof Substituent) {
                return;
            }
            String parentPos = "?";
            if (parentLin != null) {
                if (this.kcfUtil.extractAnomerixState(units.get(2)).length() == 2) {
                    this.defineAnomericStatus(this.kcfUtil.extractAnomerixState(units.get(2)), null, parentNode);
                }
                parentPos = parentLin.length() == 1 ? String.valueOf(parentLin.charAt(0)) : (parentLin.contains("/") ? parentLin : String.valueOf(parentLin.charAt(1)));
            }
            Linkage lin = new Linkage();
            lin.setParentLinkages(this.makeLinkages(parentPos));
            lin.setChildLinkages(this.makeLinkages(childPos));
            edge.addGlycosidicLinkage(lin);
            this.glyco.addNode(parentNode, edge, childNode);
        }
        if (childNode instanceof Substituent) {
            String bridgeChild = this.kcfUtil.extractEdgeByID(units.get(1), true);
            if (!bridgeChild.equals("")) {
                String childID = this.kcfUtil.extractID(this.kcfUtil.splitNotation(bridgeChild).get(1));
                if (this.nodeIndex.get(childID) == null) {
                    if (!this.isRepeat(this.kcfUtil.extractEdgeByID(units.get(1), true))) {
                        Linkage first = ((Substituent)childNode).getFirstPosition();
                        first.setParentLinkages(this.makeLinkages(parentLin));
                        ((Substituent)childNode).setFirstPosition(first);
                        edge.addGlycosidicLinkage(first);
                        edge.setParent(parentNode);
                        childNode.addParentEdge(edge);
                        this.glyco.addNodeWithSubstituent(parentNode, edge, (Substituent)childNode);
                    }
                    return;
                }
                Node bridge = childNode;
                childNode = this.nodeIndex.get(childID);
                childLin = this.kcfUtil.extractLinkagePosition(this.kcfUtil.splitNotation(this.kcfUtil.extractEdgeByID(childID, false)).get(1));
                String childPos = childLin.length() == 1 ? String.valueOf(childLin.charAt(0)) : String.valueOf(childLin.charAt(1));
                Linkage first = new Linkage();
                first.setParentLinkages(this.makeLinkages(parentLin));
                first.setChildLinkages(this.makeLinkages(childPos));
                edge.addGlycosidicLinkage(first);
                this.glyco.addNode(parentNode, edge, childNode);
                this.glyco.addNodeWithSubstituent(parentNode, edge, (Substituent)bridge);
            } else {
                Linkage first = ((Substituent)childNode).getFirstPosition();
                first.setParentLinkages(this.makeLinkages(parentLin));
                ((Substituent)childNode).setFirstPosition(first);
                edge.addGlycosidicLinkage(first);
                edge.setParent(parentNode);
                childNode.addParentEdge(edge);
                this.glyco.addNodeWithSubstituent(parentNode, edge, (Substituent)childNode);
            }
        }
    }

    private void defineAnomericStatus(String _childLin, String _parentLin, Node _node) throws GlycanException {
        int anomericSymbol;
        if (_childLin == null) {
            return;
        }
        if (_node instanceof Substituent) {
            return;
        }
        int pos = _childLin.length() == 1 ? this.charToint(_childLin.charAt(0)) : this.charToint(_childLin.charAt(1));
        int n = anomericSymbol = _childLin.length() == 1 ? 120 : (int)this.modifyAnomericSymbol(_childLin.charAt(0));
        if (this.isOpenStatus(_node)) {
            pos = 0;
            anomericSymbol = 111;
        }
        Monosaccharide mono = (Monosaccharide)_node;
        if (_parentLin != null && _parentLin.length() == 2) {
            anomericSymbol = anomericSymbol == 111 ? 120 : anomericSymbol;
            pos = _childLin.length() == 1 ? this.charToint(_childLin.charAt(0)) : this.charToint(_childLin.charAt(1));
        }
        mono.setAnomericPosition(pos);
        AnomericStateDescriptor anomState = AnomericStateDescriptor.forAnomericState((char)anomericSymbol);
        mono.setAnomer(anomState);
        if (mono.getRingStart() != -1 && mono.getRingEnd() != -1) {
            return;
        }
        if (pos == 0 || pos == -1) {
            mono.setRing(-1, -1);
        }
        if (mono.getAnomericPosition() != mono.getRingStart()) {
            mono.setRingStart(mono.getAnomericPosition());
        }
    }

    private int charToint(char _char) {
        if (_char == '?') {
            return -1;
        }
        return Integer.parseInt(String.valueOf(_char));
    }

    private Collection<Integer> makeLinkages(String _position) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (_position == null) {
            ret.add(-1);
        } else {
            String[] stringArray = _position.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String unit = stringArray[n2];
                ret.add(this.charToint(unit.charAt(0)));
                ++n2;
            }
        }
        return ret;
    }

    private boolean isOpenStatus(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getAnomericPosition() == 2) {
            return false;
        }
        for (GlyCoModification mod : mono.getModifications()) {
            if (mod.getPositionOne() != 2 || !mod.getModificationTemplate().equals((Object)ModificationTemplate.KETONE_U)) continue;
            return false;
        }
        if (mono.getAnomericPosition() == 0 && mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            return true;
        }
        for (GlyCoModification mod : mono.getModifications()) {
            if (mod.getPositionOne() != 1) continue;
            if (mod.getModificationTemplate().equals((Object)ModificationTemplate.ALDONICACID)) {
                return true;
            }
            if (mod.getModificationTemplate().equals((Object)ModificationTemplate.HYDROXYL)) {
                return true;
            }
            if (!mod.getModificationTemplate().equals((Object)ModificationTemplate.ALDEHYDE)) continue;
            return true;
        }
        return false;
    }

    private void extractRepeatation(ArrayList<String> _repeatsUnit) throws GlycanException, GlyCoImporterException {
        Node start = this.extractRepeatation(_repeatsUnit.get(1), null);
        Node end = this.extractRepeatation(_repeatsUnit.get(0), _repeatsUnit.get(2));
        if (start instanceof Monosaccharide && end instanceof Monosaccharide) {
            this.makeRepeatingUnit(start, end, null, _repeatsUnit.get(2));
        }
        if (start instanceof Substituent) {
            this.makeRepeatingUnitWithSubstituent(null, start, end, _repeatsUnit.get(2));
        }
        if (end instanceof Substituent) {
            this.makeRepeatingUnitWithSubstituent(start, end, null, _repeatsUnit.get(2));
        }
    }

    private Node extractRepeatation(String _repeat, String _count) throws GlycanException, GlyCoImporterException {
        ArrayList<String> repeat = this.kcfUtil.splitNotation(_repeat);
        BigDecimal bx = new BigDecimal(repeat.get(1)).setScale(1, 1);
        BigDecimal b1 = new BigDecimal(repeat.get(2));
        BigDecimal b2 = new BigDecimal(repeat.get(4));
        BigDecimal by = b1.add(b2).multiply(new BigDecimal(".5"));
        bx = bx.setScale(1, 1);
        by = by.setScale(1, 1);
        return this.extractNodeFromPosition(bx, by, _count == null);
    }

    private Node extractNodeFromPosition(BigDecimal _x, BigDecimal _y, boolean _isStart) throws GlyCoImporterException {
        String picked = "";
        for (String s : this.kcfUtil.getEdges()) {
            ArrayList<String> notations = this.kcfUtil.splitNotation(s);
            String child = this.kcfUtil.getNodeByID(this.kcfUtil.extractID(notations.get(1)));
            String parent = this.kcfUtil.getNodeByID(this.kcfUtil.extractID(notations.get(2)));
            BigDecimal cx = new BigDecimal(this.kcfUtil.splitNotation(child).get(2)).setScale(1, 1);
            BigDecimal cy = new BigDecimal(this.kcfUtil.splitNotation(child).get(3)).setScale(1, 1);
            if (cx.doubleValue() > _x.doubleValue()) continue;
            BigDecimal px = new BigDecimal(this.kcfUtil.splitNotation(parent).get(2)).setScale(1, 1);
            BigDecimal py = new BigDecimal(this.kcfUtil.splitNotation(parent).get(3)).setScale(1, 1);
            BigDecimal mx = cx.add(px).multiply(new BigDecimal(".5")).setScale(1, 1);
            BigDecimal my = cy.add(py).multiply(new BigDecimal(".5")).setScale(1, 1);
            if (_x.doubleValue() > cx.doubleValue() && px.doubleValue() > _x.doubleValue()) {
                if (_isStart) {
                    picked = child;
                }
                if (_isStart) break;
                picked = parent;
                break;
            }
            if (Double.compare(_y.doubleValue(), my.doubleValue()) == 0 || Double.compare(_y.doubleValue(), cy.doubleValue()) == 0 || Double.compare(_y.doubleValue(), py.doubleValue()) == 0) {
                if (!(cx.doubleValue() < _x.doubleValue()) || !(_x.doubleValue() < px.doubleValue())) continue;
                if (_isStart) {
                    picked = child;
                    break;
                }
                picked = parent;
                break;
            }
            if (!this.isApproximate(mx.divide(_x, 1, 4), my.divide(_y, 1, 4))) continue;
            if (_isStart) {
                picked = child;
                break;
            }
            picked = parent;
            break;
        }
        if (picked.equals("")) {
            throw new GlyCoImporterException("Repeat brackets could not select !");
        }
        return this.nodeIndex.get(this.kcfUtil.splitNotation(picked).get(0));
    }

    private boolean isApproximate(BigDecimal _x, BigDecimal _y) {
        return 1.01 > _x.doubleValue() && _x.doubleValue() > 0.89 && 1.01 > _y.doubleValue() && _y.doubleValue() > 0.89;
    }

    private void makeRepeatingUnitWithSubstituent(Node _start, Node _cross, Node _end, String _count) throws GlycanException {
        if (_start == null) {
            String startSide = this.kcfUtil.extractEdgeByID(this.extractNodeID(_cross), true);
            _start = this.nodeIndex.get(this.kcfUtil.extractID(this.kcfUtil.splitNotation(startSide).get(1)));
        }
        if (_end == null) {
            String endSide = this.kcfUtil.extractEdgeByID(this.extractNodeID(_cross), false);
            _end = this.nodeIndex.get(this.kcfUtil.extractID(this.kcfUtil.splitNotation(endSide).get(2)));
        }
        this.makeRepeatingUnit(_start, _end, _cross, _count);
    }

    private void makeRepeatingUnit(Node _start, Node _end, Node _cross, String _count) throws GlycanException {
        Edge parentEdge = new Edge();
        String startPos = this.kcfUtil.getLinkagePositionByNodeID(this.extractNodeID(_start), false);
        startPos = startPos == null ? "?" : (startPos.length() > 1 ? String.valueOf(startPos.charAt(1)) : startPos);
        String endPos = "?";
        ArrayList<String> endUnits = this.kcfUtil.extractEdgesByID(this.extractNodeID(_end), true);
        if (endUnits.size() > 1) {
            for (String unit : endUnits) {
                ArrayList<String> units = this.kcfUtil.splitNotation(unit);
                Node parent = this.nodeIndex.get(this.kcfUtil.extractID(units.get(2)));
                Node child = this.nodeIndex.get(this.kcfUtil.extractID(units.get(1)));
                if (child == null) {
                    endPos = this.kcfUtil.extractLinkagePosition(units.get(2));
                }
                if ((parent == null || !(parent instanceof Substituent)) && child != null && !(child instanceof Substituent)) continue;
            }
        } else {
            endPos = this.kcfUtil.extractLinkagePosition(this.kcfUtil.splitNotation(endUnits.get(0)).get(2));
        }
        Linkage lin = new Linkage();
        lin.setChildLinkages(this.makeLinkages(startPos));
        lin.setParentLinkages(this.makeLinkages(endPos));
        parentEdge.addGlycosidicLinkage(lin);
        GlycanRepeatModification repMod = new GlycanRepeatModification(null);
        repMod.setFirstPosition(new Linkage());
        repMod.setSecondPosition(new Linkage());
        if (_cross != null) {
            repMod.setTemplate(((Substituent)_cross).getSubstituent());
            SubstituentUtility substituentUtility = new SubstituentUtility();
        }
        repMod.setMinRepeatCount(-1);
        repMod.setMaxRepeatCount(-1);
        parentEdge.setSubstituent(repMod);
        this.glyco.addNode(_end, parentEdge, _start);
    }

    private String extractNodeID(Node _node) {
        DualHashBidiMap bidiMap = new DualHashBidiMap(this.nodeIndex);
        return (String)bidiMap.getKey((Object)_node);
    }

    private char modifyAnomericSymbol(char _anomericSymbol) {
        if (String.valueOf(_anomericSymbol).matches("[AB]")) {
            return String.valueOf(_anomericSymbol).toLowerCase().charAt(0);
        }
        return _anomericSymbol;
    }

    private void modifyRootStatus(Node root) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)root;
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN) && mono.getAnomericPosition() != 0 && !this.isFacingAnoms(root)) {
            mono.setAnomer(AnomericStateDescriptor.UNKNOWN_STATE);
        }
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN_STATE) && mono.getRingEnd() == -1) {
            mono.setRing(-1, -1);
        }
        if (this.isOpenStatus(root)) {
            mono.setAnomer(AnomericStateDescriptor.OPEN);
            mono.setAnomericPosition(0);
            mono.setRing(-1, -1);
        }
    }

    private boolean isFacingAnoms(Node _node) {
        boolean ret = false;
        int anomericPos = ((Monosaccharide)_node).getAnomericPosition();
        for (Edge childEdge : _node.getChildEdges()) {
            Monosaccharide child = (Monosaccharide)childEdge.getChild();
            if (child == null || child.getAnomericPosition() == -1) continue;
            for (Linkage lin : childEdge.getGlycosidicLinkages()) {
                if (lin.getParentLinkages().contains(anomericPos) || lin.getChildLinkages().size() != 1 || !lin.getChildLinkages().contains(child.getAnomericPosition()) || !lin.getParentLinkages().contains(anomericPos)) continue;
                return true;
            }
        }
        return ret;
    }

    private boolean isRepeat(String _notation) {
        if (_notation.equals("")) {
            return false;
        }
        ArrayList<String> units = this.kcfUtil.splitNotation(_notation);
        String nodeString = this.kcfUtil.getNodeByID(units.get(1));
        ArrayList<String> nodeItems = this.kcfUtil.splitNotation(nodeString);
        return nodeItems.get(1).equals("*");
    }
}

