/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;

public class IUPACLinkageParser
extends SubstituentUtility {
    private HashMap<Node, String> nodeIndex = new HashMap();
    private GlyContainer glyCo = null;
    private IUPACStacker stacker = new IUPACStacker();

    public GlyContainer getGlyCo() {
        return this.glyCo;
    }

    public IUPACLinkageParser(GlyContainer _glyCo, LinkedHashMap<Node, String> _nodeIndex, IUPACStacker _stacker) {
        this.glyCo = _glyCo;
        this.nodeIndex = _nodeIndex;
        this.stacker = _stacker;
    }

    public void start() throws GlycanException {
        for (Node node : this.stacker.getNodes()) {
            String notation = this.nodeIndex.get(node);
            if (!this.isRootOfFramgnets(notation) && !this.stacker.isComposition()) continue;
            this.glyCo.addGlycanUndefinedUnit(this.makeUndefinedUnit(node, notation));
        }
        for (Node node : this.stacker.getNodes()) {
            this.parseLinkage(node);
        }
        if (this.stacker.isFragment()) {
            Node root = this.stacker.getRoot();
            GlycanUndefinedUnit und = this.glyCo.getUndefinedUnitWithIndex(root);
            und.setConnection(root.getParentEdge());
        }
    }

    public GlycanUndefinedUnit makeUndefinedUnit(Node _node, String _notation) throws GlycanException {
        GlycanUndefinedUnit ret = new GlycanUndefinedUnit();
        ret.addNode(_node);
        for (Node parent : this.parseFragmentParents(_notation)) {
            ret.addParentNode(parent);
        }
        return ret;
    }

    public ArrayList<Node> parseFragmentParents(String _fragment) {
        ArrayList<Node> ret = new ArrayList<Node>();
        String anchor = _fragment.substring(_fragment.indexOf("=") + 1, _fragment.length() - 1);
        for (Node node : this.nodeIndex.keySet()) {
            String target;
            String notation = this.nodeIndex.get(node);
            if (notation.equals(_fragment)) continue;
            if (notation.contains("=") && notation.startsWith("?$") && anchor.equals(target = notation.endsWith(",") ? notation.substring(notation.indexOf("=") + 1, notation.length() - 1) : notation.substring(notation.indexOf("=") + 1, notation.length()))) {
                ret.add(node);
            }
            if (!notation.contains("|") && !notation.contains("$") || notation.contains("=")) continue;
            String temp = "";
            int i = 0;
            while (i < notation.length()) {
                char unit = notation.charAt(i);
                if (String.valueOf(unit).matches("\\d")) {
                    temp = String.valueOf(temp) + unit;
                }
                if (unit == '$') {
                    if (anchor.endsWith(temp = String.valueOf(temp) + unit)) {
                        ret.add(node);
                    }
                    temp = "";
                }
                ++i;
            }
        }
        return ret;
    }

    public void parseLinkage(Node _node) throws GlycanException {
        String notation = this.nodeIndex.get(_node);
        Node parent = this.stacker.getParent(_node);
        Matcher matStartRep = Pattern.compile("\\(([\\d?/?]+)[\u2192\\-]](([n\\d]+)-?([n\\d]+)?)(-.+|:.+)?").matcher(notation);
        if (matStartRep.find()) {
            this.parseRepeating(_node, parent, matStartRep.group(5));
        } else {
            this.parseSimpleLinkage(_node, parent, notation);
        }
        if (this.isEndCyclic(notation)) {
            this.parseCyclic(_node, this.getIndex(this.nodeIndex.size() - 1));
        }
        if (parent == null && !this.glyCo.containsNode(_node)) {
            this.glyCo.addNode(_node);
        }
    }

    private void parseSimpleLinkage(Node _node, Node _parent, String _notation) throws GlycanException {
        String linkage = this.extractLinkageNotation(_notation);
        String[] stringArray = linkage.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            Matcher matLin = Pattern.compile("([\\d?])+(-(\\d)?([(a-zA-Z)]+)+(\\d)?)?[-\u2192\u2194]?(([\\d?]+),?([\\d?]+)?%)?([\\d?/]+)?").matcher(unit);
            if (matLin.find()) {
                Edge parentEdge = new Edge();
                Linkage lin = new Linkage();
                lin.setChildLinkages(this.makeLinkageList(matLin.group(1)));
                if (matLin.group(4) != null) {
                    BaseCrossLinkedTemplate subface = BaseCrossLinkedTemplate.forIUPACNotation(matLin.group(4));
                    Substituent bridge = new Substituent(subface, new Linkage(), new Linkage());
                    bridge.getFirstPosition().setParentLinkages(this.makeLinkageList(matLin.group(1)));
                    bridge.getSecondPosition().setParentLinkages(this.makeLinkageList(matLin.group(9)));
                    String headPos = matLin.group(5);
                    String tailPos = matLin.group(3);
                    if (headPos != null) {
                        bridge.getFirstPosition().addChildLinkage(Integer.parseInt(headPos));
                    }
                    if (tailPos != null) {
                        bridge.getSecondPosition().addChildLinkage(Integer.parseInt(tailPos));
                    }
                    parentEdge.setSubstituent(bridge);
                    bridge.addParentEdge(parentEdge);
                }
                if (matLin.group(7) != null) {
                    if (matLin.group(7).equals("?")) {
                        lin.setProbabilityLower(-1.0);
                    } else {
                        lin.setProbabilityLower(Double.parseDouble(matLin.group(7)) * 0.01);
                    }
                }
                if (matLin.group(8) != null) {
                    if (matLin.group(8).equals("?")) {
                        lin.setProbabilityUpper(-1.0);
                    } else {
                        lin.setProbabilityUpper(Double.parseDouble(matLin.group(8)) * 0.01);
                    }
                } else if (matLin.group(8) == null && matLin.group(7) != null) {
                    if (matLin.group(7).equals("?")) {
                        lin.setProbabilityUpper(-1.0);
                    } else {
                        lin.setProbabilityUpper(Double.parseDouble(matLin.group(7)) * 0.01);
                    }
                }
                if (matLin.group(9) != null) {
                    lin.setParentLinkages(this.makeLinkageList(matLin.group(9)));
                }
                parentEdge.addGlycosidicLinkage(lin);
                if (_parent != null) {
                    if (!this.stacker.isFragment()) {
                        this.glyCo.addNode(_parent, parentEdge, _node);
                    } else {
                        GlycanUndefinedUnit und = this.glyCo.getUndefinedUnitWithIndex(this.stacker.getRoot());
                        und.addNode(_parent, parentEdge, _node);
                    }
                }
                if (matLin.group(9) != null && _parent == null) {
                    _node.addParentEdge(parentEdge);
                    parentEdge.setChild(_node);
                }
            }
            ++n2;
        }
    }

    private void parseRepeating(Node _node, Node _parent, String _repOutParent) throws GlycanException {
        String childPos = "";
        String parentPos = "";
        String count = "";
        TreeMap<Integer, String> repPos = this.extractMultipleRepStart(_node);
        ArrayList<Node> endNodes = this.getEndRepeatingNode(_node);
        for (Node endRep : endNodes) {
            String startPos = repPos.get(endNodes.indexOf(endRep) + 1);
            Matcher matStartRep = Pattern.compile("([\\d?/?]+)[\u2192\\-]](([n\\d]+)-?([n\\d]+)?)").matcher(startPos);
            if (matStartRep.find()) {
                childPos = matStartRep.group(1);
                count = matStartRep.group(2);
            }
            Matcher matEndRep = Pattern.compile("\\[(-(\\w)-)?([\\d?/]+)\\)").matcher(this.nodeIndex.get(endRep));
            childPos = childPos != null ? childPos : "?";
            parentPos = "?";
            Edge repeatEdge = new Edge();
            Linkage repeatLin = new Linkage();
            if (!matEndRep.find()) continue;
            if (matEndRep.group(3) != null) {
                parentPos = matEndRep.group(3);
            }
            repeatLin.setChildLinkages(this.makeLinkageList(childPos));
            repeatLin.setParentLinkages(this.makeLinkageList(parentPos));
            repeatEdge.addGlycosidicLinkage(repeatLin);
            BaseCrossLinkedTemplate subface = null;
            if (matEndRep.group(2) != null) {
                subface = BaseCrossLinkedTemplate.forIUPACNotation(matEndRep.group(2));
            }
            GlycanRepeatModification repMod = new GlycanRepeatModification(subface);
            repMod.setFirstPosition(new Linkage());
            repMod.setSecondPosition(new Linkage());
            String[] repCount = count.split("-");
            String min = "n";
            String max = "n";
            min = repCount[0];
            if (repCount.length == 2) {
                max = repCount[1];
            }
            repMod.setMaxRepeatCount(max.equals("n") ? -1 : Integer.parseInt(max));
            repMod.setMinRepeatCount(min.equals("n") ? -1 : Integer.parseInt(min));
            repeatEdge.setSubstituent(repMod);
            repMod.addParentEdge(repeatEdge);
            this.glyCo.addNode(endRep, repeatEdge, _node);
        }
        if (_parent != null) {
            Matcher matParent;
            Edge parentEdge = new Edge();
            Linkage lin = new Linkage();
            if (_repOutParent != null && (matParent = Pattern.compile("([\\d?])(-([(\\w)]+))?[-\u2192\u2194]([\\d?/]+)\\)").matcher(_repOutParent)).find()) {
                childPos = matParent.group(1);
                parentPos = matParent.group(4);
                BaseCrossLinkedTemplate subface = null;
                if (matParent.group(3) != null) {
                    subface = BaseCrossLinkedTemplate.forIUPACNotation(matParent.group(3));
                    Substituent bridge = new Substituent(subface, new Linkage(), new Linkage());
                    parentEdge.setSubstituent(bridge);
                    bridge.addParentEdge(parentEdge);
                }
            }
            lin.setChildLinkages(this.makeLinkageList(childPos));
            lin.setParentLinkages(this.makeLinkageList(parentPos));
            parentEdge.addGlycosidicLinkage(lin);
            this.glyCo.addNode(_parent, parentEdge, _node);
        }
    }

    private void parseCyclic(Node _node, Node _startCyclic) throws GlycanException {
        String start = this.nodeIndex.get(_startCyclic);
        String current = this.nodeIndex.get(_node).replace("]-", "");
        String childPos = start.substring(start.length() - 2, start.length() - 1);
        Linkage lin = new Linkage();
        lin.addChildLinkage(childPos.equals("?") ? -1 : Integer.parseInt(childPos));
        String child = "";
        int i = 0;
        while (i < current.length()) {
            char uni = current.charAt(i);
            if (uni == ')') break;
            if (String.valueOf(uni).matches("\\d")) {
                child = String.valueOf(child) + uni;
            }
            ++i;
        }
        lin.setParentLinkages(this.makeLinkageList(child));
        Edge cyclicEdge = new Edge();
        cyclicEdge.addGlycosidicLinkage(lin);
        GlycanRepeatModification repMod = new GlycanRepeatModification(null);
        repMod.setMaxRepeatCount(1);
        repMod.setMinRepeatCount(1);
        cyclicEdge.setSubstituent(repMod);
        this.glyCo.addNode(_node, cyclicEdge, _startCyclic);
    }

    private String extractLinkageNotation(String _linkage) {
        if (_linkage.indexOf("-(") == -1) {
            return "";
        }
        if ((_linkage = _linkage.substring(_linkage.indexOf("-(") + 1, _linkage.length())).matches("^\\(.+")) {
            _linkage = _linkage.substring(1, _linkage.length());
        }
        if (_linkage.lastIndexOf(")") != -1) {
            _linkage = _linkage.substring(0, _linkage.lastIndexOf(")"));
        }
        return _linkage;
    }

    private ArrayList<Node> getEndRepeatingNode(Node _node) {
        int size = new ArrayList<Node>(this.nodeIndex.keySet()).indexOf(_node) + 1;
        ArrayList<Node> nodes = this.stacker.getNodes();
        List<Node> subNodes = nodes.subList(0, size);
        Collections.reverse(subNodes);
        ArrayList<Node> ret = this.countRepeats(subNodes);
        if (ret.isEmpty()) {
            ret = this.countRepeats(this.stacker.getNodes().subList(this.stacker.getNodes().indexOf(_node), this.stacker.getNodes().size()));
        }
        return ret;
    }

    private ArrayList<Node> countRepeats(Collection<Node> _nodes) {
        int numOfstart = 0;
        String regex = "\\[(-[\\w()]+-)?[\\d\\?/]+\\)";
        Node ret = null;
        ArrayList<Node> retNodes = new ArrayList<Node>();
        Node start = new ArrayList<Node>(_nodes).get(0);
        TreeMap<Integer, String> repPos = this.extractMultipleRepStart(start);
        block0: for (Integer key : repPos.keySet()) {
            numOfstart = key;
            for (Node node : _nodes) {
                String notation = this.nodeIndex.get(node);
                if (!this.isStartRep(notation) && !this.isEndRep(notation)) continue;
                if (this.isStartRep(notation) && !node.equals(start)) {
                    numOfstart += this.extractMultipleRepStart(node).size();
                }
                Matcher matEndRep = Pattern.compile(regex).matcher(notation);
                while (matEndRep.find()) {
                    String repStatus = matEndRep.group(0);
                    if (this.isEndRep(String.valueOf(repStatus) + "-")) {
                        if (numOfstart != 0) {
                            --numOfstart;
                        }
                        if (numOfstart == 0) {
                            ret = node;
                            retNodes.add(node);
                            break;
                        }
                    }
                    notation = notation.replaceFirst(regex, "");
                    matEndRep = Pattern.compile(regex).matcher(notation);
                }
                if (numOfstart == 0) continue block0;
            }
        }
        return retNodes;
    }

    private TreeMap<Integer, String> extractMultipleRepStart(Node _node) {
        String repStart = this.nodeIndex.get(_node);
        TreeMap<Integer, String> repPosMap = new TreeMap<Integer, String>();
        int key = 1;
        String[] stringArray = repStart.substring(repStart.indexOf("-(") + 2, repStart.length()).split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            if (this.isStartRep(pos)) {
                repPosMap.put(key, pos);
                ++key;
            }
            ++n2;
        }
        return repPosMap;
    }

    private Node getStartRepeatingNode(Node _node) {
        int start;
        Node ret = null;
        int i = start = new ArrayList<Node>(this.nodeIndex.keySet()).indexOf(_node);
        while (i < this.nodeIndex.size()) {
            if (this.isStartRep(this.stacker.getNotationByIndex(i))) {
                ret = this.getIndex(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    private Node getIndex(int _ind) {
        return this.stacker.getNodeByIndex(_ind);
    }

    private boolean isEndCyclic(String _notation) {
        if (_notation.indexOf("]-") == 0) {
            _notation = _notation.substring(2, _notation.length());
        }
        if (_notation.indexOf("-") == 0) {
            _notation = _notation.substring(1, _notation.length());
        }
        return _notation.matches("^\\d\\).+");
    }

    private boolean isStartRep(String _notation) {
        return _notation.matches(".*\\(*[\\d?]+[\u2192-]][\\w\\d].*$");
    }

    private boolean isEndRep(String _notation) {
        return _notation.matches("^.*\\[(-\\w-)?[\\d?/]+\\).+");
    }

    private boolean isRootOfFramgnets(String _notation) {
        if (_notation.lastIndexOf("$,") != -1) {
            return true;
        }
        return _notation.lastIndexOf("$") == _notation.length() - 1;
    }

    private LinkedList<Integer> makeLinkageList(String _pos) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        String[] stringArray = _pos.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            if (pos.equals("?")) {
                ret.addLast(-1);
            } else {
                ret.addLast(Integer.parseInt(pos));
            }
            ++n2;
        }
        return ret;
    }
}

