/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACStacker;

public class IUPACCondensedLinkageParser {
    private HashMap<Node, String> nodeIndex;
    private GlyContainer glyCo;
    private IUPACStacker stacker;

    public IUPACCondensedLinkageParser(GlyContainer _glyCo, HashMap<Node, String> _nodeIndex, IUPACStacker _stacker) {
        this.nodeIndex = _nodeIndex;
        this.glyCo = _glyCo;
        this.stacker = _stacker;
    }

    public GlyContainer start() throws GlycanException {
        GlycanUndefinedUnit undef = new GlycanUndefinedUnit();
        for (Node node : this.stacker.getNodes()) {
            if (node instanceof Substituent) {
                this.parseSubstituent(node);
                continue;
            }
            this.parseLinkage(node);
            String notation = this.nodeIndex.get(node);
            if (this.glyCo.containsNode(node)) continue;
            if (undef != null && !undef.containsNode(node)) {
                this.glyCo.addNode(node);
            }
            if (undef != null) continue;
            this.glyCo.addNode(node);
        }
        return this.glyCo;
    }

    private void parseSubstituent(Node _node) throws GlycanException {
        Edge edge = new Edge();
        Node acceptor = this.stacker.getParent(_node);
        edge.setSubstituent(_node);
        edge.setParent(acceptor);
        acceptor.addChildEdge(edge);
        _node.addParentEdge(edge);
        edge.addGlycosidicLinkage(((Substituent)_node).getFirstPosition());
    }

    private void parseLinkage(Node _node) throws GlycanException {
        String notation = this.nodeIndex.get(_node);
        Node acceptor = this.stacker.getParent(_node);
        this.parseSimpleLinkage(_node, acceptor, notation);
    }

    private void parseSimpleLinkage(Node _donor, Node _acceptor, String _notation) throws GlycanException {
        String linkNotation = this.extractLinkage(_notation);
        if (linkNotation.equals("") || linkNotation.equals("-")) {
            return;
        }
        String[] stringArray = linkNotation.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            Matcher matPos = Pattern.compile("([\\d?])-(.+)").matcher(unit);
            if (matPos.find()) {
                Edge edge = new Edge();
                Linkage linkage = new Linkage();
                linkage.addChildLinkage(this.charToInt(matPos.group(1)));
                String[] stringArray2 = matPos.group(2).split("/");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pos = stringArray2[n4];
                    linkage.addParentLinkage(this.charToInt(pos));
                    ++n4;
                }
                edge.addGlycosidicLinkage(linkage);
                this.glyCo.addNode(_acceptor, edge, _donor);
            }
            ++n2;
        }
    }

    private String extractLinkage(String _notation) {
        String ret = "";
        ret = _notation.replaceAll("\\(", "").replaceAll("\\)", "");
        Matcher matPos = Pattern.compile(".+[ab?](.+)").matcher(ret);
        if (matPos.find()) {
            return matPos.group(1);
        }
        return "";
    }

    private int charToInt(String _position) {
        if (_position.equals("?")) {
            return -1;
        }
        return Integer.parseInt(_position);
    }
}

