/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.sample.dialog.AddDescriptorDialog;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.action.AbstractTreeTableAction;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorAction
extends AbstractTreeTableAction {
    private List<Descriptor> availableDescriptors = null;

    @Override
    protected void setUp() {
        this.setText("Add Descriptor");
        this.setToolTipText("Add a new Descriptor");
        this.setImageDescriptor(ImageShare.ADD_ICON);
    }

    private void loadAvailableDescriptorsForCategory() {
        this.availableDescriptors = new ArrayList<Descriptor>();
        String categoryUri = ((Category)this.treeViewer.getInput()).getUri();
        this.availableDescriptors = this.sampleOntologyApi.getCategoryDescriptors(categoryUri);
    }

    private void loadAvailableDescriptorsForTable() {
        this.availableDescriptors = new ArrayList<Descriptor>();
        List<Descriptor> allDescriptors = this.sampleOntologyApi.getAllDescriptors();
        for (Descriptor desc : allDescriptors) {
            desc.setMaxOccurrence(null);
        }
        this.availableDescriptors.addAll(allDescriptors);
    }

    public void run() {
        if (this.treeViewer != null) {
            this.loadAvailableDescriptorsForCategory();
            if (!this.availableDescriptors.isEmpty()) {
                AddDescriptorDialog descriptorDialog = new AddDescriptorDialog(Display.getCurrent().getActiveShell(), this.availableDescriptors);
                if (descriptorDialog.open() == 0) {
                    Category category = (Category)this.treeViewer.getInput();
                    List<Descriptor> descriptors = category.getDescriptors();
                    Descriptor newDescriptor = descriptorDialog.getDescriptor().getACopy();
                    int action = this.occurenceLessThanMaxAndTemplate(descriptors, newDescriptor);
                    switch (action) {
                        case 1: {
                            descriptors.add(newDescriptor);
                            this.treeViewer.refresh();
                            this.dirtyable.setDirty(true);
                            break;
                        }
                        case 0: {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Add Descriptor Denied", (String)("You cannot add this descriptor \"" + newDescriptor.getLabel() + "\" more than its max occurence \"" + newDescriptor.getMaxOccurrence() + "\""));
                            break;
                        }
                        case -1: {
                            descriptors.add(newDescriptor);
                            this.treeViewer.refresh();
                            this.dirtyable.setDirty(true);
                            this.component.setTemplateUri(null);
                            this.eventBroker.post("component_modified_in_a_tab", (Object)this.component);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                this.showInfo("No Descriptor Available", "There are no available descriptors for this category. Try adding descriptor group.");
            }
        } else if (this.tableViewer != null) {
            this.loadAvailableDescriptorsForTable();
            if (!this.availableDescriptors.isEmpty()) {
                AddDescriptorDialog descriptorDialog = new AddDescriptorDialog(Display.getCurrent().getActiveShell(), this.availableDescriptors);
                if (descriptorDialog.open() == 0) {
                    DescriptorGroup selectedDescriptorGroup = (DescriptorGroup)this.tableViewer.getInput();
                    ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(selectedDescriptorGroup.getMandatoryDescriptors());
                    descriptors.addAll(selectedDescriptorGroup.getOptionalDescriptors());
                    Descriptor newDescriptor = descriptorDialog.getDescriptor().getACopy();
                    if (this.occurenceLessThanMax(descriptors, newDescriptor)) {
                        DescriptorGroup descriptorGroupFromOntology = this.sampleOntologyApi.getDescriptorGroup(selectedDescriptorGroup.getUri());
                        boolean added = false;
                        for (Descriptor desc : descriptorGroupFromOntology.getMandatoryDescriptors()) {
                            if (!desc.getUri().equals(newDescriptor.getUri())) continue;
                            selectedDescriptorGroup.addMandatoryDescriptor(desc);
                            added = true;
                            break;
                        }
                        if (!added) {
                            selectedDescriptorGroup.addOptionalDescriptor(newDescriptor);
                        }
                        this.tableViewer.refresh();
                    } else {
                        this.showInfo("Add Descriptor Denied", "You cannot add this descriptor \"" + newDescriptor.getLabel() + "\" more than its max occurence \"" + newDescriptor.getMaxOccurrence() + "\"");
                    }
                }
            } else {
                this.showInfo("No Descriptor Available", "There are no available descriptors for this group");
            }
        }
    }

    private int occurenceLessThanMaxAndTemplate(List<Descriptor> prevDescriptors, Descriptor newDescriptor) {
        CategoryTemplate categoryTamplate = ((CategoryTreeContentProvider)this.treeViewer.getContentProvider()).getCategoryTemplate();
        boolean isInTemplate = true;
        if (categoryTamplate != null) {
            isInTemplate = false;
            List<Descriptor> descriptors = UtilityDescriptorDescriptorGroup.getAllDescriptors(categoryTamplate);
            for (Descriptor desc : descriptors) {
                if (!desc.getUri().equals(newDescriptor.getUri())) continue;
                newDescriptor.setMaxOccurrence(desc.getMaxOccurrence());
                isInTemplate = true;
                break;
            }
        }
        int templateValue = 0;
        if (!isInTemplate) {
            int n = templateValue = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Remove Template", (String)("This Descriptor \"" + newDescriptor.getLabel() + "\" is not allowed in the template \"" + categoryTamplate.getTemplateURI() + "\". Do you want to remove the template?")) ? -1 : -2;
        }
        if (templateValue >= -1) {
            int maxOccurrenceIsRight = 1;
            if (newDescriptor.getMaxOccurrence() != null) {
                int prevOccurence = 0;
                for (Descriptor prevDescriptor : prevDescriptors) {
                    if (!prevDescriptor.getUri().equals(newDescriptor.getUri())) continue;
                    ++prevOccurence;
                }
                maxOccurrenceIsRight = templateValue == 0 ? (prevOccurence < newDescriptor.getMaxOccurrence() ? 1 : 0) : (prevOccurence < newDescriptor.getMaxOccurrence() ? -1 : 0);
                return maxOccurrenceIsRight;
            }
            return templateValue == 0 ? 1 : -1;
        }
        return -2;
    }

    private void showInfo(String error, String message) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)error, (String)message);
    }

    private boolean occurenceLessThanMax(List<Descriptor> prevDescriptors, Descriptor newDescriptor) {
        if (newDescriptor.getMaxOccurrence() != null) {
            int prevOccurence = 0;
            for (Descriptor prevDescriptor : prevDescriptors) {
                if (!prevDescriptor.getUri().equals(newDescriptor.getUri())) continue;
                ++prevOccurence;
            }
            return prevOccurence < newDescriptor.getMaxOccurrence();
        }
        return true;
    }
}

