/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.UtilityPreference;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;
import org.jdom.Element;

public class KeywordPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(KeywordPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.preference.archive.keyword";
    public static final String PREFERENCE_NAME_ALL = String.valueOf(KeywordPreference.class.getName()) + ".all";
    private static final String DEFAULT_PREFERENCE_FILE = "keyword_preference.xml";
    private static final String NEW_KEYWORD_PREFIX = "New Keyword ";
    private static int newKeywordCount = 0;
    public static Set<String> DEFAULT_KEYWORDS = null;
    public static Set<String> OTHER_KEYWORDS = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    public static void loadPreferences() {
        DEFAULT_KEYWORDS = new HashSet<String>();
        OTHER_KEYWORDS = new HashSet<String>();
        newKeywordCount = 0;
        boolean loaded = false;
        try {
            try {
                PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
                if (preferenceEntity != null) {
                    KeywordPreference.addToSet(UtilityPreferenceValue.getPreferenceValuesWithSelection((PreferenceEntity)preferenceEntity));
                    loaded = true;
                } else {
                    loaded = KeywordPreference.loadValuesPreVersioning();
                }
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                loaded = KeywordPreference.loadValuesPreVersioning();
            }
            if (!loaded) {
                KeywordPreference.addToSet(PreferenceHandler.getPreferenceValues((String)DEFAULT_PREFERENCE_FILE));
                KeywordPreference.saveValues();
            }
            KeywordPreference.updateKeywordCount();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the Preference variable for Default Keywords", (Throwable)ex);
        }
    }

    private static boolean loadValuesPreVersioning() {
        boolean loaded = false;
        String previousPrefName = String.valueOf(KeywordPreference.class.getName()) + ".default";
        Element prefElement = PreferenceReader.getPreferenceElement((String)previousPrefName);
        if (prefElement == null) {
            prefElement = PreferenceReader.getPreferenceElement((String)("class " + previousPrefName));
        }
        if (prefElement != null) {
            KeywordPreference.addToSet(UtilityPreferenceValue.getPreversioningValues((Element)prefElement), true);
            KeywordPreference.saveValues();
            PreferenceWriter.deletePreference((String)previousPrefName);
            loaded = true;
        }
        if ((prefElement = PreferenceReader.getPreferenceElement((String)(previousPrefName = String.valueOf(KeywordPreference.class.getName()) + ".other"))) == null) {
            prefElement = PreferenceReader.getPreferenceElement((String)("class " + previousPrefName));
        }
        if (prefElement != null) {
            KeywordPreference.addToSet(UtilityPreferenceValue.getPreversioningValues((Element)prefElement), false);
            KeywordPreference.saveValues();
            PreferenceWriter.deletePreference((String)previousPrefName);
            loaded = true;
        }
        return loaded;
    }

    private static void addToSet(Map<String, Boolean> preferenceValuesWithSelection) {
        for (String keyword : preferenceValuesWithSelection.keySet()) {
            if (preferenceValuesWithSelection.get(keyword).booleanValue()) {
                DEFAULT_KEYWORDS.add(keyword);
                continue;
            }
            OTHER_KEYWORDS.add(keyword);
        }
    }

    private static void addToSet(Set<String> preferenceXmlValues, boolean selected) {
        Set<String> projectKeywords = selected ? DEFAULT_KEYWORDS : OTHER_KEYWORDS;
        for (String keyword : preferenceXmlValues) {
            projectKeywords.add(keyword);
        }
    }

    private static void updateKeywordCount() {
        HashSet<String> keywords = new HashSet<String>();
        keywords.addAll(DEFAULT_KEYWORDS);
        keywords.addAll(OTHER_KEYWORDS);
        for (String action : keywords) {
            if (!action.startsWith(NEW_KEYWORD_PREFIX)) continue;
            String lastPart = action.substring(NEW_KEYWORD_PREFIX.length());
            try {
                int num = Integer.parseInt(lastPart);
                newKeywordCount = Math.max(newKeywordCount, num);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected Control createContents(Composite parent) {
        KeywordPreference.loadPreferences();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Keywords");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createKeywordsTableViewer(container);
        this.initializeValues(OTHER_KEYWORDS, DEFAULT_KEYWORDS);
        Button addButton = new Button(container, 0);
        addButton.setText("Add");
        GridData addButtonData = new GridData(128);
        addButtonData.widthHint = 80;
        addButtonData.verticalSpan = 1;
        addButtonData.grabExcessHorizontalSpace = true;
        addButtonData.verticalAlignment = 2;
        addButtonData.grabExcessVerticalSpace = true;
        addButton.setLayoutData((Object)addButtonData);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List keywords = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                StringBuilder stringBuilder = new StringBuilder(KeywordPreference.NEW_KEYWORD_PREFIX);
                int n = newKeywordCount + 1;
                newKeywordCount = n;
                String newKeyword = stringBuilder.append(n).toString();
                keywords.add(newKeyword);
                KeywordPreference.this.checkboxTableViewer.refresh();
                int addingIndex = 0;
                int i = 0;
                for (String k : keywords) {
                    if (k.equals(newKeyword)) {
                        addingIndex = i;
                    }
                    ++i;
                }
                KeywordPreference.this.tableColumn2.getViewer().editElement(KeywordPreference.this.checkboxTableViewer.getElementAt(addingIndex), 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = new Button(container, 0);
        removeButton.setText("Remove");
        GridData removeButtonData = new GridData(128);
        removeButtonData.widthHint = 80;
        removeButtonData.verticalSpan = 1;
        removeButtonData.verticalAlignment = 2;
        addButtonData.grabExcessVerticalSpace = true;
        removeButton.setLayoutData((Object)removeButtonData);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List keywords = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                int selectionIndex = KeywordPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < keywords.size()) {
                    String selectedKeyword = (String)KeywordPreference.this.checkboxTableViewer.getElementAt(selectionIndex);
                    Object[] defKeywords = KeywordPreference.this.checkboxTableViewer.getCheckedElements();
                    keywords.remove(selectedKeyword);
                    KeywordPreference.this.checkboxTableViewer.refresh();
                    if (keywords.size() > 0) {
                        selectionIndex = Math.max(selectionIndex - 1, 0);
                        KeywordPreference.this.checkboxTableViewer.getTable().select(selectionIndex);
                        KeywordPreference.this.checkboxTableViewer.setSelection(KeywordPreference.this.checkboxTableViewer.getSelection());
                    }
                    KeywordPreference.this.checkboxTableViewer.setCheckedElements(defKeywords);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    private void initializeValues(Set<String> otherKeywords, Set<String> defaultKeywords) {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(otherKeywords);
        keywords.addAll(defaultKeywords);
        Collections.sort(keywords, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(keywords);
        Object[] defKeywords = new String[defaultKeywords.size()];
        int i = 0;
        for (String keyword : defaultKeywords) {
            defKeywords[i++] = keyword;
        }
        this.checkboxTableViewer.setCheckedElements(defKeywords);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createKeywordsTableViewer(Composite container) {
        Table keywordsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        keywordsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(keywordsTable, "Default");
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Keywords");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    List input = (List)KeywordPreference.this.checkboxTableViewer.getInput();
                    for (String ele : input) {
                        if (!ele.equals(element)) continue;
                        input.set(input.indexOf(ele), ((String)value).trim());
                        break;
                    }
                    KeywordPreference.this.checkboxTableViewer.setInput((Object)input);
                    KeywordPreference.this.checkboxTableViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof String) {
                    if (this.textEditor == null) {
                        this.textEditor = new TextCellEditor((Composite)KeywordPreference.this.checkboxTableViewer.getTable());
                    }
                    return this.textEditor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex > 0 && element instanceof String) {
                    return (String)element;
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        HashMap keywordsMap = PreferenceHandler.getPreferenceValues((String)DEFAULT_PREFERENCE_FILE);
        HashSet<String> otherKeywords = new HashSet<String>();
        HashSet<String> defaultKeywords = new HashSet<String>();
        for (String keyword : keywordsMap.keySet()) {
            if (((Boolean)keywordsMap.get(keyword)).booleanValue()) {
                defaultKeywords.add(keyword);
                continue;
            }
            otherKeywords.add(keyword);
        }
        this.initializeValues(otherKeywords, defaultKeywords);
        super.performDefaults();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        String invalidMessage = this.validateInput();
        this.setErrorMessage(invalidMessage);
        if (invalidMessage == null) {
            this.save();
            return true;
        }
        return false;
    }

    private String validateInput() {
        String invalidMessage = null;
        List tableInput = (List)this.checkboxTableViewer.getInput();
        HashSet uniqueKeywords = new HashSet();
        uniqueKeywords.addAll(tableInput);
        invalidMessage = uniqueKeywords.size() == tableInput.size() ? invalidMessage : "Non-unique Keywords";
        return invalidMessage;
    }

    private void save() {
        List tableInput = (List)this.checkboxTableViewer.getInput();
        DEFAULT_KEYWORDS = new HashSet<String>();
        OTHER_KEYWORDS = new HashSet<String>();
        for (String keyword : tableInput) {
            if (this.checkboxTableViewer.getChecked((Object)keyword)) {
                DEFAULT_KEYWORDS.add(keyword);
                continue;
            }
            OTHER_KEYWORDS.add(keyword);
        }
        KeywordPreference.saveValues();
        UtilityPreference.updateUIs(Arrays.asList(PREFERENCE_NAME_ALL));
    }

    public static boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setValue(UtilityPreferenceValue.getPreferenceValueString(DEFAULT_KEYWORDS, OTHER_KEYWORDS));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }
}

