/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.SelectKeywordsDialog;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.AbstractArchivePage;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.DeleteArchivedFile;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.DownloadFile;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.DownloadFilesAsZip;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.RenameArchivedFile;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.UpdateArchivedFile;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.UploadArchivedFile;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.ArchivedFileColumnComparatorListener;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.ArchivedFileViewerComparator;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.SortFileNames;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.model.DocumentType;
import org.grits.toolbox.entry.archive.preference.KeywordPreference;
import org.grits.toolbox.entry.archive.preference.doctype.DocTypePreference;
import org.grits.toolbox.entry.archive.utility.DocumentTypeLabelComparator;
import org.grits.toolbox.entry.archive.utility.DocumentTypeLabelProvider;
import org.grits.toolbox.entry.archive.utility.UtilityFileName;

public class FileArchivePage
extends AbstractArchivePage {
    private Logger logger = Logger.getLogger(FileArchivePage.class);
    public static final HashMap<String, Image> FILE_ICON_MAP = new HashMap();
    public static final String ID = "0";
    public static final String PAGE_TITLE = "File   ";
    private static final Image UNKNOWN_ICON = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.UNKNOWN_ICON).createImage();
    private ArchivedFile selectedArchivedFile = null;
    private ArrayList<Action> leftSectionActions = null;
    private Composite rightSideComposite = null;
    private Text descriptionText = null;
    private ComboViewer documentTypeCombo = null;
    private ComboViewer documentSubTypeCombo = null;
    private ComboViewer personCombo = null;
    private CDateTime cDateTime = null;
    private Text dateModifiedText = null;
    private Text keywordsText = null;
    private Button changeKeywordButton = null;
    private boolean oldSelection = true;
    private SelectKeywordsDialog selectKeywordsDialog = null;
    private SortFileNames sortByName;
    @Inject
    private EMenuService menuService;

    public Boolean isOldSelection() {
        return this.oldSelection;
    }

    @Inject
    public FileArchivePage(ArchiveEntryEditor archiveEntryEditor, CTabItem cTabItem) {
        super(archiveEntryEditor, cTabItem);
    }

    private ArchiveEntryEditor getArchiveEntryEditor() {
        return this.getEditor();
    }

    public ArchivedFile getSelectedArchivedFile() {
        return this.selectedArchivedFile;
    }

    @Override
    public void createRestOftheContent() {
        this.logger.debug((Object)"- START : Creating remaining part for the ArchivedFile page.");
        try {
            this.rightSideComposite = new Composite((Composite)this.getRightSectionOfPage(), 0);
            GridLayout rightSideCompositeLayout = new GridLayout();
            rightSideCompositeLayout.verticalSpacing = 30;
            rightSideCompositeLayout.horizontalSpacing = 10;
            rightSideCompositeLayout.numColumns = 4;
            rightSideCompositeLayout.makeColumnsEqualWidth = false;
            this.rightSideComposite.setLayout((Layout)rightSideCompositeLayout);
            this.documentTypeCombo = this.createComboLine("Document Type", 1);
            DocTypePreference.loadPreferences();
            DocumentType[] documentTypes = this.getSortedDocumentFromList(new ArrayList<DocumentType>(DocTypePreference.ALL_DOCUMENT_TYPES));
            this.documentTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.documentTypeCombo.setLabelProvider((IBaseLabelProvider)new DocumentTypeLabelProvider());
            this.documentTypeCombo.setInput((Object)documentTypes);
            if (DocTypePreference.DEFAULT_DOCUMENT_TYPE != null) {
                this.resetDocumentType(DocTypePreference.DEFAULT_DOCUMENT_TYPE.clone());
            }
            this.documentSubTypeCombo = this.createComboLine("     Sub Type", 1);
            this.documentSubTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            if (DocTypePreference.DEFAULT_DOCUMENT_TYPE != null) {
                String[] documentSubTypes = this.getSortedArrayFromList(new ArrayList<String>(DocTypePreference.DEFAULT_DOCUMENT_TYPE.getSubTypes()));
                this.documentSubTypeCombo.setInput((Object)documentSubTypes);
                this.resetDocumentSubType(DocTypePreference.DEFAULT_DOCUMENT_TYPE, DocTypePreference.DEFAULT_DOCUMENT_TYPE.getSelectedSubType());
            }
            this.documentTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (FileArchivePage.this.selectedArchivedFile != null && FileArchivePage.this.documentTypeCombo.getCombo().getSelectionIndex() >= 0) {
                        DocumentType documentType = (DocumentType)FileArchivePage.this.documentTypeCombo.getElementAt(FileArchivePage.this.documentTypeCombo.getCombo().getSelectionIndex());
                        if (FileArchivePage.this.documentTypeCombo.getCombo().getSelectionIndex() == 0) {
                            if (FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType() != null) {
                                FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().setDocumentType(null);
                                FileArchivePage.this.documentSubTypeCombo.setInput((Object)FileArchivePage.this.getSortedArrayFromList(new ArrayList<String>(documentType.getSubTypes())));
                                FileArchivePage.this.resetDocumentSubType(documentType, "  --  No Selection -- ");
                                FileArchivePage.this.pageEdited();
                            }
                        } else if (FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType() == null || !Objects.equals(FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().getLabel(), documentType.getLabel())) {
                            FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().setDocumentType(documentType.clone());
                            FileArchivePage.this.documentSubTypeCombo.setInput((Object)FileArchivePage.this.getSortedArrayFromList(new ArrayList<String>(documentType.getSubTypes())));
                            FileArchivePage.this.resetDocumentSubType(documentType, documentType.getSelectedSubType());
                            FileArchivePage.this.pageEdited();
                        }
                    }
                }
            });
            this.documentSubTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (FileArchivePage.this.selectedArchivedFile != null && FileArchivePage.this.documentSubTypeCombo.getCombo().getSelectionIndex() >= 0) {
                        String documentSubType = FileArchivePage.this.documentSubTypeCombo.getCombo().getItem(FileArchivePage.this.documentSubTypeCombo.getCombo().getSelectionIndex());
                        if (FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType() != null && !Objects.equals(FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().getSelectedSubType(), documentSubType)) {
                            FileArchivePage.this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().setSelectedSubType(documentSubType);
                            FileArchivePage.this.pageEdited();
                        }
                    }
                }
            });
            this.personCombo = this.createComboLine("Person", 3);
            this.personCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    String person;
                    if (FileArchivePage.this.selectedArchivedFile != null && FileArchivePage.this.personCombo.getCombo().getSelectionIndex() >= 0 && !Objects.equals(person = FileArchivePage.this.personCombo.getCombo().getItem(FileArchivePage.this.personCombo.getCombo().getSelectionIndex()), FileArchivePage.this.selectedArchivedFile.getPerson())) {
                        FileArchivePage.this.selectedArchivedFile.setPerson(person);
                        FileArchivePage.this.pageEdited();
                    }
                }
            });
            SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
            ArrayList<String> personList = new ArrayList<String>();
            personList.addAll(personPreference.getAllValues());
            String[] persons = this.getSortedArrayFromList(personList);
            this.personCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.personCombo.setInput((Object)persons);
            this.createLabel("Date");
            this.cDateTime = new CDateTime(this.rightSideComposite, 3);
            this.cDateTime.setPattern("MM/dd/yyyy");
            GridData textGridData = new GridData();
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.horizontalAlignment = 4;
            textGridData.minimumWidth = 100;
            textGridData.horizontalSpan = 1;
            this.cDateTime.setLayoutData((Object)textGridData);
            this.cDateTime.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.changeDate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.changeDate();
                }

                private void changeDate() {
                    Date date;
                    if (FileArchivePage.this.selectedArchivedFile != null && !Objects.equals(date = FileArchivePage.this.cDateTime.getSelection(), FileArchivePage.this.selectedArchivedFile.getSetDate())) {
                        FileArchivePage.this.selectedArchivedFile.setSetDate(date);
                        FileArchivePage.this.pageEdited();
                    }
                }
            });
            this.dateModifiedText = this.createLineForLabel("Last Modified", 80, 2048, 100, -1, 1);
            this.dateModifiedText.setEnabled(false);
            this.descriptionText = this.createLineForLabel("Description", 10000, 2624, 580, 250, 3);
            this.descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String description;
                    if (FileArchivePage.this.selectedArchivedFile != null && !Objects.equals(description = FileArchivePage.this.descriptionText.getText().trim(), FileArchivePage.this.selectedArchivedFile.getDescription())) {
                        FileArchivePage.this.selectedArchivedFile.setDescription(description);
                        FileArchivePage.this.pageEdited();
                    }
                }
            });
            this.keywordsText = this.createLineForLabel("Keywords", 10000, 2112, 580, 100, 3);
            this.keywordsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FileArchivePage.this.pageEdited();
                }
            });
            this.keywordsText.setEnabled(false);
            this.changeKeywordButton = new Button(this.rightSideComposite, 8);
            this.changeKeywordButton.setText("Modify Keywords");
            this.changeKeywordButton.setEnabled(false);
            GridData buttonData = new GridData();
            buttonData.widthHint = 200;
            buttonData.horizontalAlignment = 0x1000000;
            buttonData.horizontalSpan = 4;
            this.changeKeywordButton.setLayoutData((Object)buttonData);
            KeywordPreference.loadPreferences();
            ArrayList<String> keywords = new ArrayList<String>();
            keywords.addAll(KeywordPreference.DEFAULT_KEYWORDS);
            keywords.addAll(KeywordPreference.OTHER_KEYWORDS);
            Collections.sort(keywords, String.CASE_INSENSITIVE_ORDER);
            this.changeKeywordButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (FileArchivePage.this.selectedArchivedFile != null) {
                        this.selectKeywords();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (FileArchivePage.this.selectKeywordsDialog.open() == 0) {
                        this.selectKeywords();
                    }
                }

                private void selectKeywords() {
                    HashSet<String> allKeywords = new HashSet<String>();
                    KeywordPreference.loadPreferences();
                    allKeywords.addAll(KeywordPreference.DEFAULT_KEYWORDS);
                    allKeywords.addAll(KeywordPreference.OTHER_KEYWORDS);
                    FileArchivePage.this.selectKeywordsDialog = new SelectKeywordsDialog(Display.getCurrent().getActiveShell(), allKeywords);
                    FileArchivePage.this.selectKeywordsDialog.setSelectedKeyWords(FileArchivePage.this.selectedArchivedFile.getKeywords());
                    if (FileArchivePage.this.selectKeywordsDialog.open() == 0) {
                        FileArchivePage.this.selectedArchivedFile.setKeywords(FileArchivePage.this.selectKeywordsDialog.getSelectedKeywords());
                        FileArchivePage.this.keywordsText.setText(FileArchivePage.this.getCSKeywords(FileArchivePage.this.selectKeywordsDialog.getSelectedKeywords()));
                    }
                }
            });
            this.rightSideComposite.setLayoutData((Object)new TableWrapData(256));
            this.getRightSectionOfPage().setClient((Control)this.rightSideComposite);
            this.clearAll();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Creating remaining part for the ArchivedFile page.");
    }

    public void pageEdited() {
        if (this.selectedArchivedFile != null && this.oldSelection) {
            this.selectedArchivedFile.setModifiedDate(new Date());
            this.getArchiveEntryEditor().markDirty();
        }
    }

    protected String getCSKeywords(Set<String> keywordSet) {
        String keywords = "";
        String separator = ", ";
        for (String keyword : keywordSet) {
            if (keyword.isEmpty()) continue;
            keywords = String.valueOf(keywords) + keyword + separator;
        }
        if (!keywords.isEmpty()) {
            keywords = keywords.substring(0, keywords.length() - separator.length());
        }
        return keywords;
    }

    private DocumentType[] getSortedDocumentFromList(List<DocumentType> arrayList) {
        Collections.sort(arrayList, new DocumentTypeLabelComparator());
        DocumentType[] arrayOfValue = new DocumentType[arrayList.size() + 1];
        DocumentType documentType = new DocumentType();
        documentType.setLabel("  --  No Selection -- ");
        documentType.setSubTypes(new HashSet<String>(Arrays.asList("  --  No Selection -- ")));
        arrayOfValue[0] = documentType;
        int i = 1;
        Iterator<DocumentType> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DocumentType value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    private String[] getSortedArrayFromList(List<String> listOfValues) {
        Collections.sort(listOfValues);
        String[] arrayOfValue = new String[listOfValues.size()];
        int i = 0;
        if (!listOfValues.contains("  --  No Selection -- ")) {
            arrayOfValue = new String[listOfValues.size() + 1];
            arrayOfValue[0] = "  --  No Selection -- ";
            i = 1;
        }
        Iterator<String> iterator = listOfValues.iterator();
        while (iterator.hasNext()) {
            String value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    private ComboViewer createComboLine(String label, int horizontalSpan) {
        Label labelLabel = new Label(this.rightSideComposite, 0);
        labelLabel.setText(label);
        labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
        ComboViewer comboViewer = new ComboViewer(this.rightSideComposite, 8);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        comboGridData.horizontalAlignment = 4;
        comboGridData.horizontalSpan = horizontalSpan;
        comboViewer.getCombo().setLayoutData((Object)comboGridData);
        return comboViewer;
    }

    protected Text createLineForLabel(String label, int textLimit, int style, int minimumTextWidth, int heightHint, int horizontalSpan) {
        this.createLabel(label);
        Text labelText = new Text(this.rightSideComposite, style);
        labelText.setTextLimit(textLimit);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        textGridData.minimumWidth = minimumTextWidth;
        if (heightHint > 0) {
            textGridData.heightHint = heightHint;
        }
        textGridData.horizontalSpan = horizontalSpan;
        labelText.setLayoutData((Object)textGridData);
        return labelText;
    }

    private void createLabel(String label) {
        Label labelLabel = new Label(this.rightSideComposite, 0);
        labelLabel.setText(label);
        labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelLabel.setLayoutData((Object)labelGridData);
    }

    @Override
    protected List<Action> getLeftSectionActions() {
        this.leftSectionActions = new ArrayList();
        this.leftSectionActions.add(0, new UploadArchivedFile(this));
        this.leftSectionActions.add(1, new UpdateArchivedFile(this));
        this.leftSectionActions.add(2, new RenameArchivedFile(this));
        this.leftSectionActions.add(3, new DownloadFile(this));
        this.leftSectionActions.add(4, new DownloadFilesAsZip(this));
        this.leftSectionActions.add(5, new DeleteArchivedFile(this));
        this.sortByName = new SortFileNames(this.leftSideTreeViewer);
        this.leftSectionActions.add(6, this.sortByName);
        this.createContextMenu();
        return this.leftSectionActions;
    }

    protected void createContextMenu() {
        if (this.leftSideTreeViewer != null) {
            MenuManager contextMenu = new MenuManager("#ViewerMenu");
            contextMenu.setRemoveAllWhenShown(true);
            contextMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    if (FileArchivePage.this.leftSideTreeViewer.getSelection() != null && !FileArchivePage.this.leftSideTreeViewer.getSelection().isEmpty()) {
                        FileArchivePage.this.fillContextMenu(mgr);
                    }
                }
            });
            Menu menu = contextMenu.createContextMenu((Control)this.leftSideTreeViewer.getTree());
            this.leftSideTreeViewer.getTree().setMenu(menu);
            this.menuService.registerContextMenu((Object)this.leftSideTreeViewer, "#ViewerMenu");
        }
    }

    protected void fillContextMenu(IMenuManager contextMenu) {
        contextMenu.add((IAction)this.leftSectionActions.get(3));
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)this.leftSectionActions.get(1));
        contextMenu.add((IAction)this.leftSectionActions.get(2));
        contextMenu.add((IAction)this.leftSectionActions.get(5));
    }

    @Override
    public void setSelection(Object selectedObject) {
        String selectionTitle = "No Selection";
        if (selectedObject instanceof ArchivedFile) {
            this.oldSelection = false;
            this.selectedArchivedFile = (ArchivedFile)selectedObject;
            selectionTitle = "Selection : " + this.selectedArchivedFile.getTypicalArchivedFile().getFileName();
            this.resetPerson(this.selectedArchivedFile.getPerson());
            if (this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType() != null) {
                this.resetDocumentType(this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType());
                String[] documentSubTypes = this.getSortedArrayFromList(new ArrayList<String>(this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().getSubTypes()));
                this.documentSubTypeCombo.setInput((Object)documentSubTypes);
                if (this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().getSelectedSubType() != null) {
                    this.resetDocumentSubType(this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType(), this.selectedArchivedFile.getTypicalArchivedFile().getDocumentType().getSelectedSubType());
                }
            }
            this.cDateTime.setSelection(this.selectedArchivedFile.getSetDate());
            String value = this.selectedArchivedFile.getModifiedDate() == null ? "" : this.selectedArchivedFile.getModifiedDate().toString();
            this.dateModifiedText.setText(value);
            value = this.selectedArchivedFile.getDescription() == null || this.selectedArchivedFile.getDescription().isEmpty() ? "" : this.selectedArchivedFile.getDescription();
            this.descriptionText.setText(value);
            value = this.selectedArchivedFile.getKeywords() == null || this.selectedArchivedFile.getKeywords().isEmpty() ? "" : this.getCSKeywords(this.selectedArchivedFile.getKeywords());
            this.keywordsText.setText(value);
            this.changeKeywordButton.setEnabled(true);
            this.makeControlsEditable(true);
            this.oldSelection = true;
        } else {
            this.clearAll();
        }
        this.getRightSectionOfPage().setText(selectionTitle);
    }

    private void clearAll() {
        this.oldSelection = false;
        this.makeControlsEditable(false);
        this.selectedArchivedFile = null;
        this.documentTypeCombo.getCombo().select(0);
        this.documentSubTypeCombo.getCombo().select(0);
        this.personCombo.getCombo().select(0);
        this.cDateTime.setSelection(null);
        this.dateModifiedText.setText("");
        this.descriptionText.setText("");
        this.keywordsText.setText("");
    }

    private void makeControlsEditable(boolean editable) {
        this.documentTypeCombo.getCombo().setEnabled(editable);
        this.documentSubTypeCombo.getCombo().setEnabled(editable);
        this.personCombo.getCombo().setEnabled(editable);
        this.cDateTime.setEnabled(editable);
        this.descriptionText.setEnabled(editable);
        this.changeKeywordButton.setEnabled(editable);
    }

    private void resetCombo(ComboViewer comboViewer, String selectedValue) {
        int selectionIndex = 0;
        if (selectedValue != null) {
            comboViewer.getCombo().clearSelection();
            String[] arrayOfValues = comboViewer.getCombo().getItems();
            int i = 0;
            String[] stringArray = arrayOfValues;
            int n = arrayOfValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.equals(selectedValue)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
                ++n2;
            }
        }
        comboViewer.getCombo().select(selectionIndex);
    }

    private void resetPerson(String selectedPerson) {
        if (selectedPerson != null) {
            boolean found = false;
            String[] stringArray = this.personCombo.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docName = stringArray[n2];
                if (docName.equals(selectedPerson)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.personCombo.add((Object)selectedPerson);
            }
        }
        this.resetCombo(this.personCombo, selectedPerson);
    }

    private void resetDocumentType(DocumentType documentType) {
        String documentTypeLabel = null;
        if (documentType != null) {
            boolean found = false;
            String[] stringArray = this.documentTypeCombo.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docName = stringArray[n2];
                if (docName.equals(documentType.getLabel())) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.documentTypeCombo.add((Object)documentType.clone());
            }
            documentTypeLabel = documentType.getLabel();
        }
        this.resetCombo(this.documentTypeCombo, documentTypeLabel);
    }

    private void resetDocumentSubType(DocumentType documentType, String selectedSubType) {
        if (documentType != null && selectedSubType != null) {
            boolean found = false;
            String[] stringArray = this.documentSubTypeCombo.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docSubtype = stringArray[n2];
                if (docSubtype.equals(selectedSubType)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.documentSubTypeCombo.add((Object)selectedSubType);
                documentType.addSubType(selectedSubType);
            }
        }
        this.resetCombo(this.documentSubTypeCombo, selectedSubType);
    }

    @Override
    protected List<?> getInput() {
        return this.getArchiveEntryEditor().getArchive().getArchivedFiles();
    }

    @Override
    public void refreshPage() {
        ArchivedFile currentSelection = this.selectedArchivedFile;
        this.clearAll();
        this.setSelection(currentSelection);
    }

    @Override
    protected void setUpColumns(TreeViewer treeViewer) {
        final File archiveFolder = this.getArchiveEntryEditor().getArchiveFolder();
        treeViewer.setComparator((ViewerComparator)new ArchivedFileViewerComparator(this.getArchiveEntryEditor()));
        TreeViewerColumn columnViewer0 = new TreeViewerColumn(treeViewer, 16384);
        columnViewer0.getColumn().setWidth(200);
        columnViewer0.getColumn().setText("Name");
        columnViewer0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ArchivedFile) {
                    return ((ArchivedFile)element).getTypicalArchivedFile().getFileName();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof ArchivedFile) {
                    return FileArchivePage.this.getFileIcon((ArchivedFile)element);
                }
                return null;
            }
        });
        columnViewer0.getColumn().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileArchivePage.this.sortByName.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FileArchivePage.this.sortByName.run();
            }
        });
        TreeViewerColumn columnViewer1 = new TreeViewerColumn(treeViewer, 131072);
        columnViewer1.getColumn().setWidth(100);
        columnViewer1.getColumn().setText("Size");
        columnViewer1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ArchivedFile) {
                    ArchivedFile archivedFile = (ArchivedFile)element;
                    return archivedFile.getTypicalArchivedFile() == null ? null : UtilityFileName.getFileSize(new File(archiveFolder, archivedFile.getTypicalArchivedFile().getFileName()));
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        columnViewer1.getColumn().addSelectionListener((SelectionListener)new ArchivedFileColumnComparatorListener(treeViewer));
    }

    protected Image getFileIcon(ArchivedFile archivedFile) {
        Image icon = UNKNOWN_ICON;
        try {
            File file = new File(this.getArchiveEntryEditor().getArchiveFolder(), archivedFile.getTypicalArchivedFile().getFileName());
            if (file != null && file.getName() != null && file.getName().contains(".")) {
                String fileEnding = file.getName().substring(file.getName().lastIndexOf(46));
                if (FILE_ICON_MAP.containsKey(fileEnding)) {
                    icon = FILE_ICON_MAP.get(fileEnding);
                } else {
                    Program fileProgram = Program.findProgram((String)fileEnding);
                    ImageData iconData = null;
                    if (fileProgram != null && (iconData = fileProgram.getImageData().scaledTo(16, 16)) != null) {
                        icon = new Image((Device)Display.getCurrent(), iconData);
                        FILE_ICON_MAP.put(fileEnding, icon);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return icon;
    }

    @Inject
    @Optional
    public void preferenceUpdated(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (this.documentTypeCombo != null && preferenceName.equals(DocTypePreference.PREFERENCE_NAME_ALL)) {
            DocTypePreference.loadPreferences();
            DocumentType selectedDocumentType = this.documentTypeCombo.getSelection().isEmpty() ? null : (DocumentType)((StructuredSelection)this.documentTypeCombo.getSelection()).getFirstElement();
            String subTypeSelection = null;
            if (selectedDocumentType != null) {
                subTypeSelection = this.documentSubTypeCombo.getSelection().isEmpty() ? null : (String)((StructuredSelection)this.documentSubTypeCombo.getSelection()).getFirstElement();
            }
            this.documentTypeCombo.setInput((Object)this.getSortedDocumentFromList(new ArrayList<DocumentType>(DocTypePreference.ALL_DOCUMENT_TYPES)));
            for (DocumentType docType : DocTypePreference.ALL_DOCUMENT_TYPES) {
                if (!Objects.equals(selectedDocumentType.getLabel(), docType.getLabel())) continue;
                selectedDocumentType = docType;
                break;
            }
            this.resetDocumentType(selectedDocumentType);
            if (selectedDocumentType != null) {
                this.documentSubTypeCombo.setInput((Object)this.getSortedArrayFromList(new ArrayList<String>(selectedDocumentType.getSubTypes())));
            }
            this.resetDocumentSubType(selectedDocumentType, subTypeSelection);
        }
        if (this.personCombo != null && preferenceName.equals(ProjectPreferenceStore.Preference.PERSON.getPreferenceName())) {
            String personSelection = this.personCombo.getSelection().isEmpty() ? null : (String)((StructuredSelection)this.personCombo.getSelection()).getFirstElement();
            SingleChoicePreference personPreference = ProjectPreferenceStore.getSingleChoicePreference((ProjectPreferenceStore.Preference)ProjectPreferenceStore.Preference.PERSON);
            ArrayList<String> personList = new ArrayList<String>();
            personList.addAll(personPreference.getAllValues());
            this.personCombo.setInput((Object)this.getSortedArrayFromList(personList));
            this.resetPerson(personSelection);
        }
        if (preferenceName.equals(KeywordPreference.PREFERENCE_NAME_ALL)) {
            this.logger.debug((Object)"keywords updated");
            KeywordPreference.loadPreferences();
        }
    }

    @Override
    protected String getTitle() {
        return PAGE_TITLE;
    }
}

