/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.comparator;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.comparator.BackboneComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparator;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Monosaccharide;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class MonosaccharideComparatorForInvertBackbone
implements Comparator<Monosaccharide> {
    @Override
    public int compare(Monosaccharide MS1, Monosaccharide MS2) {
        int t_nChildCount2;
        int t_nParentCount2;
        int t_nSubstCount2;
        Backbone b2;
        BackboneComparator t_oBComp = new BackboneComparator();
        Backbone b1 = MS1.getBackbone();
        int t_iComp = t_oBComp.compare(b1, b2 = MS2.getBackbone());
        if (t_iComp != 0) {
            return t_iComp;
        }
        WURCSEdgeComparator t_oCompEdge = new WURCSEdgeComparator();
        int score1 = 0;
        int score2 = 0;
        LinkedList<WURCSEdge> t_aSubstLinkages1 = MS1.getSubstituentEdges();
        LinkedList<WURCSEdge> t_aSubstLinkages2 = MS2.getSubstituentEdges();
        int t_nSubstCount1 = t_aSubstLinkages1.size();
        if (t_nSubstCount1 != (t_nSubstCount2 = t_aSubstLinkages2.size())) {
            return t_nSubstCount2 - t_nSubstCount1;
        }
        Collections.sort(t_aSubstLinkages1, t_oCompEdge);
        Collections.sort(t_aSubstLinkages2, t_oCompEdge);
        score1 = 0;
        score2 = 0;
        for (WURCSEdge edge : t_aSubstLinkages1) {
            score1 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        for (WURCSEdge edge : t_aSubstLinkages2) {
            score2 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        t_iComp = score1 - score2;
        System.err.println("[info] " + MS1.getClass() + ":posM:" + t_iComp + " in class MonosaccharideComparatorForInvertBackbone (compare(ms1,ms2))");
        if (t_iComp != 0) {
            return t_iComp;
        }
        int t_nParentCount1 = b1.getParentEdges().size();
        t_iComp = t_nParentCount1 - (t_nParentCount2 = b2.getParentEdges().size());
        if (t_iComp != 0) {
            return t_iComp;
        }
        for (WURCSEdge edge : b1.getParentEdges()) {
            int pos1 = edge.getLinkages().getFirst().getBackbonePosition();
            score1 += pos1;
        }
        for (WURCSEdge edge : b2.getParentEdges()) {
            int pos2 = edge.getLinkages().getFirst().getBackbonePosition();
            score2 += pos2;
        }
        t_iComp = score1 - score2;
        if (t_iComp != 0) {
            return t_iComp;
        }
        LinkedList<WURCSEdge> t_aGlycoLinkages1 = MS1.getChildGlycosidicEdges();
        LinkedList<WURCSEdge> t_aGlycoLinkages2 = MS2.getChildGlycosidicEdges();
        int t_nChildCount1 = t_aGlycoLinkages1.size();
        t_iComp = t_nChildCount1 - (t_nChildCount2 = t_aGlycoLinkages2.size());
        if (t_iComp != 0) {
            return t_iComp;
        }
        Collections.sort(t_aGlycoLinkages1, t_oCompEdge);
        Collections.sort(t_aGlycoLinkages2, t_oCompEdge);
        score1 = 0;
        score2 = 0;
        for (WURCSEdge edge : t_aGlycoLinkages1) {
            int pos1 = edge.getLinkages().getFirst().getBackbonePosition();
            score1 += pos1;
        }
        for (WURCSEdge edge : t_aGlycoLinkages2) {
            int pos2 = edge.getLinkages().getFirst().getBackbonePosition();
            score2 += pos2;
        }
        t_iComp = score2 - score1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        WURCSVisitorCollectSequenceComparator t_oCompSeq = new WURCSVisitorCollectSequenceComparator();
        int n = t_aGlycoLinkages1.size();
        for (int i = 0; i < n; ++i) {
            WURCSEdge t_oEdge1 = t_aGlycoLinkages1.get(i);
            WURCSEdge t_oEdge2 = t_aGlycoLinkages2.get(i);
            try {
                WURCSVisitorCollectSequence t_oSeq1 = new WURCSVisitorCollectSequence();
                t_oSeq1.start(t_oEdge1);
                WURCSVisitorCollectSequence t_oSeq2 = new WURCSVisitorCollectSequence();
                t_oSeq2.start(t_oEdge2);
                t_iComp = t_oCompSeq.compare(t_oSeq1, t_oSeq2);
            }
            catch (WURCSVisitorException e) {
                e.printStackTrace();
            }
            if (t_iComp == 0) continue;
            return t_iComp;
        }
        return 0;
    }
}

