/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;

@XmlRootElement(name="massSpecStandardQuantification")
public class MassSpecStandardQuant {
    private static final Logger logger = Logger.getLogger(MassSpecStandardQuant.class);
    public static final String VALUE_SEPERATOR = "!!!!!!";
    protected String sStandardQuantName = null;
    protected String sDescription = null;
    protected Integer iMSLevel = null;
    protected Double dMassTolerance = null;
    protected Boolean bIsPPM = null;
    protected HashMap<Double, MassSpecStandardQuantPeak> listPeaks = null;
    protected String sStandardQuantPeakText = null;

    public MassSpecStandardQuant() {
    }

    public MassSpecStandardQuant(String sStandardQuantName, String sDescription, Integer iMSLevel, Double dMassTolerance, Boolean bIsPPM) {
        this.sStandardQuantName = sStandardQuantName;
        this.sDescription = sDescription;
        this.iMSLevel = iMSLevel;
        this.dMassTolerance = dMassTolerance;
        this.bIsPPM = bIsPPM;
        this.listPeaks = new HashMap();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MassSpecStandardQuant)) {
            return false;
        }
        return ((MassSpecStandardQuant)obj).getStandardQuantName().equals(this.getStandardQuantName());
    }

    protected MassSpecStandardQuant getNewStandardQuantObject() {
        return new MassSpecStandardQuant();
    }

    public Object clone() {
        MassSpecStandardQuant msca = this.getNewStandardQuantObject();
        msca.setStandardQuantName(this.getStandardQuantName());
        msca.setDescription(this.getDescription());
        msca.setMSLevel(this.getMSLevel());
        msca.setMassTolerance(this.getMassTolerance());
        msca.setIsPPM(this.getIsPPM());
        msca.setStandardQuantPeaks(new HashMap<Double, MassSpecStandardQuantPeak>());
        for (Double dMz : this.getStandardQuantPeaks().keySet()) {
            MassSpecStandardQuantPeak peak = this.getStandardQuantPeaks().get(dMz);
            msca.getStandardQuantPeaks().put(dMz, peak);
        }
        return msca;
    }

    public boolean differsFrom(MassSpecStandardQuant that) {
        if (!this.getStandardQuantName().equals(that.getStandardQuantName())) {
            return true;
        }
        if (this.getIsPPM().booleanValue() && !that.getIsPPM().booleanValue() || !this.getIsPPM().booleanValue() && that.getIsPPM().booleanValue()) {
            return true;
        }
        if (!this.getDescription().equals(that.getDescription())) {
            return true;
        }
        if (Double.compare(this.getMassTolerance(), that.getMassTolerance()) != 0) {
            return true;
        }
        if (this.getMSLevel() != that.getMSLevel()) {
            return true;
        }
        if (this.getStandardQuantPeaks().size() != that.getStandardQuantPeaks().size()) {
            return true;
        }
        Collection<MassSpecStandardQuantPeak> thesePeaks = this.getStandardQuantPeaks().values();
        Collection<MassSpecStandardQuantPeak> thosePeaks = that.getStandardQuantPeaks().values();
        for (MassSpecStandardQuantPeak thisPeak : thesePeaks) {
            Iterator<MassSpecStandardQuantPeak> thatItr = thosePeaks.iterator();
            boolean bFound = false;
            while (thatItr.hasNext() && !bFound) {
                MassSpecStandardQuantPeak thatPeak = thatItr.next();
                if (!thisPeak.equals(thatPeak)) continue;
                bFound = true;
            }
            if (bFound) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getStandardQuantName()) + ", num peaks: " + this.getStandardQuantPeaks().size();
    }

    public String getStandardQuantName() {
        return this.sStandardQuantName;
    }

    @XmlAttribute(name="standardQuantName")
    public void setStandardQuantName(String sStandardQuantName) {
        this.sStandardQuantName = sStandardQuantName;
    }

    public String getDescription() {
        return this.sDescription;
    }

    @XmlAttribute(name="description")
    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public Integer getMSLevel() {
        return this.iMSLevel;
    }

    @XmlAttribute(name="msLevel")
    public void setMSLevel(Integer iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    public Double getMassTolerance() {
        return this.dMassTolerance;
    }

    @XmlAttribute(name="massTolerance")
    public void setMassTolerance(Double dMassTolerance) {
        this.dMassTolerance = dMassTolerance;
    }

    public Boolean getIsPPM() {
        return this.bIsPPM;
    }

    @XmlAttribute(name="isPPM")
    public void setIsPPM(Boolean bIsPPM) {
        this.bIsPPM = bIsPPM;
    }

    public HashMap<Double, MassSpecStandardQuantPeak> getStandardQuantPeaks() {
        return this.listPeaks;
    }

    @XmlTransient
    public void setStandardQuantPeaks(HashMap<Double, MassSpecStandardQuantPeak> listPeaks) {
        this.listPeaks = listPeaks;
    }

    public String getStandardQuantPeakText() {
        return this.sStandardQuantPeakText;
    }

    @XmlAttribute(name="standardQuantPeakText")
    public void setStandardQuantPeakText(String sStandardQuantPeakText) {
        this.sStandardQuantPeakText = sStandardQuantPeakText;
    }

    public void unmarshalStandardQuantPeakList() {
        HashMap<Double, MassSpecStandardQuantPeak> sStandardQuantPeaks = MassSpecStandardQuant.unmarshalAnnotatedPeakText(this);
        this.setStandardQuantPeaks(sStandardQuantPeaks);
    }

    public void updateStandardQuantPeakText() {
        String standardQuantPeakText = MassSpecStandardQuant.createStandardQuantPeakText(this.getStandardQuantPeaks());
        this.setStandardQuantPeakText(standardQuantPeakText);
    }

    public static String createStandardQuantPeakText(MassSpecStandardQuantPeak peak) {
        String asText = XMLUtils.marshalObjectXML((Object)peak);
        return asText;
    }

    public static String createStandardQuantPeakText(HashMap<Double, MassSpecStandardQuantPeak> standardQuantPeaks) {
        StringBuilder sb = new StringBuilder();
        if (standardQuantPeaks != null && !standardQuantPeaks.isEmpty()) {
            for (Double dKey : standardQuantPeaks.keySet()) {
                MassSpecStandardQuantPeak value = standardQuantPeaks.get(dKey);
                if (value == null) continue;
                if (!sb.toString().equals("")) {
                    sb.append(VALUE_SEPERATOR);
                }
                String sXML = MassSpecStandardQuant.createStandardQuantPeakText(value);
                sb.append(sXML);
            }
        }
        return sb.toString();
    }

    public static HashMap<Double, MassSpecStandardQuantPeak> unmarshalAnnotatedPeakText(MassSpecStandardQuant standardQuant) {
        HashMap<Double, MassSpecStandardQuantPeak> standardQuantPeaks = new HashMap<Double, MassSpecStandardQuantPeak>();
        try {
            String[] standardQuants;
            if (standardQuant != null && standardQuant.getStandardQuantPeakText() != null && !standardQuant.getStandardQuantPeakText().equals("") && (standardQuants = standardQuant.getStandardQuantPeakText().trim().split(VALUE_SEPERATOR)) != null && standardQuants.length > 0) {
                int i = 0;
                while (i < standardQuants.length) {
                    String annotXML = standardQuants[i];
                    MassSpecStandardQuantPeak peak = standardQuant.getPeakObjectFromXML(annotXML);
                    if (peak != null) {
                        standardQuantPeaks.put(peak.getPeakMz(), peak);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
        }
        return standardQuantPeaks;
    }

    public MassSpecStandardQuantPeak getPeakObjectFromXML(String peakXML) {
        MassSpecStandardQuantPeak peak = (MassSpecStandardQuantPeak)XMLUtils.getObjectFromXML((String)peakXML, MassSpecStandardQuantPeak.class);
        return peak;
    }
}

