/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.spectrum.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.grits.toolbox.display.control.spectrum.chart.GRITSJFreeChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerData;
import org.grits.toolbox.display.control.spectrum.chart.GRITSXYPlot;
import org.grits.toolbox.display.control.spectrum.datamodel.FixedLineIntervalXYDataset;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;

public class GRITSSpectralViewerChart {
    protected GRITSSpectralViewerData spectralViewerData = null;
    protected ArrayList<String> alTitlesAndLabels = new ArrayList();
    protected GRITSJFreeChart chart;
    protected Boolean bVertLabels = null;
    protected String sDescription = null;
    protected Integer iScanNum = null;
    protected Integer iMSLevel = null;
    protected Boolean bIsProfile = null;
    private int iSeriesCnt = 0;
    protected int iRawPeaksSeriesIndex = -1;
    protected int iPickedPeaksSeriesIndex = -1;
    protected int iAnnotatedPeaksSeriesIndex = -1;
    protected int iUnAnnotatedPeaksSeriesIndex = -1;

    public GRITSSpectralViewerChart(String _sDescription, int _iScanNum, int _iMSLevel, boolean _bIsProfile, boolean _bVertLabels) {
        this.bVertLabels = _bVertLabels;
        this.sDescription = _sDescription;
        this.iScanNum = _iScanNum;
        this.iMSLevel = _iMSLevel;
        this.bIsProfile = _bIsProfile;
    }

    public ArrayList<String> getTitleAndLabels() {
        this.alTitlesAndLabels.add(this.sDescription);
        this.alTitlesAndLabels.add("m/z");
        this.alTitlesAndLabels.add("Peak Intensity");
        return this.alTitlesAndLabels;
    }

    public void setIsProfile(Boolean bIsProfile) {
        this.bIsProfile = bIsProfile;
    }

    public void setSpectralViewerData(GRITSSpectralViewerData spectralViewerData) {
        this.spectralViewerData = spectralViewerData;
    }

    public GRITSSpectralViewerData getSpectralViewerData() {
        return this.spectralViewerData;
    }

    public GRITSJFreeChart createChart() {
        XYBarRenderer barRenderer;
        GRITSJFreeChart chart = null;
        GRITSXYPlot plot = null;
        this.iSeriesCnt = 0;
        FixedLineIntervalXYDataset xyDataset = this.getRawDataset();
        if (xyDataset.getSeriesCount() > 0) {
            XYBarRenderer renderer;
            if (this.bIsProfile != null && this.bIsProfile.booleanValue()) {
                chart = this.createXYLineChart();
                plot = (GRITSXYPlot)chart.getPlot();
                this.iRawPeaksSeriesIndex = this.iSeriesCnt++;
                plot.setDataset(this.iRawPeaksSeriesIndex, (XYDataset)xyDataset);
                renderer = new XYLineAndShapeRenderer();
                renderer.setBaseShapesVisible(false);
                renderer.setSeriesPaint(0, (Paint)Color.BLACK);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(0.25f));
                plot.setRenderer(this.iRawPeaksSeriesIndex, (XYItemRenderer)renderer);
            } else {
                chart = this.createXYBarChart();
                plot = (GRITSXYPlot)chart.getPlot();
                this.iRawPeaksSeriesIndex = this.iSeriesCnt++;
                plot.setDataset(this.iRawPeaksSeriesIndex, (XYDataset)xyDataset);
                renderer = new XYBarRenderer();
                renderer.setBaseItemLabelsVisible(true);
                renderer.setShadowVisible(false);
                plot.setRenderer(this.iRawPeaksSeriesIndex, (XYItemRenderer)renderer);
            }
        }
        if ((xyDataset = this.getAnnotatedPeakDataset()).getSeriesCount() > 0) {
            this.iAnnotatedPeaksSeriesIndex = this.iSeriesCnt++;
            plot.setDataset(this.iAnnotatedPeaksSeriesIndex, (XYDataset)xyDataset);
            barRenderer = new XYBarRenderer();
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setShadowVisible(false);
            plot.setRenderer(this.iAnnotatedPeaksSeriesIndex, (XYItemRenderer)barRenderer, true);
        }
        if ((xyDataset = this.getUnAnnotatedPeakDataset()).getSeriesCount() > 0) {
            this.iUnAnnotatedPeaksSeriesIndex = this.iSeriesCnt++;
            plot.setDataset(this.iUnAnnotatedPeaksSeriesIndex, (XYDataset)xyDataset);
            barRenderer = new XYBarRenderer();
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setShadowVisible(false);
            plot.setRenderer(this.iUnAnnotatedPeaksSeriesIndex, (XYItemRenderer)barRenderer, true);
        }
        if ((xyDataset = this.getPickedPeakDataset()).getSeriesCount() > 0) {
            this.iPickedPeaksSeriesIndex = this.iSeriesCnt++;
            plot.setDataset(this.iPickedPeaksSeriesIndex, (XYDataset)xyDataset);
            barRenderer = new XYBarRenderer();
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setShadowVisible(false);
            plot.setRenderer(this.iPickedPeaksSeriesIndex, (XYItemRenderer)barRenderer, true);
        }
        this.setPeakLabels();
        return chart;
    }

    public void updateChart(boolean bShowRaw, boolean bShowPicked, boolean bShowPickedLabels, boolean bShowAnnotated, boolean bShowAnnotatedLabels, boolean bShowUnannotated, boolean bShowUnannotatedLabels) {
        GRITSXYPlot plot = (GRITSXYPlot)this.chart.getPlot();
        if (this.iRawPeaksSeriesIndex >= 0) {
            plot.getRenderer(this.iRawPeaksSeriesIndex).setBaseSeriesVisible(bShowRaw);
        }
        if (this.iPickedPeaksSeriesIndex >= 0) {
            plot.getRenderer(this.iPickedPeaksSeriesIndex).setBaseSeriesVisible(bShowPicked);
            plot.getRenderer(this.iPickedPeaksSeriesIndex).setBaseItemLabelsVisible(bShowPickedLabels);
            plot.getRenderer(this.iPickedPeaksSeriesIndex).setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT, TextAnchor.BASELINE_LEFT, 4.705));
        }
        if (this.iAnnotatedPeaksSeriesIndex >= 0) {
            plot.getRenderer(this.iAnnotatedPeaksSeriesIndex).setBaseSeriesVisible(bShowAnnotated);
            plot.getRenderer(this.iAnnotatedPeaksSeriesIndex).setBaseItemLabelsVisible(bShowAnnotatedLabels);
            plot.setDrawPostPaintAnnotations(bShowAnnotatedLabels);
            plot.getRenderer(this.iAnnotatedPeaksSeriesIndex).setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT, TextAnchor.BASELINE_LEFT, 4.705));
        }
        if (this.iUnAnnotatedPeaksSeriesIndex >= 0) {
            plot.getRenderer(this.iUnAnnotatedPeaksSeriesIndex).setBaseSeriesVisible(bShowUnannotated);
            plot.getRenderer(this.iUnAnnotatedPeaksSeriesIndex).setBaseItemLabelsVisible(bShowUnannotatedLabels);
            plot.getRenderer(this.iUnAnnotatedPeaksSeriesIndex).setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT, TextAnchor.BASELINE_LEFT, 4.705));
        }
    }

    protected void setPeakLabels() {
        List<Object> alSourceLabels;
        GRITSXYPlot plot = (GRITSXYPlot)this.chart.getPlot();
        HashMap<Double, List<Object>> htPostPaintLabels = new HashMap<Double, List<Object>>();
        HashMap<Double, Object> htPickedPeakLabels = new HashMap<Double, Object>();
        HashMap<Double, Object> htAnnotatedPeakLabels = new HashMap<Double, Object>();
        HashMap<Double, Object> htUnAnnotatedPeakLabels = new HashMap<Double, Object>();
        if (this.iPickedPeaksSeriesIndex >= 0) {
            for (Double dPeakMass : this.getSpectralViewerData().getPickedPeakLabels().keySet()) {
                alSourceLabels = this.getSpectralViewerData().getPickedPeakLabels().get(dPeakMass);
                if (alSourceLabels == null || alSourceLabels.isEmpty()) continue;
                htPickedPeakLabels.put(dPeakMass, alSourceLabels.get(0));
            }
            plot.setPeakLabels(this.iPickedPeaksSeriesIndex, htPickedPeakLabels);
        }
        if (this.iAnnotatedPeaksSeriesIndex >= 0) {
            for (Double dPeakMass : this.getSpectralViewerData().getAnnotatedPeakLabels().keySet()) {
                alSourceLabels = this.getSpectralViewerData().getAnnotatedPeakLabels().get(dPeakMass);
                if (alSourceLabels == null || alSourceLabels.isEmpty()) continue;
                if (alSourceLabels.size() > 1 || alSourceLabels.get(0) instanceof GlycanImageProvider.GlycanImageObject) {
                    htPostPaintLabels.put(dPeakMass, alSourceLabels);
                    continue;
                }
                htAnnotatedPeakLabels.put(dPeakMass, alSourceLabels.get(0));
            }
            plot.setPeakLabels(this.iAnnotatedPeaksSeriesIndex, htAnnotatedPeakLabels);
            plot.setPostPaintAnnotations(htPostPaintLabels);
        }
        if (this.iUnAnnotatedPeaksSeriesIndex >= 0) {
            for (Double dPeakMass : this.getSpectralViewerData().getUnAnnotatedPeakLabels().keySet()) {
                alSourceLabels = this.getSpectralViewerData().getUnAnnotatedPeakLabels().get(dPeakMass);
                if (alSourceLabels == null || alSourceLabels.isEmpty()) continue;
                htUnAnnotatedPeakLabels.put(dPeakMass, alSourceLabels.get(0));
            }
            plot.setPeakLabels(this.iUnAnnotatedPeaksSeriesIndex, htUnAnnotatedPeakLabels);
        }
    }

    protected LegendItemCollection createLegendItems() {
        LegendItemCollection legenditemcollection = new LegendItemCollection();
        return legenditemcollection;
    }

    protected GRITSJFreeChart createXYBarChart() {
        this.chart = GRITSJFreeChart.createXYBarChart(this.getTitleAndLabels().get(0), this.getTitleAndLabels().get(1), false, this.getTitleAndLabels().get(2), null, PlotOrientation.VERTICAL, true, true, false, null);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoTickUnitSelection(true);
        return this.chart;
    }

    protected GRITSJFreeChart createXYLineChart() {
        this.chart = GRITSJFreeChart.createXYLineChart(this.getTitleAndLabels().get(0), this.getTitleAndLabels().get(1), this.getTitleAndLabels().get(2), null, PlotOrientation.VERTICAL, true, true, false, null);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoTickUnitSelection(true);
        return this.chart;
    }

    protected XYDataset getYDataset() {
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        XYSeries series1 = new XYSeries((Comparable)((Object)"MS/MS Spectra"));
        int i = 0;
        while (i < this.getSpectralViewerData().getRawData().size()) {
            XYDataItem item = new XYDataItem(this.getSpectralViewerData().getRawData().get(i).getMass(), this.getSpectralViewerData().getRawData().get(i).getIntensity());
            series1.add(item);
            ++i;
        }
        xySeriesCollection.addSeries(series1);
        return xySeriesCollection;
    }

    protected FixedLineIntervalXYDataset getRawDataset() {
        FixedLineIntervalXYDataset xySeriesCollection = new FixedLineIntervalXYDataset();
        if (this.getSpectralViewerData().getRawData() != null && !this.getSpectralViewerData().getRawData().isEmpty()) {
            double[][] d = new double[2][this.getSpectralViewerData().getRawData().size()];
            int i = 0;
            while (i < this.getSpectralViewerData().getRawData().size()) {
                d[0][i] = this.getSpectralViewerData().getRawData().get(i).getMass();
                d[1][i] = this.getSpectralViewerData().getRawData().get(i).getIntensity();
                ++i;
            }
            xySeriesCollection.addSeries((Comparable)((Object)"Observed"), d);
        }
        return xySeriesCollection;
    }

    protected FixedLineIntervalXYDataset getPickedPeakDataset() {
        FixedLineIntervalXYDataset xySeriesCollection = new FixedLineIntervalXYDataset();
        if (this.getSpectralViewerData().getPickedPeaks() != null && !this.getSpectralViewerData().getPickedPeaks().isEmpty()) {
            double[][] d = new double[2][this.getSpectralViewerData().getPickedPeaks().size()];
            int i = 0;
            while (i < this.getSpectralViewerData().getPickedPeaks().size()) {
                d[0][i] = this.getSpectralViewerData().getPickedPeaks().get(i).getMass();
                d[1][i] = this.getSpectralViewerData().getPickedPeaks().get(i).getIntensity();
                ++i;
            }
            xySeriesCollection.addSeries((Comparable)((Object)"Picked Peaks"), d);
        }
        return xySeriesCollection;
    }

    protected FixedLineIntervalXYDataset getUnAnnotatedPeakDataset() {
        FixedLineIntervalXYDataset xySeriesCollection = new FixedLineIntervalXYDataset();
        if (this.getSpectralViewerData().getUnAnnotatedPeaks() != null && !this.getSpectralViewerData().getUnAnnotatedPeaks().isEmpty()) {
            double[][] d = new double[2][this.getSpectralViewerData().getUnAnnotatedPeaks().size()];
            int i = 0;
            while (i < this.getSpectralViewerData().getUnAnnotatedPeaks().size()) {
                d[0][i] = this.getSpectralViewerData().getUnAnnotatedPeaks().get(i).getMass();
                d[1][i] = this.getSpectralViewerData().getUnAnnotatedPeaks().get(i).getIntensity();
                ++i;
            }
            xySeriesCollection.addSeries((Comparable)((Object)"Unannotated Peaks"), d);
        }
        return xySeriesCollection;
    }

    protected FixedLineIntervalXYDataset getAnnotatedPeakDataset() {
        FixedLineIntervalXYDataset xySeriesCollection = new FixedLineIntervalXYDataset();
        if (this.getSpectralViewerData().getAnnotatedPeaks() != null && !this.getSpectralViewerData().getAnnotatedPeaks().isEmpty()) {
            double[][] d = new double[2][this.getSpectralViewerData().getAnnotatedPeaks().size()];
            int i = 0;
            while (i < this.getSpectralViewerData().getAnnotatedPeaks().size()) {
                d[0][i] = this.getSpectralViewerData().getAnnotatedPeaks().get(i).getMass();
                d[1][i] = this.getSpectralViewerData().getAnnotatedPeaks().get(i).getIntensity();
                ++i;
            }
            xySeriesCollection.addSeries((Comparable)((Object)"Annotated Peaks"), d);
        }
        return xySeriesCollection;
    }
}

