/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.processDialog;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;

public final class TextProgressBar
extends ProgressBar {
    private Color textColor = this.getDisplay().getSystemColor(2);
    protected String sText;

    public TextProgressBar(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point widgetSize = TextProgressBar.this.getSize();
                String text = TextProgressBar.this.getText();
                if (text != null) {
                    Point textSize = e.gc.stringExtent(text);
                    e.gc.setForeground(TextProgressBar.this.textColor);
                    e.gc.drawString(text, (widgetSize.x - textSize.x) / 2, (widgetSize.y - textSize.y) / 2, true);
                }
            }
        });
    }

    public void setText(String _sText) {
        this.sText = _sText;
    }

    public String getText() {
        return this.sText;
    }

    public void setTextColor(Color textColor) {
        this.checkWidget();
        this.textColor = textColor;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    protected void checkSubclass() {
    }
}

